function [psik]=get_psi_from_u(uk);

%  [psik] = GET_PSI_FROM_U(uk)  
%     Get spectral streamfunction from spectral zonal velocit (uk). 

kmax = size(uk,2)-1; nz=size(uk,3);

if (mod(kmax,2)==0)
  disp('This is probably not a SPECTRAL psi field...')
end

[kx_,ky_,z_] = ndgrid(-kmax:kmax,0:kmax,1:nz);
k_y(kmax+1,1,:)=.001; %overwrite 0 at origin to prevent irrelevant div-by-0

for t = 1:size(uk,4)
  psik(:,:,:,t) = (i./ky_).*uk(:,:,:,t);
end