% Tools for analysis of spectral QG model (SQG).
%
% Asterisked (*) routines are likely the most useful to the user.
%
% I/O and storage routines.
%     get_1d_series        - Read in series of 1d spectra from 3d file.
%   * getparams            - Read binary parameter file from SQG run.
%     layerize             - Convert 2D input array to 3D field.
%   * read_field           - Read binary direct access file.
%   * write_field          - Write binary direct access file.
%     sub2ind_             - Convert subscript to linear index.
%     ind2sub_             - Convert linear index to subscript.
%
% Primary analysis and transform tools.
%   * all_spectra          - Analyze a set of simulations...
%     budget_mode          - Get energy budgets as fcns of K and mode.
%     budget_z             - Get energy budgets as fcns of K and z.
%     centroid             - Get centroid of 2-d field.
%     eddy_time            - Calculate eddy turn-around time.
%   * get_pv               - Get spectral PV from spectral psi.
%     get_time             - Get time axis in terms of eddy time.
%   * get_velocities       - Get spectral velocitis from spectral psi. 
%   * get_vorticity        - Get spectral vorticity and stretching.
%   * grid2spec            - Transform grided field to spectral form.
%   * invert_pv            - Invert spectral PV to get spectral psi.
%     iso_spectra          - Get isotropic K vs. z or mode spectra.
%   * layer2mode           - Transform layered field to modal field.
%   * layerview            - Calculate layer interface heights.
%     modal_transfer       - Get modal energy transfer field T (bad).
%   * mode2layer           - Inverse of layer2mode.
%     modes_in_layer       - Projections of modes onto given layer.
%   * spec2grid            - Inverse of grid2spec.
%     sum_modes            - Sum over triply indexed modal spectra.
%
% Analytical (or semi-analytical) analysis tools
%     critical_curve       - Get critical instability curve vs. gamma.
%   * gamma_crit           - Get critical gamma=F/beta for instability.
%     lqg                  - Linear QG solver.
%   * qggr                 - Full linear QG instability analysis.
%     triad_transfer       - Spectral/modal transfer growth rate.
%     triadgr              - Transfer growth rate for range of waves.
%     tripintcoef          - Triple interaction coef for modes (bad)
%     tripintcoef2         - Triple interaction coef for modes 
%                            (dealiased - needs work)
%   * vmodes               - Get vertical modes and radii of def'n.
% 
% Graphics, plotting and field manipulation.
%     get_frame            - Grab one frame of in-memory field.
%     interp3dfield        - Interpolate 3d field onto linear grid.
%   * isoplot              - Plot iso-surface of 3D field (better).
%   * make_movie           - Make movie of in-memory field.
%   * make_filemovie       - Make movie of field by reading from file.
%   * plotfield            - Versatile field visualizer.
%     plotri               - Plot real & imaginary parts of 1D vector.
%     rot180               - Rotate field by 180 degrees.
%     surfcv               - Plot iso-surface of 3D field (low quality).
%
% Secondary analysis and transform tools.
%     ddz                  - Vertical derivative on same z coord.
%     findzeros            - Locate zeros of a vector.
%     fullspec             - Convert half-spectral field to full field.
%     grad                 - Gradient of field.
%     jacobian             - Spectral jacobian (bad).
%     laplacian_dp         - Laplacian of doubly-periodic field (grid).
%     sortvec              - Sort a vector and save index map.
%
%  Field setup and initialization.
%     get_shear            - Set up shear vector.
%     get_stratification   - Set up vertical profiles of rho, u and z.
%     get_strat_params     - Set up layer couling operator.
%     get_dz               - Get layer thicknesses from z coord.
%     get_ksqd             - Get values of K^2 on spectral grid.
%     get_z                - Get z coord from layer thicknesses.
%     make_init_field_mod  - Make initial psi for given vertical mode.
%     make_init_field_mum  - Make initial psi from most unstable mode.
%     ndparams             - Get non-dimensional parameters from scales.

%  Written by Shafer Smith, 1999.  
