% Atomic-norm denoising in the presence of outliers, based on solving 
% the problem
% 
% min_{g,z} || g ||_A / sqrt(n) + lambda || z ||_1 + gamma / 2 || y - g - z ||^2  
% 
% for lambda, gamma > 0, using an equivalent SDP formulation. The script uses CVX 
% (http://cvxr.com/cvx/).
%
% For more information see the paper "Demixing Sines and Spikes: Spectral 
% Super-resolution in the Presence of Outliers" by C. Fernandez-Granda,
% G. Tang, X. Wang and L. Zheng

function g_est = sdp_denoising_outliers_dense_noise(y, lambda, gamma)

n = length(y);

cvx_begin sdp
    variable g_est(n) complex;
    variable z(n) complex;
    variable u(n-1) complex;
    variable u1;
    variable t;

    minimize( ( n * u1 + t) / (2 * sqrt(n)) + lambda * sum( abs(z) ) ...
              + gamma * ( y - g_est - z )' * ( y - g_est - z )/2 );

    [toeplitz([u1; u]).' g_est; g_est' t] >=0;
    
cvx_end
