% Atomic-norm denoising in the presence of outliers, based on solving 
% the problem
% 
% min_g || g ||_A / sqrt(n) + lambda || y - g ||_1 
% 
% for lambda > 0, using an equivalent SDP formulation. The script uses CVX 
% (http://cvxr.com/cvx/).
%
% For more information see the paper "Demixing Sines and Spikes: Spectral 
% Super-resolution in the Presence of Outliers" by C. Fernandez-Granda,
% G. Tang, X. Wang and L. Zheng

function [g_est, z_est] = sdp_denoising_outliers(y, lambda)

n = length(y);

cvx_begin sdp
    variable g_est(n) complex;
    variable u(n-1) complex;
    variable u1;
    variable t;

    minimize( ( n * u1 + t) / (2 * sqrt(n)) + lambda * sum( abs(y - g_est) ) );

    [toeplitz([u1; u]).' g_est; g_est' t] >=0;
    
cvx_end

z_est = y - g_est;
