function [config,NumNodesX] = LoadData(InitialCondType,FileNameInitSolution,SelectedTime)

global LevelSetFunction;

%% load data file

% read front
[InitFront,id_Front,InitArea,x_c,y_c] = ExtractInitDomainShape(FileNameInitSolution,SelectedTime,0,0,0);

% read data (Ux,Uy,M, ...)
load(FileNameInitSolution,'PosX','PosY','M_All','Ux_All','Uy_All','config');

%% Number of Mesh points in x direction (uniform mesh)

% computational domain (big box containing the cell during the simulation)
DomainSizeX                 = 12*config.InitialRadius;
config.Domain               = {[-DomainSizeX/6 5*DomainSizeX/6],[-DomainSizeX/2 DomainSizeX/2]}; 

% for use in main function
config.DomainSizeX          = DomainSizeX;

% Number of Mesh points in x direction (uniform mesh)
% This can be a vector for multiple runs (sequential),
% e.g. NumNodesX = [66 77 88];
NumNodesX                   = 125;  


%% Initial condition (interpolate saved data on the new mesh)

% create a global level-set function using 'InitFront' with actual
% coordinates
LevelSetFunction            = @(x,y) p_poly_dist_my(x,y,InitFront.Polygon(:,1), InitFront.Polygon(:,2));

% index of the inside nodes
InsideMask                  = LevelSetFunction(PosX, PosY) <0;

% actin velocity init. values
InitCondition.Ux            = scatteredInterpolant(PosX(InsideMask), PosY(InsideMask), full(Ux_All(InsideMask,id_Front)),'natural');
InitCondition.Uy            = scatteredInterpolant(PosX(InsideMask), PosY(InsideMask), full(Uy_All(InsideMask,id_Front)),'natural');

% myosin init. value
InitCondition.M             = scatteredInterpolant(PosX(InsideMask), PosY(InsideMask), full(M_All(InsideMask,id_Front)),'natural');

% re-normalize the level-set function and the interpolation functions'
% coordinates
InitFront.Polygon(:,1)      = InitFront.Polygon(:,1) - x_c;
InitFront.Polygon(:,2)      = InitFront.Polygon(:,2) - y_c;
LevelSetFunction            = @(x,y) p_poly_dist_my(x,y,InitFront.Polygon(:,1), InitFront.Polygon(:,2));

InitCondition.Ux.Points(:,1)= InitCondition.Ux.Points(:,1) - x_c;
InitCondition.Ux.Points(:,2)= InitCondition.Ux.Points(:,2) - y_c;

InitCondition.Uy.Points(:,1)= InitCondition.Uy.Points(:,1) - x_c;
InitCondition.Uy.Points(:,2)= InitCondition.Uy.Points(:,2) - y_c;

InitCondition.M.Points(:,1) = InitCondition.M.Points(:,1) - x_c;
InitCondition.M.Points(:,2) = InitCondition.M.Points(:,2) - y_c;

%% Final preparations

config.InitCondition        = InitCondition; 
config.InitialCondType      = InitialCondType;
config.InitDomainShape      = 'ShapeFromSavedData';
config.InitFront            = InitFront;
config.InitArea             = InitArea;

end