function [CellVariable] = CreateCellVariable(FuncOrConst,NumInsideNodes,varargin)

% creates a cell variable that is defined everywhere inside the domain.
% 'FuncOrConst' could be either a constant or a function with independent
% variables defined in 'varargin'. Please note the function should be
% defined using Element-By-Element notations.
%
% For example, to create a cell variable from a constant 'ksi'
%   1-   CellVariablekisi =  CreateCellVariable(ksi,NumInsideNodes)
%
% Or, to create a cell variable for ksi(x,U) = 1+x-U/x  (U is the state variable in our problem)
%
%   1-   ksi = @(x,u) 1+x-u./x;
%   2-   U_local = U(InsideOldMask); X_local = PosX(InsideOldMask);
%   2-   CellVariablekisi =  CreateCellVariable(ksi, NumInsideNodes, X_local, U_local)

CellVariable = FuncOrConst(varargin{:}).*ones(NumInsideNodes,1);

end  % end function 'CreateCellVariable' 