function [xc,yc,R,obj_func_optimized] = IsCircle(x_c,y_c,x_c0,y_c0)

% optimization with fminsearch

% define and objective function that needs to be minimized
obj_func = @(x) sum((sqrt((x_c-x(1)).^2+(y_c-x(2)).^2) - x(3)).^2);

% send the obj_func with an inital guess for unknowns to the Nelder-Mead
% algorithm 
a_guess = [x_c0,y_c0,0];
options = optimset('MaxFunEvals', 500*3);
[a_optimized,obj_func_optimized] = fminsearch(obj_func,a_guess,options);

xc = a_optimized(1);
yc = a_optimized(2);
R = a_optimized(3);


