function [mat,vector] = SourceTerm(A, Source, RankineHugoniot, A_old)

% returns the matrix 'mat' or the RHS 'vector' of the source term. 
% Some notes:
% 1- Source should be a 'cell' variable defined everywhere inside the
% domain. Any function or constant can be converted to a 'cell' variable
% using 'CreateCellVariable'. 
%
% 2- in time-dependent problems A_old should be used to build RHS
% for 'Rankine-Hugoniot', and 'A' for Dirichlet BC.
% 
% 3- in stationary problems, or in time-dependent problems with implicit
% treatment of the source term, the matrix is always constructed using A,
% so simply call the function as:  
%                            [mat,~] = SourceTerm(A, Source)


% Check the input arguments to see whether we need to assemble the system
% matrices or the resulting vectors.

if nargin<3    % assembles the coeff matrix 'mat' (LHS) 
  vector = [];
  NumInsideNodes = length(Source);
  mat = sparse(1:NumInsideNodes, 1:NumInsideNodes, A.*Source , NumInsideNodes, NumInsideNodes);

else            % assembles the 'vector = mat*Source' (RHS)
  mat = [];
  if RankineHugoniot
    vector = Source.*A_old;
  else
    vector = Source.*A;
  end
end

end  % end of function 'SourceTerm'