import stokeslet_new as st
import analyze_density_tests as ana
import numpy as np
import matplotlib.pyplot as plt

numCircles = range(20,60,5)
runsPerDensity = 2

lead_offset = 0.002
rear_offset = 0.002
bott_offset = 0.25
top_offset = 0.25
N = 512

for num in numCircles:
    for run in range(0,runsPerDensity):
        ss, pf, fg = ana.load_run(num,run,'runs_with_velocity_BC')
        fg_lead = st.FluidGrid(1-lead_offset,1-lead_offset,1,bott_offset,1-top_offset,N)
        fg_rear = st.FluidGrid(rear_offset,rear_offset,1,bott_offset,1-top_offset,N)
        st.compute_flow(pf,fg_lead,ss)
        st.compute_flow(pf,fg_rear,ss)
        plt.figure()
        plt.plot(fg_lead.Y.flatten(),fg_lead.P.flatten())
        plt.plot(fg_rear.Y.flatten(),fg_rear.P.flatten(),'r')