import stokeslet_new as st
import matplotlib.pyplot as plt
import numpy as np
import pickle
import datetime

numCircles = range(5,165,5)
runsPerDensity = 10

for num in numCircles:
    for run in range(0,runsPerDensity):
        start = datetime.datetime.now()

        ss = st.StokesletSetup()
        ss.numCircles = num
        ss.nFPerCircle = 25
        
        #xF, yF = st.generate_circles(ss)
        
        pf = st.generate_cell_with_velocity(1.0,ss)
        #pf.add_points(xF,yF,uF=0,vF=0)
        pf.compute_forces(ss)
        
        fg = st.FluidGrid(0,1,128,0,1,128)
        st.compute_flow(pf,fg,ss)
        
        finish = datetime.datetime.now()
        
        filename = 'numCircle.' + str(num) + '.run.' + str(run) + '.data'
        file = open(filename,'wb')
        
        pickle.dump(ss,file)
        pickle.dump(pf,file)
        pickle.dump(fg,file)
        pickle.dump(start,file)
        pickle.dump(finish,file)
        
        file.close()