from common import *

import numpy.random as rand
from matplotlib.delaunay.triangulate import delaunay
import scipy.linalg as la
from libstokeslet_cpp import *

use_mp = True

def toggle_mp():
    global use_mp
    use_mp = not use_mp

## Structure for general problem information
#class StokesletSetup:
#    def __init__(self):
#        self.init = False
#        
#        self.mu = 1.0
#        
#        self.a = .005
#        self.nFPerCircle = 40
#        self.numCircles = 20
#        self.nF = self.nFPerCircle*self.numCircles
#        self.ds = 2*pi*self.a/self.nFPerCircle
#        self.e = .25*self.ds
#
#        self.xMin = 0
#        self.xMax = 1
#        self.yMin = 0
#        self.yMax = 1
#
#        self.init = True
#        
#    def __setattr__(self,name,value):
#        self.__dict__[name] = value
#        if not self.init:
#            return
#        if name == "nFPerCircle" or name == "numCircles":
#            self.nF = self.nFPerCircle*self.numCircles
#            self.ds = 2*pi*self.a/self.nFPerCircle
#            self.e = .25*self.ds
#        if name == "a":
#            self.ds = 2*pi*self.a/self.nFPerCircle
#            self.e = .25*self.ds

#def generate_cell_with_velocity(v_cell,setup):
#    xMin = setup.xMin
#    xMax = setup.xMax
#    yMin = setup.yMin
#    yMax = setup.yMax
#    ds = setup.ds
#    
#    nX = np.ceil((xMax-xMin)/ds)
#    nY = np.ceil((yMax-yMin)/ds)
#    
#    xT, yT = generate_line(xMin,xMax,yMax,yMax,nX)
#    xB, yB = generate_line(xMin,xMax,yMin,yMin,nX)
#    xL, yL = generate_line(xMin,xMin,yMin,yMax,nY)
#    xR, yR = generate_line(xMax,xMax,yMin,yMax,nY)
#    
#    pf = PointForces()
#    
#    pf.add_points(xT, yT, uF = 0, vF = 0)
#    pf.add_points(xB, yB, uF = 0, vF = 0)
#    pf.add_points(xL, yL, uF = v_cell, vF = 0)
#    pf.add_points(xR, yR, uF = v_cell, vF = 0)
#    
#    xCirc, yCirc, xCent, yCent = generate_circles(setup,withCenters=True)
#    
#    pf.xCent = xCent
#    pf.yCent = yCent
#    pf.add_points(xCirc, yCirc, uF = 0, vF = 0)
#    
#    return pf
#
#def generate_cell(tensL,tensR,setup):
#    xMin = setup.xMin
#    xMax = setup.xMax
#    yMin = setup.yMin
#    yMax = setup.yMax
#    ds = setup.ds
#    
#    nX = np.ceil((xMax-xMin)/ds)
#    nY = np.ceil((yMax-yMin)/ds)
#    
#    fL = tensL/nY
#    fR = tensR/nY
#    gL = 0
#    gR = 0
#    
#    xT, yT = generate_line(xMin,xMax,yMax,yMax,nX)
#    xB, yB = generate_line(xMin,xMax,yMin,yMin,nX)
#    #xL, yL = generate_line(xMin,xMin,yMin,yMax,nY)
#    xR, yR = generate_line(xMax,xMax,yMin,yMax,nY)
#    
#    pf = PointForces()
#    
#    pf.add_points(xT, yT, uF = 0, vF = 0)
#    pf.add_points(xB, yB, uF = 0, vF = 0)
#    #pf.add_points(xL, yL, fF = fL, gF = gL)
#    pf.add_points(xR, yR, fF = fR, gF = gR)
#    
#    xC, yC = generate_circles(setup)
#    
#    pf.add_points(xC, yC, uF = 0, vF = 0)
#    
#    return pf
#
#def generate_cell_2(pL,pR,uL,uR,setup):
#    xMin = setup.xMin
#    xMax = setup.xMax
#    yMin = setup.yMin
#    yMax = setup.yMax
#    ds = setup.ds
#    
#    nX = np.ceil((xMax-xMin)/ds)
#    nY = np.ceil((yMax-yMin)/ds)
#
#    xT, yT = generate_line(xMin,xMax,yMax,yMax,nX)
#    xB, yB = generate_line(xMin,xMax,yMin,yMin,nX)
#    xL, yL = generate_line(xMin,xMin,yMin,yMax,nY)
#    xR, yR = generate_line(xMax,xMax,yMin,yMax,nY)
#    
#    pf = PointForces()
#    
#    pf.add_points(xT, yT, uF = 0, vF = 0)
#    pf.add_points(xB, yB, uF = 0, vF = 0)
#    pf.add_points(xL, yL, pF = pL, uF = 0)
#    pf.add_points(xR, yR, pF = pR, uF = 0)
#    
#    xC, yC = generate_circles(setup)
#    
#    #pf.add_points(xC, yC, uF = 0, vF = 0)
#    
#    return pf
#
#def generate_line(xMin,xMax,yMin,yMax,n):
#    dx = (np.double(xMax) - np.double(xMin))/n
#    dy = (np.double(yMax) - np.double(yMin))/n
#    x = np.linspace(np.double(xMin),np.double(xMax),endpoint=False,num=n) + 0.5*dx
#    y = np.linspace(np.double(yMin),np.double(yMax),endpoint=False,num=n) + 0.5*dy
#    return x, y
#
#def generate_box(xMin,xMax,yMin,yMax,n):
#    x_l, y_l = generate_line(xMin,xMin,yMin,yMax,n)
#    x_r, y_r = generate_line(xMax,yMax,yMin,yMax,n)
#    x_b, y_b = generate_line(xMin,xMax,yMin,yMin,n)
#    x_t, y_t = generate_line(xMin,xMax,yMax,yMax,n)
#    
#    x = np.append(x_l, x_t)
#    x = np.append(x, x_r)
#    x = np.append(x, x_b)
#    y = np.append(y_l, y_t)
#    y = np.append(y, y_r)
#    y = np.append(y, y_b)
#    
#    return x, y

## Structure containing x and y coordinates of point
## forces and the x and y (labeled f and g) components
## of the force vectors at those points, as well as
## the u and v components of the velocity at those points
#class PointForces:
#    def __init__(self):
#        self.clear()
#        
#    def clear(self):
#        self.nF = 0
#        self.xF = np.zeros((0))
#        self.yF = np.zeros((0))
#        self.fF = np.zeros((0))
#        self.fKnown = np.zeros((0))
#        self.gF = np.zeros((0))
#        self.gKnown = np.zeros((0))
#        self.uF = np.zeros((0))
#        self.uKnown = np.zeros((0))
#        self.vF = np.zeros((0))
#        self.vKnown = np.zeros((0))
#        self.pF = np.zeros((0))
#        self.pKnown = np.zeros((0))
#    
#    def compute_flow_from_known_forces(self,setup):
#        known_ind = np.nonzero((self.fKnown == 1)*(self.gKnown == 1))
#        f_k = self.fF[known_ind]
#        g_k = self.gF[known_ind]
#        x_k = self.xF[known_ind]
#        y_k = self.yF[known_ind]
#        
#        pf_known = PointForces()
#        pf_known.add_points(x_k, y_k, fF=f_k, gF=g_k)
#        
#        unknown_ind = np.nonzero((self.fKnown != 1) + (self.gKnown != 1))
#        x_u = self.xF[unknown_ind]
#        y_u = self.yF[unknown_ind]
#        u, v, p = compute_flow_1D(pf_known,x_u,y_u,setup)
#        return u, v, p, unknown_ind
#    
#    def compute_forces(self,setup):
#        u, v, p, unknown_ind = self.compute_flow_from_known_forces(setup)
#        
#        u = self.uF[unknown_ind] - u
#        v = self.vF[unknown_ind] - v
#        p = self.pF[unknown_ind] - p
#
#        x = self.xF[unknown_ind]
#        y = self.yF[unknown_ind]
#        
#        pf_unknown = PointForces()
#        pf_unknown.add_points(x,y,uF=u,vF=v,pF=p)
#        pf_unknown.uKnown = self.uKnown[unknown_ind]
#        pf_unknown.vKnown = self.vKnown[unknown_ind]
#        pf_unknown.pKnown = self.pKnown[unknown_ind]
#        
#        compute_forces(pf_unknown,setup)
#        
#        self.fF[unknown_ind] = pf_unknown.fF
#        self.gF[unknown_ind] = pf_unknown.gF
#
#    def append_or_make_zero(self,target,appendee,nF):
#        if appendee == None:
#            output = np.append(target,np.zeros((nF)))
#        elif type(appendee) == int or type(appendee) == float or type(appendee) == np.float64:
#            output = np.append(target,appendee*np.ones((nF)))
#        else:
#            output = np.append(target,appendee)
#        return output
#    
#    def append_known(self,target,known,nF):
#        if known == None:
#            output = self.append_or_make_zero(target,known,nF)
#        else:
#            output = self.append_or_make_zero(target,1,nF)
#        return output
#    
#    def add_points(self,xF,yF,fF=None,gF=None,uF=None,vF=None,pF=None):
#        nF = xF.size
#        self.xF = np.append(self.xF,xF)
#        self.yF = np.append(self.yF,yF)
#        
#        self.fF = self.append_or_make_zero(self.fF,fF,nF)
#        self.fKnown = self.append_known(self.fKnown,fF,nF)
#        
#        self.gF = self.append_or_make_zero(self.gF,gF,nF)
#        self.gKnown = self.append_known(self.gKnown,gF,nF)
#        
#        self.uF = self.append_or_make_zero(self.uF,uF,nF)
#        self.uKnown = self.append_known(self.uKnown,uF,nF)
#        
#        self.vF = self.append_or_make_zero(self.vF,vF,nF)
#        self.vKnown = self.append_known(self.vKnown,vF,nF)
#        
#        self.pF = self.append_or_make_zero(self.pF,pF,nF)
#        self.pKnown = self.append_known(self.pKnown,pF,nF)
#        
#        self.nF += nF

## Structure containing x and y coordinates of points
## at which to find the velocity field and pressure,
## and arrays giving the u and v components of the velocity
## and the pressure at those points
#class FluidGrid:
#    def __init__(self,xMin,xMax,nX,yMin,yMax,nY):
#        self.xMin = xMin
#        self.xMax = xMax
#        self.nX = nX
#        self.yMin = yMin
#        self.yMax = yMax
#        self.nY = nY
#
#        self.x = np.linspace(xMin,xMax,nX,endpoint=True)
#        self.y = np.linspace(yMin,yMax,nY,endpoint=True)
#        
#        self.X, self.Y = np.meshgrid(self.x,self.y)
#        
#        self.U = np.zeros((nY,nX))
#        self.V = np.zeros((nY,nX))
#        self.P = np.zeros((nY,nX))

## Generate n evenly spaced (in arclength) points around
## the perimeter of a cylinder of radius a center at
## (xC,yC).
#def make_cylinder(xC,yC,setup):
#    a = setup.a
#    n = setup.nFPerCircle
#    th = np.linspace(0,2*np.pi,n,endpoint=False)
#    x = xC + a*np.cos(th)
#    y = yC + a*np.sin(th)
#    return x, y
#
#def generate_centers(setup,maxIts=200000):
#    numCircles = setup.numCircles
#    a = setup.a
#    # Generate a circle which is entirely within the interior of the
#    # unit square, and which is at least two cylinder diameters from
#    # the leading edge of the cell.
#    
#    # Distance from cylinder edge to leading edge
#    LE_dist = 4.0*a
#    
#    xC = ((np.random.rand((numCircles)))**(1.0/6.0))*(1 - (LE_dist + 2.0*a)) + a
#    yC = np.random.rand((numCircles))*(1 - 2.0*a) + a
#    if maxIts <= 0 or numCircles <= 1:
#        return xC, yC
#    dmin = 0
#    it = 0
#    while it < maxIts:
#        
#        xC = ((np.random.rand((numCircles)))**(1.0/6.0))*(1 - (LE_dist + 2.0*a)) + a
#        yC = np.random.rand((numCircles))*(1 - 2.0*a) + a
#        
#        if numCircles == 2:
#            dmin = sqrt((xC[0]-xC[1])**2.0 + (yC[0]-yC[1])**2.0)
#        else:
#            circumcenters, edges, tri_points, tri_neighbors = delaunay(xC,yC)
#            dx = xC[edges[:,0]] - xC[edges[:,1]]
#            dy = yC[edges[:,0]] - yC[edges[:,1]]
#            dist = np.sqrt(dx**2.0 + dy**2.0)
#            dmin = min(dist)
#        if dmin > 2*a:
#            return xC, yC
#        it += 1
#        del(xC,yC,dx,dy,dist,dmin)
#    return xC, yC
#
#def generate_gridded_circles(setup):
#    numCircles = setup.numCircles
#    nFPerCircle = setup.nFPerCircle
#    a = setup.a
#
#    
#    
#    xF = np.zeros((0))
#    yF = np.zeros((0))
#    for k in range(0,numCircles):
#        xAdd, yAdd = make_cylinder(xC[k],yC[k],setup)
#        xF = np.append(xF,xAdd)
#        yF = np.append(yF,yAdd)
#
#def generate_circles(setup,withCenters=False):
#    numCircles = setup.numCircles
#    nFPerCircle = setup.nFPerCircle
#    a = setup.a
#    xC, yC = generate_centers(setup)
#    xF = np.zeros((0))
#    yF = np.zeros((0))
#    for k in range(0,numCircles):
#        xAdd, yAdd = make_cylinder(xC[k],yC[k],setup)
#        xF = np.append(xF,xAdd)
#        yF = np.append(yF,yAdd)
#    if withCenters:
#        return xF, yF, xC, yC
#    return xF, yF
#
#def generate_circles_from_centers(setup,xC,yC):
#    numCircles = setup.numCircles
#    nFPerCircle = setup.nFPerCircle
#    a = setup.a
#    xF = np.zeros((0))
#    yF = np.zeros((0))
#    for k in range(0,numCircles):
#        xAdd, yAdd = make_cylinder(xC[k],yC[k],setup)
#        xF = np.append(xF,xAdd)
#        yF = np.append(yF,yAdd)
#    return xF, yF

#def vectorize(xComponent,yComponent):
#    return np.append(xComponent,yComponent)
#
#def unvectorize(vec):
#    size = vec.size
#    N = size/2
#    xComponent = vec[:N]
#    yComponent = vec[N:]
#    return xComponent, yComponent

## Given a PointForces (pf) structure with xF, yF,
## fF, and gF defined, and given a FluidGrid (fg)
## with X and Y defined, computes and stores in
## fg.U, fg.V, and fg.P, the velocity and pressure
## due to those forces
#def compute_flow_py(pf,fg,setup):
#    nF = pf.xF.shape[0]
#    e = setup.e
#    mu = setup.mu
#    
#    for k in range(0,nF):
#        # x - x_k and y - y_k
#        xMxK = fg.X - pf.xF[k]
#        yMyK = fg.Y - pf.yF[k]
#        
#        # f dot (x - x_k)
#        f_dot_xMxK = pf.fF[k]*xMxK + pf.gF[k]*yMyK
#        
#        r2 = xMxK**2.0 + yMyK**2.0
#        e2 = e**2.0
#        r = sqrt(r2)
#        root_r2Pe2 = sqrt(r2 + e2)
#        
#        fg.P = fg.P + (1/(2*pi))*f_dot_xMxK*\
#            ((r2 + 2*e2 + e*root_r2Pe2)/((root_r2Pe2 + e)*(root_r2Pe2)**3.0))
#        
#        velFactor1 = log(root_r2Pe2 + e) - \
#            (e*(root_r2Pe2 + 2*e))/((root_r2Pe2 + e)*root_r2Pe2)
#        velFactor2 = (root_r2Pe2 + 2*e)/(((root_r2Pe2+e)**2.0)*root_r2Pe2)
#        
#        fg.U = fg.U + (-pf.fF[k]/(4*pi*mu))*velFactor1 + \
#            (1.0/(4*pi*mu))*f_dot_xMxK*xMxK*velFactor2
#        
#        fg.V = fg.V + (-pf.gF[k]/(4*pi*mu))*velFactor1 + \
#            (1.0/(4*pi*mu))*f_dot_xMxK*yMyK*velFactor2
#    fg.speed = np.sqrt(fg.U**2.0 + fg.V**2.0)
#
#def compute_flow(pf,fg,setup):
#    global use_mp
#    if use_mp:
#        compute_flow_mp_cpp(pf,fg,setup)
#    else:
#        compute_flow_cpp(pf,fg,setup)
#    fg.speed = np.sqrt(fg.U**2.0 + fg.V**2.0)
#
#def compute_flow_1D(pf,x,y,setup):
#    nF = pf.xF.shape[0]
#    nOut = x.shape[0]
#    e = setup.e
#    mu = setup.mu
#    
#    P = np.zeros((nOut))
#    U = np.zeros((nOut))
#    V = np.zeros((nOut))
#    
#    for k in range(0,nF):
#        # x - x_k and y - y_k
#        xMxK = x - pf.xF[k]
#        yMyK = y - pf.yF[k]
#        
#        # f dot (x - x_k)
#        f_dot_xMxK = pf.fF[k]*xMxK + pf.gF[k]*yMyK
#        
#        r2 = xMxK**2.0 + yMyK**2.0
#        e2 = e**2.0
#        r = sqrt(r2)
#        root_r2Pe2 = sqrt(r2 + e2)
#        
#        P = P + (1/(2*pi))*f_dot_xMxK*\
#            ((r2 + 2*e2 + e*root_r2Pe2)/((root_r2Pe2 + e)*(root_r2Pe2)**3.0))
#        
#        velFactor1 = log(root_r2Pe2 + e) - \
#            (e*(root_r2Pe2 + 2*e))/((root_r2Pe2 + e)*root_r2Pe2)
#        velFactor2 = (root_r2Pe2 + 2*e)/(((root_r2Pe2+e)**2.0)*root_r2Pe2)
#        
#        U = U + (-pf.fF[k]/(4*pi*mu))*velFactor1 + \
#            (1.0/(4*pi*mu))*f_dot_xMxK*xMxK*velFactor2
#        
#        V = V + (-pf.gF[k]/(4*pi*mu))*velFactor1 + \
#            (1.0/(4*pi*mu))*f_dot_xMxK*yMyK*velFactor2
#            
#    return U, V, P
            
## Compute mobility matrix for a given PointForces
## (pf) class that has the arrays xF and yF defined
#def compute_mobility_py(pf,setup):
#    Msize = 2*pf.nF
#    M = np.zeros((Msize,Msize))
#    
#    e = setup.e
#    mu = setup.mu
#    
#    for k in range(0,pf.nF):
#        x_k = pf.xF[k]
#        y_k = pf.yF[k]
#        
#        fCol = k
#        gCol = k + pf.nF
#        
#        for i in range(0,pf.nF):
#            x_i = pf.xF[i]
#            y_i = pf.yF[i]
#            
#            xMxK = x_i - x_k
#            yMyK = y_i - y_k
#            
#            r2 = xMxK**2.0 + yMyK**2.0
#            e2 = e**2.0
#            r = sqrt(r2)
#            root_r2Pe2 = sqrt(r2+e2)
#            
#            velFactor1 = log(root_r2Pe2 + e) - \
#                (e*(root_r2Pe2 + 2*e))/((root_r2Pe2 + e)*root_r2Pe2)
#            velFactor2 = (root_r2Pe2 + 2*e)/(((root_r2Pe2+e)**2.0)*root_r2Pe2)
#            
#            uRow = i
#            vRow = i + pf.nF
#            
#            M[uRow,fCol] = -velFactor1/(4*pi*mu) + (xMxK**2.0)*velFactor2/(4*pi*mu)
#            M[uRow,gCol] = xMxK*yMyK*velFactor2/(4*pi*mu)
#            M[vRow,fCol] = xMxK*yMyK*velFactor2/(4*pi*mu)
#            M[vRow,gCol] = -velFactor1/(4*pi*mu) + (yMyK**2.0)*velFactor2/(4*pi*mu)
#    return M
#
#def compute_forces(pf,setup):
#    global use_mp
#    if use_mp:
#        M = compute_mobility_mp_cpp(pf,setup)
#        rhs = set_rhs_for_mobility_mp_cpp(pf,setup)
#    else:
#        M = compute_mobility_cpp(pf,setup)
#        rhs = set_rhs_for_mobility_cpp(pf,setup)
#    Fvec = la.solve(M,rhs)
#    pf.fF, pf.gF = unvectorize(Fvec)
##    M = compute_mobility(pf,setup)
##    Uvec = vectorize(pf.uF,pf.vF)
##    Fvec = la.solve(M,Uvec)
##    pf.fF, pf.gF = unvectorize(Fvec)
#    
#def compute_exact(fg,setup):
#    a = setup.a
#    mu = setup.mu
#    
#    f0 = 8*pi/(1-2*log(a))
#    g0 = 0.0
#    
#    fDotX = f0*fg.X + g0*fg.Y
#    
#    R2 = fg.X**2.0 + fg.Y**2.0
#    R = sqrt(R2)
#    
#    fg.U = -(f0/(8*pi))*(2*log(R) - (a**2.0)/R2) + (fDotX/(4*pi*R2))*fg.X*(1 - (a**2.0)/R2)
#    fg.V = -(g0/(8*pi))*(2*log(R) - (a**2.0)/R2) + (fDotX/(4*pi*R2))*fg.Y*(1 - (a**2.0)/R2)
    
def mask_flow(fg,setup):
    a = setup.a
    
    R2 = fg.X**2.0 + fg.Y**2.0
    a2 = a**2.0
    
    mask = lambda input: np.ma.masked_where(R2 <= a2, np.ma.array(input))
    
    fg.X_ma = mask(fg.X)
    fg.Y_ma = mask(fg.Y)
    fg.U_ma = mask(fg.U)
    fg.V_ma = mask(fg.V)
    fg.P_ma = mask(fg.P)
