import stokeslet_new as st
import numpy as np
import analyze_density_tests as ana

def average_pressure_drop(num, run, dir, xInset=0.0015, yStart=0.2, yEnd=0.8):
    N = 1024
    
    ss, pf, fg = ana.load_run(num, run, dir)
    
    fgLead = st.FluidGrid(1-xInset,1-xInset,1,yStart,yEnd,N)
    fgRear = st.FluidGrid(xInset,xInset,1,yStart,yEnd,N)
    
    st.compute_flow(pf,fgLead,ss)
    st.compute_flow(pf,fgRear,ss)
    
    P_lead = fgLead.P.flatten().mean()
    P_rear = fgRear.P.flatten().mean()
    
    P_drop = P_lead - P_rear
    return P_drop

def run_average_pressures(numCircles, runsPerDensity, dir, xInset=0.0015, yStart=0.2, yEnd=0.8):
    N = 1024
    P_drops = np.zeros((len(numCircles),runsPerDensity))
    for num in numCircles:
        for run in range(0,runsPerDensity):
            P_drop = average_pressure_drop(num, run, dir, xInset, yStart, yEnd)
            num_ind = numCircles.index(num)
            P_drops[num_ind,run] = P_drop
            P_drops_mean = P_drops.mean(1)
    return P_drops, P_drops_mean