import stokeslet_new as st
import matplotlib.pyplot as plt
import numpy as np
import pickle
import datetime
import analyze_density_tests as ana


numCircles = range(0,5,5)
runsPerDensity = 1
dir = '.'

N = 512

for num in numCircles:
    for run in range(0,runsPerDensity):
        
        ss, pf, fg = ana.load_run(num, run, dir)
        
        
        fgLead = st.FluidGrid(1,1,1,0,1,N)
        fgRear = st.FluidGrid(0,0,1,0,1,N)
        
        st.compute_flow(pf,fgLead,ss)
        st.compute_flow(pf,fgRear,ss)
        
        filename = dir + '/' 'numCircle.' + str(num) + '.run.' + str(run) + '.edge_pressures.data'
        file = open(filename,'wb')
        
        pickle.dump(fgLead,file)
        pickle.dump(fgRear,file)
        
        file.close()