setup = '''
import stokeslet as st
import scipy.sparse as sp
import scipy.sparse.linalg as spla

ss = st.StokesletSetup()
pf = st.generate_cell_with_velocity(1, ss, 20, 20)
u, v, p, unknown_ind = pf.compute_flow_from_known_forces(ss)
u = pf.uF[unknown_ind] - u
v = pf.uF[unknown_ind] - v
p = pf.uF[unknown_ind] - p
x = pf.xF[unknown_ind]
y = pf.yF[unknown_ind]
pf_unknown = st.PointForces()
pf_unknown.add_points(x,y,uF=u,vF=v,pF=p)
pf_unknown.uKnown = pf.uKnown[unknown_ind]
pf_unknown.vKnown = pf.vKnown[unknown_ind]
pf_unknown.pKnown = pf.pKnown[unknown_ind]

M = st.compute_mobility_mp_cpp(pf_unknown,ss)
Msp = sp.csr_matrix(M)
rhs = st.set_rhs_for_mobility_mp_cpp(pf_unknown,ss)
'''

import timeit

print 'Conjugate gradient timing'
Tcg = timeit.Timer(u'Fvec,info = spla.cg(Msp, rhs, tol=1e-9, maxiter=Msp.shape[0])',setup = setup)
cgResults = Tcg.repeat(repeat=3,number=1)
print cgResults
print '\n'

print 'Gmres timing'
Tgmres = timeit.Timer(u'Fvec,info = spla.gmres(Msp, rhs, tol=1e-9, maxiter=Msp.shape[0])',setup = setup)
gmresResults = Tgmres.repeat(repeat=3,number=1)
print gmresResults
print '\n'

print 'Bicg timing'
Tbicg = timeit.Timer(u'Fvec,info = spla.bicg(Msp, rhs, tol=1e-9, maxiter=Msp.shape[0])',setup = setup)
bicgResults = Tbicg.repeat(repeat=3,number=1)
print bicgResults
print '\n'

print 'Bicgstab timing'
Tbicgstab = timeit.Timer(u'Fvec,info = spla.bicgstab(Msp, rhs, tol=1e-9, maxiter=Msp.shape[0])',setup = setup)
bicgStabResults = Tbicgstab.repeat(repeat=3,number=1)
print bicgStabResults
print '\n'

