import numpy as np
import scipy.optimize as opt
import matplotlib.pyplot as plt

def powerlaw(x, amp, index):
    return amp * (x**index)

def fit(x, y):
    logx = np.log(x)
    logy = np.log(y)
    
    fitfunc = lambda p, x: p[0] + p[1]*x
    errfunc = lambda p, x, y: (y - fitfunc(p, x))
    
    pinit = [1.0 -1.0]
    out = opt.leastsq(errfunc, pinit, args=(logx, logy),full_output=1)
    
    pfinal = out[0]
    
    return pfinal

def fitandplot(x, y, loglog='False'):
    plt.figure()
    p = fit(x, y)
    index = pfinal[1]
    amp = np.exp(pfinal[0])
    
    xmin = x.min()
    xmax = x.max()
    
    xx = np.linspace(xmin,xmax,100,endpoint=True)
    yy = powerlaw(xx, amp, index)
    
    if loglog:
        plt.loglog(x, y, 'bo')
        plt.loglog(xx,yy,'r')
    else:
        plt.plot(x, y, 'bo')
        plt.plot(xx,yy,'r')
    plt.xlim(xmin,xmax)
    return p