from common import *

# Structure containing x and y coordinates of points
# at which to find the velocity field and pressure,
# and arrays giving the u and v components of the velocity
# and the pressure at those points
class FluidGrid:
    def __init__(self,xMin,xMax,nX,yMin,yMax,nY):
        self.xMin = xMin
        self.xMax = xMax
        self.nX = nX
        self.yMin = yMin
        self.yMax = yMax
        self.nY = nY

        self.x = np.linspace(xMin,xMax,nX,endpoint=True)
        self.y = np.linspace(yMin,yMax,nY,endpoint=True)
        
        self.X, self.Y = np.meshgrid(self.x,self.y)
        
        self.U = np.zeros((nY,nX))
        self.V = np.zeros((nY,nX))
        self.P = np.zeros((nY,nX))