from common import *
from compute import *

# Structure containing x and y coordinates of point
# forces and the x and y (labeled f and g) components
# of the force vectors at those points, as well as
# the u and v components of the velocity at those points
class PointForces:
    def __init__(self):
        self.clear()
        
    def clear(self):
        self.nF = 0
        self.xF = np.zeros((0))
        self.yF = np.zeros((0))
        self.fF = np.zeros((0))
        self.fKnown = np.zeros((0))
        self.gF = np.zeros((0))
        self.gKnown = np.zeros((0))
        self.uF = np.zeros((0))
        self.uKnown = np.zeros((0))
        self.vF = np.zeros((0))
        self.vKnown = np.zeros((0))
        self.pF = np.zeros((0))
        self.pKnown = np.zeros((0))
    
    def compute_flow_from_known_forces(self,setup):
        known_ind = np.nonzero((self.fKnown == 1)*(self.gKnown == 1))
        f_k = self.fF[known_ind]
        g_k = self.gF[known_ind]
        x_k = self.xF[known_ind]
        y_k = self.yF[known_ind]
        
        pf_known = PointForces()
        pf_known.add_points(x_k, y_k, fF=f_k, gF=g_k)
        
        unknown_ind = np.nonzero((self.fKnown != 1) + (self.gKnown != 1))
        x_u = self.xF[unknown_ind]
        y_u = self.yF[unknown_ind]
        u, v, p = compute_flow_1D(pf_known,x_u,y_u,setup)
        return u, v, p, unknown_ind

    def compute_forces(self,setup):
        u, v, p, unknown_ind = self.compute_flow_from_known_forces(setup)
        
        u = self.uF[unknown_ind] - u
        v = self.vF[unknown_ind] - v
        p = self.pF[unknown_ind] - p

        x = self.xF[unknown_ind]
        y = self.yF[unknown_ind]
        
        pf_unknown = PointForces()
        pf_unknown.add_points(x,y,uF=u,vF=v,pF=p)
        pf_unknown.uKnown = self.uKnown[unknown_ind]
        pf_unknown.vKnown = self.vKnown[unknown_ind]
        pf_unknown.pKnown = self.pKnown[unknown_ind]
        
        compute_forces(pf_unknown,setup)
        
        self.fF[unknown_ind] = pf_unknown.fF
        self.gF[unknown_ind] = pf_unknown.gF

    def append_or_make_zero(self,target,appendee,nF):
        if appendee == None:
            output = np.append(target,np.zeros((nF)))
        elif type(appendee) == int or type(appendee) == float or type(appendee) == np.float64:
            output = np.append(target,appendee*np.ones((nF)))
        else:
            output = np.append(target,appendee)
        return output
    
    def append_known(self,target,known,nF):
        if known == None:
            output = self.append_or_make_zero(target,known,nF)
        else:
            output = self.append_or_make_zero(target,1,nF)
        return output
    
    def add_points(self,xF,yF,fF=None,gF=None,uF=None,vF=None,pF=None):
        nF = xF.size
        self.xF = np.append(self.xF,xF)
        self.yF = np.append(self.yF,yF)
        
        self.fF = self.append_or_make_zero(self.fF,fF,nF)
        self.fKnown = self.append_known(self.fKnown,fF,nF)
        
        self.gF = self.append_or_make_zero(self.gF,gF,nF)
        self.gKnown = self.append_known(self.gKnown,gF,nF)
        
        self.uF = self.append_or_make_zero(self.uF,uF,nF)
        self.uKnown = self.append_known(self.uKnown,uF,nF)
        
        self.vF = self.append_or_make_zero(self.vF,vF,nF)
        self.vKnown = self.append_known(self.vKnown,vF,nF)
        
        self.pF = self.append_or_make_zero(self.pF,pF,nF)
        self.pKnown = self.append_known(self.pKnown,pF,nF)
        
        self.nF += nF