from common import *

# Structure for general problem information
class StokesletSetup:
    def __init__(self):
        self.init = False
        
        self.mu = 1.0
        
        self.a = .005
        self.nFPerCircle = 20
        self.numCircles = 20
        self.nF = self.nFPerCircle*self.numCircles
        self.ds = 2*pi*self.a/self.nFPerCircle
        self.e = self.ds

        self.xMin = 0
        self.xMax = 1
        self.yMin = 0
        self.yMax = 1

        self.init = True
        
    def __setattr__(self,name,value):
        self.__dict__[name] = value
        if not self.init:
            return
        if name == "nFPerCircle" or name == "numCircles":
            self.nF = self.nFPerCircle*self.numCircles
            self.ds = 2*pi*self.a/self.nFPerCircle
            self.e = self.ds
        if name == "a":
            self.ds = 2*pi*self.a/self.nFPerCircle
            self.e = self.ds
        if name == "ds":
            self.e = self.ds