import stokeslet as st
import pickle
import numpy as np
import scipy.integrate as integrate

body_num = 20
front_num_range = range(5,270,5)

front_rear_edge_offset = 0.01
top_bottom_edge_offset = 0.2

x_rear = 0.0 + front_rear_edge_offset
x_front = 1.0 - front_rear_edge_offset
y_top = 1.0 - top_bottom_edge_offset
y_bottom = 0.0 + top_bottom_edge_offset

runsPerDensity = 10

P_drops = {}

for front_num in front_num_range:
    P_drops[front_num] = []
    for run in range(0,runsPerDensity):
        filename = 'front_num.' + str(front_num) + '.run.' + str(run) + '.data'
        file = open(filename,'rb')
        
        ss = pickle.load(file)
        pf = pickle.load(file)
        
        file.close()
        
        def P(x0,Y):
            if type(Y) is not np.ndarray:
                y = np.array([Y])
            else:
                y = Y
            x = x0*np.ones(y.shape)
            u, v, p = st.compute_arbitrary_flow_mp((x,y),pf,ss)
            return p
        
        P_front = lambda Y: P(x_front,Y)
        P_rear = lambda Y: P(x_rear,Y)
        
        P_front_avg = (integrate.quad(P_front, y_bottom, y_top)[0])/(y_top - y_bottom)
        P_rear_avg = (integrate.quad(P_rear, y_bottom, y_top)[0])/(y_top - y_bottom)
        
        P_drop = P_front_avg - P_rear_avg
        P_drops[front_num].append(P_drop)
    P_drops[front_num] = np.array(P_drops[front_num])
        
P_drops_avg = {}
for front_num in P_drops:
    P_drops_avg[front_num] = P_drops[front_num].mean()

filename = 'pressure_drops.data'
file = open(filename,'wb')
pickle.dump(P_drops_avg,file)
pickle.dump(P_drops,file)
file.close()
