import stokeslet as st
import pickle
import datetime

body_num = 20
front_num_range = range(5,355,5)

runsPerDensity = 10

for front_num in front_num_range:
    for run in range(0,runsPerDensity):
        start = datetime.datetime.now()

        ss = st.StokesletSetup()
        ss.nFPerCircle = 30
        
        pf = st.generate_cell_with_velocity(1.0,ss,body_num,front_num)
        pf.compute_forces(ss)
                
        finish = datetime.datetime.now()
        
        filename = 'front_num.' + str(front_num) + '.run.' + str(run) + '.data'
        file = open(filename,'wb')
        
        pickle.dump(ss,file)
        pickle.dump(pf,file)
        pickle.dump(start,file)
        pickle.dump(finish,file)
        
        file.close()