/*
 * compute_mobility.cpp
 *
 *  Created on: Sep 7, 2012
 *      Author: fogelson
 */

#include "compute_mobility.h"

void export_compute_mobility(){
	def("compute_mobility_cpp",compute_mobility);
	def("compute_mobility_mp_cpp",compute_mobility_mp);
}

object compute_mobility(object pf, object setup){
	int nF = extract<int>(pf.attr("nF"));

	bz_1_ptr uKnown_ptr, vKnown_ptr, pKnown_ptr, fKnown_ptr, gKnown_ptr;
	uKnown_ptr = extract<bz_1_ptr>(pf.attr("uKnown"));
	vKnown_ptr = extract<bz_1_ptr>(pf.attr("vKnown"));
	pKnown_ptr = extract<bz_1_ptr>(pf.attr("pKnown"));
	fKnown_ptr = extract<bz_1_ptr>(pf.attr("fKnown"));
	gKnown_ptr = extract<bz_1_ptr>(pf.attr("gKnown"));
	Array<double,1> & uKnown = *uKnown_ptr.get(),
			& vKnown = *vKnown_ptr.get(),
			& pKnown = *pKnown_ptr.get(),
			& fKnown = *fKnown_ptr.get(),
			& gKnown = *gKnown_ptr.get();

	int Msize = 2*nF;

	npy_intp dims[] = {Msize, Msize};

	PyObject * M_py_ptr = PyArray_SimpleNew(2,dims,NPY_DOUBLE);
	handle<> M_py_hndl(M_py_ptr);
	object M_py(M_py_hndl);

	bz_2_ptr M_bz_ptr = pybz::convertPyToBz<2>(M_py_ptr);
	Array<double,2> & M = *M_bz_ptr.get();
	M = 0;

	double e, mu;
	e = extract<double>(setup.attr("e"));
	mu = extract<double>(setup.attr("mu"));

	bz_1_ptr xF_ptr, yF_ptr;
	xF_ptr = extract<bz_1_ptr>(pf.attr("xF"));
	yF_ptr = extract<bz_1_ptr>(pf.attr("yF"));
	Array<double,1> & xF = *xF_ptr.get(),
			& yF = *yF_ptr.get();


	double x_k, y_k, x_i, y_i;
	double xMxK, yMyK, r2, e2, r, root_r2Pe2, velFactor1, velFactor2, pFactor;

	int row1, row2, fCol, gCol;

	int k, i;

	for(k = 0; k < nF; k++){
		x_k = xF(k);
		y_k = yF(k);

		fCol = k;
		gCol = k + nF;

		for(i = 0; i < nF; i++){
			x_i = xF(i);
			y_i = yF(i);

			xMxK = x_i - x_k;
			yMyK = y_i - y_k;

			r2 = pow2(xMxK) + pow2(yMyK);
			e2 = pow2(e);
			r = sqrt(r2);
			root_r2Pe2 = sqrt(r2+e2);

			pFactor = (r2 + 2.0*e2 + e*root_r2Pe2)/((root_r2Pe2 + e)*pow(root_r2Pe2,3.0));
			velFactor1 = log(root_r2Pe2 + e) - (e*(root_r2Pe2 + 2.0*e))/((root_r2Pe2 + e)*root_r2Pe2);
			velFactor2 = (root_r2Pe2 + 2.0*e)/((pow2(root_r2Pe2+e))*root_r2Pe2);

			row1 = i;
			row2 = i + nF;

			if(uKnown(i) == 1){
				M(row1,fCol) = -velFactor1/(4.0*pi*mu) + (pow2(xMxK))*velFactor2/(4.0*pi*mu);
				M(row1,gCol) = xMxK*yMyK*velFactor2/(4.0*pi*mu);

				if(vKnown(i) == 1){
					M(row2,fCol) = xMxK*yMyK*velFactor2/(4.0*pi*mu);
					M(row2,gCol) = -velFactor1/(4.0*pi*mu) + (pow2(yMyK))*velFactor2/(4.0*pi*mu);
				}
				else if(pKnown(i) == 1){
					M(row2,fCol) = (1.0/(2.0*pi))*xMxK*pFactor;
					M(row2,gCol) = (1.0/(2.0*pi))*yMyK*pFactor;
				}
			}
			else if(vKnown(i) == 1 && pKnown(i) == 1){
				M(row1,fCol) = xMxK*yMyK*velFactor2/(4.0*pi*mu);
				M(row1,gCol) = -velFactor1/(4.0*pi*mu) + (pow2(yMyK))*velFactor2/(4.0*pi*mu);


				M(row2,fCol) = (1.0/(2.0*pi))*xMxK*pFactor;
				M(row2,gCol) = (1.0/(2.0*pi))*yMyK*pFactor;
			}
		}
	}
	return M_py;
}

object compute_mobility_mp(object pf, object setup){
	int nF = extract<int>(pf.attr("nF"));

	bz_1_ptr uKnown_ptr, vKnown_ptr, pKnown_ptr, fKnown_ptr, gKnown_ptr;
	uKnown_ptr = extract<bz_1_ptr>(pf.attr("uKnown"));
	vKnown_ptr = extract<bz_1_ptr>(pf.attr("vKnown"));
	pKnown_ptr = extract<bz_1_ptr>(pf.attr("pKnown"));
	fKnown_ptr = extract<bz_1_ptr>(pf.attr("fKnown"));
	gKnown_ptr = extract<bz_1_ptr>(pf.attr("gKnown"));
	Array<double,1> & uKnown = *uKnown_ptr.get(),
			& vKnown = *vKnown_ptr.get(),
			& pKnown = *pKnown_ptr.get(),
			& fKnown = *fKnown_ptr.get(),
			& gKnown = *gKnown_ptr.get();

	int Msize = 2*nF;

	npy_intp dims[] = {Msize, Msize};

	PyObject * M_py_ptr = PyArray_SimpleNew(2,dims,NPY_DOUBLE);
	handle<> M_py_hndl(M_py_ptr);
	object M_py(M_py_hndl);

	bz_2_ptr M_bz_ptr = pybz::convertPyToBz<2>(M_py_ptr);
	Array<double,2> & M = *M_bz_ptr.get();
	M = 0;

	double e, mu;
	e = extract<double>(setup.attr("e"));
	mu = extract<double>(setup.attr("mu"));

	bz_1_ptr xF_ptr, yF_ptr;
	xF_ptr = extract<bz_1_ptr>(pf.attr("xF"));
	yF_ptr = extract<bz_1_ptr>(pf.attr("yF"));
	Array<double,1> & xF = *xF_ptr.get(),
			& yF = *yF_ptr.get();


	double x_k, y_k, x_i, y_i;
	double xMxK, yMyK, r2, e2, r, root_r2Pe2, velFactor1, velFactor2, pFactor;

	int row1, row2, fCol, gCol;

	int k, i;

	int chunk = 100;


	for(k = 0; k < nF; k++){
		x_k = xF(k);
		y_k = yF(k);

		fCol = k;
		gCol = k + nF;

		#pragma omp parallel shared(chunk,k,fCol,gCol) private(i,row1,row2,x_i,y_i,xMxK,yMyK,r2,e2,r,root_r2Pe2,pFactor,velFactor1,velFactor2)
		{
			#pragma omp for schedule(dynamic,chunk) nowait
			for(i = 0; i < nF; i++){
				x_i = xF(i);
				y_i = yF(i);

				xMxK = x_i - x_k;
				yMyK = y_i - y_k;

				r2 = pow2(xMxK) + pow2(yMyK);
				e2 = pow2(e);
				r = sqrt(r2);
				root_r2Pe2 = sqrt(r2+e2);

				pFactor = (r2 + 2.0*e2 + e*root_r2Pe2)/((root_r2Pe2 + e)*pow(root_r2Pe2,3.0));
				velFactor1 = log(root_r2Pe2 + e) - (e*(root_r2Pe2 + 2.0*e))/((root_r2Pe2 + e)*root_r2Pe2);
				velFactor2 = (root_r2Pe2 + 2.0*e)/((pow2(root_r2Pe2+e))*root_r2Pe2);

				row1 = i;
				row2 = i + nF;

				if(uKnown(i) == 1){
					M(row1,fCol) = -velFactor1/(4.0*pi*mu) + (pow2(xMxK))*velFactor2/(4.0*pi*mu);
					M(row1,gCol) = xMxK*yMyK*velFactor2/(4.0*pi*mu);

					if(vKnown(i) == 1){
						M(row2,fCol) = xMxK*yMyK*velFactor2/(4.0*pi*mu);
						M(row2,gCol) = -velFactor1/(4.0*pi*mu) + (pow2(yMyK))*velFactor2/(4.0*pi*mu);
					}
					else if(pKnown(i) == 1){
						M(row2,fCol) = (1.0/(2.0*pi))*xMxK*pFactor;
						M(row2,gCol) = (1.0/(2.0*pi))*yMyK*pFactor;
					}
				}
				else if(vKnown(i) == 1 && pKnown(i) == 1){
					M(row1,fCol) = xMxK*yMyK*velFactor2/(4.0*pi*mu);
					M(row1,gCol) = -velFactor1/(4.0*pi*mu) + (pow2(yMyK))*velFactor2/(4.0*pi*mu);


					M(row2,fCol) = (1.0/(2.0*pi))*xMxK*pFactor;
					M(row2,gCol) = (1.0/(2.0*pi))*yMyK*pFactor;
				}
			}
		}
	}
	return M_py;
}
