from common import *

import numpy.ma as ma
import matplotlib
import matplotlib.pyplot as plt

def plot_pressure(setup,pf,fg):
    plt.contourf(10.0*fg.X,10.0*fg.Y,(1.0e-4)*fg.P,500)
    plt.colorbar()
    plt.xlabel(r'\(x\) (\si{\micro\meter})')
    plt.ylabel(r'\(y\) (\si{\micro\meter})')
    plt.title(r'Pressure (\si{\pico\newton\per\micro\meter\squared})')

def plot_T_drops_statistics(P_drops, P_drops_avg):
    for n in P_drops:
        plt.plot((1.0e-1)*n*np.ones(P_drops[n].shape),-(1.0e-4)*P_drops[n],'bo')
    for n in P_drops_avg:
        plt.plot((1.0e-1)*n,-(1.0e-4)*P_drops_avg[n],'ro')
    plt.xlabel(r'Density of transmembrane proteins near leading edge (\si{proteins\per\square{\micro\meter}})')
    plt.ylabel(r'Tension drop from leading edge to rear (\si{\pico\newton\per\micro\meter})')


def draw_cylinders(setup,pf,color='white',units=False,radius=None,ax=None):
    if radius is None:
        a = setup.a
    else:
        a = radius
        
    xCent = pf.xCent.copy()
    yCent = pf.yCent.copy()
    if units:
        xCent *= 10.0
        yCent *= 10.0

    if ax is None:
        ax = plt.gca()

    r = a
    if units:
        r *= 10.

    for i in range(0,len(xCent)):
        circ = plt.Circle((xCent[i],yCent[i]),radius=r,color=color)
        ax.add_patch(circ)
    plt.draw()
        

def mask_cylinders(setup,pf,fg):
    a = setup.a
    a2 = a**2.0
    
    N = len(pf.xCent)
    
    X = fg.X
    Y = fg.Y
    U_ma = ma.masked_array(fg.U.copy())
    V_ma = ma.masked_array(fg.V.copy())
    P_ma = ma.masked_array(fg.P.copy())

    for n in range(0,N):
        x0 = pf.xCent[n]
        y0 = pf.yCent[n]
        r2 = (X - x0)**2.0 + (Y - y0)**2.0
        interior = (r2 <= a2)
        U_ma.mask = U_ma.mask + interior*(1 - U_ma.mask)
    fg.U_ma = U_ma
    fg.V_ma = V_ma
    fg.P_ma = P_ma
    fg.speed_ma = np.sqrt(U_ma**2.0 + V_ma**2.0)
        