from common import *

import ConfigParser

from ast import literal_eval

current_section = None    

def write_default_config_file():
    config = ConfigParser.ConfigParser()
    global current
    current = ''
    
    def set_current(name):
        global current
        if not config.has_section(name):
            config.add_section(name)
        current = name
    
    def set(name, value):
        global current
        config.set(current,name,value)
    
    set_current('Fluid Properties')
    set('mu',1.0)
    set('dims',(0.0,1.0,0.0,1.0))
    set('nX',128)
    set('nY',128)
    
    set_current('Protein Properties')
    set('a',0.005)
    set('LE_dist',4*0.005)
    set('body_fraction',0.9)
    set('body_num',20)
    set('front_num',100)
    
    set_current('Stokeslet Properties')
    set('nFPerCircle',20)
    
    with open('default.cfg', 'wb') as configfile:
        config.write(configfile)

def read_config_file(name):
    config = ConfigParser.ConfigParser()
    config.read(name)
    return config