/*
 * set_rhs_for_mobility.cpp
 *
 *  Created on: Sep 7, 2012
 *      Author: fogelson
 */

#include "set_rhs_for_mobility.h"

void export_set_rhs_for_mobility(){
	def("set_rhs_for_mobility_cpp",set_rhs_for_mobility);
	def("set_rhs_for_mobility_mp_cpp",set_rhs_for_mobility_mp);
}

object set_rhs_for_mobility(object pf, object setup){
	int nF = extract<int>(pf.attr("nF"));

	bz_1_ptr uKnown_ptr, vKnown_ptr, pKnown_ptr, fKnown_ptr, gKnown_ptr;
	uKnown_ptr = extract<bz_1_ptr>(pf.attr("uKnown"));
	vKnown_ptr = extract<bz_1_ptr>(pf.attr("vKnown"));
	pKnown_ptr = extract<bz_1_ptr>(pf.attr("pKnown"));
	fKnown_ptr = extract<bz_1_ptr>(pf.attr("fKnown"));
	gKnown_ptr = extract<bz_1_ptr>(pf.attr("gKnown"));
	Array<double,1> & uKnown = *uKnown_ptr.get(),
			& vKnown = *vKnown_ptr.get(),
			& pKnown = *pKnown_ptr.get(),
			& fKnown = *fKnown_ptr.get(),
			& gKnown = *gKnown_ptr.get();


	bz_1_ptr u_ptr, v_ptr, p_ptr, f_ptr, g_ptr;
	u_ptr = extract<bz_1_ptr>(pf.attr("uF"));
	v_ptr = extract<bz_1_ptr>(pf.attr("vF"));
	p_ptr = extract<bz_1_ptr>(pf.attr("pF"));
	f_ptr = extract<bz_1_ptr>(pf.attr("fF"));
	g_ptr = extract<bz_1_ptr>(pf.attr("gF"));
	Array<double,1> & u = *u_ptr.get(),
			& v = *v_ptr.get(),
			& p = *p_ptr.get(),
			& f = *f_ptr.get(),
			& g = *g_ptr.get();

	int rhs_size = 2*nF;

	npy_intp dims[] = {rhs_size};

	PyObject * rhs_py_ptr = PyArray_SimpleNew(1,dims,NPY_DOUBLE);
	handle<> rhs_py_hndl(rhs_py_ptr);
	object rhs_py(rhs_py_hndl);

	bz_1_ptr rhs_bz_ptr = extract<bz_1_ptr>(rhs_py);
	Array<double,1> & rhs = *rhs_bz_ptr.get();
	rhs = 0;

	int row1, row2;

	int i = 0;

	for(i = 0; i < nF; i++){
		row1 = i;
		row2 = i + nF;

		if(uKnown(i) == 1){
			rhs(row1) = u(i);

			if(vKnown(i) == 1){
				rhs(row2) = v(i);
			}
			else if(pKnown(i) == 1){
				rhs(row2) = p(i);
			}
		}
		else if(vKnown(i) == 1 && pKnown(i) == 1){
			rhs(row1) = v(i);
			rhs(row2) = p(i);
		}
	}
	return rhs_py;
}


object set_rhs_for_mobility_mp(object pf, object setup){
	int nF = extract<int>(pf.attr("nF"));

	bz_1_ptr uKnown_ptr, vKnown_ptr, pKnown_ptr, fKnown_ptr, gKnown_ptr;
	uKnown_ptr = extract<bz_1_ptr>(pf.attr("uKnown"));
	vKnown_ptr = extract<bz_1_ptr>(pf.attr("vKnown"));
	pKnown_ptr = extract<bz_1_ptr>(pf.attr("pKnown"));
	fKnown_ptr = extract<bz_1_ptr>(pf.attr("fKnown"));
	gKnown_ptr = extract<bz_1_ptr>(pf.attr("gKnown"));
	Array<double,1> & uKnown = *uKnown_ptr.get(),
			& vKnown = *vKnown_ptr.get(),
			& pKnown = *pKnown_ptr.get(),
			& fKnown = *fKnown_ptr.get(),
			& gKnown = *gKnown_ptr.get();


	bz_1_ptr u_ptr, v_ptr, p_ptr, f_ptr, g_ptr;
	u_ptr = extract<bz_1_ptr>(pf.attr("uF"));
	v_ptr = extract<bz_1_ptr>(pf.attr("vF"));
	p_ptr = extract<bz_1_ptr>(pf.attr("pF"));
	f_ptr = extract<bz_1_ptr>(pf.attr("fF"));
	g_ptr = extract<bz_1_ptr>(pf.attr("gF"));
	Array<double,1> & u = *u_ptr.get(),
			& v = *v_ptr.get(),
			& p = *p_ptr.get(),
			& f = *f_ptr.get(),
			& g = *g_ptr.get();

	int rhs_size = 2*nF;

	npy_intp dims[] = {rhs_size};

	PyObject * rhs_py_ptr = PyArray_SimpleNew(1,dims,NPY_DOUBLE);
	handle<> rhs_py_hndl(rhs_py_ptr);
	object rhs_py(rhs_py_hndl);

	bz_1_ptr rhs_bz_ptr = extract<bz_1_ptr>(rhs_py);
	Array<double,1> & rhs = *rhs_bz_ptr.get();
	rhs = 0;

	int row1, row2;

	int i = 0;
	int chunk = 100;

	#pragma omp parallel for default(shared) private(row1, row2) schedule(dynamic,100)
		for(i = 0; i < nF; i++){
			row1 = i;
			row2 = i + nF;

			if(uKnown(i) == 1){
				rhs(row1) = u(i);

				if(vKnown(i) == 1){
					rhs(row2) = v(i);
				}
				else if(pKnown(i) == 1){
					rhs(row2) = p(i);
				}
			}
			else if(vKnown(i) == 1 && pKnown(i) == 1){
				rhs(row1) = v(i);
				rhs(row2) = p(i);
			}
		}
	return rhs_py;
}
