
void veccopy(double r1[2], double r2[2])
{
	int i;
	for(i=0; i<2; i++) r2[i]=r1[i];
}

void vecadd(double r1[2], double r2[2], double r3[2])
{
	int i;
	for(i=0; i<2; i++) r3[i]=r1[i]+r2[i];
}

void vecsub(double r1[2], double r2[2], double r3[2])
{
	int i;
	for(i=0; i<2; i++) r3[i]=r1[i]-r2[i];
}

void vecprod(double r1[2], double x, double r2[2])
{
	r2[0]=x*r1[0];
	r2[1]=x*r1[1];
}

void vecdiv(double r1[2], double x, double r2[2])
{
	r2[0]=r1[0]/x;
	r2[1]=r1[1]/x;
}

void veczero(double r[2])
{
	r[0]=r[1]=0.0;
}

double dotprod(double r1[2], double r2[2])
{
	return r1[0]*r2[0]+r1[1]*r2[1];
}

double unitdotprod(double r1[2], double r2[2])
{
	double n1, n2;
	if((n1=norm(r1))==0.0) return 0.0;
	if((n2=norm(r2))==0.0) return 0.0;
	return dotprod(r1,r2)/n1/n2;
}

double crossprod(double r1[2], double r2[2])
{
	return r1[0]*r2[1]-r2[0]*r1[1];
}

double norm(double r[2])
{
	return sqrt(r[0]*r[0]+r[1]*r[1]);
}

void normalize(double r1[2], double r2[2])
{
	int i;
	double r;
	r=norm(r1);
	if(r==0.0) {r2[0]=1.0; r2[1]=0.0;}
	else {
		for(i=0; i<2; i++) r2[i]=r1[i]/r;
	}
}

double distance(double r1[2], double r2[2])
{
	return sqrt(pow(r1[0]-r2[0],2)+pow(r1[1]-r2[1],2));
}

void limitvector(double r[2], double nrm)	// s.t. 0<=|r|<=nrm
{
	double nr, fct;
	nr=norm(r);
	if(nr<=nrm) return;
	fct=nrm/nr;	// 0<=fct<1
	vecprod(r, fct, r);
}

double randsign(void)
{
	return ran2(&mseed)>0.5?1.0:-1.0;
}

double getangle(double r1[2], double r2[2])	// 0<=angle<pi
{
	double dotp, denom;
	dotp=dotprod(r1,r2);
	denom=norm(r1)*norm(r2);
	if(denom==0.0) return 0.0;
	else if(dotp>denom) return 0.0;
	else if(dotp<-denom) return Pi;
	else return acos(dotp/denom);
}

double getanglesign(double r1[2], double r2[2])	// angle with sign
{
	double crossp;
	crossp=-crossprod(r1, r2);
	return getangle(r1, r2)*sign(crossp);	// CW being +, CCW being -
}

void limitpi(double *x)	// limit -pi<x<pi
{
	while(*x>Pi) *x-=Pidb;
	while(*x<-Pi) *x+=Pidb;
}

void limityaw(double *x)	// limit 0<x<pihalf, for yaw angle
{
	while(*x>Pi) *x-=Pi;	// first limit to 0<x<pi
	while(*x<0) *x+=Pi;
	if(*x>Pihalf) *x=Pi-(*x);	// limit to 0<x<pi/2
}

void Crt2Pol(double r[2], double *a)	// CRT to polar, 0<=a<2*Pi
{
	double xy;
	xy=sqrt(r[0]*r[0]+r[1]*r[1]);
	if(xy==0.0) *a=0.0;
	else if(r[1]>=0.0) *a=acos(r[0]/xy);	// 1st & 2nd quadrants
	else *a=Pidb-acos(r[0]/xy);	// 3rd & 4th quadrants
}

void Pol2Crt(double a, double r[2])	// polar to CRT, r is a unit vector
{
	double sa, ca;
	sa=sin(a);	ca=cos(a);
	r[0]=ca;	r[1]=sa;
}

void Loc2Lab(double r1[2], double r2[2])	// rotate loc (CM) to lab
{
	double rr[2];
	rr[0]=cthb*r1[0]+sthb*r1[1];
	rr[1]=-sthb*r1[0]+cthb*r1[1];
	veccopy(rr,r2);
}

void Lab2Loc(double r1[2], double r2[2])	// rotate lab to loc (CM)
{
	double rr[2];
	rr[0]=cthb*r1[0]-sthb*r1[1];
	rr[1]=sthb*r1[0]+cthb*r1[1];
	veccopy(rr,r2);
}

void Crt2LabPol(double r[2], double *a)	// CRT to lab polar, -pi<a<=Pi
{
	double xy;
	xy=sqrt(r[0]*r[0]+r[1]*r[1]);
	if(xy==0.0) *a=0.0;
	else if(r[0]>=0.0) *a=acos(r[1]/xy);	// 1st & 4th quadrants
	else *a=-acos(r[1]/xy);	// 2nd & 3rd quadrants
}

void RotMatrix(double sth, double cth, double r1[2], double r2[2])
{
	double rr[2];
	rr[0]=cth*r1[0]-sth*r1[1];
	rr[1]=sth*r1[0]+cth*r1[1];
	veccopy(rr,r2);
}

double getcurvature(double r1[2], double r2[2], double r3[2])
{
	int i;
	double drdt[2], drdt2[2], drcross;
	double z;
	
	for(i=0; i<2; i++) {
		drdt[i]=(r3[i]-r1[i])/2;
		drdt2[i]=(r1[i]+r3[i]-2.0*r2[i]);
	}
	drcross=crossprod(drdt, drdt2);
	z=fabs(drcross)/max2(1.0e-9, pow(norm(drdt),3));	// curature=|r' x r"|/|r'|^3
	z=max2(z, 1.0e-3);
	return z;
}

void getcurvaturecenter(double r1[2], double r2[2], double r3[2], double *k, double rc[2])
{
	int i;
	double dr[2];
	double radius;
	
	*k=getcurvature(r1, r2, r3);
	radius=1.0/(*k);	// radius
	for(i=0; i<2; i++) dr[i]=r1[i]+r3[i]-2*r2[i];	// estimated direction of arc center: (r3-r2)-(r2-r1)
	normalize(dr, dr);
	vecprod(dr, radius, rc);	// estimated location of arc center from r2
	vecadd(rc, r2, rc);	// in lab coordinate
}


//----- from NR -----
static float sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : sqrarg*sqrarg)
static float maxarg1,maxarg2;
#define FMAX(a,b) (maxarg1=(a),maxarg2=(b),(maxarg1)>(maxarg2)?(maxarg1):(maxarg2))
static float minarg1,minarg2;
#define FMIN(a,b) (minarg1=(a),minarg2=(b),(minarg1)<(minarg2)?(minarg1):(minarg2))

#define NR_END 1
#define FREE_ARG char*

void nrerror(char error_text[])
/* Numerical Recipes standard error handler */
{
	fprintf(stderr,"Numerical Recipes run-time error...\n");
	fprintf(stderr,"%s\n",error_text);
	fprintf(stderr,"...now exiting to system...\n");
	exit(1);
}

unsigned long *lvector(long nl, long nh)
{	// allocate an unsigned long vector with subscript range v[nl..nh]
	unsigned long *v;

	v=(unsigned long *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(long)));
	if (!v) nrerror("allocation failure in lvector()");
	return v-nl+NR_END;
}

float *vector(long nl, long nh)
/* allocate a float vector with subscript range v[nl..nh] */
{
	float *v;

	v=(float *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(float)));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl+NR_END;
}

double *dvector(long nl, long nh)
{	// allocate a double vector with subscript range v[nl..nh]
	double *v;

	v=(double *)malloc((size_t) ((nh-nl+1+NR_END)*sizeof(double)));
	if (!v) nrerror("allocation failure in dvector()");
	return v-nl+NR_END;
}

float **matrix(long nrl, long nrh, long ncl, long nch)
/* allocate a float matrix with subscript range m[nrl..nrh][ncl..nch] */
{
	long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	float **m;

	/* allocate pointers to rows */
	m=(float **) malloc((size_t)((nrow+NR_END)*sizeof(float*)));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m += NR_END;
	m -= nrl;

	/* allocate rows and set pointers to them */
	m[nrl]=(float *) malloc((size_t)((nrow*ncol+NR_END)*sizeof(float)));
	if (!m[nrl]) nrerror("allocation failure 2 in matrix()");
	m[nrl] += NR_END;
	m[nrl] -= ncl;

	for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

	/* return pointer to array of pointers to rows */
	return m;
}

double **dmatrix(long nrl, long nrh, long ncl, long nch)
{	// allocate a double matrix with subscript range m[nrl..nrh][ncl..nch]
	long i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	double **m;

	/* allocate pointers to rows */
	m=(double **) malloc((size_t)((nrow+NR_END)*sizeof(double*)));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m += NR_END;
	m -= nrl;

	/* allocate rows and set pointers to them */
	m[nrl]=(double *) malloc((size_t)((nrow*ncol+NR_END)*sizeof(double)));
	if (!m[nrl]) nrerror("allocation failure 2 in matrix()");
	m[nrl] += NR_END;
	m[nrl] -= ncl;

	for(i=nrl+1;i<=nrh;i++) m[i]=m[i-1]+ncol;

	/* return pointer to array of pointers to rows */
	return m;
}

double **convert_dmatrix(double *a, long nrl, long nrh, long ncl, long nch)
/* allocate a float matrix m[nrl..nrh][ncl..nch] that points to the matrix
declared in the standard C manner as a[nrow][ncol], where nrow=nrh-nrl+1
and ncol=nch-ncl+1. The routine should be called with the address
&a[0][0] as the first argument. */
{
	long i,j,nrow=nrh-nrl+1,ncol=nch-ncl+1;
	double **m;

	/* allocate pointers to rows */
	m=(double **) malloc((size_t) ((nrow+NR_END)*sizeof(double*)));
	if (!m) nrerror("allocation failure in convert_matrix()");
	m += NR_END;
	m -= nrl;

	/* set pointers to rows */
	m[nrl]=a-ncl;
	for(i=1,j=nrl+1;i<nrow;i++,j++) m[j]=m[j-1]+ncol;
	/* return pointer to array of pointers to rows */
	return m;
}

void free_lvector(unsigned long *v, long nl, long nh)
{	// free an unsigned long vector allocated with lvector()
	free((FREE_ARG) (v+nl-NR_END));
}

void free_vector(float *v, long nl, long nh)
/* free a float vector allocated with vector() */
{
	free((FREE_ARG) (v+nl-NR_END));
}

void free_dvector(double *v, long nl, long nh)
{	// free a double vector allocated with dvector()
	free((FREE_ARG) (v+nl-NR_END));
}

void free_matrix(float **m, long nrl, long nrh, long ncl, long nch)
/* free a float matrix allocated by matrix() */
{
	free((FREE_ARG) (m[nrl]+ncl-NR_END));
	free((FREE_ARG) (m+nrl-NR_END));
}

void free_dmatrix(double **m, long nrl, long nrh, long ncl, long nch)
{	// free a double matrix allocated by dmatrix()
	free((FREE_ARG) (m[nrl]+ncl-NR_END));
	free((FREE_ARG) (m+nrl-NR_END));
}

void free_convert_dmatrix(double **b, long nrl, long nrh, long ncl, long nch)
{	// free a matrix allocated by convert_matrix()
	free((FREE_ARG) (b+nrl-NR_END));
}

        
//----- RNG: ran2 -----

#define IM1 2147483563
#define IM2 2147483399
#define AM (1.0/IM1)
#define IMM1 (IM1-1)
#define IA1 40014
#define IA2 40692
#define IQ1 53668
#define IQ2 52774
#define IR1 12211
#define IR2 3791
#define NTAB 32
#define NDIV (1+IMM1/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

double ran2(long *idum)
{
	int j;
	long k;
	static long idum2=123456789;
	static long iy=0;
	static long iv[NTAB];
	double temp;

	if (*idum <= 0) {
		if (-(*idum) < 1) *idum=1;
		else *idum = -(*idum);
		idum2=(*idum);
		for (j=NTAB+7;j>=0;j--) {
			k=(*idum)/IQ1;
			*idum=IA1*(*idum-k*IQ1)-k*IR1;
			if (*idum < 0) *idum += IM1;
			if (j < NTAB) iv[j] = *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ1;
	*idum=IA1*(*idum-k*IQ1)-k*IR1;
	if (*idum < 0) *idum += IM1;
	k=idum2/IQ2;
	idum2=IA2*(idum2-k*IQ2)-k*IR2;
	if (idum2 < 0) idum2 += IM2;
	j=iy/NDIV;
	iy=iv[j]-idum2;
	iv[j] = *idum;
	if (iy < 1) iy += IMM1;
	if ((temp=AM*iy) > RNMX) return RNMX;
	else return temp;
}
#undef IM1
#undef IM2
#undef AM
#undef IMM1
#undef IA1
#undef IA2
#undef IQ1
#undef IQ2
#undef IR1
#undef IR2
#undef NTAB
#undef NDIV
#undef EPS
#undef RNMX


//----- RNG: ran3 -----

#define MBIG 1000000000
#define MSEED 161803398
#define MZ 0
#define FAC (1.0/MBIG)

double ran3(long *idum)
{
	static int inext,inextp;
	static long ma[56];
	static int iff=0;
	long mj,mk;
	int i,ii,k;

	if (*idum < 0 || iff == 0) {
		iff=1;
		mj=MSEED-(*idum < 0 ? -*idum : *idum);
		mj %= MBIG;
		ma[55]=mj;
		mk=1;
		for (i=1;i<=54;i++) {
			ii=(21*i) % 55;
			ma[ii]=mk;
			mk=mj-mk;
			if (mk < MZ) mk += MBIG;
			mj=ma[ii];
		}
		for (k=1;k<=4;k++)
			for (i=1;i<=55;i++) {
				ma[i] -= ma[1+(i+30) % 55];
				if (ma[i] < MZ) ma[i] += MBIG;
			}
		inext=0;
		inextp=31;
		*idum=1;
	}
	if (++inext == 56) inext=1;
	if (++inextp == 56) inextp=1;
	mj=ma[inext]-ma[inextp];
	if (mj < MZ) mj += MBIG;
	ma[inext]=mj;
	return mj*FAC;
}
#undef MBIG
#undef MSEED
#undef MZ
#undef FAC


//---------------- Root Finding --------------------

#define ITMAX 100
#define EPS 3.0e-8

double zbrent(double (*func)(double), double x1, double x2, double tol)
{
	int iter;
	double a=x1,b=x2,c=x2,d,e,min1,min2;
	double f_a=(*func)(a),f_b=(*func)(b),f_c,p,q,r,s,tol1,xm;

	if ((f_a > 0.0 && f_b > 0.0) || (f_a < 0.0 && f_b < 0.0))
	//	nrerror("Root must be bracketed in zbrent");
		return 0.0;
	f_c=f_b;
	for (iter=1;iter<=ITMAX;iter++) {
		if ((f_b > 0.0 && f_c > 0.0) || (f_b < 0.0 && f_c < 0.0)) {
			c=a;
			f_c=f_a;
			e=d=b-a;
		}
		if (fabs(f_c) < fabs(f_b)) {
			a=b;
			b=c;
			c=a;
			f_a=f_b;
			f_b=f_c;
			f_c=f_a;
		}
		tol1=2.0*EPS*fabs(b)+0.5*tol;
		xm=0.5*(c-b);
		if (fabs(xm) <= tol1 || f_b == 0.0) return b;
		if (fabs(e) >= tol1 && fabs(f_a) > fabs(f_b)) {
			s=f_b/f_a;
			if (a == c) {
				p=2.0*xm*s;
				q=1.0-s;
			} else {
				q=f_a/f_c;
				r=f_b/f_c;
				p=s*(2.0*xm*q*(q-r)-(b-a)*(r-1.0));
				q=(q-1.0)*(r-1.0)*(s-1.0);
			}
			if (p > 0.0) q = -q;
			p=fabs(p);
			min1=3.0*xm*q-fabs(tol1*q);
			min2=fabs(e*q);
			if (2.0*p < (min1 < min2 ? min1 : min2)) {
				e=d;
				d=p/q;
			} else {
				d=xm;
				e=d;
			}
		} else {
			d=xm;
			e=d;
		}
		a=b;
		f_a=f_b;
		if (fabs(d) > tol1)
			b += d;
		else
			b += SIGN(tol1,xm);
		f_b=(*func)(b);
	}
	//nrerror("Maximum number of iterations exceeded in zbrent");
	return b;
}


double zbrent2(double (*func)(double, double), double val, double x1, double x2, double tol)
{
	int iter;
	double a=x1,b=x2,c=x2,d,e,min1,min2;
	double f_a=(*func)(a,val),f_b=(*func)(b,val),f_c,p,q,r,s,tol1,xm;

	if ((f_a > 0.0 && f_b > 0.0) || (f_a < 0.0 && f_b < 0.0))
	//	nrerror("Root must be bracketed in zbrent");
		return 0.0;
	f_c=f_b;
	for (iter=1;iter<=ITMAX;iter++) {
		if ((f_b > 0.0 && f_c > 0.0) || (f_b < 0.0 && f_c < 0.0)) {
			c=a;
			f_c=f_a;
			e=d=b-a;
		}
		if (fabs(f_c) < fabs(f_b)) {
			a=b;
			b=c;
			c=a;
			f_a=f_b;
			f_b=f_c;
			f_c=f_a;
		}
		tol1=2.0*EPS*fabs(b)+0.5*tol;
		xm=0.5*(c-b);
		if (fabs(xm) <= tol1 || f_b == 0.0) return b;
		if (fabs(e) >= tol1 && fabs(f_a) > fabs(f_b)) {
			s=f_b/f_a;
			if (a == c) {
				p=2.0*xm*s;
				q=1.0-s;
			} else {
				q=f_a/f_c;
				r=f_b/f_c;
				p=s*(2.0*xm*q*(q-r)-(b-a)*(r-1.0));
				q=(q-1.0)*(r-1.0)*(s-1.0);
			}
			if (p > 0.0) q = -q;
			p=fabs(p);
			min1=3.0*xm*q-fabs(tol1*q);
			min2=fabs(e*q);
			if (2.0*p < (min1 < min2 ? min1 : min2)) {
				e=d;
				d=p/q;
			} else {
				d=xm;
				e=d;
			}
		} else {
			d=xm;
			e=d;
		}
		a=b;
		f_a=f_b;
		if (fabs(d) > tol1)
			b += d;
		else
			b += SIGN(tol1,xm);
		f_b=(*func)(b,val);
	}
	//nrerror("Maximum number of iterations exceeded in zbrent");
	return b;
}
#undef ITMAX
#undef EPS


//-------- Elliptic Integral ---------

#define ERRTOL 0.05
#define TINY 1.0e-25
#define BIG 4.5e21
#define C1 (3.0/14.0)
#define C2 (1.0/6.0)
#define C3 (9.0/22.0)
#define C4 (3.0/26.0)
#define C5 (0.25*C3)
#define C6 (1.5*C4)

float rd(float x, float y, float z)
{
	float alamb,ave,delx,dely,delz,ea,eb,ec,ed,ee,fac,sqrtx,sqrty,
		sqrtz,sum,xt,yt,zt;

	if (FMIN(x,y) < 0.0 || FMIN(x+y,z) < TINY || FMAX(FMAX(x,y),z) > BIG) {
		//nrerror("invalid arguments in rd");
		exit(0);
	}
	xt=x;
	yt=y;
	zt=z;
	sum=0.0;
	fac=1.0;
	do {
		sqrtx=sqrt(xt);
		sqrty=sqrt(yt);
		sqrtz=sqrt(zt);
		alamb=sqrtx*(sqrty+sqrtz)+sqrty*sqrtz;
		sum += fac/(sqrtz*(zt+alamb));
		fac=0.25*fac;
		xt=0.25*(xt+alamb);
		yt=0.25*(yt+alamb);
		zt=0.25*(zt+alamb);
		ave=0.2*(xt+yt+3.0*zt);
		delx=(ave-xt)/ave;
		dely=(ave-yt)/ave;
		delz=(ave-zt)/ave;
	} while (FMAX(FMAX(fabs(delx),fabs(dely)),fabs(delz)) > ERRTOL);
	ea=delx*dely;
	eb=delz*delz;
	ec=ea-eb;
	ed=ea-6.0*eb;
	ee=ed+ec+ec;
	return 3.0*sum+fac*(1.0+ed*(-C1+C5*ed-C6*delz*ee)
		+delz*(C2*ee+delz*(-C3*ec+delz*C4*ea)))/(ave*sqrt(ave));
}
#undef ERRTOL
#undef TINY
#undef BIG
#undef C1
#undef C2
#undef C3
#undef C4
#undef C5
#undef C6




#define ERRTOL 0.08
#define TINY 1.5e-38
#define BIG 3.0e37
#define THIRD (1.0/3.0)
#define C1 (1.0/24.0)
#define C2 0.1
#define C3 (3.0/44.0)
#define C4 (1.0/14.0)

float rf(float x, float y, float z)
{
	float alamb,ave,delx,dely,delz,e2,e3,sqrtx,sqrty,sqrtz,xt,yt,zt;

	if (FMIN(FMIN(x,y),z) < 0.0 || FMIN(FMIN(x+y,x+z),y+z) < TINY ||
		FMAX(FMAX(x,y),z) > BIG) {
			//nrerror("invalid arguments in rf");
			exit(0);
	}
	xt=x;
	yt=y;
	zt=z;
	do {
		sqrtx=sqrt(xt);
		sqrty=sqrt(yt);
		sqrtz=sqrt(zt);
		alamb=sqrtx*(sqrty+sqrtz)+sqrty*sqrtz;
		xt=0.25*(xt+alamb);
		yt=0.25*(yt+alamb);
		zt=0.25*(zt+alamb);
		ave=THIRD*(xt+yt+zt);
		delx=(ave-xt)/ave;
		dely=(ave-yt)/ave;
		delz=(ave-zt)/ave;
	} while (FMAX(FMAX(fabs(delx),fabs(dely)),fabs(delz)) > ERRTOL);
	e2=delx*dely-delz*delz;
	e3=delx*dely*delz;
	return (1.0+(C1*e2-C2-C3*e3)*e2+C4*e3)/sqrt(ave);
}
#undef ERRTOL
#undef TINY
#undef BIG
#undef THIRD
#undef C1
#undef C2
#undef C3
#undef C4


float elle(float phi, float ak)
{
	float rd(float x, float y, float z);
	float rf(float x, float y, float z);
	float cc,q,s;

	s=sin(phi);
	cc=SQR(cos(phi));
	q=(1.0-s*ak)*(1.0+s*ak);
	return s*(rf(cc,q,1.0)-(SQR(s*ak))*rd(cc,q,1.0)/3.0);
}


//------------ multi-dimensional minimization for curvature calculation -------------
#define ITMAX 100
#define CGOLD 0.3819660
#define ZEPS 1.0e-10
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);

float brent(float ax, float bx, float cx, float (*f)(float), float tol,
	float *xmin)
{
	int iter;
	float a,b,d,etemp,fu,fv,fw,fx,p,q,r,tol1,tol2,u,v,w,x,xm;
	float e=0.0;

	a=(ax < cx ? ax : cx);
	b=(ax > cx ? ax : cx);
	x=w=v=bx;
	fw=fv=fx=(*f)(x);
	for (iter=1;iter<=ITMAX;iter++) {
		xm=0.5*(a+b);
		tol2=2.0*(tol1=tol*fabs(x)+ZEPS);
		if (fabs(x-xm) <= (tol2-0.5*(b-a))) {
			*xmin=x;
			return fx;
		}
		if (fabs(e) > tol1) {
			r=(x-w)*(fx-fv);
			q=(x-v)*(fx-fw);
			p=(x-v)*q-(x-w)*r;
			q=2.0*(q-r);
			if (q > 0.0) p = -p;
			q=fabs(q);
			etemp=e;
			e=d;
			if (fabs(p) >= fabs(0.5*q*etemp) || p <= q*(a-x) || p >= q*(b-x))
				d=CGOLD*(e=(x >= xm ? a-x : b-x));
			else {
				d=p/q;
				u=x+d;
				if (u-a < tol2 || b-u < tol2)
					d=SIGN(tol1,xm-x);
			}
		} else {
			d=CGOLD*(e=(x >= xm ? a-x : b-x));
		}
		u=(fabs(d) >= tol1 ? x+d : x+SIGN(tol1,d));
		fu=(*f)(u);
		if (fu <= fx) {
			if (u >= x) a=x; else b=x;
			SHFT(v,w,x,u)
			SHFT(fv,fw,fx,fu)
		} else {
			if (u < x) a=u; else b=u;
			if (fu <= fw || w == x) {
				v=w;
				w=u;
				fv=fw;
				fw=fu;
			} else if (fu <= fv || v == x || v == w) {
				v=u;
				fv=fu;
			}
		}
	}
	nrerror("Too many iterations in brent");
	*xmin=x;
	return fx;
}
#undef ITMAX
#undef CGOLD
#undef ZEPS
#undef SHFT


extern int ncom;
extern float *pcom,*xicom,(*nrfunc)(float []);
float f1dim(float x)
{
	int j;
	float f,*xt;

	xt=vector(1,ncom);
	for (j=1;j<=ncom;j++) xt[j]=pcom[j]+x*xicom[j];
	f=(*nrfunc)(xt);
	free_vector(xt,1,ncom);
	return f;
}



#define GOLD 1.618034
#define GLIMIT 100.0
#define TINY 1.0e-20
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);
void mnbrak(float *ax, float *bx, float *cx, float *fa, float *fb, float *fc,
	float (*func)(float))
{
	float ulim,u,r,q,fu,dum;

	*fa=(*func)(*ax);
	*fb=(*func)(*bx);
	if (*fb > *fa) {
		SHFT(dum,*ax,*bx,dum)
		SHFT(dum,*fb,*fa,dum)
	}
	*cx=(*bx)+GOLD*(*bx-*ax);
	*fc=(*func)(*cx);
	while (*fb > *fc) {
		r=(*bx-*ax)*(*fb-*fc);
		q=(*bx-*cx)*(*fb-*fa);
		u=(*bx)-((*bx-*cx)*q-(*bx-*ax)*r)/
			(2.0*SIGN(FMAX(fabs(q-r),TINY),q-r));
		ulim=(*bx)+GLIMIT*(*cx-*bx);
		if ((*bx-u)*(u-*cx) > 0.0) {
			fu=(*func)(u);
			if (fu < *fc) {
				*ax=(*bx);
				*bx=u;
				*fa=(*fb);
				*fb=fu;
				return;
			} else if (fu > *fb) {
				*cx=u;
				*fc=fu;
				return;
			}
			u=(*cx)+GOLD*(*cx-*bx);
			fu=(*func)(u);
		} else if ((*cx-u)*(u-ulim) > 0.0) {
			fu=(*func)(u);
			if (fu < *fc) {
				SHFT(*bx,*cx,u,*cx+GOLD*(*cx-*bx))
				SHFT(*fb,*fc,fu,(*func)(u))
			}
		} else if ((u-ulim)*(ulim-*cx) >= 0.0) {
			u=ulim;
			fu=(*func)(u);
		} else {
			u=(*cx)+GOLD*(*cx-*bx);
			fu=(*func)(u);
		}
		SHFT(*ax,*bx,*cx,u)
		SHFT(*fa,*fb,*fc,fu)
	}
}
#undef GOLD
#undef GLIMIT
#undef TINY
#undef SHFT



#define TOL 2.0e-4
int ncom;
float *pcom,*xicom,(*nrfunc)(float []);

void linmin(float p[], float xi[], int n, float *fret, float (*func)(float []))
{
	float brent(float ax, float bx, float cx,
		float (*f)(float), float tol, float *xmin);
	float f1dim(float x);
	void mnbrak(float *ax, float *bx, float *cx, float *fa, float *fb,
		float *fc, float (*func)(float));
	int j;
	float xx,xmin,fx,fb,fa,bx,ax;

	ncom=n;
	pcom=vector(1,n);
	xicom=vector(1,n);
	nrfunc=func;
	for (j=1;j<=n;j++) {
		pcom[j]=p[j];
		xicom[j]=xi[j];
	}
	ax=0.0;
	xx=1.0;
	mnbrak(&ax,&xx,&bx,&fa,&fx,&fb,f1dim);
	*fret=brent(ax,xx,bx,f1dim,TOL,&xmin);
	for (j=1;j<=n;j++) {
		xi[j] *= xmin;
		p[j] += xi[j];
	}
	free_vector(xicom,1,n);
	free_vector(pcom,1,n);
}
#undef TOL



#define ITMAX 200
#define EPS 1.0e-10
#define FREEALL free_vector(xi,1,n);free_vector(h,1,n);free_vector(g,1,n);
// revised from void to int !!!
int frprmn(float p[], int n, float ftol, int *iter, float *fret,
	float (*func)(float []), void (*dfunc)(float [], float []))
{
	void linmin(float p[], float xi[], int n, float *fret, float (*func)(float []));
	//void dlinmin(float p[], float xi[], int n, float *fret, float (*func)(float []), void (*dfunc)(float [], float []));
	int j,its;
	float gg,gam,fp,dgg;
	float *g,*h,*xi;

	g=vector(1,n);
	h=vector(1,n);
	xi=vector(1,n);
	fp=(*func)(p);
	(*dfunc)(p,xi);
	for (j=1;j<=n;j++) {
		g[j] = -xi[j];
		xi[j]=h[j]=g[j];
	}
	for (its=1;its<=ITMAX;its++) {
		*iter=its;
		linmin(p,xi,n,fret,func);
		//dlinmin(p,xi,n,fret,func,dfunc);
		if (2.0*fabs(*fret-fp) <= ftol*(fabs(*fret)+fabs(fp)+EPS)) {
			FREEALL
			return 1;	// revised
		}
		fp=(*func)(p);
		(*dfunc)(p,xi);
		dgg=gg=0.0;
		for (j=1;j<=n;j++) {
			gg += g[j]*g[j];
			dgg += (xi[j]+g[j])*xi[j];
		}
		if (gg == 0.0) {
			FREEALL
			return 1;	// revised
		}
		gam=dgg/gg;
		for (j=1;j<=n;j++) {
			g[j] = -xi[j];
			xi[j]=h[j]=g[j]+gam*h[j];
		}
	}
	//nrerror("Too many iterations in frprmn");
	return 0;	// revised
}
#undef ITMAX
#undef EPS
#undef FREEALL




