
/*-------------------
Elastic Network By Using Delaunay Triangulation
Units: micron, s, pN
-------------------*/

#define OPENGL 0	// with graphics or not 
#define SAVPIC 0	// save frames

#define AUTNUC 2	// 0=nucleation, 1=autocatalytic, 2=both
#define VBRUSH 1	// 0=no brushing effect, 1=have brushing effect

#define NODDYN 1	// node dynamics or not
#define FILGRW 1	// filaments grow or not

#define LPD_CT 0	// lipid coated or not
#define INISYM 3	// initial symmetry breaking: 0=none, 1=long, 2=wide, 3=half-half, 4=rand sym-brk

#define CIRBND 1	// circular boundary or rectangular boundary
#define INBEAD 1	// with bead inside or not

#define GELMOV 1	// move gel or not
#define LNKBRK 1	// link break or not

#define TSTGEL 0	// testing gel: 0= no test, 1= test tensile stress, 2= test shear stress
#define CONSTF 1	// constant external force or variable, if TSTGEL

#define EXPPWR 1	// 1 for exponential decay, 0 for power law
#define VAR_KS 0	// variable spring constant

#define TEXMAP 1	// initially with texture mapping or not
#define SHWFIL 1	// initially show filament or not
#define SHWPFN 0	// show P(f), P(n) distribution or not
#define LNKCLR 0	// initially show link color or not

#define LNKSRC 2	// link source from 0: triangulation vertex, 1: graph's edges, 2: graph nodes
#define AALIAS 0	// anti-alias
#define VCDBUG 0	// debugging mode

#include "include.h"


void getmseed(void)
{
#if OPENGL && SAVPIC
	mseed=-1;
#else
	struct tm *newtime;
	time_t long_time;

	time(&long_time);	// RNG seed
	newtime=localtime(&long_time);
	mseed=-(int) fabs((newtime->tm_hour+1)*(2*newtime->tm_min+3)*(111*newtime->tm_sec+5)+
		191*(newtime->tm_min)+901*(newtime->tm_sec)-1);

#endif
}


void getconst(void)
{
	dt=0.2;
	v0dt=V0*dt;
	v0dtdb=v0dt*2;
	kadt=ka*dt;
	kcdt=kc*dt;
	kddt=kd*dt;
	kdisdt=kdis*dt;
	probnewdet=kd/(ka+kd);	// probability of creating free
	probnewatt=ka/(ka+kd);	// probability of creating att

	Ra=Rafix;
	Rb=Rbfix;
	if(Ra==Rb) Circum=Pidb*Ra;
	else Circum=Pi*(3*(Ra+Rb)-sqrt((3*Ra+Rb)*(Ra+3*Rb)));	// circumference

	if(AUTNUC==2) {
		kaut=autofrac*kautnuc;	// node's total autacatalytic branching rate /s
		knuc=(kautnuc-kaut);	// node's total nucleation rate /s
	}
	else kaut=knuc=kautnuc;

	kaut*=Circum;	// proportional to bead's size
	knuc*=Circum;

	kautback=backbias*kaut;
	kautbase=kaut-kautback;
	knucback=backbias*knuc;
	knucbase=knuc-knucback;

	kautdt=kaut*dt;
	knucdt=knuc*dt;

	kautbasedt=kautbase*dt;
	kautbackdt=kautback*dt;
	knucbasedt=knucbase*dt;
	knucbackdt=knucback*dt;
	
	//-------------------------
	Ra2=Ra*Ra;
	Rb2=Rb*Rb;
	Ra4=Ra2*Ra2;
	Rb4=Rb2*Rb2;
	RaRb=Ra*Rb;
	Ra2Rb2=Ra2*Rb2;
	Ra4Rb2=Ra2*Ra2Rb2;
	Ra2Rb4=Rb2*Ra2Rb2;
	Ra2_Rb2=Ra2/Rb2;
	Ra2mRb2=Ra2-Rb2;
	Rb2mRa2=Rb2-Ra2;

	Rmin=min2(Ra,Rb);
	Rmax=max2(Ra,Rb);
	Rave=(Ra+Rb)/2.0;
	Rave2=Rave*Rave;
	Rc=sqrt(Rmax*Rmax-Rmin*Rmin);	// focal length
	if(Rb>Ra) {
		Focus1[0]=Focus2[0]=0.0;
		Focus1[1]=Rc;
		Focus2[1]=-Rc;
	}
	else {
		Focus1[1]=Focus2[1]=0.0;
		Focus1[0]=-Rc;
		Focus2[0]=Rc;
	}
	
	ecc=sqrt(1.0-pow(Rmin/Rmax,2));	// eccentricity
	Circumhalf=Circum/2.0;
	Circumquad=Circum/4.0;
	zonedL=Circum/BeadZones;
	BeadZonesm1=BeadZones-1;
	BeadZoneshalf=BeadZones/2;
	BeadZonesquad=BeadZones/4;
	BeadZoneshalfp1=BeadZoneshalf+1;

	surfbindL=Circum/SurfBins;
	SurfBinsm1=SurfBins-1;
	SurfBinshalf=SurfBins/2.0;
	SurfBinsquad=SurfBins/4.0;
	SurfBinshalfp1=SurfBinshalf+1;

	Rabranch=Ra+BranchLayer;
	Rbbranch=Rb+BranchLayer;
	Rabranch2=Rabranch*Rabranch;
	Rbbranch2=Rbbranch*Rbbranch;

	SpreadDist=SpreadRate*dt;
	Nspreadhalf=(int)(BeadZones*(SpreadDist/Circum));	// spread factor is scaled by bead size
	if(Nspreadhalf<3) printf("Warning: BeadZones too small: Nspreadhalf=%d\n\n", Nspreadhalf);
	Angspread=SpreadDist/Ra;	// for Ra=Rb only

	Ragrow=Ra+InteractLayer;
	Rbgrow=Rb+InteractLayer;
	Ragrow2=Ragrow*Ragrow;
	Rbgrow2=Rbgrow*Rbgrow;
	Radeform=Ra+DeformLayer;
	Rbdeform=Rb+DeformLayer;
	Radeform2=Radeform*Radeform;
	Rbdeform2=Rbdeform*Rbdeform;
	initRegion2=initRegion*initRegion;

	mjunode=(log(filalenave/dlt)-1)/2.0/Pi/eta/filalenave;	// filament moving along its axis
	if(Rmax==Rmin) mjubead=1.0/6.0/Pi/eta/Rmax;
	else mjubead=(log(2*Rmax/Rmin)-0.5)/4.0/Pi/eta/Rmax;	// bead moving along its long axis
	mjuplate=1.0/16.0/Pi/eta/GelWidthIni;
	mjunodeksdt=mjunode*ksnode*dt;	// v=mju*f=mju*ks*dl
	mjubeadksdt=mjubead*ksnode*dt;	// so dr=v*dt=(mju*ks*dt)*dl
	mjuplateksdt=mjuplate*ksnode*dt;

	dlbr=1.0*fbr/ksnode;
	dlscaleshow=2.0*f0_scale/ksnode;

	dxpernode=1.0*forcepernode/ksnode;
	ksfila_node=1.0*ksfila/ksnode;	// ratio of the two spring constants
	ksnode_fila=1.0*ksnode/ksfila;
	ksfila_nodem1=ksfila_node-1.0;

	NtwkRadius2=NtwkRadius*NtwkRadius;
	NtwkRadiusdb=2.0*NtwkRadius;
	
	rhoymax=sqrt(1+Ra2/eps);	// for creating new nodes around the bead

	dspl_smp_skip=(int)(dspl_smp_dt/dt);
	dspl_n_avem1=dspl_n_ave-1;

	smp_dtdb=2.0*smp_dt;
	smp_dt2=smp_dt*smp_dt;

	Ymodfactor=Floadini/h_gel;
}


void init(void)
{
	getconst();
#if !TSTGEL
	prepSurfBin();
	#if AUTNUC
	prepZone();
	#endif
#endif

	Nnodes=Nnodes_ini;

	// GL
#if OPENGL && SAVPIC
	showskip=10;
	img_cntm=5;	// skip time = dt*showskip*img_cntm
	img_cnt=0;
	nframe=0;
#else
	showskip=10;	// show frame every this iterations
#endif
	texturemap=TEXMAP;
	showlink=LNKSRC;
	showfila=SHWFIL;
	showpfn=SHWPFN;
	pause=0;
	linkcolor=LNKCLR;
	zoom=(float)((NtwkRadius/Rave)/CanvasFactor);
	dxshow=1.0/SurfBins;
	dxshowm1=1.0/SurfBinsm1;
#if TSTGEL
	zoom*=3.0f;
#endif
	zoominv=1.0f/zoom;

#if TSTGEL
	N_tst_bufferm1=N_tst_buffer-1;
	n_tst_save=(int)(t_tst_save/dt);
#else
	smp_bufferm1=smp_buffer-1;
	smp_cnt_max=(int)(smp_dt/dt);
#endif
}


void updateGLboundary(void)
{
	GLbnd[0]=GLbnd[1]=(float)(0.7*zoominv);
	GLbnddb[0]=(float)(2.0*GLbnd[0]);
	GLbnddb[1]=(float)(2.0*GLbnd[1]);
}


void reset(void)
{
	int i;
	FILE *fp;

	t=0.0;
	veczero(Rcenter);
	veczero(Rcenterprev);
	veczero(dLbead);
	veczero(Vcenter);

	Rcenterprev[1]=-eps;
	Vcenter[1]=1.0;

	probaut=probnuc=probnucbase=probnucback=probautbase=probautback=probdis=0.0;
	thb=dthb=thbd=0.0;
	sthb=sin(thb);
	cthb=cos(thb);

	// GL
	start=1;
	PanX=PanY=0.0f;
#if TSTGEL
	PanY=-0.3f;
#endif
	disp_nshift[0]=disp_nshift[1]=0;
	Disp_shift[0]=Disp_shift[1]=0.0f;
	updateGLboundary();

	ntop=nbot=0;
	graph_nedge=0;
	Nlinks=Ncontact=Nnotcontact=0;
	Nfree=Natt=Nfila=0;
	Nlinkpernode=0.0;
	linklenave=0.0;

	dspl_smp_cnt=dspl_smp_skip;
	dspl_smp_num=dspl_v_ptr=0;
	for(i=0; i<dspl_n_ave; i++) dspl_V[i]=0.0;

#if TSTGEL
	teststart=1;
	testdirection=TestDirectionIni;
	cnt_tst_save=n_tst_save;
	rupture=0;
	topposini[0]=0.0;
	topposini[1]=GelHeightIni;
	veccopy(topposini, toppos);
	veccopy(toppos, Rcenterprev);
	veccopy(toppos, topposprev);
	veczero(dtoppos);
	veczero(dtoppostot);

	#if CONSTF
		Floadtst=Floadini;
	#else
		Floadtst=norm(dtoppostot)*ks_lever;
	#endif

	cnt_tst_buffer=0;
	for(i=0; i<N_tst_buffer; i++) {
		Nbrklink_tst_buffer[i]=0;
		t_tst_buffer[i]=dr_tst_buffer[i][0]=dr_tst_buffer[i][1]=0.0;
		v_tst_buffer[i]=0.0;
	}
	fp=fopen("testgel.dat","w");
	fprintf(fp, "#t\tdx\tdy\tv\n");
	fclose(fp);
#else
	smp_cnt=smp_cnt_max;
	smp_sav_cnt=0;
	for(i=0; i<smp_buffer; i++) {
		smp_t_buffer[i]=smp_thb_buffer[i]=smp_yaw_buffer[i]=0.0;
		smp_r_buffer[i][0]=smp_r_buffer[i][1]=0.0;
		dNlr_buffer[i]=dNf_buffer[i]=dNa_buffer[i]=0.0;
	}
	for(i=0; i<SurfBins; i++) {
		surfPf[i]=surfPn[i]=0.0;
	}
	fp=fopen("track.dat","w");
	fprintf(fp, "#t\tthb\tx\ty\tvb\tdNlr\tdNf\tdNa\n");
	fclose(fp);
#endif

	Nnodes=Nnodes_ini;	// this should not be in front of CleanGraph()
	TriangulationSuccess=0;
}


void BuildNetwork(void)
{
	DoTriangulation();
	BuildGraph();

#if TSTGEL
	dlloadtst=1.0*Floadtst/ksnode;
	NodesStats();
	Nlinksini=Nlinks;
#endif
}


void DoSimu(void)
{
#if NODDYN
	NodesDynamics();
#endif
	NodesStats();
	GelMotion();
	BeadMotion();

	t+=dt;
#if TSTGEL
	if(TestDirectionIni==0 && teststart==1) t-=dt;
#endif
}


void terminate(void)
{
#if TSTGEL
	FlushTest(cnt_tst_buffer);
#else
	FlushTracking(smp_sav_cnt);
	ProcessTrack();
	DoAllStats();
#endif
	exit(0);
}


int main(int argc, char **argv)
{
#if OPENGL
	getmseed();
#else
	if(argc==2) mseed=-abs(atoi(argv[1]));
	else getmseed();
#endif

	init();
	reset();
	BuildNetwork();

#if OPENGL
	RunGL(&argc,argv);
#else
	while(t<=Tmax) DoSimu();
	terminate();
#endif

#if VCDBUG
	_CrtDumpMemoryLeaks();
#endif

	return 0;
}


