
void statbeadFN(void)
{
	int i, j;
	double a, ntot, ftot;
	graph_node *p;


	ntot=ftot=0.0;
	for(i=0; i<SurfBins; i++) surfPf[i]=surfPn[i]=0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact) {
			Crt2LabPol(p->r1, &a);
			if(a>=0.0) {
				j=0;
				while(a>=surfbinAng[j] && j<SurfBinshalf) j++;
				if(j>0) j--;
			}
			else {
				if(a>=surfbinAng[SurfBinsm1]) j=SurfBinsm1;
				else if(a<=surfbinAng[SurfBinshalfp1]) j=SurfBinshalf;
				else {
					j=SurfBinshalfp1;
					while(a>surfbinAng[j] && j<SurfBinsm1) j++;
					if(j>SurfBinshalfp1) j--;
				}
			}
			surfPn[j]++;
			ntot++;
		#if F_PULL
			surfPf[j] += p->dlen;
			ftot+=fabs(p->dlen);
		#else
			if(p->dlen>0) {
				surfPf[j] += p->dlen;
				ftot+=fabs(p->dlen);
			}
		#endif
		}	// end of if p->contact
	}	// end of i
	
	for(i=0; i<SurfBins; i++) {
		if(ntot>1.0) surfPn[i]/=ntot;
		else surfPn[i]=0.0;
		if(ftot>0.0) surfPf[i]/=ftot;
		else surfPf[i]=0.0;
	}
}


void corr_omg(void)
{
	int i, j, itau, taustep, ntau;
	double thbvar, thbave;
	double omgbdvar, omgbdave;	// bead in lab
	double omgtlvar, omgtlave;	// tail in lab
	double omgbdtlvar, omgbdtlave;	// bead in tail
	double taux, corrx1, corrx2, corrx3, corrx4;
	FILE *fp;
	
	printf("\nAutocorr omg ... ");
	if(n_track==0) { printf("Abort.\n"); return; }

	thbvar=thbave=omgbdvar=omgbdave=0.0;
	omgtlvar=omgtlave=omgbdtlvar=omgbdtlave=0.0;
	
	for(i=0; i<n_track; i++) {
		thbave+=thb_seqsm[i];
		omgbdave+=omg_bd[i];
		omgtlave+=omg_tl[i];
		omgbdtlave+=omg_bdtl[i];
	}
	thbave/=n_track;	// average
	omgbdave/=n_track;
	omgtlave/=n_track;
	omgbdtlave/=n_track;
	
	for(i=0; i<n_track; i++) {
		thbvar+=pow(thb_seqsm[i]-thbave,2);
		omgbdvar+=pow(omg_bd[i]-omgbdave,2);
		omgtlvar+=pow(omg_tl[i]-omgtlave,2);
		omgbdtlvar+=pow(omg_bdtl[i]-omgbdtlave,2);
	}
	thbvar/=n_track;	// variance
	omgbdvar/=n_track;
	omgtlvar/=n_track;
	omgbdtlvar/=n_track;

	thbvar=max2(thbvar, 1.0e-10);
	omgbdvar=max2(omgbdvar, 1.0e-10);
	omgtlvar=max2(omgtlvar, 1.0e-10);
	omgbdtlvar=max2(omgbdtlvar, 1.0e-10);

	ntau=min2(Ncorr, n_track/2);	// total number of corr. points
	taustep=(int) (min2(t/2,Tcorrmax)/smp_dt/ntau);	// correlation intervals: tau1, tau2, ...
	taustep=max2(taustep, 1);
	fp=fopen("corr_omg.dat", "w");
	fprintf(fp, "#tau\tC_thb\tC_bd\tC_tl\tC_bdtl\n");
	
	for(i=0; i<ntau; i++) {	// tau's
		itau=i*taustep;
		taux=itau*smp_dt;	// tau in sec
		corrx1=corrx2=corrx3=corrx4=0.0;
		for(j=0; j<n_track-itau; j++) {	// t's
			corrx1+=(thb_seqsm[j]-thbave)*(thb_seqsm[j+itau]-thbave);
			corrx2+=(omg_bd[j]-omgbdave)*(omg_bd[j+itau]-omgbdave);
			corrx3+=(omg_tl[j]-omgtlave)*(omg_tl[j+itau]-omgtlave);
			corrx4+=(omg_bdtl[j]-omgbdtlave)*(omg_bdtl[j+itau]-omgbdtlave);
		}
		corrx1/=(j*thbvar);
		corrx2/=(j*omgbdvar);
		corrx3/=(j*omgtlvar);
		corrx4/=(j*omgbdtlvar);
		fprintf(fp, "%.3g\t%.3g\t%.3g\t%.3g\t%.3g\n", taux, corrx1, corrx2, corrx3, corrx4);
	}
	fclose(fp);
	
	printf("Done.\n");
}


void corr_ktail(void)
{
	int i, j, itau, taustep, ntau;
	double kave, kvar, corr, taux;
	FILE *fp;
	
	printf("Autocorr Ktail ... ");
	if(n_ktail<=0) { printf("Abort.\n"); return; }
	
	kave=kvar=0.0;
	for(i=0; i<n_ktail; i++) kave+=ktail[i];
	kave/=n_ktail;
	for(i=0; i<n_ktail; i++) kvar+=pow(ktail[i]-kave,2);
	kvar/=n_ktail;
	kvar=max2(kvar, 1.0e-10);
	
	ntau=min2(Ncorr, n_ktail/2);
	taustep=(int) (min2(t/2,Tcorrmax)/smp_dt/ntau);	// correlation intervals: tau1, tau2, ...
	taustep=max2(taustep, 1);
	fp=fopen("corr_ktail.dat", "w");
	fprintf(fp, "#tau\tdistance\tC_ktail\n");
	
	for(i=0; i<ntau; i++) {	// tau's
		itau=i*taustep;
		taux=itau*smp_dt;	// tau in sec
		corr=0.0;
		for(j=0; j<n_ktail-itau; j++) {	// t's
			corr+=(ktail[j]-kave)*(ktail[j+itau]-kave);
		}
		corr/=(j*kvar);
		fprintf(fp, "%.3g\t%.3g\t%.3g\n", taux, taux*vbd_ave, corr);
	}
	fclose(fp);
	
	printf("Done.\n");
}



void Ktailstat(void)	// get Ktail distribution, total number is not n_track but n_ktail!
{
	int i, j, bins, ncnt;
	double xave, xrms, xmax, xlimit, dx, fct;
	double k1, k2;
	float *xs;
	FILE *fp;
	
	printf("Ktail stat ... ");
	if(n_ktail<=0) { printf("Abort.\n"); return; }
		
	xave=xrms=0.0;
	bins=20;
	xmax=2.0;	// *xrms
	dx=xmax/(bins-1);
	ncnt=0;
	
	xs=malloc(bins*sizeof(float));
	
	for(i=0; i<n_ktail; i++) xave+=ktail[i];
	xave/=n_ktail;
	
	for(i=0; i<n_ktail; i++) xrms+=pow(ktail[i],2);
	xrms/=n_ktail;
	xrms=max2(sqrt(xrms), 1.0e-10);

	xlimit=3.0*xmax*xrms;	// set a cutoff threshold, and do the stat again

	//-----------------------------
	xave=xrms=0.0;
	ncnt=0;

	for(i=0; i<n_ktail; i++) {	// discard extremely high values
		if(ktail[i]<=xlimit) { xave+=ktail[i]; ncnt++; }
	}
	xave/=max2(ncnt,1);
	for(i=0; i<n_ktail; i++) {
		if(ktail[i]<=xlimit) xrms+=pow(ktail[i],2);
	}
	xrms/=ncnt;
	xrms=max2(sqrt(xrms), 1.0e-10);	// this is the Krms I want
	
	//----------------------------
	xmax*=xrms;	// real xmax
	ncnt=0;
	
	for(i=0; i<bins; i++) xs[i]=0.0;
	for(i=0; i<n_ktail; i++) {
		j=(int) (bins*ktail[i]/xmax);
		if(j<bins) { xs[j]++; ncnt++; }
	}
	fct=1.0/max2(ncnt,1)/dx;
	for(i=0; i<bins; i++) xs[i]*=fct;	// normalize
	
	fp=fopen("Ktailstat.dat", "w");
	fprintf(fp, "#K\tK/Krms\tP\n");
	for(i=0; i<bins; i++) {
		k1=i*dx;
		k2=k1*xrms;
		fprintf(fp, "%.4g\t%.4g\t%.4g\n", k2, k1, xs[i]);
	}
	fprintf(fp, "\n#K_rms = %.3f /um\n#R_rms = %.3f um.\n", xrms, 1.0/xrms);
	fclose(fp);
	
	free(xs);
	printf("Done.\n");
}


void Omgstat(void)	// get omg distribution
{
	int i, j1, j2, j3, n1, n2, n3, bins, binsh;
	double wa1, wa2, wa3, wrms1, wrms2, wrms3;
	double wrms, wf, wmax, dw, fct1, fct2, fct3;
	double w1, w2;
	float *s1, *s2, *s3;
	FILE *fp;
	
	printf("Omg stat ... ");
	bins=20;
	binsh=bins/2;
	wf=2.0;	// wmax=wf*wrms
	dw=2.0*wf/(bins-1);
	
	s1=malloc(bins*sizeof(float));
	s2=malloc(bins*sizeof(float));
	s3=malloc(bins*sizeof(float));
	for(i=0; i<bins; i++) s1[i]=s2[i]=s3[i]=0.0;
	
	wa1=wa2=wa3=wrms1=wrms2=wrms3=0.0;
	for(i=0; i<n_track; i++) {
		wa1+=omg_bd[i];
		wa2+=omg_tl[i];
		wa3+=omg_bdtl[i];
		wrms1+=pow(omg_bd[i],2);
		wrms2+=pow(omg_tl[i],2);
		wrms3+=pow(omg_bdtl[i],2);
	}
	wa1/=n_track;
	wa2/=n_track;
	wa3/=n_track;
	wrms=max2(wrms1, max2(wrms2, wrms3))/n_track;
	wrms=max2(sqrt(wrms), 1.0e-10);	// wrms being the largest wrms among 3
	wmax=wf*wrms;
	
	n1=n2=n3=0;
	for(i=0; i<n_track; i++) {
		j1=(int) (binsh*(omg_bd[i]/wmax+1));
		j2=(int) (binsh*(omg_tl[i]/wmax+1));
		j3=(int) (binsh*(omg_bdtl[i]/wmax+1));
		
		if(j1>=0 && j1<bins) { s1[j1]++; n1++; }
		if(j2>=0 && j2<bins) { s2[j2]++; n2++; }
		if(j3>=0 && j3<bins) { s3[j3]++; n3++; }
	}
	fct1=1.0/n1/dw;
	fct2=1.0/n2/dw;
	fct3=1.0/n3/dw;
	for(i=0; i<bins; i++) {
		s1[i]*=fct1;
		s2[i]*=fct2;
		s3[i]*=fct3;
	}
	
	fp=fopen("Wstat.dat", "w");
	fprintf(fp, "#omg\tomg/omgrms\tbeadlab\ttaillab\tbeadtail\n");
	for(i=0; i<bins; i++) {
		w1=i*dw-wf;	// omega/omega_rms
		w2=w1*wrms;	// omega (deg/s)
		fprintf(fp, "%.4g\t%.4g\t%.4g\t%.4g\t%.4g\n", w2, w1, s1[i], s2[i], s3[i]);
	}
	fprintf(fp, "\n#W_rms = %.3f deg/s\n", wrms);
	fclose(fp);
		
	free(s1);
	free(s2);
	free(s3);
	
	printf("Done.\n");
}


void Yawstat(void)	// get yaw distribution
{
	int i, j, bins;
	int cnt1, cnt2, cnt3;
	double thx, dthx, fct;
	double *stat;
	FILE *fp;
	
	printf("Yaw stat ... ");
	bins=9;
	dthx=90.0/(bins);
	cnt1=cnt2=cnt3=0;
	
	stat=malloc(bins*sizeof(double));
	for(i=0; i<bins; i++) stat[i]=0.0;
	
	for(i=0; i<n_track; i++) {
		j=(int) (yaw_seq[i]/dthx);
		if(j>=bins) j=bins-1;
		stat[j]++;
		
		if(yaw_seq[i]<=30.0) cnt1++;	// long
		else if(yaw_seq[i]<=60.0) cnt2++;	// intermediate
		else cnt3++;	// wide
	}
	
	fct=0.0;
	for(i=0; i<bins; i++) fct+=stat[i];
	fct=1.0/max2(fct,1.0e-9);	// probability for each bin

	for(i=0; i<bins; i++) stat[i]*=fct;	// normalization

	fp=fopen("Yawstat.dat", "w");
	fprintf(fp, "#yaw\tP\n");
	for(i=0; i<bins; i++) {
		thx=(i+0.5)*dthx;	// marks are in the middle of the bin
		fprintf(fp, "%.2f\t%.4f\n", thx, stat[i]);
	}
	fprintf(fp, "\n#Fractions:\n#Long = %.3f\n", 1.0*cnt1/n_track);
	fprintf(fp, "#Skew = %.3f\n", 1.0*cnt2/n_track);
	fprintf(fp, "#Wide = %.3f\n", 1.0*cnt3/n_track);
	fclose(fp);
	
	free(stat);
	printf("Done.\n");
}


void OmgYawstat(void)	// get omg-yaw relation
{
	int i, j, n, bins;
	double thx, dthx;
	float *w1, *w2, *w3;
	int *cnt;
	FILE *fp;
	
	printf("Omg-Yaw stat ... ");
	bins=20;
	dthx=90.0/(bins);
	
	w1=malloc(bins*sizeof(float));
	w2=malloc(bins*sizeof(float));
	w3=malloc(bins*sizeof(float));
	cnt=malloc(bins*sizeof(int));
	
	for(i=0; i<bins; i++) {
		w1[i]=w2[i]=w3[i]=0.0;
		cnt[i]=0;
	}
	
	for(i=0; i<n_track; i++) {
		j=(int)(yaw_seq[i]/dthx);
		if(j>=bins) j=bins-1;
		cnt[j]++;
		w1[j]+=omg_bd[i];
		w2[j]+=omg_tl[i];
		w3[j]+=omg_bdtl[i];
	}
	
	for(i=0; i<bins; i++) {
		n=max2(cnt[i],1);
		w1[i]/=n;
		w2[i]/=n;
		w3[i]/=n;
	}
	
	fp=fopen("WYstat.dat", "w");
	fprintf(fp, "#yaw\tWbdlab\tWtlab\tWbd_tl\n");
	for(i=0; i<bins; i++) {
		thx=(i+0.5)*dthx;	// marks are in the middle of the bin
		fprintf(fp, "%.2f\t%.4g\t%.4g\t%.4g\n", thx, w1[i], w2[i], w3[i]);
	}
	fclose(fp);
	
	free(cnt);
	free(w1);
	free(w2);
	free(w3);
	
	printf("Done.\n");
}


void xcorr_template(float x1[], float x2[], int ntau, int taustep, float xcorr[])
{
	int i, j, itau;
	double ave1, ave2, var1, var2, taux, xc, sqrtvar12;
	
	ave1=ave2=var1=var2=xc=0.0;
	
	for(i=0; i<n_track; i++) {
		ave1+=x1[i];
		ave2+=x2[i];
	}
	ave1/=n_track;
	ave2/=n_track;
	for(i=0; i<n_track; i++) {
		var1+=pow(x1[i]-ave1,2);
		var2+=pow(x2[i]-ave2,2);
	}
	var1/=n_track;
	var2/=n_track;
	var1=max2(var1,1.0e-9);
	var2=max2(var2,1.0e-9);
	sqrtvar12=sqrt(var1*var2);
	
	for(i=0; i<ntau; i++) {	// tau's
		itau=i*taustep;
		taux=itau*smp_dt;	// tau in sec
		xc=0.0;
		for(j=0; j<n_track-itau; j++) {	// t's
			xc+=(x1[j]-ave1)*(x2[j+itau]-ave2);
		}
		xc/=j*sqrtvar12;
		xcorr[i]=xc;
	}
}


void xcorr_dNlr(void)
{
	int i, ntau, taustep;
	float *signed_omg_sm, *xc, *xcf, *xca;
	double itau, taux;
	FILE *fp;
	
	printf("Xcorr dN-omg ... ");
	
	ntau=min2(Ncorr, n_track/2);
	taustep=(int) (min2(t/2,Tcorrmax)/smp_dt/ntau);	// correlation intervals: tau1, tau2, ...
	taustep=max2(taustep, 1);
	
	signed_omg_sm=malloc(n_track*sizeof(float));
	xc =malloc(ntau*sizeof(float));
	xcf=malloc(ntau*sizeof(float));
	xca=malloc(ntau*sizeof(float));
	
	for(i=0; i<n_track; i++) {	// smoothed omega from Ktail & vb
		signed_omg_sm[i]=sign(omg_tl[i])*ktailall[i]*v_seq[i];
	}
	xcorr_template(dNlr_seq, signed_omg_sm, ntau, taustep, xc);
	xcorr_template(dNf_seq, signed_omg_sm, ntau, taustep, xcf);
	xcorr_template(dNa_seq, signed_omg_sm, ntau, taustep, xca);
	
	
	fp=fopen("xcorr_dNlr.dat", "w");
	fprintf(fp, "#tau\tdistance\tXC_dNlr\tXC_dNf\tXC_dNa\n");
	for(i=0; i<ntau; i++) {	// tau's
		itau=i*taustep;
		taux=itau*smp_dt;	// tau in sec

		fprintf(fp, "%.3g\t%.3g\t%.3g\t%.3g\t%.3g\n", 
			taux, taux*vbd_ave, xc[i], xcf[i], xca[i]);
	}
	fclose(fp);
	
	free(signed_omg_sm);
	free(xc);
	free(xcf);
	free(xca);
	printf("Done.\n");
}




void xcorr_dNlr_old(void)	// cross correlation between dNlr and omega (curvature)
{
	int i, j, itau, taustep, ntau;
	double dna, dnv, wa, wv, taux, xc;
	float *signed_omg_sm;
	FILE *fp;
	
	printf("Xcorr dN-omg ... ");
	dna=wa=dnv=wv=xc=0.0;
	signed_omg_sm=malloc(n_track*sizeof(float));
	
	for(i=0; i<n_track; i++) {
		dna+=dNlr_seq[i];
		signed_omg_sm[i]=sign(omg_tl[i])*ktailall[i]*v_seq[i];	// smoothed omega from Ktail & vb
		wa+=signed_omg_sm[i];
	}
	dna/=n_track;
	wa/=n_track;
	for(i=0; i<n_track; i++) {
		dnv+=pow(dNlr_seq[i]-dna,2);
		wv+=pow(signed_omg_sm[i]-wa,2);
	}
	dnv/=n_track;
	wv/=n_track;
	dnv=max2(dnv,1.0e-9);
	wv=max2(wv,1.0e-9);
	
	ntau=min2(Ncorr, n_track/2);
	taustep=(int) (min2(t/2,Tcorrmax)/smp_dt/ntau);	// correlation intervals: tau1, tau2, ...
	taustep=max2(taustep, 1);
	fp=fopen("xcorr_dNlr.dat", "w");
	fprintf(fp, "#tau\tdistance\tXC_dNlr\n");
	
	for(i=0; i<ntau; i++) {	// tau's
		itau=i*taustep;
		taux=itau*smp_dt;	// tau in sec
		xc=0.0;
		for(j=0; j<n_ktail-itau; j++) {	// t's
			xc+=(dNlr_seq[j]-dna)*(signed_omg_sm[j+itau]-wa);
		}
		xc/=j*sqrt(dnv*wv);
		fprintf(fp, "%.3g\t%.3g\t%.3g\n", taux, taux*vbd_ave, xc);
	}
	fclose(fp);
	
	fp=fopen("dNlr.dat", "w");
	fprintf(fp, "t\tdNlr\tw_tl\tw_tl_sm\n");
	for(i=0; i<n_track; i++) {
		fprintf(fp, "%f\t%.3g\t%.3g\t%.3g\n", 
			t_seq[i], dNlr_seq[i], omg_tl[i], signed_omg_sm[i]);
	}
	fclose(fp);
	free(signed_omg_sm);
	printf("Done.\n");
}


void cleanupstats(void)
{
	free(t_seq);
	free(thb_seq);
	free(yaw_seq);
	free(x_seq);
	free(y_seq);
	free(v_seq);
	free(dNlr_seq);
	free(thb_seqsm);
	free(x_seqsm);
	free(y_seqsm);
	free(omg_tl);
	free(omg_bd);
	free(omg_bdtl);
	free(ktail);
	free(ktailall);
}


void DoAllStats(void)
{

	if(n_track>=3) {
		corr_omg();
		corr_ktail();
		Ktailstat();
		Omgstat();
		Yawstat();
		OmgYawstat();
		xcorr_dNlr();
		cleanupstats();
	}
	else printf("Number of data points < 3. No stats.\n");
}
