
void shiftview(void)
{
	int i;
	
	for(i=0; i<2; i++) {
		if(Rcenterdisp[i]<-0.9*GLbnd[i]) disp_nshift[i]++;	// factor to avoid jump
		else if(Rcenterdisp[i]>1.11111*GLbnd[i]) disp_nshift[i]--;
		Disp_shift[i]=(float)(disp_nshift[i]*GLbnddb[i]);
		Rcenterdisp[i]=(float)(Rcenter[i]+Disp_shift[i]);
	}
}


void drawviewbox(void)
{
	float r1[2],r2[2],r3[2],r4[2];
	
	r1[0]=-GLbnd[0];	r1[1]=-GLbnd[1];
	r2[0]=GLbnd[0];	r2[1]=-GLbnd[1];
	r3[0]=GLbnd[0];	r3[1]=GLbnd[1];
	r4[0]=-GLbnd[0];	r4[1]=GLbnd[1];
	
	glScalef(zoom,zoom,zoom);
	glColor3f(0.6,0.6,1.0);
	glBegin(GL_LINE_LOOP);
		glVertex2f(r1[0], r1[1]);
		glVertex2f(r2[0], r2[1]);
		glVertex2f(r3[0], r3[1]);
		glVertex2f(r4[0], r4[1]);
	glEnd();
	
	glLoadIdentity();
}


void display_list(void)
{
	int i;
	float a, x, y;
	bead=glGenLists(1);
	glNewList(bead, GL_COMPILE);
	if(texturemap==0) glColor3f(0.5, 0.5, 0.5);
	else glColor3f(0.7, 0.7, 0.7);
	glLineWidth(3.0);
	glScalef(Ra, Rb, 1.0);	// scale
	
	glBegin(GL_TRIANGLES);	// solid disk
	for(i=0; i<100; i++) {
		glVertex2f(0,0);
		
		a=Pidb*i/100.0;
		x=(float)(cos(a));
		y=(float)(sin(a));
		glVertex2f(x,y);
		
		a=Pidb*(i+1)/100.0;
		x=(float)(cos(a));
		y=(float)(sin(a));
		glVertex2f(x,y);
	}
	glEnd();
	
	glScalef(1.0/Ra, 1.0/Rb, 1.0);
	glEndList();
	
}


void drawbead1(void)
{
	glTranslatef(Rcenterdisp[0], Rcenterdisp[1], 0.0);
	glCallList(bead);
	glTranslatef(-Rcenterdisp[0], -Rcenterdisp[1], 0.0);
}


void drawbead(void)
{
	int i;
	float r[2];
	
	for(i=0; i<2; i++) r[i]=(float)(Rcenter[i]);
	glTranslatef(r[0],r[1],0.0);
	glRotatef(thbd,0,0,-1);
	glCallList(bead);
	
	glRotatef(thbd,0,0,1);
	glTranslatef(-r[0],-r[1],0.0);
}


void drawbottom(void)
{
	float d, h, w, dx;
	
	d=10.2*NtwkRadius;	// thickness 0.2
	h=0.99*(GelHeightIni);	// distance between plates
	w=3.0*NtwkRadius;	// width 1.4
	dx=0.0;	//-0.2;	// shift left, make room for spring
	
	glTranslatef(PanX, PanY, 0.0);
	glScalef(zoom, zoom, zoom);	// scale
	glTranslatef(dx, -h-d, 0.0);	// bottom
	
	if(texturemap==0) glColor3f(0.5, 0.5, 0.5);
	else glColor3f(0.3, 0.3, 0.3);	//glColor3f(0.6, 0.6, 0.6);
	
	glBegin(GL_QUADS);
		glVertex3f(-w, 0.0, 0.0);
		glVertex3f(w, 0.0, 0.0);
		glVertex3f(w, d, 0.0);
		glVertex3f(-w, d, 0.0);
	glEnd();
	glLoadIdentity();
}


void drawlever(void)	// top cantilever
{
	float d, h, w, dx;
	
	d=0.2*NtwkRadius;	// thickness
	h=0.99*(GelHeightIni);	// distance between plates
	w=1.2*NtwkRadius;	// width
	dx=0.0;	//-0.2;	// shift left, make room for spring
	
	glTranslatef(PanX, PanY, 0.0);
	glScalef(zoom, zoom, zoom);	// scale
	glTranslatef(toppos[0]+dx, toppos[1], 0.0);	// top
	
	if(texturemap==0) glColor3f(0.5, 0.5, 0.5);
	else glColor3f(0.6, 0.6, 0.6);
	
	glBegin(GL_QUADS);
		glVertex3f(-w, 0.0, 0.0);
		glVertex3f(w, 0.0, 0.0);
		glVertex3f(w, d, 0.0);
		glVertex3f(-w, d, 0.0);
	glEnd();
	
	glLoadIdentity();
}


void drawleverbead(void)
{
	int i;
	float r[2];
	
	glTranslatef(PanX, PanY, 0.0);
	glScalef(zoom, zoom, zoom);	// scale
	
	for(i=0; i<2; i++) r[i]=(float)(Rcenter[i]);
	glTranslatef(r[0],r[1],0.0);
	glRotatef(thbd,0,0,-1);
	glCallList(bead);
	
	glLoadIdentity();
}


void drawspring(void)
{
	int i, nwave, npt;
	float x, y, ym, dy, h, x0;
	
	nwave=8;	// showing n periods of sine waves
	x0=0.1f;	// how fat the spring is
	npt=500;
	h=(float)(GelHeightIni/NtwkRadius);
	ym=(float)(toppos[1]-botpos[1]);
	dy=ym/(npt-1.0f);
	
	glTranslatef(PanX, PanY, 0.0);
	glScalef(zoom, zoom, zoom);	// scale
	glTranslatef(-1.5, -h, 0.0);
	
	glPointSize(5.0);
	glColor3f(0.4, 0.4, 0.6);
	glBegin(GL_POINTS);
		for(i=0; i<npt; i++) {
			y=i*dy;
			x=(float)(x0*sin(Pidb*nwave*y/ym));
			glVertex2f(x,y);
		}
	glEnd();
	
	glLoadIdentity();
}


void drawnodes(void)	// from graph
{
	int i;
	float x, y;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->connected) glPointSize(4.0);
		else glPointSize(2.0);
			
		x=(float) (p->R0[0]);
		y=(float) (p->R0[1]);
	#if TSTGEL
		if(p->contact==1)glColor3f(0.0, 0.0, 0.0);
		else glColor3f(0.5, 0.5, 0.5);
	#else
		if(p->contact==1 && p->capped==0) glColor3f(0.0, 0.0, 0.0);
		else glColor3f(0.5, 0.5, 0.5);
	#endif
		
		glBegin(GL_POINTS);
			glVertex2f(x, y);
		glEnd();
	}
}


void drawnodes_old(void)	// from triangulation
{
	tVertex temp;
	float x, y;
	
	temp = vertices;
	glColor3f(0, 0, 0);
	glPointSize(3.0);
	
	glBegin(GL_POINTS);
	if (vertices) do {
		x=(float) (vertices->v[0]);
		y=(float) (vertices->v[1]);
		glVertex2f(x, y);
		vertices = vertices->next;
	} while ( vertices != temp );
	glEnd();
}


void drawline(double v1[], double v2[], float thickness)
{
	int i;
	float v1f[2], v2f[2];
	
	for(i=0; i<2; i++) {
		v1f[i]=(float) (v1[i]);
		v2f[i]=(float) (v2[i]);
	}
	glLineWidth(thickness);
	glBegin(GL_LINES);
		glVertex2f(v1f[0], v1f[1]);
		glVertex2f(v2f[0], v2f[1]);
	glEnd();
}


void drawlineclr(double v1[], double v2[], double dl, float thickness)
{
	int i;
	float v1f[2], v2f[2];
	float mag, rgbini, drgb, r, g, b;
	
	for(i=0; i<2; i++) {
		v1f[i]=(float) (v1[i]);
		v2f[i]=(float) (v2[i]);
	}
	
	if(linkcolor==0) {
		if(showlink==1) glColor3f(0.6,0.6,1.0);	// from edges
		else if(showlink==2) glColor3f(0.0,0.9,0.0);	// from graph nodes
		else glColor3f(0.9,0.9,0.0);	// from graph nodes, clumsy
	}
	else {
		rgbini=0.8;	//0.8;
		r=g=b=rgbini;
		mag=(float) (pow(fabs(dl)/dlscaleshow,0.4));	// smaller factor is more sensitive to force change
		drgb=rgbini*mag;	// 0<=drgb<=rgbini
		if(dl>=0) {	// stretching: blue
			mag*=0.5;
			r-=drgb;
			g-=drgb;
			b+=(1.0-rgbini)*mag;
		}
		else {	// compressing: red
			r+=(1.0-rgbini)*mag;
			g-=drgb;
			b-=drgb;
		}
		
		glColor3f(r,g,b);
	}
	
	glLineWidth(thickness);
	glBegin(GL_LINES);
		glVertex2f(v1f[0], v1f[1]);
		glVertex2f(v2f[0], v2f[1]);
	glEnd();
}


void drawtriangle(double v1[], double v2[], double v3[])
{
	int i;
	float v1f[2], v2f[2], v3f[2];
	
	for(i=0; i<2; i++) {
		v1f[i]=(float) (v1[i]);
		v2f[i]=(float) (v2[i]);
		v3f[i]=(float) (v3[i]);
	}
	
	glColor3f(1.0,0.6,0.3);
	glLineWidth(1.0);

#if INBEAD
	glBegin(GL_LINES);
		if(!CutOffBead(v1,v2)) {
			glVertex2f(v1f[0], v1f[1]);
			glVertex2f(v2f[0], v2f[1]);
		}
		if(!CutOffBead(v2,v3)) {
			glVertex2f(v2f[0], v2f[1]);
			glVertex2f(v3f[0], v3f[1]);
		}
		if(!CutOffBead(v1,v3)) {
			glVertex2f(v1f[0], v1f[1]);
			glVertex2f(v3f[0], v3f[1]);
		}
	glEnd();
#else
	glBegin(GL_LINE_LOOP);
		glVertex2f(v1f[0], v1f[1]);
		glVertex2f(v2f[0], v2f[1]);
		glVertex2f(v3f[0], v3f[1]);
	glEnd();
#endif
}


void drawlines1(void)	// draw links from triangulation vertex
{
	tFace temp;
	temp = faces;
	if (faces) do {
		if(faces->lower) 
		drawtriangle(faces->vertex[0]->v,faces->vertex[1]->v,faces->vertex[2]->v);
		faces= faces->next;
	} while ( faces != temp );
}


void drawlines2(void)	// draw links from graph's edges
{
	double r1[2], r2[2];
	graph_edge *p;
	
	p=myedge;
	while(p) {
		getvertexr(p->pair[0],p->pair[1],r1,r2);	// or p->id, p->next->id?
		drawline(r1,r2,1.0);
		p = p->next;
	}
}


void drawlines3(void)	// by connecting graph nodes, actual number of links is 2x
{
	int i;
	graph_node *p, *q;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q = p->next;
		while(q) {
			if(linkcolor==0) drawline(p->R0, q->R0, 1.0);
			else drawlineclr(p->R0, q->R0, q->dl, 1.0);
			q = q->next;
		}
	}
}


void drawlines4(void)	// clumsy way to test graph, but has problem
{
	int i;
	double r1[2], r2[2];
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		while(p) {
			getvertexr(i,p->id,r1,r2);
			drawline(r1,r2,1.0);
			p=p->next;
		}
	}
}


void drawlinks(void)
{
	if(showlink==0) drawlines1();
	else if(showlink==1) drawlines2();
	else if(showlink==2) drawlines3();
	else drawlines4();
}


void showtext(void)
{
	int i, len1, len2, len3, len4;
	char str1[100], str2[100], str3[100], str4[100];
	
	
	sprintf(str1, "t = %.3g s,  v = %.3g nm/s", t, dspl_Vave*1.0e3);
	sprintf(str2, "Fext = %.3g pN,  Nodes = %d,  Free = %d,  Att = %d", 
		Fext[1]*ksnode, Nnodes, Nfree, Natt);

	sprintf(str4, "Fext = %.3g,  Ftop = %.3g,  Fbot = %.3g pN", 
		Fext[1]*ksnode, Ftop[1]*ksnode, Fbot[1]*ksnode);

#if AUTNUC
	sprintf(str3, "Autocatalytic");
#else
	sprintf(str3, "Nucleation");
#endif

	len1=(int) strlen(str1);
	len2=(int) strlen(str2);
	len3=(int) strlen(str3);
	len4=(int) strlen(str4);

	if(texturemap==0) glColor3f(0.2, 0.2, 0.2);
	else glColor3f(0.6, 0.6, 0.6);
	if(HWratio>1) glRasterPos2f(-0.9, 0.92*HWratio);
	else glRasterPos2f(-0.9/HWratio, 0.92);
	for (i = 0; i < len1; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str1[i]);

	glRasterPos2f(-0.2, 0.92);
	for (i = 0; i < len2; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str2[i]);

//	glRasterPos2f(-0.45, -0.92);
//	for (i = 0; i < len4; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str4[i]);
/*
	glRasterPos2f(-0.95, -0.95);
	for (i = 0; i < len2; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str2[i]);
	glRasterPos2f(0.6, 0.95);
	for (i = 0; i < len3; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str3[i]);
	glRasterPos2f(-0.3, 0.95);
	for (i = 0; i < len4; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str4[i]);
	*/
	glRasterPos2f(-0.4, -0.95);
	for (i = 0; i < len4; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str4[i]);
}


void showtexttestgel(void)
{
	int i, len1, len3, len4;
	char str1[100], str1a[100], str3[100], str4[100];
	
	if(testdirection==0) sprintf(str1, "F");
	else if(testdirection==1) sprintf(str1, "Push F");
	else if(testdirection==2) sprintf(str1, "Pull F");
	else if(testdirection<=4) sprintf(str1, "Shear F");
	
	if(testdirection==0) sprintf(str1a, " = 0");
	else sprintf(str1a, " = %.3g pN", Floadtst);
	strcat(str1, str1a);
	
//	sprintf(str2, "N_brk = %d", Nlinksini-Nlinks);
	sprintf(str3, "dr = (%.2g, %.2g)", dtoppostot[0], dtoppostot[1]);
	sprintf(str4, "Y = %.2g Pa", Ymod);
	
	len1=(int) strlen(str1);
//	len2=(int) strlen(str2);
	len3=(int) strlen(str3);
	len4=(int) strlen(str4);
	
	glRasterPos2f(-0.95, -0.99);
	for (i = 0; i < len1; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str1[i]);
//	glRasterPos2f(-0.45, -0.99);
//	for (i = 0; i < len2; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str2[i]);
	glRasterPos2f(-0.25, -0.99);
	for (i = 0; i < len3; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str3[i]);
#if !NODDYN
	glRasterPos2f(0.5, -0.99);
	for (i = 0; i < len4; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str4[i]);
#endif
}


void showtexthistory(void)
{
	int i, len1, len2;
	char str1[100], str2[100];
	
	if(Fswitch==0) sprintf(str1, "Consant Force");
	else sprintf(str1, "Varying Force");
	
	sprintf(str2, "F_hold = %.3g pN", Fhold);
	
	len1=(int) strlen(str1);
	len2=(int) strlen(str2);
	
	glRasterPos2f(-0.95, -0.95);
	for (i = 0; i < len1; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str1[i]);
	glRasterPos2f(-0.55, -0.95);
	for (i = 0; i < len2; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str2[i]);
}


void mapnodes(void)	// show R0
{
	int i;
	float r1[2], r2[2], r3[2], r4[2];
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		r1[0] = r2[0] = p->R0[0] - ParticleRadius;
		r1[1] = r4[1] = p->R0[1] - ParticleRadius;
		r2[1] = r3[1] = p->R0[1] + ParticleRadius;
		r3[0] = r4[0] = p->R0[0] + ParticleRadius;
		
		glTexCoord2f(0.0, 0.0);
		glVertex3f(r1[0], r1[1], 0.0);
		glTexCoord2f(0.0, 1.0);
		glVertex3f(r2[0], r2[1], 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3f(r3[0], r3[1], 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3f(r4[0], r4[1], 0.0);
	}
}


void mapnodes0a(void)	// show R0, with colors
{
	int i;
	float r1[2], r2[2], r3[2], r4[2];
	float f, rgbini, r, g, b, mag;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		r1[0] = r2[0] = p->R0[0] - ParticleRadius;
		r1[1] = r4[1] = p->R0[1] - ParticleRadius;
		r2[1] = r3[1] = p->R0[1] + ParticleRadius;
		r3[0] = r4[0] = p->R0[0] + ParticleRadius;
		
		f=0.0;
		p = p->next;
		while(p) {
			f += p->dl;	// dl>0 for compression, <0 for stretching
			p = p->next;
		}
		rgbini=1.0;
		r=g=b=rgbini;
		mag=(float) (pow(fabs(f)/dlscaleshow,0.2));	// smaller factor is more sensitive to force change
		mag=min2(mag,1.0);
		if(f>=0) {	// stretching: blue
			r-=rgbini*mag;
			g-=rgbini*mag;
			b+=(1.0-rgbini)*mag;
		}
		else {	// compressing: red
			r+=(1.0-rgbini)*mag;
			g-=rgbini*mag;
			b-=rgbini*mag;
		}
		glColor4f(r, g, b, 0.6);
		glTexCoord2f(0.0, 0.0);
		glVertex3f(r1[0], r1[1], 0.0);
		glTexCoord2f(0.0, 1.0);
		glVertex3f(r2[0], r2[1], 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3f(r3[0], r3[1], 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3f(r4[0], r4[1], 0.0);
	}
}


void mapnodes0b(void)	// show link, streched with colors
{
	int i, j;
	double r1[2], r2[2], r3[2], r4[2];
	double ta, ta2, sa, ca;
	float r1f[2], r2f[2], r3f[2], r4f[2];
	graph_node *p, *q;
#if LNKCLR
	float rgbini, r, g, b, mag;
#endif
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q = p->next;
		while(q) {
			if(p->id < q->id) {	// to avoid double-count
			#if LNKCLR
				rgbini=0.8;
				r=g=b=rgbini;
				mag=(float) (pow(fabs(q->dl)/dlscaleshow,0.2));	// smaller factor is more sensitive to force change
				mag=min2(mag,1.0);
				if(q->dl>0) {	// stretching: blue
					r-=rgbini*mag;
					g-=rgbini*mag;
					b+=(1.0-rgbini)*mag;
				}
				else {	// compressing: red
					r+=(1.0-rgbini)*mag;
					g-=rgbini*mag;
					b-=rgbini*mag;
				}
				glColor4f(r, g, b, 0.6);
			#else
				glColor4f(0.8, 0.8, 0.8, 0.6);
			#endif
				if(p->R0[0] == q->R0[0]) {	// slope=inf
					r1f[0] = r2f[0] = (float) (p->R0[0] - ParticleRadius);
					r3f[0] = r4f[0] = (float) (p->R0[0] + ParticleRadius);
					r1f[1] = r4f[1] = (float) (p->R0[1] - ParticleRadius);
					r2f[1] = r3f[1] = (float) (q->R0[1] + ParticleRadius);
				}
				else {
					ta = (q->R0[1] - p->R0[1])/(q->R0[0] - p->R0[0]);	// slope
					ta2 = ta*ta;
					ca = 1.0/sqrt(1+ta2);	// 1st quadrant
					sa = fabs(ta)*ca;
					if(q->R0[0] < p->R0[0]) {	// 2nd or 3rd quadrant
						ca*=-1;
						if(q->R0[1] < p->R0[1]) sa*=-1;	// 3rd
					}
					else if(q->R0[1] < p->R0[1]) sa*=-1;	// 4th
					
					r1[0] = r1[1] = -ParticleRadius;
					r2[0] = -ParticleRadius;	r2[1] = ParticleRadius;
					r3[0] = r3[1] = ParticleRadius;
					r4[0] = ParticleRadius;	r4[1] = -ParticleRadius;
					
					RotMatrix(sa, ca, r1, r1);
					RotMatrix(sa, ca, r2, r2);
					RotMatrix(sa, ca, r3, r3);
					RotMatrix(sa, ca, r4, r4);
					vecadd(p->R0, r1, r1);
					vecadd(p->R0, r2, r2);
					vecadd(q->R0, r3, r3);
					vecadd(q->R0, r4, r4);
					for(j=0; j<2; j++) {
						r1f[j]=(float)(r1[j]);	r2f[j]=(float)(r2[j]);
						r3f[j]=(float)(r3[j]);	r4f[j]=(float)(r4[j]);
					}
				}
				glTexCoord2f(0.0, 0.0);
				glVertex3f(r1f[0], r1f[1], 0.0);
				glTexCoord2f(0.0, 1.0);
				glVertex3f(r2f[0], r2f[1], 0.0);
				glTexCoord2f(1.0, 1.0);
				glVertex3f(r3f[0], r3f[1], 0.0);
				glTexCoord2f(1.0, 0.0);
				glVertex3f(r4f[0], r4f[1], 0.0);
			}	// end of if p<q
			q = q->next;
		}	// end of while-q
	}
}



void mapnodes0c(void)	// show link, decorated with colors
{
	int i, j, n, flg;
	float r1[2], r2[2], r3[2], r4[2];
	double drnrm[2], ri[2];
	graph_node *p, *q;
#if LNKCLR
	float rgbini, drgb, r, g, b, mag;
	rgbini=0.3;
#endif

	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q = p->next;
		while(q) {
			flg=0;	// show head node just once
			if(p->id < q->id) {	// to avoid double-count
			#if LNKCLR
				r=g=b=rgbini;
				mag=(float) (pow(fabs(q->dl)/dlscaleshow,0.3));	// smaller factor is more sensitive to force change
				drgb=(1-rgbini)*min2(mag,1);
				if(q->dl > 0) {	// stretched: blue
					b+=drgb;
				}
				else {	// compressed: red
					r+=drgb;
				}
				glColor4f(r, g, b, 0.8);
			#else
				glColor4f(0.4, 1.0, 0.4, 0.6);
			#endif
			
				n=(int)(q->l0 / LinkDecorSpacing);
				n=max2(n,1);
				vecsub(q->R0, p->R0, drnrm);
				vecdiv(drnrm, n, drnrm);	// each increment
				vecadd(p->R0, drnrm, ri);	// skip head node
				for(j=0; j<n; j++) {
					r1[0] = r2[0] = (float) (ri[0] - ParticleRadius);
					r3[0] = r4[0] = (float) (ri[0] + ParticleRadius);
					r1[1] = r4[1] = (float) (ri[1] - ParticleRadius);
					r2[1] = r3[1] = (float) (ri[1] + ParticleRadius);
					glTexCoord2f(0.0, 0.0);
					glVertex3f(r1[0], r1[1], 0.0);
					glTexCoord2f(0.0, 1.0);
					glVertex3f(r2[0], r2[1], 0.0);
					glTexCoord2f(1.0, 1.0);
					glVertex3f(r3[0], r3[1], 0.0);
					glTexCoord2f(1.0, 0.0);
					glVertex3f(r4[0], r4[1], 0.0);
					vecadd(ri, drnrm, ri);
				}
				
			}	// end of if p<q
			q = q->next;
		}	// end of while-q
	}
}



void testmapnodes0b(void)	// show R0, with colors
{
	int i, j;
	double r1[2], r2[2], r3[2], r4[2];
	double ta, ta2, sa, ca;
	float r1f[2], r2f[2], r3f[2], r4f[2];
	float f, rgbini, r, g, b, mag;
	graph_node *p, *q;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q = p->next;
		while(q) {
			if(p->id < q->id) {	// to avoid double-count
				if(p->R0[0] == q->R0[0]) {	// slope=inf
					r1f[0] = r2f[0] = (float) (p->R0[0] - ParticleRadius);
					r3f[0] = r4f[0] = (float) (p->R0[0] + ParticleRadius);
					r1f[1] = r4f[1] = (float) (p->R0[1] - ParticleRadius);
					r2f[1] = r3f[1] = (float) (q->R0[1] + ParticleRadius);
				}
				else {
					ta = (q->R0[1] - p->R0[1])/(q->R0[0] - p->R0[0]);	// slope
					ta2 = ta*ta;
					ca = 1.0/sqrt(1+ta2);	// 1st quadrant
					sa = fabs(ta)*ca;
					if(q->R0[0] < p->R0[0]) {	// 2nd or 3rd quadrant
						ca*=-1;
						if(q->R0[1] < p->R0[1]) sa*=-1;	// 3rd
					}
					else if(q->R0[1] < p->R0[1]) sa*=-1;	// 4th
					
					r1[0] = r1[1] = -ParticleRadius;
					r2[0] = -ParticleRadius;	r2[1] = ParticleRadius;
					r3[0] = r3[1] = ParticleRadius;
					r4[0] = ParticleRadius;	r4[1] = -ParticleRadius;
					
					RotMatrix(sa, ca, r1, r1);
					RotMatrix(sa, ca, r2, r2);
					RotMatrix(sa, ca, r3, r3);
					RotMatrix(sa, ca, r4, r4);
					vecadd(p->R0, r1, r1);
					vecadd(p->R0, r2, r2);
					vecadd(q->R0, r3, r3);
					vecadd(q->R0, r4, r4);
					for(j=0; j<2; j++) {
						r1f[j]=(float)(r1[j]);	r2f[j]=(float)(r2[j]);
						r3f[j]=(float)(r3[j]);	r4f[j]=(float)(r4[j]);
					}
				}
			}	// end of if p<q
			q = q->next;
		}	// end of while-q
		
		f=0.0;
		p = p->next;
		while(p) {
			f += p->dl;	// dl>0 for compression, <0 for stretching
			p = p->next;
		}
		rgbini=1.0;
		r=g=b=rgbini;
		mag=(float) (pow(fabs(f)/dlbr,0.2));	// smaller factor is more sensitive to force change
		if(f>=0) {	// stretching: blue
			r-=rgbini*mag;
			g-=rgbini*mag;
			b+=(1.0-rgbini)*mag;
		}
		else {	// compressing: red
			r+=(1.0-rgbini)*mag;
			g-=rgbini*mag;
			b-=rgbini*mag;
		}
		glColor4f(r, g, b, 0.6);
		
	glBegin(GL_LINE_LOOP);
		glVertex2f(r1f[0], r1f[1]);
		glVertex2f(r2f[0], r2f[1]);
		glVertex2f(r3f[0], r3f[1]);
		glVertex2f(r4f[0], r4f[1]);
	glEnd();
	}
}


void mapnodes1(void)	// show (R0+R1)/2
{
	int i;
	float r1[2], r2[2], r3[2], r4[2];
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		r1[0] = r2[0] = (p->R0[0]+p->R1[0])/2 - ParticleRadius;
		r1[1] = r4[1] = (p->R0[1]+p->R1[1])/2 - ParticleRadius;
		r2[1] = r3[1] = (p->R0[1]+p->R1[1])/2 + ParticleRadius;
		r3[0] = r4[0] = (p->R0[0]+p->R1[0])/2 + ParticleRadius;
		
		glTexCoord2f(0.0, 0.0);
		glVertex3f(r1[0], r1[1], 0.0);
		glTexCoord2f(0.0, 1.0);
		glVertex3f(r2[0], r2[1], 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3f(r3[0], r3[1], 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3f(r4[0], r4[1], 0.0);
	}
}


void mapnodes2(void)	// show filament R0-R1
{
	int i, j;
	float r1f[2], r2f[2], r3f[2], r4f[2];
	double ta, ta2, sa, ca;
	double r1[2], r2[2], r3[2], r4[2];
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->R0[0] == p->R1[0]) {
			r1f[0] = r4f[0] = (float) (p->R0[0] + ParticleRadius);
			r1f[1] = r2f[1] = (float) (p->R0[1] - ParticleRadius);
			r2f[0] = r3f[0] = (float) (p->R1[0] - ParticleRadius);
			r3f[1] = r4f[1] = (float) (p->R1[1] + ParticleRadius);
		}
		else {
			ta = (p->R1[1] - p->R0[1])/(p->R1[0] - p->R0[0]);	// slope
			ta2 = ta*ta;
			ca = 1/sqrt(1+ta2);
			sa = fabs(ta)*ca;
			if(p->R1[0] < p->R0[0]) {	// 2nd or 3rd quadrant
				ca*=-1;
				if(p->R1[1] < p->R0[1]) sa*=-1;	// 3rd
			}
			else if(p->R1[1] < p->R0[1]) sa*=-1;	// 4th
			
			r1[0] = r1[1] = -ParticleRadius;
			r2[0] = -ParticleRadius;	r2[1] = ParticleRadius;
			r3[0] = r3[1] = ParticleRadius;
			r4[0] = ParticleRadius;	r4[1] = -ParticleRadius;
			
			RotMatrix(sa, ca, r1, r1);
			RotMatrix(sa, ca, r2, r2);
			RotMatrix(sa, ca, r3, r3);
			RotMatrix(sa, ca, r4, r4);
			vecadd(p->R0, r1, r1);
			vecadd(p->R0, r2, r2);
			vecadd(p->R1, r3, r3);
			vecadd(p->R1, r4, r4);
			for(j=0; j<2; j++) {
				r1f[j]=(float)(r1[j]);	r2f[j]=(float)(r2[j]);
				r3f[j]=(float)(r3[j]);	r4f[j]=(float)(r4[j]);
			}
		}
		glTexCoord2f(0.0, 0.0);
		glVertex3f(r1f[0], r1f[1], 0.0);
		glTexCoord2f(0.0, 1.0);
		glVertex3f(r2f[0], r2f[1], 0.0);
		glTexCoord2f(1.0, 1.0);
		glVertex3f(r3f[0], r3f[1], 0.0);
		glTexCoord2f(1.0, 0.0);
		glVertex3f(r4f[0], r4f[1], 0.0);
	}
}


void showtexture(void)
{
	glEnable(GL_TEXTURE_2D);
	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glBindTexture(GL_TEXTURE_2D, texName);

	glEnable(GL_BLEND);
	glDepthMask(GL_FALSE);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	glBegin(GL_QUADS);
		mapnodes0c();
		//mapnodes2();
	glEnd();
	
	glDepthMask(GL_TRUE);
	glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	//testmapnodes0b();
}


void showdistrib(void)
{
	int i;
	float x1, x2, y, y1, y2, ybot;
	
	statbeadFN();
	
	ybot=-0.8f*HWratio;
	
#if AALIAS
	glDisable(GL_LINE_SMOOTH);
#endif
	glLineWidth(1.0);
	glColor3f(0.5, 0.5, 0.5);
	
	glBegin(GL_LINES);	// bottom
		glVertex2f(-0.5, ybot);
		glVertex2f(0.5, ybot);
	glEnd();
	glRasterPos2f(-0.4, -0.85*HWratio);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, 'L');
	glRasterPos2f(0.4, -0.85*HWratio);
	glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, 'R');
	
	if(Ncontact<=0) return;
	
	for(i=SurfBinsm1; i>=0; i--) {
		x1=-0.5+(SurfBinsm1-i)*dxshow;	// x goes from -0.5 to 0.5
		x2=x1+dxshow;
		y=0.05*SurfBins*surfPn[i]+ybot;
		glBegin(GL_LINE_LOOP);
			glVertex2f(x1, ybot);
			glVertex2f(x1, y);
			glVertex2f(x2, y);
			glVertex2f(x2, ybot);
		glEnd();
	}
		
	glColor3f(0.5, 0.5, 1.0);
	glEnable(GL_LINE_STIPPLE);
	glLineStipple (3, 0xAAAA);
	for(i=SurfBinsm1; i>=1; i--) {
		x1=-0.5+(SurfBinsm1-i)*dxshowm1;	// x goes from -0.5 to 0.5
		x2=x1+dxshowm1;
		y1=0.05*SurfBins*surfPf[i]+ybot;
		y2=0.05*SurfBins*surfPf[i-1]+ybot;
		glBegin(GL_LINES);
			glVertex2f(x1, y1);
			glVertex2f(x2, y2);
		glEnd();
	}
	glDisable(GL_LINE_STIPPLE);
}


void drawfila(void)
{
	int i;
	graph_node *p;
	
		for(i=0; i<Nnodes; i++) {
			p=graph[i];
			if(p->contact==1 && p->capped==0) {
				if(p->attached==0) glColor3f(0.3,1.0,0.3);	// free
				else glColor3f(0.0,0.0,1.0);	// attached
				drawline(p->R0, p->Rtip, 1.0);
			}
		}
}


void drawforce(void)
{
	int i, j;
	float v1[2], v2[2];
	double v[2];
	graph_node *p;
	
	glColor3f(0.8,0.0,0.0);
	glLineWidth(1.0);
	glBegin(GL_LINES);
		for(i=0; i<Nnodes; i++) {
			p=graph[i];
			if(p->contact==1 && !(p->attached==0 && (p->dlen<0 || p->capped==1))) {
				vecprod(p->Ftip, 1.0e1, v);
				vecadd(v, p->R1, v);
				for(j=0; j<2; j++) {
					v1[j]=(float) (p->R1[j]);
					v2[j]=(float) (v[j]);
				}
				glVertex2f(v1[0], v1[1]);
				glVertex2f(v2[0], v2[1]);
			}
		}
	glEnd();
}


void drawallforce(void)
{
	int i, j;
	float v1[2], v2[2];
	double v[2];
	graph_node *p;
	
	glColor3f(0.8,0.0,0.0);
	glLineWidth(1.0);
	glBegin(GL_LINES);
		for(i=0; i<Nnodes; i++) {
			p=graph[i];
			vecprod(p->DLvec, 10.0, v);
			for(j=0; j<2; j++) {
				v1[j]=(float) (p->R0[j]);
				v2[j]=(float) (p->R0[j]+v[j]);
			}
			glVertex2f(v1[0], v1[1]);
			glVertex2f(v2[0], v2[1]);
		}
	glEnd();
}


void marknodes(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	graph_node *p;
	
	glColor3f(0.2, 0.2, 0.2);
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->bnd == -1) {
			sprintf(str, "%d", p->bnd);
			len=(int) strlen(str);
			r[0]=(float)(p->R0[0]);
			r[1]=(float)(p->R0[1]+0.01+(i%5)*0.02);
			glRasterPos2f(1.01*r[0], 1.01*r[1]);
			for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
		}
	}
}


void marklinks(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	graph_node *p, *q;
	
	glColor3f(0.2, 0.2, 0.2);
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q=p->next;
		while(q) {
			sprintf(str, "%.2g, %.2g", q->l0, q->dl);
			len=(int) strlen(str);
			r[0]=(float)((p->R0[0]+q->R0[0])/2.0);
			r[1]=(float)((p->R0[1]+q->R0[1])/2.0);
			glRasterPos2f(1.01*r[0], 1.01*r[1]);
			for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
			q = q->next;
	}
	}
}



void drawallobj(void)
{
//	drawviewbox();

#if !TSTGEL
	shiftview();
	if(showpfn==1) showdistrib();
#endif

	glTranslatef(PanX, PanY, 0.0);
	glScalef(zoom, zoom, zoom);	// scale
	glTranslatef(Disp_shift[0], Disp_shift[1], 0.0);
	
	if(texturemap==1) showtexture();

#if !TSTGEL
	drawbead();
#endif
	
	if(texturemap==0) {
		drawlinks();
		drawnodes();
		if(showfila==1) {
			drawfila();
			//drawforce();
		}
		//drawallforce();
		//marknodes();
		//marklinks();
	}
	glLoadIdentity();

#if TSTGEL
	#if INBEAD
		drawleverbead();
	#else
	//	drawspring();
		drawlever();	// it uses loadidentity(), needs to move out of zoom
	#endif
	drawbottom();	// it uses loadidentity(), needs to move out of zoom
#endif
}


void GLmain(void)
{
	int i;
	//glClear(GL_COLOR_BUFFER_BIT);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();

	drawallobj();	// scaled obj

#if !SAVPIC
	showtext();
#endif

#if TSTGEL
	//showtexttestgel();
	#if HISTRY
	showtexthistory();
	#endif
#endif
	
	
//-------- snapshots --------
#if SAVPIC
	if(img_cnt%img_cntm==0) {
		nframe++;
		printf("frame = %d\n", nframe);
		sprintf(img_name, "frames/p%.4u.png", nframe);
		img_data=(GLubyte*)malloc((Width)*(Height)*3*sizeof(GLubyte));
		ilTexImage(Width, Height, 1, 3, GL_RGB, GL_UNSIGNED_BYTE, img_data);
	
		glPixelStorei(GL_PACK_ALIGNMENT, 1);
		glReadPixels(0, 0, Width, Height, GL_RGB, GL_UNSIGNED_BYTE, img_data);

		ilSetData(img_data);
		ilSave(IL_PNG, img_name);
		free(img_data);
	}
	img_cnt++;
#endif
//---------------------------

	if(start) start=0;
//	pause=1;
	if(!pause) for(i=0; i<showskip; i++) DoSimu();
		
	glPopMatrix();
	glutSwapBuffers();
}


void RunGL(int *argc, char **argv)
{
	glutInit(argc,argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
//	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(Width,Height);
	glutInitWindowPosition(50,50);
	glutCreateWindow("Actin Network");

	init_GL();
#if SAVPIC
	ilInit();	// initializing IL
#endif
	display_list();
	glutMouseFunc(mouse);
	glutMotionFunc(drag);
	glutReshapeFunc(changeSize);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(arrow_keys);

	glutDisplayFunc(GLmain);
	glutIdleFunc(GLmain);
	glutMainLoop();
}


