
void readtrack(void)
{
	int i;
	char tmp[50];
	FILE *fp;

	n_track=(int) (t/smp_dt);	// number of total data points
	
	t_seq=malloc(n_track*sizeof(float));
	thb_seq=malloc(n_track*sizeof(float));
	x_seq=malloc(n_track*sizeof(float));
	y_seq=malloc(n_track*sizeof(float));
	
	fp=fopen("track.dat", "r");
	fscanf(fp, "%s\t%s\t%s\t%s", tmp, tmp, tmp, tmp);
	for(i=0; i<n_track; i++) {
		fscanf(fp, "%f\t%f\t%f\t%f", &t_seq[i], &thb_seq[i], &x_seq[i], &y_seq[i]);
	}
	fclose(fp);
}


void smooth3pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	for(i=1; i<n_track-1; i++) s2[i]=(s1[i-1]+s1[i+1]+2*s1[i])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smooth5pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	s2[1]=(s1[0]+s1[2]+2*s1[1])/4.0;
	for(i=2; i<n_track-2; i++) s2[i]=(s1[i-2]+s1[i+2]+4*(s1[i-1]+s1[i+1])+6*s1[i])/16.0;
	s2[n_track-2]=(s1[n_track-3]+s1[n_track-1]+2*s1[n_track-2])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smooth7pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	s2[1]=(s1[0]+s1[2]+2*s1[1])/4.0;
	s2[2]=(s1[0]+s1[4]+4*(s1[1]+s1[3])+6*s1[2])/16.0;
	for(i=3; i<n_track-3; i++) {
		s2[i]=(s1[i-3]+s1[i+3]+6*(s1[i-2]+s1[i+2])+15*(s1[i-1]+s1[i+1])+20*s1[i])/64.0;
	}
	s2[n_track-3]=(s1[n_track-5]+s1[n_track-1]+4*(s1[n_track-4]+s1[n_track-2])+6*s1[n_track-3])/16.0;
	s2[n_track-2]=(s1[n_track-3]+s1[n_track-1]+2*s1[n_track-2])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smoothfunc(float s1[], float s2[])
{	
	smooth5pt(s1, s2);
	smooth5pt(s1, s2);
	smooth5pt(s1, s2);
	
	/*
	smooth3pt(s1, s2);
	smooth3pt(s1, s2);
	smooth3pt(s1, s2);
	
	smooth5pt(s1, s2);
	smooth5pt(s1, s2);
	smooth5pt(s1, s2);
	
	smooth7pt(s1, s2);
	smooth7pt(s1, s2);
	smooth7pt(n1, s2);
	*/
}


void smoothtrack(void)
{
	thb_seqsm=malloc(n_track*sizeof(float));
	x_seqsm=malloc(n_track*sizeof(float));
	y_seqsm=malloc(n_track*sizeof(float));
	
	smoothfunc(thb_seq, thb_seqsm);
	smoothfunc(x_seq, x_seqsm);
	smoothfunc(y_seq, y_seqsm);
}


//------------------- get yaw angle from smoothed track ------------------

void getyaw(void)
{
	int i, ia, ib;
	double dr[2], vbangle, yawangle;
	
	yaw_seq=malloc(n_track*sizeof(float));
	
	for(i=0; i<n_track; i++) {
		if(i==0) {ia=i; ib=i+1;}
		else if(i==n_track-1) {ia=i-1; ib=i;}
		else {ia=i-1; ib=i+1;}
		
		dr[0]=x_seqsm[ib]-x_seqsm[ia];
		dr[1]=y_seqsm[ib]-y_seqsm[ia];
		Crt2LabPol(dr, &vbangle);
		yawangle=vbangle-thb_seqsm[i]*d2r;
		limityaw(&yawangle);	// limit 0<x<pihalf, for yaw angle
		yaw_seq[i]=yawangle*r2d;
	}
}


//------------------- get omg's from smoothed track ------------------

void getomgfunc(float x[], float y[], float w[])
{
	int i;
	double r1[2], r2[2];
	for(i=1; i<n_track-1; i++) {
		r1[0]=x[i]-x[i-1];
		r1[1]=y[i]-y[i-1];
		r2[0]=x[i+1]-x[i];
		r2[1]=y[i+1]-y[i];
		w[i]=getanglesign(r1,r2)*r2d/smp_dt;	// in degrees
	}
	w[0]=w[1];
	w[n_track-1]=w[n_track-2];
}


void getomg_tl(void)	// omg_tail in lab
{
	int i;
	omg_tl=malloc(n_track*sizeof(float));
	for(i=0; i<n_track; i++) omg_tl[i]=0.0;
	getomgfunc(x_seqsm, y_seqsm, omg_tl);
}


void getomg_bd(void)	// omg_bead in lab
{
	int i, ia, ib, di;
	float dth;
	
	omg_bd=malloc(n_track*sizeof(float));
	for(i=0; i<n_track; i++) {
		if(i==0) {ia=i; ib=i+1; di=1;}
		else if(i==n_track-1) {ia=i-1; ib=i; di=1;}
		else {ia=i-1; ib=i+1; di=2;}
		dth=(thb_seqsm[ib]-thb_seqsm[ia])/di;	// thb is not limited within (-180,180)
		omg_bd[i]=dth/smp_dt;	// in degrees
	}
}


void getomg_bdtl(void)	// omg_bead in tail
{
	int i;
	omg_bdtl=malloc(n_track*sizeof(float));
	for(i=0; i<n_track; i++) omg_bdtl[i]=omg_bd[i]-omg_tl[i];
}


void getomgs(void)
{
	getomg_tl();
	getomg_bd();
	getomg_bdtl();
}


//------------------- get ktail from smoothed track ------------------

void getKtail(void)
{
	int i, j, cnt;
	double r1[2], r2[2], r3[2];
	double kave, krms, kcut;
	float *ktailall;
	
	ktailall=malloc(n_track*sizeof(float));
	for(i=1; i<n_track-1; i++) {
		r1[0]=x_seqsm[i-1];	r1[1]=y_seqsm[i-1];
		r2[0]=x_seqsm[i];	r2[1]=y_seqsm[i];
		r3[0]=x_seqsm[i+1];	r3[1]=y_seqsm[i+1];
		ktailall[i]=getcurvature(r1, r2, r3);
	}
	if(n_track==1) ktailall[0]=0.0;
	else if(n_track>=2) {
		ktailall[0]=ktailall[1];
		ktailall[n_track-1]=ktailall[n_track-2];
	}
	
//--- start truncating high curvatures due to stalled bead ---
	kave=krms=0.0;
	cnt=0;
	for(i=0; i<n_track; i++) {
		if(ktailall[i]<2.0) {	// ignore curvatures greater than 2/um
			kave+=ktailall[i];
			krms+=pow(ktailall[i],2);
			cnt++;
		}
	}
	cnt=max2(cnt,1);
	kave/=cnt;
	krms/=cnt;
	krms=sqrt(krms);
	
	kcut=10.0*max2(kave,krms);
	
	n_ktail=0;
	for(i=0; i<n_track; i++) {
		if(ktailall[i]<kcut) n_ktail++;
	}
	
	if(n_ktail==0) {
		ktail=malloc(sizeof(float));
		ktail[0]=0.0;
		free(ktailall);
		return;
	}
	
	ktail=malloc(n_ktail*sizeof(float));

	j=0;
	for(i=0; i<n_track; i++) {
		if(ktailall[i]<kcut && j<n_ktail) ktail[j++]=ktailall[i];
	}
//--- end of truncating ktail ---
	free(ktailall);
}

//----------- overall ------------

void savetrack(void)
{
	int i;
	FILE *fp;
	fp=fopen("track_sm.dat", "w");
	fprintf(fp, "#t\tyaw\tthb\tx\ty\n");
	for(i=0; i<n_track; i++) fprintf(fp, "%.2f\t%.2f\t%.2f\t%.2f\t%.2f\n", 
		t_seq[i], yaw_seq[i], thb_seqsm[i], x_seqsm[i], y_seqsm[i]);
	fclose(fp);
	
	fp=fopen("omg_sm.dat", "w");
	fprintf(fp, "#t\tomg_bd\tomg_tl\tomg_bdtl\n");
	for(i=0; i<n_track; i++) fprintf(fp, "%.2f\t%.3g\t%.3g\t%.3g\n", 
		t_seq[i], omg_bd[i], omg_tl[i], omg_bdtl[i]);
	fclose(fp);
}


void ProcessTrack(void)
{
	readtrack();
	smoothtrack();
	if(n_track>=3) {
		getyaw();
		getomgs();
		getKtail();
		savetrack();
	}
}



