
void CopyGraphNode(graph_node *p1, graph_node *p2)
{
	p2->id = p1->id;
	p2->bnd = p1->bnd;
	p2->nnbr = p1->nnbr;
	p2->contact = p1->contact;
	
	p2->tipcontact = p1->tipcontact;
	p2->arp23 = p1->arp23;
	p2->deformable = p1->deformable;
	p2->attached = p1->attached;
	p2->branchable = p1->branchable;
	p2->capped = p1->capped;
	
	p2->connected = p1->connected;
	p2->segmentid = p1->segmentid;
	p2->linkdown = p1->linkdown;
	
	p2->len = p1->len;
	p2->len0 = p1->len0;
	p2->dlen = p1->dlen;
	p2->l0 = p1->l0;
	p2->dl = p1->dl;
	
	veccopy(p1->R0, p2->R0);
	veccopy(p1->R1, p2->R1);
	veccopy(p1->r0, p2->r0);
	veccopy(p1->r1, p2->r1);
	veccopy(p1->nrm, p2->nrm);
	veccopy(p1->dlvec, p2->dlvec);
	veccopy(p1->DLvec, p2->DLvec);
	
	veccopy(p1->ftip, p2->ftip);
	veccopy(p1->Ftip, p2->Ftip);
	veccopy(p1->Rtip, p2->Rtip);
	
	p2->sumka = p1->sumka;
	p2->sumkc = p1->sumkc;
	p2->sumkd = p1->sumkd;
	
	p2->next = p1->next;
}


void SwapGraphNodes(graph_node *p1, graph_node *p2)
{
	graph_node *p;
	p=(graph_node *)malloc(sizeof(graph_node));
	CopyGraphNode(p1,p);
	CopyGraphNode(p2,p1);
	CopyGraphNode(p,p2);
	free(p);
}


void GetNewNodePos(double R0[2])	// rlab is in lab frame
{
#if TSTGEL	// ----- testing gel -----
	#if INBEAD
		double a, r, sn, cs;
		a=Pi*ran2(&mseed);
		sn=sin(a);
		cs=cos(a);
		if(Ra==Rb) r=Ra;
		else r=1.0/sqrt(cs*cs/Ra2+sn*sn/Rb2);
		r+=ran2(&mseed)*newnodedistance;
		R0[0]=Rcenter[0]+r*cs;
		R0[1]=Rcenter[1]-r*sn;
	#else
		R0[0]=toppos[0]+GelWidthIni*(1.0-2*ran2(&mseed));
		R0[1]=toppos[1]-ran2(&mseed)*newnodedistance;
	#endif

#else	// ----- not testing gel -----

	#if INBEAD
		double a, rloc[2];
		double y, y2, rho, rhoy;
		
		if(Ra==Rb) {	// circle
			a=Pidb*ran2(&mseed);
			rloc[0]=Ra*cos(a);
			rloc[1]=Ra*sin(a);
		}
		else {	// 2D ellipse
			do {
				y=Rb*(1.0-2*ran2(&mseed));
				y2=y*y;
				rhoy=sqrt(1+Ra2_Rb2*y2/max2(eps,Rb2-y2));	// see notebook
				rho=rhoymax*ran2(&mseed);
			} while(rho>rhoy);
			rloc[0]=randsign()*Ra*sqrt(1-y2/Rb2);
			rloc[1]=y;
		}
		Loc2Lab(rloc, R0);	// first rotate
		vecadd(R0, Rcenter, R0);	// then translate
	#else
		#if CIRBND
		double x, y, z;
		do {
			x=NtwkRadius*(1.0-2*ran2(&mseed));
			y=NtwkRadius*(1.0-2*ran2(&mseed));
			z=x*x+y*y;
		} while(z>NtwkRadius2);
		rloc[0]=x;
		rloc[1]=y;
		#else
		rloc[0]=GelWidthIni*(1.0-2*ran2(&mseed));
		rloc[1]=GelHeightIni*(1.0-2*ran2(&mseed));
		#endif
		veccopy(rloc, R0);
	#endif

#endif	// -----
}



void GetNewNodePosBack(double R0[2])	// rlab is in lab frame, biased position only at the bead rear
{
	int keepgoing;
	double a, rloc[2], nrm[2], v;
	double y, y2, rho, rhoy, prob;
	
	v=norm(Vcenter)*1.0e-3;	// in um/s
	if(v<Vbrush) {	// uniform nucleation if v is small
		GetNewNodePos(R0);
		return;
	}
	
	keepgoing=1;
	do {
		if(Ra==Rb) {	// circle
			a=Pidb*ran2(&mseed);
			nrm[0]=cos(a);
			nrm[1]=sin(a);
			rloc[0]=Ra*nrm[0];
			rloc[1]=Ra*nrm[1];
		}
		else {	// 2D ellipse
			do {
				y=Rb*(1.0-2*ran2(&mseed));
				y2=y*y;
				rhoy=sqrt(1+Ra2_Rb2*y2/max2(eps,Rb2-y2));	// see notebook
				rho=rhoymax*ran2(&mseed);
			} while(rho>rhoy);
			rloc[0]=randsign()*Ra*sqrt(1-y2/Rb2);
			rloc[1]=y;
			nrm[0]=rloc[0]/Ra2;	// not normalized surface normal
			nrm[1]=rloc[1]/Rb2;
			Loc2Lab(nrm, nrm);
		}
		Loc2Lab(nrm, nrm);
		prob=-dotprod(nrm,Vcenter);	// prob>0 if on the back
		if(prob>0) keepgoing=0;
	} while (keepgoing);	// ignore if it is on the front side of the bead

	Loc2Lab(rloc, R0);	// first rotate
	vecadd(R0, Rcenter, R0);	// then translate
}



void GetNeighborPos(double r[2], int idx[], int *nx)	// r is in lab
{
	int i, j, k, cnt, nmax, flg;
	int idxplus[LinkPerNodeplus], idxplusflag[LinkPerNodeplus];
	double rtmp, rmin[LinkPerNodeplus], dotpd;
	double r1[2], r2[2], n1[2], n2[2];
	graph_node *p;

	for(i=0; i<LinkPerNodeplus; i++) {
		rmin[i]=inf;
		idxplus[i]=idxplusflag[i]=0;
	}
	
	cnt=0;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		rtmp=distance(r,p->R0);
		flg=0;
		if(rtmp>0.1 && rtmp<0.3 && rtmp<rmin[LinkPerNodeplusm1] && p->nnbr<LinkPerNodedb) flg=1;
	#if INBEAD
		if(flg) {
			if(CutOffBead(r,p->R0)) flg=0;
		}
	#endif
			
		if(flg) {
			j=LinkPerNodeplusm1;
			while(rtmp<rmin[j] && j>0) j--;
			if(j>0 && rtmp>rmin[j]) j++;
			for(k=LinkPerNodeplusm1; k>j; k--) {	// move the rest
				rmin[k]=rmin[k-1];
				idxplus[k]=idxplus[k-1];
			}
			rmin[j]=rtmp;
			idxplus[j] = p->id;
			cnt++;
		}
	}
	
	for(i=0; i<LinkPerNode; i++) idx[i]=idxplus[i];	// temporarily accept it
	
	if(cnt<LinkPerNode) {	// not enough nodes selected
		*nx=cnt;
		return;
	}
	
	nmax=min2(cnt, LinkPerNodeplus);	// cnt may < or > LinkPerNodeplus
	*nx=k=1;	// fix idx[0]=idxplus[0]
	idxplusflag[0]=1;
	for(i=0; i<LinkPerNodem1; i++) {	// among LinkPerNodeplus, pick out LinkPerNode nodes
		vecsub(r, graph[idxplus[i]]->R0, r1);
		normalize(r1, n1);
		j=i;
		do {
			j++;
			vecsub(r, graph[idxplus[j]]->R0, r2);
			normalize(r2,n2);
			dotpd=fabs(dotprod(n1,n2));
		} while(dotpd>0.8 && idxplusflag[j]==1 && j<nmax);	// shouldn't be too close
		
		if(j<nmax && k<LinkPerNode) {
			idx[k]=idxplus[j];
			idxplusflag[j]=1;	// this node is now taken
			k++;
			(*nx)++;
		}
	}
}


void GetNeighborPos2(double rloc[2], double r[2], int idx[], int *nx)	// r is in lab
{
	int i, j, k, cnt, nmax;
	int idxplus[LinkPerNodeplus], idxplusflag[LinkPerNodeplus];
	double nrm[2], drlab[2], prod;
	double rtmp, rmin[LinkPerNodeplus], dotpd;
	double r1[2], r2[2], n1[2], n2[2];
	graph_node *p;

	for(i=0; i<LinkPerNodeplus; i++) {
		rmin[i]=inf;
		idxplus[i]=idxplusflag[i]=0;
	}
	nrm[0]=rloc[0]/Ra2;
	nrm[1]=rloc[1]/Rb2;
	Loc2Lab(nrm, nrm);	// surface outward-normal direction in lab frame
	
	cnt=0;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		
		rtmp=distance(r, p->R0);
		vecsub(p->R0, r, drlab);
		prod=dotprod(nrm, drlab);	// if new node is above horizon, then prod>=0, otherwise<0
		
		if(rtmp>0.05 && rtmp<Rafix && prod>=0.0 && rtmp<rmin[LinkPerNodeplusm1]) {
			j=LinkPerNodeplusm1;
			while(rtmp<rmin[j] && j>0) j--;
			if(j>0 && rtmp>rmin[j]) j++;
			for(k=LinkPerNodeplusm1; k>j; k--) {	// move the rest
				rmin[k]=rmin[k-1];
				idxplus[k]=idxplus[k-1];
			}
			rmin[j]=rtmp;
			idxplus[j] = p->id;
			cnt++;
		}	// end of if
	}	// end of i
	
	for(i=0; i<LinkPerNode; i++) idx[i]=idxplus[i];	// temporarily accept it

	if(cnt<LinkPerNode) {	// not enough nodes selected
		*nx=cnt;
		return;
	}
	
	nmax=min2(cnt, LinkPerNodeplus);	// cnt may < or > LinkPerNodeplus
	*nx=k=1;	// fix idx[0]=idxplus[0]
	idxplusflag[0]=1;
	for(i=0; i<LinkPerNodem1; i++) {	// among LinkPerNodeplus, pick out LinkPerNode nodes
		vecsub(r, graph[idxplus[i]]->R0, r1);
		normalize(r1, n1);
		j=i;
		do {
			j++;
			vecsub(r, graph[idxplus[j]]->R0, r2);
			normalize(r2,n2);
			dotpd=fabs(dotprod(n1,n2));
		} while(dotpd>0.9 && idxplusflag[j]==1 && j<nmax);	// shouldn't be too close
		
		if(j<nmax && k<LinkPerNode) {
			idx[k]=idxplus[j];
			idxplusflag[j]=1;	// this node is now taken
			k++;
			(*nx)++;
		}
	}
}


void appendNode(graph_node *p, int id)	// append node id to thread p
{
	graph_node *q, *r;
	
	if(!p) printf("error\n");
	q = p;
	while(q->next) q = q->next;	// q is the end of p
	
	r = (graph_node *)malloc(sizeof(graph_node));
	q->next = r;
	
	CopyGraphNode(graph[id], r);
	r->l0 = distance(p->R0, r->R0);
	r->dl = 0.0;
	r->next = NULL;
}


void GetNewNodeProp(graph_node *p)	// get new node's properties, input is p->R0
{
#if TSTGEL
	getLocalPropsTest(p,1);	// from R0, get r0, r1, nrm, R1 & Rtip
#else
	getLocalProps(p,1);	// from R0, get r0, r1, nrm, R1 & Rtip
#endif
	veccopy(p->R1, p->Rtip);
	
	p->contact = 1;
	p->deformable = 1;
	p->len = p->len0 = distance(p->r0, p->r1);	// initial filament length
	p->dlen = 0.0;
	
	if(ran2(&mseed)<probnewatt) p->attached = 1;
	else p->attached = 0;

	p->l0 = 0.0;	// itself
	p->dl = 0.0;
	
	veczero(p->dlvec);
	veczero(p->DLvec);

#if LMT_NF
	if(Nfila>=Nfilamax) p->capped = 1;	// if limit max fila number
	else p->capped = 0;
#else
	p->capped = 0;
#endif
	
	p->sumka = 0.1*(1-2*ran2(&mseed));	// stochastic
	p->sumkc = 0.1*(1-2*ran2(&mseed));
	p->sumkd = 0.1*(1-2*ran2(&mseed));
	
	p->next = NULL;
	
#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) p->bnd = 1;
		else if(p->R0[1]<-botlayerheight) p->bnd=-1;
		else p->bnd = 0;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) p->bnd=1;
		else if(p->R0[1]<-botlayerheight) p->bnd=-1;
		else p->bnd=0;
	#endif
#endif
	
}


//--- nucleation ---

void NodeCreationNuc(void)	// create 1 node and connect to other nodes, append to graph
{
	int i, nm, nx;
	int idx[LinkPerNode];
	double R0[2];
	graph_node *p;

	if(Nnodes>Nnodes_max) { printf("Too many nodes.\n"); exit(0); }

	GetNewNodePos(R0);	// new node's id=nm, append to the list
	GetNeighborPos(R0, idx, &nx);	// nx neighbors
	
	nm=Nnodes;
	Nnodes++;
	Ncontact++;
	
	insertEdge(graph+nm, nm);	// add nm to the head of graph[nm], self as 1st column'
	p=graph[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(R0, p->R0);
	GetNewNodeProp(p);	// input p->R0, get other initial properties
	
#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#endif
#endif
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);

	for(i=0; i<nx; i++) {	// for each neighbor
		appendNode(graph[nm], idx[i]);	// append idx[i] to thread graph[nm]
		appendNode(graph[idx[i]], nm);	// append nm to thread graph[idx[i]]
		(graph[idx[i]]->nnbr)++;	// update neighbor counter
	}
}


//--- biased nucleation ---

void NodeCreationNucBack(void)	// create 1 node at rear and connect to other nodes, append to graph
{
	int i, nm, nx;
	int idx[LinkPerNode];
	double R0[2];
	graph_node *p;

	if(Nnodes>Nnodes_max) { printf("Too many nodes.\n"); exit(0); }

	GetNewNodePosBack(R0);	// new node's id=nm, append to the list
	GetNeighborPos(R0, idx, &nx);	// nx neighbors
	
	nm=Nnodes;
	Nnodes++;
	Ncontact++;
	
	insertEdge(graph+nm, nm);	// add nm to the head of graph[nm], self as 1st column'
	p=graph[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(R0, p->R0);
	GetNewNodeProp(p);	// input p->R0, get other initial properties
	
#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#endif
#endif
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);

	for(i=0; i<nx; i++) {	// for each neighbor
		appendNode(graph[nm], idx[i]);	// append idx[i] to thread graph[nm]
		appendNode(graph[idx[i]], nm);	// append nm to thread graph[idx[i]]
		(graph[idx[i]]->nnbr)++;	// update neighbor counter
	}
}

//--- autocatalytic ---

void CreateNewNodeInZone(int z)	// create new node near between zones z & z+1
{
	int i, nm, nx;
	int idx[LinkPerNode];
	double a1, a2, a, r, sa, ca;
	double rloc[2], rlab[2];
	graph_node *p;
	
	if(Ra==Rb) {	// circle
		a=(z+ran2(&mseed))*dzone;	// random between z and z+1
		sa=sin(a);
		ca=cos(a);
		rloc[0]=Ra*sa;
		rloc[1]=Ra*ca;
	}
	else {	// 2D ellipse
		if(z==0) {	// a=+0
			a1=0.0;
			a2=zoneAng[1];
		}
		else if(z==BeadZonesm1) {	// a=-0
			a1=Pidb+zoneAng[z];
			a2=0.0;
		}
		else {
			a1=zoneAng[z];
			a2=zoneAng[z+1];
			if(a1<0) a1+=Pidb;
			if(a2<0) a2+=Pidb;	// convert to 0--2Pi
		}
		a=a1+ran2(&mseed)*(a2-a1);	//  a(z) < a < a(z+1)
		sa=sin(a);
		ca=cos(a);
	
		r=1.0/sqrt(sa*sa/Ra2+ca*ca/Rb2);
		rloc[0]=r*sa;
		rloc[1]=r*ca;
	}
	
	Loc2Lab(rloc, rlab);	// first rotate
	vecadd(rlab, Rcenter, rlab);	// then translate
	
#if INBEAD
	GetNeighborPos(rlab, idx, &nx);	// nx neighbors
#else
	GetNeighborPos(rlab, idx, &nx);	// nx neighbors
#endif
	
	nm=Nnodes;
	Nnodes++;
	Ncontact++;
	
	insertEdge(graph+nm, nm);	// add nm to the head of graph[nm], self as 1st column'
	p=graph[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(rlab, p->R0);
	GetNewNodeProp(p);	// input p->R0, get other initial properties
	
#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#endif
#endif
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);

	for(i=0; i<nx; i++) {	// for each neighbor
		appendNode(graph[nm], idx[i]);	// append idx[i] to thread graph[nm]
		appendNode(graph[idx[i]], nm);	// append nm to thread graph[idx[i]]
		(graph[idx[i]]->nnbr)++;	// update neighbor counter
	}
}


void CreateNewNodeAtAngle(double a)	// create new node at angle a
{
	int i, nm, nx;
	int idx[LinkPerNode];
	double r, sa, ca;
	double rloc[2], rlab[2];
	graph_node *p;
	
	sa=sin(a);
	ca=cos(a);
	if(Ra==Rb) {	// circle
		rloc[0]=Ra*sa;
		rloc[1]=Ra*ca;
	}
	else {	// 2D ellipse
		r=1.0/sqrt(sa*sa/Ra2+ca*ca/Rb2);
		rloc[0]=r*sa;
		rloc[1]=r*ca;
	}
	
	Loc2Lab(rloc, rlab);	// first rotate
	vecadd(rlab, Rcenter, rlab);	// then translate
	
#if INBEAD
	GetNeighborPos(rlab, idx, &nx);	// nx neighbors
#else
	GetNeighborPos(rlab, idx, &nx);	// nx neighbors
#endif
	
	nm=Nnodes;
	Nnodes++;
	Ncontact++;
	
	insertEdge(graph+nm, nm);	// add nm to the head of graph[nm], self as 1st column'
	p=graph[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(rlab, p->R0);
	GetNewNodeProp(p);	// input p->R0, get other initial properties
	
#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) ntop++;
		else if(p->R0[1]<-botlayerheight) nbot++;
	#endif
#endif
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);

	for(i=0; i<nx; i++) {	// for each neighbor
		appendNode(graph[nm], idx[i]);	// append idx[i] to thread graph[nm]
		appendNode(graph[idx[i]], nm);	// append nm to thread graph[idx[i]]
		(graph[idx[i]]->nnbr)++;	// update neighbor counter
	}
}

int findZone(double r[2])	// input location in bead frame, return zone of that location
{
	int z;
	double a;
	
	Crt2LabPol(r, &a);	// -pi<a<=pi, note that p->r1 may not be updated yet, in bead frame
	if(a>=0.0) {
		z=0;
		while(zoneAng[z]<=a && z<BeadZoneshalf) z++;
		if(z>0) z--;
	}
	else {
		if(a>=zoneAng[BeadZonesm1]) z=BeadZonesm1;
		else if(a<=zoneAng[BeadZoneshalfp1]) z=BeadZoneshalf;
		else {
			z=BeadZoneshalfp1;
			while(zoneAng[z]<=a && z<BeadZonesm1) z++;
			if(z>BeadZoneshalfp1) z--;
		}
	}
	if(z>BeadZonesm1) z=BeadZonesm1;	// j is always the left boundary
	return z;
}


double widena(double a)	// spread the angle, for Ra=Rb
{
	double da, ax;
	
	da=(1-2*ran2(&mseed))*Angspread;
	ax=a+da;
	return ax;
}


int widenz(int z)	// spread the zone, for Ra!=Rb
{
	int dz, zz;
	
	dz=(int)((1-2*ran2(&mseed))*Nspreadhalf);
	zz=z+dz;
	
	if(zz<0) zz+=BeadZones;
	else if(zz>=BeadZones) zz-=BeadZones;
	return zz;
}


double widenaz(double a, int z)	// interpolate zones to get new angle, z is the left boundary
{
	int dnz, z2;
	double dl, dz1, dz2, da1, da2;
	double ax;
	
	if(Ra==Rb) return widena(a);
	
	dl=randsign()*SpreadDist;	// actual displacement along bead surface
	dnz=(int)(dl);
	z2=z+dnz;	// new zone
	if(z2<0) z2+=BeadZones;
	else if(z2>=BeadZones) z2-=BeadZones;
	
	da1=zoneAngDiff[z];	// da1=a[z+1]-a[z]>0
	
	if(z==BeadZoneshalf) {	// dz1>=0
		if(z!=Pi) dz1=(a+zoneAng[z])/da1;
		else dz1=0.0;
	}
	else dz1=(a-zoneAng[z])/da1;
	dz2=(dnz+dz1)*zonedL+dl;

	da2=zoneAngDiff[z2];
	ax=zoneAng[z2]+(dz2/zonedL)*da2;
	
	return ax;
}



void NodeCreationAut1(int n, int backonly)	// create n nodes according to autocatalytic rules
{
	int i, j, z, ntot, np[BeadZones];
	double thv, thvb, nv[2];
	graph_node *p;
	
	if(Nnodes>Nnodes_max) { printf("Too many nodes.\n"); exit(0); }
	
	
	if(backonly) {
		Crt2LabPol(Vcenter, &thv);	// CRT to lab polar, -pi<a<=Pi, angle of bead velocity
		thvb=thv-thb;	// angle of bead velocity with respect to y-axis in bead's frame
		nv[0]=sin(thvb);	// unit vector along velocity in bead frame
		nv[1]=cos(thvb);
	}
	
	ntot=0;
	for(i=0; i<BeadZones; i++) np[i]=0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(NodeInBranchRegion(p->r0) && p->capped==0) {	// tip is within branching region, not base (p->r0)
			j=findZone(p->r0);
			if(backonly) {	// back only
				if(dotprod(nv, zonenrm[j])<=0.0) {	// only count those at the rear
					np[j]++;
					ntot++;
				}
			}
			else {	// uniform
				np[j]++;
				ntot++;
			}
		}	// end of if
	}	// end of i
	
	for(i=1; i<BeadZones; i++) np[i]+=np[i-1];	// convert to cumulative sum
	
	for(i=0; i<n; i++) {	// based on density, find a random zone to create new node
		j=(int)(ntot*ran2(&mseed));
		z=0;
		while(np[z]==0) z++;
		while(np[z]<j && z<BeadZonesm1) z++;
		
		if(z>=BeadZones) z=BeadZonesm1;
		z=widenz(z);
		CreateNewNodeInZone(z);
	}
}




void NodeCreationAut(int n, int backonly)	// create n nodes according to autocatalytic rules
{
	int i, id, z, ntot;
	double a, thv, thvb, nv[2], *ap, r1[2], nr[2];
	graph_node *p;
	
	if(Nnodes>Nnodes_max) { printf("Too many nodes.\n"); exit(0); }
	if(Nnodes==0) return;
	
	if(backonly) {
		Crt2LabPol(Vcenter, &thv);	// CRT to lab polar, -pi<a<=Pi, angle of bead velocity
		thvb=thv-thb;	// angle of bead velocity with respect to y-axis in bead's frame
		nv[0]=sin(thvb);	// unit vector along velocity in bead frame
		nv[1]=cos(thvb);
	}
	
	ap=malloc(Nnodes*sizeof(double));
	ntot=0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(NodeInBranchRegion(p->r0) && p->capped==0) {	// base is within branching region, not tip (p->r1)
			ProjectBeadNormal(p->r0, r1, nr);	// get local outward normal nr
			if(backonly) {	// back only
				if(dotprod(nv, nr)<=0.0) {	// only count those at the rear
					Crt2LabPol(p->r0, &ap[ntot]);
					ntot++;
				}
			}
			else {
				Crt2LabPol(p->r0, &ap[ntot]);
				ntot++;
			}
		}	// end of if
	}	// end of i
	
	
	for(i=0; i<n; i++) {	// based on density, find a random node to create new node
		id=(int)(ntot*ran2(&mseed));	// randomly choose a node
		a=ap[id];	// angle of the chosen one
		z=findZone(graph[id]->r0);	// zone of the chosen one
		a=widenaz(a,z);	// don't widen bins, widen actual angles!!!
		CreateNewNodeAtAngle(a);
	}
	free(ap);
}



void NodeDeletion(int id)
{
	int nm;
	graph_node *p, *q, *r;
	
	if(Nnodes<1) return;
	
	nm=Nnodes-1;
	Nnodes--;
	
	while(graph[id]) {
		p=graph[id];
		graph[id] = p->next;
		if(p->id != id) {
			q=graph[p->id];
			r = q->next;
			while(r) {
				if(r->id == id) {
					q->next = r->next;
					free(r);
					r = q->next;
					(graph[p->id]->nnbr)--;
				}
				else {
					q = r;
					r = r->next;
				}
			}
		}
		free(p);
	}	// now graph[id]=NULL

	if(id!=nm) {
		graph[id]=(graph_node *)malloc(sizeof(graph_node));
		CopyGraphNode(graph[nm],graph[id]);
		free(graph[nm]);	// only remove the head node of last thread
	
		// update id
		p=graph[id];	// previous node-nm
		while(p) {
			if(p->id == nm) p->id = id;
			else {
				q = graph[p->id]->next;
				while(q) {
					if(q->id == nm) q->id = id;
					q = q->next;
				}
			}
			p = p->next;
		}
	}
}


void NodeDeletionRnd(void)	// remove 1 rnd. thread from the graph
{
	int id, cnt;
	
	if(Nnodes<1) return;
	
	cnt=0;
	id=(int)(ran2(&mseed)*Nnodes);
	
	while(graph[id]->contact==1 && cnt<Nnodes) {	// remove a node not in contact with bead
		id++;
		if(id>=Nnodes) id=0;
		cnt++;
	}
	if(cnt==Nnodes) return;	// no nodes are ready for deletion
	
	NodeDeletion(id);
}


void NodeDeletionRnd1(void)	// remove 1 rnd. thread from the graph
{
	int id;
	
	if(Nnodes<1) return;
	id=(int)(ran2(&mseed)*Nnodes);
	NodeDeletion(id);
}


void NodeDeletionOrphan(void)	// remove orphan nodes
{
	int i, id, flg, go;
	graph_node *p;
	
	flg=1;
	while(flg) {
		go=1;
		i=Nnodes-1;
		while(i>=0 && go) {
			p=graph[i];
			if(p->nnbr <1) {id=i; go=0;}
			i--;
		}
		if(go==0) {NodeDeletion(id); flg=1;}	// now Nnodes changes
		else flg=0;
	}
}



void DeleteDistalNodes(void)
{
	int i;
	
	for(i=0; i<Nnodes; i++) {
		if(norm(graph[i]->r0)>7.0) NodeDeletion(i);
	}
}


void LinkRupture(void)
{
	int i;
	graph_node *p, *q, *r, *s;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q = p->next;
		while(q) {
			if(fabs(q->dl) > dlbr) {
				r=graph[q->id];
				s = r->next;
				while(s) {
					if(s->id == i) {
						r->next = s->next;
						free(s);
						s = r->next;
						(graph[q->id]->nnbr)--;
					}
					else {
						r = s;
						s = s->next;
					}
				}
				
				p->next = q->next;
				free(q);
				q = p->next;
				(graph[i]->nnbr)--;
			}
			else {
				p = q;
				q = q->next;
			}
		}
	}
}


void NodesDynamics(void)
{
	int i, n;
	
#if AUTNUC	// auto, or auto+nuc
  #if VBRUSH	// with brushing effect
	probautbase+=kautbasedt;
	probautback+=kautbackdt;
	if(probautbase>1.0) {
		n=(int)(probautbase);
		NodeCreationAut(n,0);	// uniform
		probautbase-=n;
	}
	if(probautback>1.0) {
		n=(int)(probautback);
		NodeCreationAut(n,1);	// back only
		probautback-=n;
	}
  #else
	probaut+=kautdt;
	if(probaut>1.0) {	// auto
		n=(int)(probaut);
		NodeCreationAut(n,0);
		probaut-=n;
	}
  #endif
	
	if(AUTNUC==2) {	// both auto and nuc
	#if VBRUSH	// with brushing effect
		probnucbase+=knucbasedt;
		probnucback+=knucbackdt;
		if(probnucbase>1.0) {
			n=(int)(probnucbase);
			for(i=0; i<n; i++) NodeCreationNuc();
			probnucbase-=n;
		}
		if(probnucback>1.0) {
			n=(int)(probnucback);
			for(i=0; i<n; i++) NodeCreationNucBack();
			probnucback-=n;
		}
	#else
		probnuc+=knucdt;
		if(probnuc>1.0) {
			n=(int)(probnuc);
			for(i=0; i<n; i++) NodeCreationNuc();
			probnuc-=n;
		}
	#endif
	}
#else	// nucleation only
	#if VBRUSH	// with brushing effect
		probnucbase+=knucbasedt;
		probnucback+=knucbackdt;
		if(probnucbase>1.0) {
			n=(int)(probnucbase);
			for(i=0; i<n; i++) NodeCreationNuc();
			probnucbase-=n;
		}
		if(probnucback>1.0) {
			n=(int)(probnucback);
			for(i=0; i<n; i++) NodeCreationNucBack();
			probnucback-=n;
		}
	#else
		probnuc+=knucdt;
		if(probnuc>1.0) {
			n=(int)(probnuc);
			for(i=0; i<n; i++) NodeCreationNuc();
			probnuc-=n;
		}
	#endif
#endif

	probdis+=kdisdt*Nnodes;
	if(probdis>1.0) {
		n=(int)(probdis);
		for(i=0; i<n; i++) NodeDeletionRnd();
		probdis-=n;
	}
	
#if LNKBRK
	LinkRupture();
#endif

	NodeDeletionOrphan();
	DeleteDistalNodes();
}


void NodesStats(void)
{
	int i;
	graph_node *q;

	Nlinks=0;
	linklenave=0.0;
	for(i=0; i<Nnodes; i++) {
		Nlinks += graph[i]->nnbr;
		q=graph[i]->next;
		while(q) {
			linklenave += q->l0;
			q = q->next;
		}
	}
	Nlinks/=2;
	linklenave/=max2(2*Nlinks,1);
	Nlinkpernode=(float) (1.0*Nlinks/max2(Nnodes,1));
}
