/*
scaling: 
in exp, N=1000A=4e5; in simu, N=40. Therefore scaling is 1e-4
in exp, Fstall=300 nN, then in simu Fstall should be scaled to 30 pN=N*f0, so f0=1 pN
in exp, klever=30 pN/nm; in simu, it should scale as 30/10^4 pN/nm=3 pN/um
*/

#define Rafix 1.0	// minor axis
#define Rbfix (1.0*Rafix)	// major axis

#define kautnuc 2.0	// total creation rates scaled per micron

#define kc (kc_ka*ka)
#define kd (kd_ka*ka)	// filament detachment rate /s
#define kdis 8.0e-3	// network disasembling rate /s

#define V0 0.05	// free filament growth velocity in micron/s
#define Vbrush (0.1*V0)	// threshold velocity above which brushing will take effect

#define vfpower 2.0	// v-f power factor: v/v0=1-(f/fbuckle)^vfpower, >1 concave down, <1 concave up
#define f0_scale 1.5	// force scale in pN, for calc fila growth v
#define f0_stall 3.0	// stall force for power-law v-f relation
#define fbuckle 100.0	// buckling force in pN
#define fdetach 1.5	// filament's characteristic detachment force in pN

#define ksfila (1.0*ksnode)	// filament's spring constant in pN/micron
#define ks_std 10.0	// spring constant pN/um of a 0.1 um spring (ksnode invers prop to spring length)

#define DeformLayer InteractLayer	// outside which nodes are pinned to substrate and longer deform

#define Floadini 10.0	// in pN
#define ks_lever 10.0	// sprint constant of cantilever, in pN/micron
#define h_gel 0.02	// gel thickness in um, for calc. Young's modulus

#define LinkPerNode 4	// links per new node, integer
#define LinkPerNodem1 (LinkPerNode-1)
#define LinkPerNodedb (2*LinkPerNode)
#define LinkPerNodeplus (LinkPerNode+10)
#define LinkPerNodeplusm1 (LinkPerNodeplus-1)
#define GelBeadRelax 5	// relaxation iteration

#define BeadZones 2400	// divide bead surface into this many zones, be a multiple of 4
#define SpreadRate (SpreadRateFct*V0)	// max filament-spread speed along bead surface in microns/sec

#define eta 1.0e-2	// actual viscosity: eta=10*eta_water=0.01 Pa*s=0.01 pN*s/um^2
#define dlt 2.7e-3	// monomer half size
#define filalenave 0.2	// average filament length, to calculate mjunode

#define Nnodes_ini 200	// initial nodes
#define Nnodes_max 5000	// max nodes
#define SurfBins 32	// surface bins to stat on F & N distribution, be a multiple of 4

#define NtwkRadius 1.0	// micron
#define forcepernode 1.0	// temprary force in pN
#define initRegion (1.5*NtwkRadius)	// initial gel region
#define CutTolerence 0.8	// for avoiding bead

#define dl0_scale (f0_scale/ksfila)	// dl0_scale=f0/ks_filament
#define dl0_stall (f0_stall/ksfila)
#define dl_buckle (fbuckle/ksfila)
#define dl_detach (fdetach/ksfila)

#define Pi 3.14159265
#define Pihalf (Pi/2.0)
#define Pidb (2.0*Pi)
#define r2d (180.0/Pi)
#define d2r (Pi/180.0)
#define eps 1.0e-10
#define inf 1.0e10

//--- Data Sampling ---
#define Tmax 1.0e4	// total simulation time in seconds
#define dspl_smp_dt 5.0	// this calculates v
#define dspl_n_ave 10	// display v is averaged over this many samples

#define smp_dt 10.0	// sampling time interval for saving tracks
#define smp_buffer 10

//--- stat ---
#define icutoff 3	// cutoff factor for Gaussian smoothing range
#define smoothwindow 0.5	// smoothing window size in microns
#define CurvatureWidthHalf 2.0	// half-width for curvature-fitting in microns
#define Ncorr 30	// number of autocorrelation points
#define Tcorrmax 300.0	// max correlation time interval

// gel relax solver
#define Matrix_ITOL 1
#define Matrix_TOL 1.0e-9
#define Matrix_ITMAX 75

//--- Gel Test ---
#define t_tst_save 2.0	// save test results every this time
#define TestDirectionIni 1
#define GelWidthIni (NtwkRadius)
#define GelHeightIni (1.0*NtwkRadius)
#define toplayerheight (0.88*GelHeightIni)	// for testing gel
#define toplayerthick (GelHeightIni-toplayerheight)
#define botlayerheight (0.88*GelHeightIni)
#define N_tst_buffer 10

//--- GL ---
#if SAVPIC
#define Width 480
#define Height 480
#else
#define Width 800
#define Height 800
#endif
#define HWratio (1.0*Height/Width)
#define CanvasFactor 5.5	// ratio of window size to bead size

#define ParticleRadius 0.5	// display partical size
#define TextureWidth 128
#define TextureHalfWidth (TextureWidth/2)
#define TextureDecayWidth (TextureHalfWidth/4)
#define TextureDecayWidth2 (TextureDecayWidth*TextureDecayWidth)
#define TextureDecayWidth2db (2.0*TextureDecayWidth2)
#define LinkDecorSpacing (0.2*ParticleRadius)

