

void getvertexr(int i, int j, double r1[2], double r2[2])	// return vertices with id=i&j
{
	int flg=0;
	tVertex p;
	
	p=vertices;
	while(flg<2 && p) {
		if(i==p->vnum) { veccopy(p->v,r1); flg++; }
		if(j==p->vnum) { veccopy(p->v,r2); flg++; }
		p=p->next;
	}
}


int swapcomp(int p[2], int i, int j)
{
	if(p[0]==i && p[1]==j) return 1;
	if(p[0]==j && p[1]==i) return 1;
	return 0;
}


void addpair2list(int i, int j)	// add (i, j) to pair list. i&j are the id's of nodes
{
	graph_edge *p, *q;

	if(!myedge) {
		myedge=(graph_edge *)malloc(sizeof(graph_edge));
		myedge->pair[0]=i;
		myedge->pair[1]=j;
		myedge->next = NULL;
		graph_nedge++;
		return;
	}
	
	p=q=myedge;
	while(p && !swapcomp(p->pair, i, j)) {q=p; p=p->next;}
	if(!p) {
		p=(graph_edge *)malloc(sizeof(graph_edge));	// new pair
		p->pair[0]=i;
		p->pair[1]=j;
		p->next = NULL;	// add to the tail
		q->next = p;
		graph_nedge++;
	}
}


void addface2list(tFace p)	// get pairs from each face
{
	int i, j, id[3];
	double v[3][2];
	
	for(i=0; i<3; i++) {	// three vertices
		id[i] = p->vertex[i]->vnum;
		veccopy(p->vertex[i]->v, v[i]);
	#if TSTGEL
		vecsub(v[i],Rcenter,v[i]);
	#endif
	}
	
	for(i=0; i<3; i++) {
		j=(i+1)%3;
	#if INBEAD
		if(!CutOffBead(v[i],v[j])) {	// extra requirements
			addpair2list(id[i],id[j]);
		}
	#else
		if(distance(v[i],v[j])<0.5*NtwkRadius) addpair2list(id[i],id[j]);
	#endif
	}
}


void getedgelist(void)	// get pairs from all faces
{
	tFace p;
	p=faces;
	if(p) do {
		if(p->lower) addface2list(p);
		p = p->next;
	} while(p!=faces);
}



void getpair_i(int i, int pair[2])	// return the i-th pair
{
	int j=0;
	graph_edge *p;

	p=myedge;
	while(j++<i) p=p->next;
	pair[0] = p->pair[0];
	pair[1] = p->pair[1];
}


void insertEdge( graph_node **ptr, int id )	// insert a new graph_node at the start.
{
	graph_node *newnode = (graph_node *)malloc(sizeof(graph_node));
	newnode->id = id;
	newnode->next = *ptr;
	*ptr = newnode;
}


void GetGraph(void)	// fills graph as adjacency list from array edges.
{
	int i;
	int pair[2];
	for( i=0; i<graph_nedge; ++i ) {
		getpair_i(i, pair);
		insertEdge(graph+pair[0], pair[1]);
		insertEdge(graph+pair[1], pair[0]); // undirected graph.
	}
	for(i=0; i<Nnodes; i++) insertEdge(graph+i, i);
	for(i=Nnodes; i<Nnodes_max; i++) graph[i]=NULL;
}


void GetGraphProp(void)	// initial setup: read node's r0 from vertices
{
	int i, id, cnt, capcnt;
	tVertex v;
	graph_node *p, *q;
	
	ntop=nbot=0;
	
	for(i=0; i<Nnodes; i++) {	// for each graph node, find node coordinates
		p=graph[i];
		
		while(p) {
			id = p->id;
			v=vertices;
			while(v && v->vnum != id) v = v->next;
			if(v) veccopy(v->v, p->r0);
			else { printf("error in graph-prop.\n"); exit(0); }
				
		#if TSTGEL	// testing gel with plate or non-rotating bead
			veccopy(p->r0, p->R0);
			getLocalPropsTest(p,1);	// from R0, get r0, r1, nrm & R1; 1 for new filas
		#else
			Loc2Lab(p->r0, p->R0);	// first rotate
			vecadd(p->R0, Rcenter, p->R0);	// then translate
			getLocalProps(p,1);	// from R0, get r0, r1, nrm & R1; 1 for new filas
		#endif
		
			veccopy(p->R1, p->Rtip);
			veczero(p->ftip);
			veczero(p->Ftip);
			
	#if TSTGEL
		#if INBEAD
			if(NodeInContactRegion(p->r0)) {	// p->r0 in bead frame
				p->contact = p->bnd = 1;
				ntop++;
			}
			else if(p->R0[1]<botlayercontact) {
				p->bnd=-1;
				nbot++;
			}
			else p->contact = p->bnd = 0;
		#else
			if(p->R0[1]>toplayerheight) {
				p->bnd = p->contact = 1;
				ntop++;
			}
			else {
				p->contact = 0;
				if(p->R0[1]>botlayercontact) p->bnd=0;
				else {
					p->bnd=-1;
					nbot++;
				}
			}
		#endif
	#else
		if(NodeInContactRegion(p->r0)) p->contact = 1;
		else p->contact = 0;
	#endif
			p = p->next;
		}
	}
	
	capcnt=0;
	for(i=0; i<Nnodes; i++) {	// for each graph node, find initial rest length
		p = graph[i];
		q = p->next;
	#if NEWATT
		p->len = p->len0 = distance(p->r0, p->r1);	// initial filament length
	#else
		p->len = 0.0;
		p->len0 = distance(p->r0, p->r1);
	#endif
		p->l0 = 0.0;	// itself
		p->dl = p->dlen = 0.0;
		
		veczero(p->dlvec);
		veczero(p->DLvec);
		
	#if NEWATT
		if(ran2(&mseed)<probnewatt && p->contact) p->attached = 1;
		else p->attached = 0;
	#else
		p->attached = 0;
	#endif
	
		if(p->contact == 0) p->capped = 1;
		else {
		#if LMT_NF	// if limit max fila number
			if(++capcnt<Nfilamax) p->capped = 0;
			else p->capped = 1;
		#else
			p->capped = 0;
		#endif
		}
		
		p->sumka = 1-2*ran2(&mseed);	// random initial probability, to prevent convertion at the same time
		p->sumkc = 1-2*ran2(&mseed);
		p->sumkd = 1-2*ran2(&mseed);
		
		cnt=0;	// neighbor counter
		while(q) {
			q->l0 = distance(p->R0, q->R0);	// distance of graph[i][0] to graph[i][j]
			q->dl = 0.0;
			cnt++;
			q = q->next;
		}
		p->nnbr = cnt;
	}
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);
	
#if TSTGEL
	ntoplinks=LinkPerNode*ntop;
	if(ntop*nbot==0) { printf("Error: no top/bottom nodes.\n"); exit(0); }
#endif
}


void BuildGraph(void)
{
	graph = (graph_node **)calloc(Nnodes_max, sizeof(graph_node *));
	getedgelist();
	GetGraph();
	GetGraphProp();
}


void CleanGraph(void)
{
	int i;
	graph_edge *p;
	graph_node *q;
	
	while(myedge) {
		p=myedge;
		myedge = p->next;
		free(p);
	}
	myedge=NULL;

	if(graph) {
		for(i=Nnodes-1; i>=0; i--) {
			while(graph[i]) {
				q=graph[i];
				graph[i] = q->next;
				free(q);
			}
			free(graph[i]);
		}
		free(graph);
	}
	graph=NULL;
}


void CleanUp(void)
{
	CleanTriangles();
	CleanGraph();
#if VCDBUG
	_CrtDumpMemoryLeaks();
#endif
}
