
/*-------------------
Elastic Network By Using Delaunay Triangulation
Units: micron, s, pN
-------------------*/

#define OPENGL 0	// with graphics or not 
#define SAVPIC 0	// save frames
#define TSTGEL 1	// testing gel: 0= no test, 1= test tensile stress, 2= test shear stress

#define INBEAD 0	// with bead inside or not
#define CONSTF 0	// constant external force or variable, if TSTGEL
#define CFTEST 0	// do constant force v(t) test or not, make sure matches with CONSTF=1
#define HISTRY 0	// do loading history test or not

#define EXPPWR 1	// 1 for exponential decay, 0 for power law
#define VAR_KS 0	// variable spring constant

#define AUTNUC 0	// autocatalytic or nucleation
#define NODDYN 1	// node dynamics or not
#define FILGRW 1	// filaments grow or not
#define LMT_NF 1	// limit filament number or not

#define NEWATT 1	// new filaments are attached or free
#define LPD_CT 0	// lipid coated or not
#define CIRBND 0	// circular boundary or rectangular boundary

#define GELMOV 1	// move gel or not ???
#define LNKBRK 0	// link break or not

#define TEXMAP 0	// initially with texture mapping or not
#define SHWFIL 1	// initially show filament or not
#define SHWPFN 1	// show P(f), P(n) distribution or not
#define LNKCLR 1	// initially show link color or not

#define LNKSRC 2	// link source from 0: triangulation vertex, 1: graph's edges, 2: graph nodes
#define AALIAS 1	// anti-alias
#define VCDBUG 0	// debugging mode

#include "include.h"


void getmseed(void)
{
#if OPENGL && SAVPIC
	mseed=-11;
#else
	struct tm *newtime;
	time_t long_time;

	time(&long_time);	// RNG seed
	newtime=localtime(&long_time);
	mseed=-(int) fabs((newtime->tm_hour+1)*(2*newtime->tm_min+3)*(111*newtime->tm_sec+5)+
		191*(newtime->tm_min)+901*(newtime->tm_sec)-1);
#endif
}


void getconst(void)
{
	dt=0.1;
	v0dt=V0*dt;
	v0dtdb=2*v0dt;
	v0dt_relax=v0dt/GelBeadRelax;
	Nnodes_ini=(int)(knden/(0.5*V0)*(4*GelWidthIni*GelHeightIni));
	Nnodes_ini=max2(Nnodes_ini, 50);
	printf("N_ini=%d\n", Nnodes_ini);

	kadt=ka*dt;
	kcdt=kc*dt;
	kddt=kd*dt;

#if INBEAD
	BeadCircumference=Pi*(3*(Rafix+Rbfix)-sqrt((3*Rafix+Rbfix)*(Rafix+3*Rbfix)));
	knuc=kaut=knden*BeadCircumference/2.0;
#else
	knuc=kaut=knden*2*(GelWidthIni);
#endif

	kautdt=kaut*dt;
	knucdt=knuc*dt;
	kdisdt=kdis*dt;

	probnewdet=kd/(ka+kd);	// probability of creating free
	probnewatt=ka/(ka+kd);	// probability of creating att

	Ra=Rafix;
	Rb=Rbfix;
	Ra2=Ra*Ra;
	Rb2=Rb*Rb;
	Ra4=Ra2*Ra2;
	Rb4=Rb2*Rb2;
	RaRb=Ra*Rb;
	Ra2Rb2=Ra2*Rb2;
	Ra4Rb2=Ra2*Ra2Rb2;
	Ra2Rb4=Rb2*Ra2Rb2;
	Ra2_Rb2=Ra2/Rb2;
	Ra2mRb2=Ra2-Rb2;
	Rb2mRa2=Rb2-Ra2;

	Rmin=min2(Ra,Rb);
	Rmax=max2(Ra,Rb);
	Rave=(Ra+Rb)/2.0;
	Rave2=Rave*Rave;
	Rc=sqrt(Rmax*Rmax-Rmin*Rmin);	// focal length
	if(Rb>Ra) {
		Focus1[0]=Focus2[0]=0.0;
		Focus1[1]=Rc;
		Focus2[1]=-Rc;
	}
	else {
		Focus1[1]=Focus2[1]=0.0;
		Focus1[0]=-Rc;
		Focus2[0]=Rc;
	}
	
	ecc=sqrt(1.0-pow(Rmin/Rmax,2));	// eccentricity
	Circum=Pi*(3*(Ra+Rb)-sqrt((3*Ra+Rb)*(Ra+3*Rb)));	// circumference
	Circumhalf=Circum/2.0;
	Circumquad=Circum/4.0;
	zonedL=Circum/BeadZones;
	BeadZonesm1=BeadZones-1;
	BeadZoneshalf=BeadZones/2;
	BeadZonesquad=BeadZones/4;
	BeadZoneshalfp1=BeadZoneshalf+1;

	surfbindL=Circum/SurfBins;
	SurfBinsm1=SurfBins-1;
	SurfBinshalf=SurfBins/2;
	SurfBinsquad=SurfBins/4;
	SurfBinshalfp1=SurfBinshalf+1;

	Rabranch=Ra+BranchLayer;
	Rbbranch=Rb+BranchLayer;
	Rabranch2=Rabranch*Rabranch;
	Rbbranch2=Rbbranch*Rbbranch;
	SpreadWhalf=0.5*SpreadFactor*BeadZoneshalf;

#if TSTGEL
	Ragrow=Ra+InteractLayer;
	Rbgrow=Rb+InteractLayer;
#else
	Ragrow=Ra+InteractLayer;
	Rbgrow=Rb+InteractLayer;
#endif
	Ragrow2=Ragrow*Ragrow;
	Rbgrow2=Rbgrow*Rbgrow;
	initRegion2=initRegion*initRegion;

	mjunode=(log(filalenave/dlt)-1)/2.0/Pi/eta/filalenave;	// filament moving along its axis
	if(Rmax==Rmin) mjubead=1.0/6.0/Pi/eta/Rmax;
	else mjubead=(log(2*Rmax/Rmin)-0.5)/4.0/Pi/eta/Rmax;	// bead moving along its long axis
	mjuplate=1.0/16.0/Pi/eta/sqrt(GelWidthIni*h_gel/2);	// gelwidthini*h_gel/2 is the area
	mjunodeksdt=mjunode*ksnode*dt;	// v=mju*f=mju*ks*dl
	mjubeadksdt=mjubead*ksnode*dt;	// so dr=v*dt=(mju*ks*dt)*dl
	mjuplateksdt=mjuplate*ksnode*dt;

	platemjudt=mjuplate*dt;
	beadmjudt=mjubead*dt;
	platemjudtrelax=mjuplate*dt/GelBeadRelax;
	beadmjudtrelax=mjubead*dt/GelBeadRelax;

	mjunodeksdtinv=1.0/mjunodeksdt;
	thermaldx=sqrt(1.5*4.5e-3/ksnode);	// in um, 1kBT=4.5pN*nm=4.5e-3pN*um; 1.5 from normalization

	dlbr=fbr/ksnode;
	dlscaleshow=5*f0_scale/ksnode;

	dxpernode=forcepernode/ksnode;
	ksfila_node=ksfila/ksnode;	// ratio of the two spring constants
	ksnode_fila=ksnode/ksfila;
	ksfila_nodem1=ksfila_node-1.0;
	kslever_node=ks_lever/ksnode;
	CoarseSegmentm1=CoarseSegment-1;

	NtwkRadius2=NtwkRadius*NtwkRadius;
	NtwkRadiusdb=2.0*NtwkRadius;
	
	rhoymax=sqrt(1+Ra2/eps);	// for creating new nodes around the bead

	dspl_smp_skip=(int)(dspl_smp_dt/dt);
	dspl_n_avem1=dspl_n_ave-1;

	smp_dtdb=2.0*smp_dt;
	smp_dt2=smp_dt*smp_dt;

	Tswitch1pdt=Tswitch1+dt;
	Tswitch2pdt=Tswitch2+dt;

	Ymodfactor=Floadini/h_gel;
}


void init(void)
{
	getconst();
	Nnodes=Nnodes_ini;

#if TSTGEL
	prepSurfBin();
#endif
#if INBEAD && AUTNUC
	prepZone();
#endif

	// GL
#if OPENGL && SAVPIC
	showskip=1;
	img_cnt=0;
	img_cntm=5;	// skip time = dt*showskip*img_cntm
	nframe=0;
#else
	showskip=1;	// show frame every this iterations
#endif
	texturemap=TEXMAP;
	showlink=LNKSRC;
	showfila=SHWFIL;
	showpfn=SHWPFN;
	pause=0;
	linkcolor=LNKCLR;

	zoom=(float)((1.0/max2(NtwkRadius,0.5))/CanvasFactor);
	dxshow=1.0f/SurfBins;
	dxshowm1=1.0f/SurfBinsm1;
#if TSTGEL
	#if !INBEAD
		zoom*=1.6f;
	#endif
#endif
	zoominv=1.0f/zoom;

#if TSTGEL
	N_tst_bufferm1=N_tst_buffer-1;
	n_tst_save=(int)(t_tst_save/dt);
#else
	smp_bufferm1=smp_buffer-1;
	smp_cnt_max=(int)(smp_dt/dt);
#endif

#if CFTEST
	if(CONSTF==0) { printf("*** Sure want to have constant force v(t) test? ***\n\n"); }
#endif
}


void updateGLboundary(void)
{
	GLbnd[0]=GLbnd[1]=(float)(0.8*zoominv);
	GLbnddb[0]=(float)(2.0*GLbnd[0]);
	GLbnddb[1]=(float)(2.0*GLbnd[1]);
}


void reset(void)
{
	int i;
	FILE *fp;

	t=0.0;
	veczero(Rcenter);
	veczero(Rcenterprev);
	veczero(dLbead);

	probaut=probnuc=probdis=0.0;
	thb=dthb=thbd=0.0;
	sthb=sin(thb);
	cthb=cos(thb);

	// GL
	start=1;
	PanX=PanY=0.0f;
#if TSTGEL
	#if INBEAD
	PanY=(float)((-0.6*GelHeightIni)*HWratio);
	#else
	PanY=(float)((-1*GelHeightIni)*HWratio);
	#endif
#endif
	disp_nshift[0]=disp_nshift[1]=0;
	Disp_shift[0]=Disp_shift[1]=0.0f;
	updateGLboundary();

	graph_nedge=0;
	Nlinks=Ncontact=Nnotcontact=0;
	Nfree=Natt=0;
	Nfila=0;
	Nlinkpernode=0.0;
	linklenave=0.0;

	dspl_smp_cnt=dspl_smp_skip;
	dspl_smp_num=dspl_v_ptr=0;
	dspl_Vave=0.0;
	for(i=0; i<dspl_n_ave; i++) dspl_V[i]=0.0;

#if TSTGEL
	teststart=1;
	testdirection=TestDirectionIni;
	cnt_tst_save=0;	//n_tst_save;
	rupture=0;
	ntop=nbot=0;
	topposini[0]=0.0;
	topposini[1]=GelHeightIni;
	botpos[0]=0.0;
	botpos[1]=-GelHeightIni;
	veccopy(topposini, toppos);
	veccopy(toppos, Rcenter);
	veccopy(toppos, Rcenterprev);
	veccopy(toppos, topposprev);
	veczero(dtoppos);
	veczero(dtoppostot);
	veczero(Fgelprev);
	veczero(Ftoptot);
	veczero(Fext);

	#if CONSTF
		Floadtst=Floadini;
	#else
		Floadtst=norm(dtoppostot)*ks_lever;
	#endif

	cnt_tst_buffer=0;
	for(i=0; i<N_tst_buffer; i++) {
		Nbrklink_tst_buffer[i]=0;
		t_tst_buffer[i]=dr_tst_buffer[i][0]=dr_tst_buffer[i][1]=0.0;
		v_tst_buffer[i]=F_tst_buffer[i]=0.0;
	}
	v_current_buffer=0.0;

	#if HISTRY	// loading history test
		if(CONSTF) {	// initially constant force
			Fswitch=Fswitchprev=0;
			Fhold=Floadini;
		}
		else {	// initially varying force
			Fswitch=Fswitchprev=1;
			Fhold=0.0;	// but will be changed to current F when '.' is pressed
		}
		Hleverrest=topposini[1];
	#endif

	fp=fopen("testgel.dat","w");
	fprintf(fp, "#t\ty\tF\tv\n");
	fclose(fp);
	#if !OPENGL
	printf("t\ty\tF\tv\n");
	#endif
#else
	smp_cnt=smp_cnt_max;
	smp_sav_cnt=0;
	for(i=0; i<smp_buffer; i++) {
		smp_t_buffer[i]=smp_thb_buffer[i]=smp_yaw_buffer[i]=0.0;
		smp_r_buffer[i][0]=smp_r_buffer[i][1]=0.0;
	}
	for(i=0; i<SurfBins; i++) {
		surfPf[i]=surfPn[i]=0.0;
	}
	fp=fopen("track.dat","w");
	fprintf(fp, "#t\tthb\tx\ty\n");
	fclose(fp);
	#if !OPENGL
	printf("t\tth\tx\ty\n");
	#endif
#endif

	Nnodes=Nnodes_ini;	// this should not be in front of CleanGraph()
	TriangulationSuccess=0;
}


void BuildNetwork(void)
{
	DoTriangulation();
	BuildGraph();

#if TSTGEL
	dlloadtst=Floadini/ksnode;
	NodesStats();
	Nlinksini=Nlinks;
#endif
}


void switchload(void)	// for loading history test
{
	if(t>=Tswitch1 && t<=Tswitch1pdt) {	// switch 1
		Fhold=Floadtst;
		Hleverrest=toppos[1]-Fhold/ks_lever;	// update Lever's rest position
	#if CONSTF	// if it's const->linear->const switching, needs the following
		Fswitchprev=Fswitch;
		Fswitch=(Fswitch+1)%2;
	#endif
	}
	else if(t>=Tswitch2 && t<=Tswitch2pdt) {	// switch 2
		Fswitchprev=Fswitch;
		Fswitch=(Fswitch+1)%2;
	}
}


void DoSimu(void)
{
#if NODDYN
	NodesDynamics();
#endif
	NodesStats();
	GelPlateDynamics();

	t+=dt;

#if TSTGEL
	if(TestDirectionIni==0 && teststart==1) t-=dt;

	#if !OPENGL && HISTRY
	switchload();
	#endif
#endif
}


void MultipleRuns(void)
{
	int i;
	double vave;
	FILE *fp;

	vave=0.0;
	fp=fopen("multi_run.dat", "w");
	fprintf(fp, "run\t<v>/v0\n");
	fclose(fp);

	for(i=0; i<Ntest_CF; i++) {	// do simulation this many times
		cnt_v_CF=0;
		v_ave_CF=0.0;
		while(t<Tend_CF) DoSimu();	// cnt_v_CF++ & v_ave_CF+= are in motion.c

		v_ave_CF/=cnt_v_CF*V0;	// normalized by V0
		vave+=v_ave_CF;

		printf("run = %d,\t<v>/v0 = %f\n\n", i+1, vave/(i+1));
		fp=fopen("multi_run.dat", "a");
		fprintf(fp, "%d\t%f\n", i+1, v_ave_CF);
		fclose(fp);

		CleanUp();
		reset();
		BuildNetwork();
	}
	vave/=Ntest_CF;
	printf("vave=%f\n", vave);

	fp=fopen("cf_v.dat", "w");
	fprintf(fp, "%f\t%f\n", Floadini, vave);
	fclose(fp);
}



void terminate(void)
{
#if TSTGEL
	FlushTest(cnt_tst_buffer);
#else
//	FlushTracking(smp_sav_cnt);
	ProcessTrack();
	DoAllStats();
#endif
	exit(0);
}


int main(int argc, char **argv)
{
#if OPENGL
	getmseed();
#else
	if(argc==2) mseed=-abs(atoi(argv[1]));
	else getmseed();
#endif

	init();
	reset();
	BuildNetwork();

#if OPENGL
	RunGL(&argc,argv);
#else
	#if CONSTF && CFTEST
		MultipleRuns();
	#else
		while(t<=Tmax) DoSimu();
	#endif
	terminate();
#endif


#if VCDBUG
	_CrtDumpMemoryLeaks();
#endif

	return 0;
}


