/*
scaling: 
I want ks=300 pN/um to match Y=3 kPa, then mesh size ksi=ks/Y=0.1 um.
I want rho=1000/um^2. b/c rho=N/l/d where d is the depth of my gel. N=knuc/kc=l*knden/kc,
so d=N/rho/l=knden/rho/kc=0.02 um.

so if my N~100, then l=N*kc/knden=5 um. A should be A=l*d=0.1 um^2
For cantilever, scaling factor is alpha=A/A0=0.1/400=1/4000.
So, my cantilever stiffness is kcant=kcant_exp*alpha=30/4000 pN/nm = 7.5 pN/um.

For sykes, area around the bead is pi*R*d=0.05 um^2. Cross-section area is A=2R*d=0.04 um^2.
So, YA=120 pN (so Fstall=YA/exp(kt)=YA/exp(0.8)=54 pN. good!)
*/

#define Rafix 1.0	// minor axis
#define Rbfix (1.0*Rafix)	// major axis

#define knden 2.0	// node's total creation rate /s /um
#define kdis 8.0e-3	// network disasembling rate /s

#define ka 1.0	// filament attachment rate /s
#define kc 0.1	// filament capping rate /s
#define kd 2.7	// filament detachment rate /s

#define InteractLayer 0.5	// within this layer in micron, gel pushes bead
#define BranchLayer 0.5	// within this layer in micron, filaments branch
#define V0 0.05	// free filament growth velocity in micron/s

#define vfpower 2.0	// v-f power factor: v/v0=1-(f/fbuckle)^vfpower, >1 concave down, <1 concave up
#define f0_scale 1.5	// force scale in pN, for calc fila growth v when exp() relation
#define f0_stall 3.0	// stall force for power-law v-f relation
#define fbr 100.0	// link's rupture force, in pN
#define fbuckle 100.0	// buckling force in pN
#define fdetach 100.0	// filament's detachment force in pN

#define Floadini 0.0	// in pN, value comparable to (f0*Nfilamax)
#define Nfilamax 200	// to limit filament number

#define ksnode 300.0	// spring constant of each link, in pN/micron
#define ksfila (ksnode)	// filament's spring constant in pN/micron
#define ks_std 10.0	// spring constant pN/um of a 0.1 um spring (ksnode invers prop to spring length)
#define ks_lever 7.5	// sprint constant of cantilever, in pN/micron

#define h_gel 0.1	// gel thickness in um, for calc. Young's modulus
// this thickness is estimated from filament density rho=1000/um^2=N/A=40/(2um*0.02um)

#define LinkPerNode 4	// links per new node, integer
#define LinkPerNodem1 (LinkPerNode-1)
#define LinkPerNodedb (2*LinkPerNode)
#define LinkPerNodeplus (LinkPerNode+20)
#define LinkPerNodeplusm1 (LinkPerNodeplus-1)

#define GelBeadRelax 10	// relaxation iteration
#define CoarseSegment 10	// divide the network into this many segments for coarse-graining

#define BeadZones 80	// divide bead surface into this many zones, be a multiple of 4
#define SpreadFactor 0.5	// filaments spread on bead surface=SpreadFactor*HalfCircumference

#define eta 1.0e-2	// actual viscosity: eta=10*eta_water=0.01 Pa*s=0.01 pN*s/um^2
#define dlt 2.7e-3	// monomer half size
#define filalenave 1.0	// average filament length, to calculate mjunode

#define Nnodes_max 2000	// max nodes
#define SurfBins 40	// surface bins to stat on F & N distribution, be a multiple of 4

#define forcepernode 1.0	// temprary force in pN
#define initRegion (2.5*NtwkRadius)	// initial gel region
#define CutTolerence 0.9	// for avoiding bead

#define dl0_scale (f0_scale/ksfila)	// dl0_scale=f0/ks_filament
#define dl0_stall (f0_stall/ksfila)
#define dl_buckle (fbuckle/ksfila)
#define dl_detach (fdetach/ksfila)

#define Pi 3.14159265
#define Pihalf (Pi/2.0)
#define Pidb (2.0*Pi)
#define r2d (180.0/Pi)
#define d2r (Pi/180.0)
#define eps 1.0e-10
#define inf 1.0e10

//--- Data Sampling ---
#define dspl_smp_dt 1.0
#define dspl_n_ave 1	// display v is averaged over this many samples

#define smp_dt 1.0	// sampling time interval
#define smp_buffer 10

//--- stat ---
#define Ncorr 20	// number of autocorrelation points
#define Tcorrmax 600.0	// max correlation time interval

//--- Gel Test ---
#define Tmax 100.0	// max run time in sec
#define t_tst_save 1.0	// save test results every this much time
#define TestDirectionIni 1

#if INBEAD
	#define NtwkRadius (1.2*Rafix)
	#define GelWidthIni (1.4*Rafix)
	#define GelHeightIni (1.0*Rbfix)	// half of the total height
#else
	#define NtwkRadius 2.5	// halfwidth of network in micron
	#define GelWidthIni (NtwkRadius)
	#define GelHeightIni (0.25*NtwkRadius)	// half of the total height
#endif
#define toplayerthick (0.8*GelHeightIni)
#define toplayerheight (GelHeightIni-toplayerthick)	// for testing gel

#define botlayercontact (-0.9*GelHeightIni)	// note that GelHeightIni is the half height
#define newnodedistance (0.2*toplayerthick)
#define N_tst_buffer 5

//--- constant force test ---
#define Ntest_CF 20	// do constant force test for this many times
#define Tstart_CF 30.0	// start recording v-t
#define Tend_CF 60.0	// end recording v-t

//--- Loading History w/o GL ---
#define Tswitch1 40.0
#define Tswitch2 70.0

// gel relax solver
#define Matrix_ITOL 1
#define Matrix_TOL 1.0e-9
#define Matrix_ITMAX 75

//--- GL ---
#if SAVPIC
#define Width 640
#define Height 640
#else
#define Width 800
#define Height 800
#endif
#define HWratio (1.0f*Height/Width)
#define CanvasFactor 3.0	// ratio of window size to bead size

#define TextureWidth 256

#if INBEAD
	#define ParticleRadius 0.15	//  for bead
	#define TextureHalfWidth (TextureWidth/2)
	#define TextureDecayWidth (TextureHalfWidth/5)
#else
	#define ParticleRadius 0.08	// for cantilever
	#define TextureHalfWidth (TextureWidth/2)
	#define TextureDecayWidth (TextureHalfWidth/5)
#endif

#define TextureDecayWidth2 (TextureDecayWidth*TextureDecayWidth)
#define TextureDecayWidth2db (2.0*TextureDecayWidth2)
#define LinkDecorSpacing (0.2*ParticleRadius)


