
void makeTexImage(void) {
    int i, j, c;
	double r2;
    for (i = 0; i < TextureWidth; i++) {
        for (j = 0; j < TextureWidth; j++) {
			r2=pow(i-TextureHalfWidth,2)+pow(j-TextureHalfWidth,2);
		#if SAVPIC
			c=(int)(exp(-r2/TextureDecayWidth2db)*50);	// 255
		#else
			c=(int)(exp(-r2/TextureDecayWidth2db)*255);	// 255
		#endif
            TexImage[i][j][0] = (GLubyte) c;
            TexImage[i][j][1] = (GLubyte) c;
            TexImage[i][j][2] = (GLubyte) c;
            TexImage[i][j][3] = (GLubyte) 100;
        }
    }
}

void init_GL(void)
{
#if AALIAS
	glEnable(GL_POINT_SMOOTH);
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POLYGON_SMOOTH);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);
#endif

	glClear(GL_COLOR_BUFFER_BIT);
	glClearColor(0.0, 0.0, 0.0, 1.0);
//	glClearColor(1.0, 1.0, 1.0, 1.0);

	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT0);
	glClear(GL_COLOR_BUFFER_BIT);
	
}


void changeSize(int w, int h)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//gluOrtho2D(-1, 1, -1, 1);	// left, right, bottom, top
	if(HWratio>1.0) gluOrtho2D(-1,1,-HWratio,HWratio);
	else gluOrtho2D(-1.0/HWratio,1.0/HWratio,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}


void keyboard(unsigned char key, int x, int y)
{
	switch (key) {
		case 27:		// When Escape Is Pressed...
			//CleanUp();
			ProcessTrack();
			terminate();	// Exit The Program
			break;		// Ready For Next Case
		case 'c':
			linkcolor=(linkcolor+1)%4;
			break;
		case 'f':
			showforce=(showforce+1)%6;
			break;
		case 'm':
			showmelt=(showmelt+1)%2;
			break;
		case 'n':
			noise=(noise+1)%2;
			break;
		case 'p':
			pause=(pause+1)%3;
			break;
		case 'r':
			reset();
			init_GL();
			break;
		case 's':
			showstrain=(showstrain+1)%2;
			break;
		case 'z':
			shownormal=(shownormal+1)%3;
			break;
		case '+':
		case '=':
			zoom*=1.2f;
			zoominv=1.0f/zoom;
			break;
		case '-':
			zoom/=1.2f;
			zoominv=1.0f/zoom;
			break;
		case ' ':	// reset zoom & view
			initview();
			break;
		default:
			break;
	}
}


void arrow_keys(int a_keys, int x, int y)
{
	switch (a_keys) {
	case GLUT_KEY_UP:	// When Up Arrow Is Pressed...
		PanY-=0.1f;
		break;
	case GLUT_KEY_DOWN:	// When Down Arrow Is Pressed...
		PanY+=0.1f;
		break;
	case GLUT_KEY_RIGHT:
		PanX-=0.1f;
		break;
	case GLUT_KEY_LEFT:
		PanX+=0.1f;
		break;
	default:
		break;
  }
}


void mouse(int button, int state, int x, int y)
{
    if(button==GLUT_LEFT_BUTTON)
    {
        if(state==GLUT_DOWN) {
            mouse_left=1;
            mouse_x=x;
            mouse_y=y;
        }
        else mouse_left=0;
    }

	if(button==GLUT_RIGHT_BUTTON) {
        if(state==GLUT_DOWN) {
            mouse_right=1;
            mouse_x=x;
            mouse_y=y;
        }
        else mouse_right=0;
    }
}


void drag(int x, int y) 
{ 
	if(mouse_left==1) {
		PanX+=0.0025f*(x-mouse_x);
		PanY-=0.0025f*(y-mouse_y);
		mouse_x=x;
		mouse_y=y; 
		glutPostRedisplay(); 
	}

	if(mouse_right==1) {
		zoom*=(1.0f+0.005f*(x-mouse_x));
		zoom*=(1.0f-0.005f*(y-mouse_y));
		zoominv=1.0f/zoom;
		mouse_x=x;
		mouse_y=y; 
		glutPostRedisplay(); 
	} 
}

