
void display_list(void)
{
	int i;
	float a, x, y;
	bead=glGenLists(1);
	glNewList(bead, GL_COMPILE);
	glColor3f(0.6, 0.6, 0.6);
	glLineWidth(3.0);
	
//	/*
	glBegin(GL_TRIANGLES);	// solid disk
	for(i=0; i<100; i++) {
		glVertex2f(0,0);
		
		a=Pidb*i/100.0;
		x=(float)(R_NUC*cos(a));
		y=(float)(R_NUC*sin(a));
		glVertex2f(x,y);
		
		a=Pidb*(i+1)/100.0;
		x=(float)(R_NUC*cos(a));
		y=(float)(R_NUC*sin(a));
		glVertex2f(x,y);
	}
	glEnd();
//	*/
	/*
	glBegin(GL_LINE_LOOP);	// hollow circle
	for(i=0; i<100; i++) {
		a=Pidb*i/100.0;
		x=(float)(R_NUC*cos(a));
		y=(float)(R_NUC*sin(a));
		glVertex2f(x,y);
	}
	glEnd();
	*/
	glEndList();
	
	arrowhead=glGenLists(2);
	glNewList(arrowhead, GL_COMPILE);
	glColor3f(1.0, 1.0, 0.0);
	a=40.0*d2r;	// angle of arrowhead
	y=arrowheadlen;	// length of arrowhead
	x=y*tan(a/2);
	glBegin(GL_TRIANGLES);
		glVertex2f(0,y);
		glVertex2f(-x,0);
		glVertex2f(x,0);
	glEnd();
	glEndList();
	
}


void drawline(double v1[], double v2[], float thickness)
{
	int i;
	float v1f[2], v2f[2];
	
	for(i=0; i<2; i++) {
		v1f[i]=(float) (v1[i]);
		v2f[i]=(float) (v2[i]);
	}
	glLineWidth(thickness);
	glBegin(GL_LINES);
		glVertex2f(v1f[0], v1f[1]);
		glVertex2f(v2f[0], v2f[1]);
	glEnd();
}


void drawlineclr(double v1[], double v2[], double dl, double dl0, float thickness, float brightness)
{
	int i;
	float v1f[2], v2f[2];
	float mag, rgbini, drgb, r, g, b;
	
	for(i=0; i<2; i++) {
		v1f[i]=(float) (v1[i]);
		v2f[i]=(float) (v2[i]);
	}
	
	mag=(float) (pow(fabs(dl)/dl0,0.2));	// smaller factor is more sensitive to force change
	mag=min2(mag, 1.0);
	rgbini=max2(mag, brightness);	// brightness
	r=g=b=rgbini;
	drgb=mag*0.5;
	if(dl>=0) {	// stretched: blue
		r-=drgb;
		g-=drgb;
		b+=drgb;
	//	b+=(1.0-rgbini)*mag;
	}
	else {	// compressed: red
	//	r+=(1.0-rgbini)*mag;
		r+=drgb;
		g-=drgb;
		b-=drgb;
	}
	
	glColor3f(r,g,b);
	glLineWidth(thickness);
	glBegin(GL_LINES);
		glVertex2f(v1f[0], v1f[1]);
		glVertex2f(v2f[0], v2f[1]);
	glEnd();
}


void drawCellShade(void)
{
	int i, j, nx, ny;
	float x, y;
	double dx, dy, r[2];
	
	nx=40;
	ny=40;
	
	dx=(Xmax-Xmin)/(nx-1);
	dy=(Ymax-Ymin)/(ny-1);
	
	glPointSize(50.0);
	glColor3f(0.2, 0.2, 0.5);
	glBegin(GL_POINTS);
	for(i=0; i<nx; i++) {
		r[0] = Xmin+i*dx;
		for(j=0; j<ny; j++) {
			r[1] = Ymin+j*dy;
			if(PointInCell(r)==1) {
				x=(float)(r[0]);
				y=(float)(r[1]);
				glVertex2f(x, y);
			}
		}
	}
	glEnd();
}



void drawNucleus(void)
{
	int i;
	float r[2];
	
	for(i=0; i<2; i++) r[i]=(float)(Rnuc[i]);
	glTranslatef(r[0],r[1],0.0);
	glCallList(bead);
	//glLoadIdentity();
	glTranslatef(-r[0],-r[1],0.0);
}


void drawWalls(void)
{
	float d, h, w;
	
	w=10.0*XLENhalf;	// width
	d=10.0*YLENhalf;	// thickness 0.2
	h=YLENhalf;	// distance between plates
	
	glColor3f(0.3, 0.3, 0.3);
	glBegin(GL_QUADS);
		glVertex3f(-w, h, 0.0);
		glVertex3f(w, h, 0.0);
		glVertex3f(w, h+d, 0.0);
		glVertex3f(-w, h+d, 0.0);
		glVertex3f(-w, -h, 0.0);
		glVertex3f(w, -h, 0.0);
		glVertex3f(w, -h-d, 0.0);
		glVertex3f(-w, -h-d, 0.0);
	glEnd();
}


void drawECMnodes(void)	// from graph
{
	int i;
	float x, y;
	ECM_node *p;
	
	glPointSize(2.0);
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
	//	if(p->connected==1) {
		if(p->nnbr>1 && p->connected) {
			x=(float) (p->r[0]);
			y=(float) (p->r[1]);
			if(p->contact==1)glColor3f(1.0, 0.0, 0.0);
			//if(p->connected==-2)glColor3f(1.0, 1.0, 0.0);
			else glColor3f(0.5, 0.5, 0.5);
			glBegin(GL_POINTS);
				glVertex2f(x, y);
			glEnd();
		}
	}
	/*
#if CTXADH
	glPointSize(4.0);
	glColor3f(0.8, 0.0, 0.0);
	
	glBegin(GL_POINTS);
	for(i=0; i<N_ECM; i++) {
		p = ECM[i];
		if(p->nearmem == 1) {
			x=(float) (p->r[0]);
			y=(float) (p->r[1]);
			glVertex2f(x, y);
		}
	}
	glEnd();
#endif
*/
}


void drawMEMnodes(void)	// from graph
{
	int i;
	float x, y;
	MEM_node *p;
	
#if SMDOTS
	glPointSize(6.0);
#else
	glPointSize(8.0);
#endif
	
	glBegin(GL_POINTS);
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		
		if(showmelt) {
			if(p->melt == 0) glColor3f(0.5, 0.5, 1.0);
			else glColor3f(1.0, 0.3, 0.3);
		}
		else glColor3f(0.5, 0.5, 1.0);
		
		x=(float) (p->r[0]);
		y=(float) (p->r[1]);
		glVertex2f(x, y);
	}
	glEnd();
	
/*
#if ECMMLT	// mark tip
	p=&MEM[TIP_ID];
	x=(float) (p->r[0]);
	y=(float) (p->r[1]);
	
	glPointSize(8.0);
	glColor3f(1.0, 1.0, 1.0);
	glBegin(GL_POINTS);
		glVertex2f(x, y);
	glEnd();
#endif
*/
}


void drawCTXnodes(void)	// from graph
{
	int i;
	float x, y;
	CTX_node *p;
	
	glPointSize(2.0);
	glColor3f(0.5, 0.5, 0.5);
	
	glBegin(GL_POINTS);
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		if(p->nnbr > 0) {
			x=(float) (p->r[0]);
			y=(float) (p->r[1]);
			glVertex2f(x, y);
		}
	}
	glEnd();
	
/*
	glColor3f(1, 1, 1);
	glBegin(GL_LINES);
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		if(p->nnbr>0) {
			x=(float)(p->r[0]);
			y=(float)(p->r[1]);
			glVertex2f(x, y);
			x=(float)((MEM[p->nearmemid].r[0]+MEM[MEM[p->nearmemid].nbr[1]].r[0])/2);
			y=(float)((MEM[p->nearmemid].r[1]+MEM[MEM[p->nearmemid].nbr[1]].r[1])/2);
			glVertex2f(x, y);
		}
	}
	glEnd();
*/
}


void drawAdhesions(void)	// from graph
{
#if CTXADH || EXTNSN
	int i;
	float x, y;
	CTX_node *p;
	
	glPointSize(8.0);
	glColor3f(0.8, 0.8, 0.8);
	
	glBegin(GL_POINTS);
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		if(p->adhere == 1) {
		//if(p->nearmem) {
			x=(float) (p->r[0]);
			y=(float) (p->r[1]);
			glVertex2f(x, y);
		}
	}
	glEnd();
#endif
}


void drawECMlinks(void)	// by connecting graph nodes, actual number of links is 2x
{
	int i;
	ECM_node *p, *q;
	
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->nnbr > 1) {
			q = p->next;
			while(q) {
				if(q->connected == 1 && ECM[q->id]->nnbr>1) {	// note that q->connected may be -1!
					if(linkcolor==0 || linkcolor==2) {
						glColor3f(0.3, 0.3, 0.3);
						drawline(p->r, q->r, 2.0);
					}
					else drawlineclr(p->r, q->r, q->dl, dlcolorscaleECM, 2.0, 0.2);
				}
				q = q->next;
			}
		}
	}
}


void drawMEMlinks(void)
{
	int i;
	MEM_node *p, *q;
	
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		q = &MEM[p->nbr[1]];	// right neighbor
		if(linkcolor<3) {
			//if(p->health) glColor3f(0.5, 0.5, 1.0);
			//else glColor3f(1,0.0,0.0);
			
		#if ECMMLT
			if(showmelt) {
				if(p->melt == 0) glColor3f(0.5, 0.5, 1.0);
				else glColor3f(1.0, 0.3, 0.3);
			}
			else glColor3f(0.5, 0.5, 1.0);
		#else
			glColor3f(0.5, 0.5, 1.0);
		#endif
		
			drawline(p->r, q->r, 8.0);
		}
		else drawlineclr(p->r, q->r, p->dl[1], dlcolorscaleMEM, 8.0, 0.8);
	}
}


void drawCTXlinks(void)
{
	int i;
	CTX_node *p, *q;
	
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		q = p->next;	// right neighbor
		while(q) {
			if(q->connected == 1) {
				if(linkcolor<=1) {
					glColor3f(0.0, 0.8, 0.0);
					drawline(p->r, q->r, 2.0);
				}
				else drawlineclr(p->r, q->r, q->dl, dlcolorscaleCTX, 2.0, 0.4);
			}
			q = q->next;
		}
	}
}



void showtext(void)
{
	int i, len0, len1, len3, len4, len5, len6;
	double v, vave;
	char str0[100], str1[100], str3[100], str4[100], str5[100], str6[100];
	
	v=3600*norm(Vnuc);
	vave=3600*vnucave;	// in um/hr
	if(v<0.1) v=0.0;
	
	if(ECMMLT && CTXADH) sprintf(str0, "ECM Melting + CTX Adhesion");
	else if(ECMMLT) sprintf(str0, "ECM Melting");
	else if(CTXADH) sprintf(str0, "CTX Adhesion");
	else sprintf(str0, "Cortex Contraction");
	
	//sprintf(str1, "t = %.3g s,   N = %d", t, N_CTX);
	sprintf(str1, "t = %.3g s,   Nadh(contact) = %d", t, N_ADH);
	//sprintf(str2, "F = %.3g pN,", f);
	sprintf(str3, "V = %.3g um/hr", v);
	sprintf(str4, "<V> = %.3g um/hr", vave);
	sprintf(str5, "Noise");
	
	if(showforce==1) sprintf(str6, "F_nuc");
	else if(showforce==2) sprintf(str6, "F_mem");
	else if(showforce==3) sprintf(str6, "F_ctx");
	else if(showforce==4) sprintf(str6, "F_ecm");
	else if(showforce==5) sprintf(str6, "F_cell");

	len0=(int) strlen(str0);
	len1=(int) strlen(str1);
	//len2=(int) strlen(str2);
	len3=(int) strlen(str3);
	len4=(int) strlen(str4);
	len5=(int) strlen(str5);
	len6=(int) strlen(str6);

	glColor3f(0.8, 0.8, 0.8);
	if(HWratio>1) glRasterPos2f(-0.15, 0.88*HWratio);
	else glRasterPos2f(-0.08/HWratio, 0.88);
	for (i = 0; i < len0; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str0[i]);
	
	if(HWratio>1) glRasterPos2f(-0.95, 0.88*HWratio);
	else glRasterPos2f(-0.95/HWratio, 0.88);
	for (i = 0; i < len1; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str1[i]);
	
	/*
	if(HWratio>1) glRasterPos2f(-0.95, -0.95*HWratio);
	else glRasterPos2f(-0.95/HWratio, -0.95);
	for (i = 0; i < len2; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str2[i]);
	*/
	
	if(HWratio>1) glRasterPos2f(-0.8, -0.95*HWratio);
	else glRasterPos2f(-0.8/HWratio, -0.95);
	for (i = 0; i < len3; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str3[i]);
	
	if(staton) glColor3f(0.8, 0.8, 0.8);
	else glColor3f(0.4, 0.4, 0.4);
	if(HWratio>1) glRasterPos2f(0.5, -0.95*HWratio);
	else glRasterPos2f(0.5/HWratio, -0.95);
	for (i = 0; i < len4; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str4[i]);
	
	if(noise) glColor3f(0.8, 0.8, 0.8);
	else glColor3f(0.4, 0.4, 0.4);
	if(HWratio>1) glRasterPos2f(0.8, 0.88*HWratio);
	else glRasterPos2f(0.8/HWratio, 0.88);
	for (i = 0; i < len5; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str5[i]);
	
	if(showforce) {
		glColor3f(0.8, 0.8, 0.8);
		if(HWratio>1) glRasterPos2f(-0.05, -0.95*HWratio);
		else glRasterPos2f(-0.05/HWratio, -0.95);
		for (i = 0; i < len6; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str6[i]);
	}
}


void showshorttext(void)
{
	int i, len1, len2;
	double v, vave;
	char str1[100], str2[100];
	
	v=3600*norm(Vnuc);
	vave=3600*vnucave;
	if(v<0.1) v=0.0;
	
	sprintf(str1, "t = %.4g s", t);
	sprintf(str2, "V = %.4g um/hr", vave);

	len1=(int) strlen(str1);
	len2=(int) strlen(str2);

	glColor3f(0.8, 0.8, 0.8);
	
	if(HWratio>1) glRasterPos2f(-0.95, -0.95*HWratio);
	else glRasterPos2f(-0.95/HWratio, -0.95);
	for (i = 0; i < len1; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str1[i]);
	
	/*
	if(HWratio>1) glRasterPos2f(-0.2, -0.95*HWratio);
	else glRasterPos2f(-0.2/HWratio, -0.95);
	for (i = 0; i < len2; i++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, str2[i]);
	*/
}



void drawNUCforce(void)
{
	int i;
	double v1[2], v2[2];
	
	for(i=0; i<2; i++) {
		v1[i] = Rnuc[i];
		v2[i] = v1[i] + Fnuc[i]/(dlbrCTX);
	}
//	if(DRIVER==1) v2[0]-=(Fload/fbrCTX);
	drawline(v1, v2, 3.0);
	
	glColor3f(0.3,0.3,0.3);
	glPointSize(4.0);
	glBegin(GL_POINTS);
		glVertex2f(Rnuc[0], Rnuc[1]);
	glEnd();
}


void drawECMforce(void)
{
	int i, j;
	float v1[2], v2[2];
	double v[2];
	ECM_node *p;
	
	glBegin(GL_LINES);
		for(i=0; i<N_ECM; i++) {
			p=ECM[i];
			if(p->connected==1 && p->bnd == 0) {
				vecdiv(p->dlvec, 1.0*dlbrECM, v);
				for(j=0; j<2; j++) {
					v1[j]=(float) (p->r[j]);
					v2[j]=(float) (p->r[j]+v[j]);
				}
				glVertex2f(v1[0], v1[1]);
				glVertex2f(v2[0], v2[1]);
			}
		}
	glEnd();
}


void drawCTXforce(void)
{
	int i, j;
	float v1[2], v2[2];
	double v[2];
	CTX_node *p;
	
	glBegin(GL_LINES);
		for(i=0; i<N_CTX; i++) {
			p=CTX[i];
			if(p->contact != 0) {	// in contact with nucleus or membrane or both
				vecdiv(p->dlvec, dlbrCTX, v);
				for(j=0; j<2; j++) {
					v1[j]=(float) (p->r[j]);
					v2[j]=(float) (p->r[j]+v[j]);
				}
				glVertex2f(v1[0], v1[1]);
				glVertex2f(v2[0], v2[1]);
			}
		}
	glEnd();
}


void drawMEMforce(void)
{
	int i, j;
	float v1[2], v2[2];
	double v[2];
	MEM_node *p;
	
	glBegin(GL_LINES);
		for(i=0; i<N_MEM; i++) {
			p = &MEM[i];
			vecdiv(p->dlvec, 0.2*dlbrECM, v);
			for(j=0; j<2; j++) {
				v1[j]=(float) (p->r[j]);
				v2[j]=(float) (p->r[j]+v[j]);
			}
			glVertex2f(v1[0], v1[1]);
			glVertex2f(v2[0], v2[1]);
		}
	glEnd();
}




void drawCELLforce(void)
{
	int i;
	double v1[2], v2[2];
	
	for(i=0; i<2; i++) {
		v1[i] = Rcell[i];
		v2[i] = v1[i] + Fcell[i]/(dlbrCTX);
	}
//	if(DRIVER==1) v2[0]-=(Fload/fbrCTX);
	drawline(v1, v2, 3.0);
	
	glColor3f(0.3,0.3,0.3);
	glPointSize(4.0);
	glBegin(GL_POINTS);
		glVertex2f(Rcell[0], Rcell[1]);
	glEnd();
}



void drawForces(void)
{
	if(linkcolor) glColor3f(0.0,1.0,0.0);
	else glColor3f(1.0,0.0,0.0);
	glLineWidth(3.0);
	
	if(showforce==1) drawNUCforce();
	else if(showforce==2) drawMEMforce();
	else if(showforce==3) drawCTXforce();
	else if(showforce==4) drawECMforce();
	else if(showforce==5) drawCELLforce();
}



void drawArrow(double r1[2], double r2[2])	// draw an arrow pointing from r1 to r2
{
	double dr[2], len, a;
	double ra[2], rb[2];
	float x, y, yshaft;
	
	vecsub(r2, r1, dr);
	Crt2Polb(dr, &len, &a);	// -Pi<a<Pi, 12 O'clock is 0, cw is +
	if(len<eps) return;
	a*=r2d;	// -180<a<180
	
	x=(float)(r1[0]);
	y=(float)(r1[1]);
	ra[0]=ra[1]=rb[0]=0;
	rb[1]=len;
	yshaft=len-arrowheadlen;
	
	glTranslatef(x, y, 0);	// move to the arrow tail
	glRotatef(-a, 0, 0, 1);	// rotate to arrow's direction
	
	glColor3f(1.0, 1.0, 0.0);	// arrow shaft
	drawline(ra, rb, 2.0);
	
	glTranslatef(0, yshaft, 0);
	glCallList(arrowhead);	// arrow head
	glTranslatef(0, -yshaft, 0);
	
	glRotatef(a, 0, 0, 1);
	glTranslatef(-x, -y, 0);
	
}


void showStrainField(void)
{
	int i;
	ECM_node *p;
	
	for(i=0; i<N_ECM; i+=2) {
		p = ECM[i];
		if(p->connected == 1 && p->nnbr > 1) {
			if(PointInCell(p->rini)==0) drawArrow(p->rini, p->r);
		}
	}
}


void markECMnodes(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	ECM_node *p;
	
	glColor3f(0.5, 0.5, 0.5);
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->connected == 1) {
			sprintf(str, "%d", p->nnbr);
			len=(int) strlen(str);
			r[0]=(float)(p->r[0]);
			r[1]=(float)(p->r[1]+0.02);
			glRasterPos2f(1.01*r[0], 1.01*r[1]);
			for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
		}
	}
}


void markCTXnodes(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	CTX_node *p;
	
	glColor3f(0.8, 0.8, 0.8);
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		if(p->adhere == 1) {
			sprintf(str, "%d", p->adhereid);
			len=(int) strlen(str);
			r[0]=(float)(p->r[0]);
			r[1]=(float)(p->r[1]+0.02);
			glRasterPos2f(1.01*r[0], 1.01*r[1]);
			for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
		}
	}
}


void markMEMnodes(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	MEM_node *p;
	
	glColor3f(0.85, 0.85, 0.85);
	for(i=0; i<N_MEM; i++) {
		p=&MEM[i];
		sprintf(str, "%d", p->id);
		len=(int) strlen(str);
		r[0]=(float)(p->r[0]);
		r[1]=(float)(p->r[1]+0.02);
		glRasterPos2f(1.01*r[0], 1.01*r[1]);
		for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
	}
}



void markECMlinks(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	ECM_node *p, *q;
	
	glColor3f(0.5, 0.5, 0.5);
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		q=p->next;
		while(q) {
			if(q->connected == 1) {
				sprintf(str, "%.2g", q->dl);
				len=(int) strlen(str);
				r[0]=(float)((p->r[0]+q->r[0])/2.0);
				r[1]=(float)((p->r[1]+q->r[1])/2.0);
				glRasterPos2f(1.01*r[0], 1.01*r[1]);
				for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
			}
			q = q->next;
		}
	}
}


void markCTXlinks(void)
{
	int i, j, len;
	float r[2];
	char str[20];
	CTX_node *p, *q;
	
	glColor3f(0.5, 0.5, 0.5);
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		q=p->next;
		while(q) {
			if(q->connected == 1) {
				sprintf(str, "%.2g", q->l0);
				len=(int) strlen(str);
				r[0]=(float)((p->r[0]+q->r[0])/2.0);
				r[1]=(float)((p->r[1]+q->r[1])/2.0);
				glRasterPos2f(1.01*r[0], 1.01*r[1]);
				for(j=0; j<len; j++) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, str[j]);
			}
			q = q->next;
		}
	}
}


void drawMEMnormal(void)
{
	int i, j;
	float r1[2], r2[2], len;
	MEM_node *p;
	
	len=0.1*R_MEM;
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		if(shownormal==1) {
			for(j=0; j<2; j++) {
				r1[j] = p->r[j];
				r2[j] = r1[j] + len*(p->nrm[j]);
			}
		}
		else {
			for(j=0; j<2; j++) {
				r1[j] = (p->r[j] + MEM[p->nbr[1]].r[j])/2;
				r2[j] = r1[j] + len*(p->nrmedge[j]);
			}
		}
		
		glColor3f(0.0,1.0,0.0);
		glLineWidth(1.0);
		glBegin(GL_LINES);
			glVertex2f(r1[0], r1[1]);
			glVertex2f(r2[0], r2[1]);
		glEnd();
	}
}


void drawAdhesionlinks(void)	// by connecting graph nodes, actual number of links is 2x
{
	int i;
	CTX_node *c;
	ECM_node *e;
	
	for(i=0; i<N_CTX; i++) {
		c=CTX[i];
		if(c->adhere == 1) {
			e = ECM[c->adhereid];
			glColor3f(0.0, 0.0, 1);
			drawline(c->r, e->r, 1.0);
		}
	}
}


void drawallobj(void)
{
//	drawviewbox();

	glTranslatef(PanX, PanY, 0.0);
	glScalef(zoom, zoom, zoom);	// scale
	
	drawECMlinks();
	drawECMnodes();
	
	drawWalls();
	//drawCellShade();
	
	drawNucleus();
	
	drawCTXlinks();
	drawCTXnodes();
	
	
	drawMEMlinks();
	drawMEMnodes();
	if(shownormal) drawMEMnormal();
	
	drawAdhesions();
	
	if(showstrain) showStrainField();
	drawForces();
	
	//markECMnodes();
	//markECMlinks();

	//markCTXnodes();
	//markCTXlinks();
	
	//markMEMnodes();
	
	//drawAdhesionlinks();

	glLoadIdentity();
}


void SaveStrainField(int n)
{
	int i;
	char fn[100];
	ECM_node *p;
	FILE *fp;
	
	sprintf(fn, "frames/s%.4u.dat", n);
	fp=fopen(fn, "w");
	fprintf(fp, "#x0\ty0\tx\ty\n");
	for(i=0; i<N_ECM; i+=2) {
		p = ECM[i];
		if(p->connected == 1 && p->nnbr > 1) 
			fprintf(fp, "%f\t%f\t%f\t%f\n", p->rini[0], p->rini[1], p->r[0], p->r[1]);
	}
	fclose(fp);
}



void GLmain(void)
{
	int i;
#if REPEAT
	FILE *fp;
#endif
	
	//glClear(GL_COLOR_BUFFER_BIT);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();

	drawallobj();	// scaled obj
	
	
#if SAVPIC
	showshorttext();
#else
	showtext();
#endif

//-------- snapshots --------
#if SAVPIC
	if(img_cnt%img_cntm==0) {
		nframe++;
		printf("frame = %d\n", nframe);
		sprintf(img_name, "frames/p%.4u.png", nframe);
		img_data=(GLubyte*)malloc((Width)*(Height)*3*sizeof(GLubyte));
		ilTexImage(Width, Height, 1, 3, GL_RGB, GL_UNSIGNED_BYTE, img_data);
	
		glPixelStorei(GL_PACK_ALIGNMENT, 1);
		glReadPixels(0, 0, Width, Height, GL_RGB, GL_UNSIGNED_BYTE, img_data);

		ilSetData(img_data);
		ilSave(IL_PNG, img_name);
		free(img_data);
		
		//SaveStrainField(nframe);
	}
	img_cnt++;
#endif
//---------------------------

	//pause=1;
	if(!pause) {
		for(i=0; i<showskip; i++) DoSimu();
	#if REPEAT
		if(ValidRun==0) {	// membrane crossed
			if(repeatcnt<Nrepeat-1) reset();	// make sure smptot!=0
			repeatcnt++;
		}
		else if(Xmax>RightBnd || t>Tmax) {	// one loop ends
			ProcessTrack();
			vrepeatind[NrepeatValid]=Vcell_ave;
			vrepeatsum+=Vcell_ave;
			printf("%d\t%.3g\n", NrepeatValid+1, Vcell_ave*3600);
			
			fp=fopen("multi.dat", "a");
			fprintf(fp, "%d\t%.4g\n", NrepeatValid+1, Vcell_ave*3600);
			fclose(fp);
			
			NrepeatValid++;
			if(repeatcnt<Nrepeat-1) reset();	// make sure smptot!=0
			repeatcnt++;
		}
		
		if(repeatcnt>=Nrepeat) terminate();
	#endif
	}
		
	glPopMatrix();
	glutSwapBuffers();
}


void RunGL(int *argc, char **argv)
{
	glutInit(argc,argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
//	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(Width,Height);
	glutInitWindowPosition(50,50);
	glutCreateWindow("Cell Moving Through Matrix");

	init_GL();
#if SAVPIC
	ilInit();	// initializing IL
#endif
	display_list();
	glutMouseFunc(mouse);
	glutMotionFunc(drag);
	glutReshapeFunc(changeSize);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc(arrow_keys);

	glutDisplayFunc(GLmain);
	glutIdleFunc(GLmain);
	glutMainLoop();
}


