
void PrintMembrane(void)	// prints the membrane
{
	int i;
	MEM_node *p;
	FILE *fp;

	fp=fopen("membrane.dat","w");
	
	if(N_MEM==0) { printf("N_MEM=0\n"); exit(0); }
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		printf("%d\t%.2f\t%.2f\n", p->id, p->r[0], p->r[1]);
		fprintf(fp, "%d\t%.2f\t%.2f\n", p->id, p->r[0], p->r[1]);
	}
	fclose(fp);
}



void GetMembraneShape1(double *r[2])	// circular membrane
{
	int i;
	double da, a;
	
	da=Pidb/N_MEM;
	for(i=0; i<N_MEM; i++) {
		a = i*da;
		r[i][0] = Rnuc[0]+R_MEM*sin(a);	// CW from 12 O'clock
		r[i][1] = Rnuc[1]+R_MEM*cos(a);
	}
}


void GetMembraneShape2(double *r[2])	// circular membrane + 1 protrusion
{
	int i, n1, n2, n3;
	double a1x, a10, a20;	// x: contacting angle, 0: starting angle, for circles 1 & 2
	double xcontact, x0shaft, x0circ2;
	double delta, L, L1, L2, a;
	double da1, da2, dL1, dL2;
	
	if(R_EXT > R_MEM) { printf("R_EXT too large!\n"); exit(0); }
	
	a1x = asin(1.0*R_EXT/R_MEM);	// angle at which extension is in contact with circle_1
	L1 = Pidb*R_MEM - 2.0*R_MEM*a1x;	// arc length of circle_1
	L2 = 2.0*L_EXT + Pi*R_EXT;	// contour length of protrusion region including shaft & circle_2
	L = L1 + L2;	// total contour length
	delta = L/N_MEM;	// interval between nodes
	n1 = (int)(L1/delta);	// # of nodes in circle_1
	
	a10 = (Pidb*R_MEM  - n1*delta)/2/R_MEM;	// starting angle for circle_1
	if(a10<a1x) { printf("a10=%.2f < a1x=%.2f\n", a10, a1x); exit(0); }
	da1 = (Pidb-2*a10)/n1;	// anglular interval for circle_1
	
	for(i=0; i<=n1; i++) {	// nodes in circle_1
		a = Pidb - (a10 + i*da1);	// nodes starts from bottom right of circle_1, then turn CW
		r[i][0] = Rnuc[0]+R_MEM*cos(a);
		r[i][1] = Rnuc[1]+R_MEM*sin(a);
	}
	
	dL1 = R_MEM*(a10-a1x);	// half of leftovers for circle_1
	n2 = (int)((L_EXT+dL1)/delta);	// # of nodes on one side of the shaft
	xcontact = Rnuc[0] + R_MEM*cos(a1x);	// x-coordinate of circle-shaft contacting point
	x0shaft = xcontact + (delta - dL1);	// starting x-cooridnate of nodes on upper shaft
	
	for(i=n1+1; i<=n1+n2; i++) {	// nodes on upper shaft
		r[i][0] = x0shaft + (i-n1-1)*delta;
		r[i][1] = Rnuc[1] + R_EXT;
	}
	for(i=N_MEM-1; i>=N_MEM-n2; i--) {	// nodes on lower shaft
		r[i][0] = x0shaft + (N_MEM-1-i)*delta;
		r[i][1] = Rnuc[1] - R_EXT;
	}
	
	dL2 = L_EXT - (n2*delta - dL1);	// leftovers for one side of the shaft
	n3 = (N_MEM - n2) - (n1 + n2);	// # of nodes in circle_2
	if(n3<0) { printf("n3<0\n"); exit(0); }
	a20 = (delta - dL2)/R_EXT;	// starting angle for circle_2
	if(a20<0) { printf("a20<0\n"); exit(0); }
	da2 = delta/R_EXT;
	x0circ2 = xcontact + L_EXT;	// starting x-coordinate for circle_2
	
	for(i=n1+n2+1; i<(N_MEM-n2); i++) {	// nodes on circle_2
		a = a20 + (i-n1-n2-1)*da2;	// angle from 12 O'clock, CW
		r[i][0] = x0circ2 + R_EXT*sin(a);
		r[i][1] = Rnuc[1] + R_EXT*cos(a);
	}
//	printf("n1, n2, n3 = %d, %d, %d\n", n1, n1+n2, n1+n2+n3);
}


void GetMembraneProp(void)	// initial setup: read MEM_node's r0 from vertices
{
	int i, il, ir;
	double **r;
	MEM_node *p;
	
	r = (double **)calloc(N_MEM, sizeof(double *));
	for(i=0; i<N_MEM; i++) r[i] = malloc(2*sizeof(double));
	
#if !EXTNSN
	GetMembraneShape1(r);
#else
	GetMembraneShape2(r);
#endif

	for(i=0; i<N_MEM; i++) {	// for each cell MEM_node, find MEM_node coordinates
		p = &MEM[i];
		p->id = i;
		p->contact = 0;
		p->health = 1;
		p->melt = 0;
		p->nctx = p->necm = 0;
		
		veccopy(r[i], p->r);
		veczero(p->dl);
		veczero(p->dlvec);
			
		il=i-1;
		ir=i+1;
		if(il<0) il=N_MEM-1;
		if(ir>N_MEM-1) ir=0;
		p->nbr[0] = il;
		p->nbr[1] = ir;
	}
	
	for(i=0; i<N_MEM; i++) {	// for each cell MEM_node, find initial rest length
		p = &MEM[i];
		il = p->nbr[0];
		ir = p->nbr[1];
		p->l0[0] = distance(MEM[il].r, p->r);
		p->l0[1] = distance(MEM[ir].r, p->r);
		veccopy(p->l0, p->l);
	}
	
	for(i=N_MEM-1; i>=0; i--) free(r[i]);
	free(r);
}


void GetMembraneGeometry(int state)	// update geometry after nodes' motion, state=0 for init, state=1 for others
{
	int i, il, ir;
	double r1[2], r2[2], nrm[2];
	double d, dmin;
	MEM_node *p;
	
	veczero(Rcell);
	Xmax=Ymax=-inf;
	Xmin=Ymin=inf;
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		il = p->nbr[0];
		ir = p->nbr[1];
		getnormal(MEM[il].r, p->r, MEM[ir].r, nrm);	// update normal
		
		p->A = p->r[1] - MEM[ir].r[1];
		p->B = -(p->r[0] - MEM[ir].r[0]);
		p->C = -(p->B)*(p->r[1]) - (p->A)*(p->r[0]);
		p->Denom = sqrt(pow(p->A,2)+pow(p->B,2));
		p->Denom = max2(p->Denom, eps);
		
		vecsub(MEM[ir].r, p->r, r1);	// r1 to r2
		normalize(r1, p->tngedge);
		p->nrmedge[0] = -(p->tngedge[1]);	// nrmedge = e_z x n12
		p->nrmedge[1] = p->tngedge[0];
		
	#if EXTNSN
		if(p->r[0] > Xmax) EXT_TIP_ID = i;	// for tip actin creation
	#endif
	
		Xmax=max2(Xmax, p->r[0]);
		Ymax=max2(Ymax, p->r[1]);
		Xmin=min2(Xmin, p->r[0]);
		Ymin=min2(Ymin, p->r[1]);
		
		if(state) {	// for t>0
			//if(dotprod(nrm, p->nrm)>0.0) veccopy(nrm, p->nrm);	// didn't change sign
			//else vecprod(nrm, -1.0, p->nrm);	// nrm changed sign due to convex->concave transition
			veccopy(nrm, p->nrm);
			
			/*
			if(dotprod(nrm, p->nrm)>0.0) vecadd(p->nrm, nrm, nrm);	//veccopy(nrm, p->nrm);	// didn't change sign
			else vecsub(p->nrm, nrm, nrm);	//vecprod(nrm, -1.0, p->nrm);	// nrm changed sign due to convex->concave transition
			normalize(nrm, p->nrm);
			*/
		}
		else {	// for t=0, initializing
			veccopy(nrm, p->nrm);
		
			p->tng[0] = p->nrm[1];	// clockwise tangential
			p->tng[1] =-p->nrm[0];
			
			vecsub(p->r, MEM[il].r, r1);
			vecsub(MEM[ir].r, p->r, r2);
			
			p->l[0] = distance(MEM[il].r, p->r);	// actual separation, left & right
			p->l[1] = distance(MEM[ir].r, p->r);
			
			p->dl[0] = p->l[0] - p->l0[0];	// deformation, left & right
			p->dl[1] = p->l[1] - p->l0[1];
			
			veccopy(p->r, MEMprev[i]);
		}
		
		vecadd(Rcell, p->r, Rcell);
	}
	vecdiv(Rcell, N_MEM, Rcell);	// position of cell center
	if(state==0) veccopy(Rcell, Rcellprev);
	
	// calc. cell area
	Area=0.0;
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		ir = p->nbr[1];
		Area+=triangleareasigndb(Rcell, p->r, MEM[ir].r);	// calc area of tirangle Rcell-r(i)-r(ir)
		// self-crossed area will reduce the total A, causing higher internal pressure, which helps relieve crossing
		
		#if ECMMLT
		if(state==0) {	// for initilization, after Rcell is obtained
		#if EXTNSN
			if(p->r[0]>Rnuc[0]+0.75*R_NUC && p->r[0]<Rnuc[0]+1.25*R_NUC) p->melt = 1;	// also defined in ecm.c
		#else
			if(p->nrm[0]>0 && fabs(p->r[1] - Rcell[1]) < R_MELT && p->r[0] > Rcell[0]) p->melt = 1;
			//if(p->nrm[0]>0 && fabs(p->r[1] - Rnuc[1]) < R_MELT && p->r[0] > Rcell[0]) p->melt = 1;
		#endif
			else p->melt = 0;
		}
		#endif
	}
	Area=0.5*fabs(Area);
	dArea=Area-Area0;
	
	TIP_ID=0;	// tip for ECM-melting
	dmin=inf;
	for(i=0; i<N_MEM; i++) {	// find the membrane at the leading edge that has the same y as NUC
		p = &MEM[i];
		d = fabs(p->r[1] - Rnuc[1]);	// vertical distance from NUC
		if(d<dmin && p->nrm[0]>0) {
			dmin = d;
			TIP_ID = i;
		}
	}
}



void BuildMEM(void)
{
	MEM=(MEM_node *)malloc(N_MEM*sizeof(MEM_node));
	GetMembraneProp();
	GetMembraneGeometry(0);
	Area0=Area;
	//PrintMembrane(MEM);
}



void CleanMEM(void)
{
	if(MEM) free(MEM);
	MEM=NULL;
}


