
void limitECMmotion(ECM_node *p, double dr[2])	// dr is the displacement of node
{
	double n;
	n=max2(p->nnbr, 1.0);	
	n+=(p->contact);
	if(n>mjuECMksdtinv) vecdiv(p->dlvec, n, dr);
}



void UpdateECM_Nbrs(int status)	// update positions of each node's neighbors regarding to head nodes' positions
{	// status=1: update p->nnbr. status=0: don't update p->nnbr
	int i, n;
	ECM_node *p;
	
	for(i=0; i<N_ECM; i++) {
		n=0;
		p = ECM[i]->next;	// neighbors
		while(p) {
			if(status) {
				if(p->connected == 1) n++;
			}
			veccopy(ECM[p->id]->r, p->r);	// update p->r from head node
			p = p->next;
		}
		if(status) ECM[i]->nnbr = n;
	}
}



void ECMMotion1(void)
{
	int i;
	double dr[2];
	ECM_node *p;
	
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->bnd == 0) {	// don't move boundary nodes
			vecprod(p->dlvec, mjuECMksdt, dr);
			limitECMmotion(p, dr);
			vecadd(p->r, dr, p->r);
			
			if(p->r[1]>YLENhalf) p->r[1] = YLENhalf;	// hard wall
			else if(p->r[1]<-YLENhalf) p->r[1] = -YLENhalf;
		}
	}
	
	UpdateECM_Nbrs(1);	// update all the rest nodes' positions & p->nnbr
}



void ECMMotion(void)
{
	int i;
	double n, dr[2];
	ECM_node *p;
	
	for(i=N_ECM-1; i>=0; i--) {
		p=ECM[i];
		if(p->bnd == 0 && p->connected == 1 && p->nnbr > 0) {	// don't move boundary nodes
			//vecprod(p->dlvec, mjuECMksdt, dr);
			//limitECMmotion(p, dr);
			
			n = 1.0*(p->nnbr);
			vecdiv(p->dlvec, n, dr);	// divided by # of links
			
			limitvector(dr, limECM);
			vecadd(p->r, dr, p->r);
			
			if(p->r[1]>YLENhalf) p->r[1] = YLENhalf;	// hard wall
			else if(p->r[1]<-YLENhalf) p->r[1] = -YLENhalf;
		}
	}
	
	UpdateECM_Nbrs(1);	// update all the rest nodes' positions & p->nnbr
}


void ECMfluctuation(void)
{
	int i, j;
	ECM_node *p;
	
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->bnd == 0 && p->connected == 1) {
			for(j=0; j<2; j++) p->r[j] += ksiECMfluct*(1-2*ran2(&mseed));
			
			if(p->r[1]>YLENhalf) p->r[1] = YLENhalf;	// hard wall
			else if(p->r[1]<-YLENhalf) p->r[1] = -YLENhalf;
		}
	}
	
	UpdateECM_Nbrs(0);	// update all the rest nodes' positions w/o updating p->nnbr
}



//-----------------------------------------


void limitCTXmotion(CTX_node *p, double dr[2])	// dr is the displacement of node
{
	double n;
	n=max2(p->nnbr, 1.0);
	n+=(p->contact);
	if(n>mjuCTXksdtinv) vecdiv(p->dlvec, n, dr);
}


void UpdateCTX_Nbrs(int status)	// update positions of each node's neighbors regarding to head nodes' positions
{	// status=1: update p->nnbr. status=0: don't update p->nnbr
	int i, n;
	CTX_node *p;
	
	for(i=0; i<N_CTX; i++) {
		n=0;
		p = CTX[i]->next;	// neighbors
		while(p) {
			if(status) {
				if(p->connected == 1) n++;
			}
			veccopy(CTX[p->id]->r, p->r);	// update p->r from head node
			p = p->next;
		}
		if(status) CTX[i]->nnbr = n;
	}
}


void CTXMotion(void)
{
	int i;
	double n, dr[2];
	CTX_node *p;
	
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		//vecprod(p->dlvec, mjuCTXksdt, dr);
		//limitCTXmotion(p, dr);
		
		n = max2(p->nnbr, 1);
		vecdiv(p->dlvec, n, dr);
		
		limitvector(dr, ksiCTX);
		vecadd(p->r, dr, p->r);
	}
	UpdateCTX_Nbrs(1);	// update all the rest nodes' positions & p->nnbr
}


void CTXfluctuation(void)
{
	int i, j;
	CTX_node *p;
	
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		if(p->connected == 1) {
			for(j=0; j<2; j++) p->r[j] += ksiCTXfluct*(1-2*ran2(&mseed));
		}
	}
	UpdateCTX_Nbrs(0);	// update all the rest nodes' positions
}


//-------------------------------------------

/*
void HandleMEMcrossing(void)
{
	int i;
	
	if(InspectMEMcross()) {
		for(i=0; i<N_MEM; i++) veccopy(MEMprev[i], MEM[i].r);	// revert motion
	}
	else {
		for(i=0; i<N_MEM; i++) veccopy(MEM[i].r, MEMprev[i]);	// update history
	}
}
*/


void CheckMEMcrossing(void)	// to mark m->health
{
	int i, j, di, dj, is, js, cnt;
	int xi[30], xj[30];	// list of crossing nodes
	MEM_node *p, *q, *r, *s;
	
	for(i=0; i<N_MEM; i++) MEM[i].health=1;
	
	cnt=0;
	for(i=0; i<N_MEMm3; i++) {
		p = &MEM[i];
		q = &MEM[p->nbr[1]];	// right neighbor
		j = i+2;
		if(j<N_MEM) {
			for(; j<N_MEMm1; j++) {
				r = &MEM[j];
				s = &MEM[r->nbr[1]];	// right neighbor
				if(SegSegIntersectProp(p->r, q->r, r->r, s->r) && cnt<30) {
					xi[cnt]=i;
					xj[cnt]=j;
					cnt++;
					//printf("%d\t%d\n", i, j);
				}
			}
		}
	}
	
	if(cnt==0) return;
	else ValidRun=0;
	
	for(i=0; i<cnt; i++) {
		j=i+1;
		if(j==cnt) j=0;
		di=abs(xi[i]-xi[j]);
		dj=abs(xj[i]-xj[j]);
		if(di>N_MEMhalf) di=N_MEM-di;
		if(dj>N_MEMhalf) dj=N_MEM-dj;
		if(di==0 && dj==1) MEM[xj[j]].health = 0;	// same i for 2 rows, meaning j of the 2nd row is intruding i->(i+1)
		else if(dj==0 && di==1) MEM[xi[j]].health = 0;	// same j for 2 rows, meaning i of the 2nd row is intruding j->(j+1)
		else {	// just neighbor crossing
			if(xj[i]==xi[i]+2 || xj[i]==xi[i]+N_MEM-2) {	// make sure it is neighbor-crossing
				p = &MEM[xi[i]];
				MEM[p->nbr[1]].health = 0;
				MEM[xj[i]].health = 0;
			}
			else {
				if(xj[i]-xi[i]<N_MEMhalf) {	// i->j is clockwise
					is=xi[i];	// i
					js=xj[i];	// j
				}
				else {	// jump at 0, make i->j clockwise
					is=xj[i];	// i
					js=xi[i];	// j
				}
				// now swap i+1 & j
				is=MEM[is].nbr[1];
				js=MEM[js].nbr[1];
				do {
					MEM[is].health = 0;
					is = MEM[is].nbr[1];
				} while(is!=js);
			}
		}
	}
}

	

void HandleMEMcrossing(void)	// return 1 if there is a crossing
{
	int i, j, is, js, cnt;
	int xi[10], xj[10];	// list of crossing nodes
	double r1[2], dr[2];
	MEM_node *p, *q, *r, *s;
	
	cnt=0;
	for(i=0; i<N_MEMm3; i++) {
		p = &MEM[i];
		q = &MEM[p->nbr[1]];	// right neighbor
		j = i+2;
		if(j<N_MEM) {
			for(; j<N_MEMm1; j++) {
				r = &MEM[j];
				s = &MEM[r->nbr[1]];	// right neighbor
				if(SegSegIntersectProp(p->r, q->r, r->r, s->r)) {
					xi[cnt]=i;
					xj[cnt]=j;
					cnt++;
					printf("%d\t%d\n", i, j);
				}
			}
		}
	}
	
	if(cnt==0) return;
	
	printf("x\n");
	if(cnt==1) {	// one crossing
		if(xj[0]==xi[0]+2 || xj[0]==xi[0]+N_MEM-2) {	// if it is neighbor-crossing
			p = &MEM[xi[0]];
			q = &MEM[p->nbr[1]];	// swap q=i+1 and r=j
			r = &MEM[xj[0]];
			vecswap(q->r, r->r);
		}
		else {
			if(xj[0]-xi[0]<N_MEMhalf) {	// i->j is clockwise
				is=xi[0];	// i+1
				js=xj[0];	// j
			}
			else {	// jump at 0, make i->j clockwise
				is=xj[0];	// i
				js=xi[0];	// j+1
			}
			// now swap i+1 & j
			is=MEM[is].nbr[1];
			do {	// swap all the nodes in the small loop
				vecswap(MEM[is].r, MEM[js].r);
				is=MEM[is].nbr[1];	// move along the small loop
				js=MEM[js].nbr[0];
			} while(MEM[is].nbr[1]!=js && MEM[is].nbr[1]!=MEM[js].nbr[0]);
		}
	}
	else {	// more than one crossing
		for(i=0; i<cnt; i++) {
			j=i+1;
			if(j==cnt) j=0;
			if(xi[i]==xi[j]) {	// same i for 2 rows, meaning j of the 2nd row is intruding i->(i+1)
				q = &MEM[xj[j]];
				p = &MEM[q->nbr[0]];
				r = &MEM[q->nbr[1]];
				r1[0] = (p->r[0] + r->r[0])/2;	// middle of j-1 & j+1
				r1[1] = (p->r[1] + r->r[1])/2;
				vecsub(r1, q->r, dr);
				vecadd(r1, dr, q->r);	// new position for j-th node: symmetric about middle of j-1 & j+1
			}
			else if(xj[i]==xj[j]) {	// same j for 2 rows, meaning i of the 2nd row is intruding j->(j+1)
				q = &MEM[xi[j]];
				p = &MEM[q->nbr[0]];
				r = &MEM[q->nbr[1]];
				r1[0] = (p->r[0] + r->r[0])/2;	// middle of j-1 & j+1
				r1[1] = (p->r[1] + r->r[1])/2;
				vecsub(r1, q->r, dr);
				vecadd(r1, dr, q->r);	// new position for i-th node: symmetric about middle of i-1 & i+1
			}
			else {	// just neighbor crossing
				if(xj[i]==xi[i]+2 || xj[i]==xi[i]+N_MEM-2) {	// make sure it is neighbor-crossing
					p = &MEM[xi[i]];
					q = &MEM[p->nbr[1]];	// swap q=i+1 and r=j
					r = &MEM[xj[i]];
					vecswap(q->r, r->r);
				}
				else {
					if(xj[i]-xi[i]<N_MEMhalf) {	// i->j is clockwise
						is=xi[i];	// i+1
						js=xj[i];	// j
					}
					else {	// jump at 0, make i->j clockwise
						is=xj[i];	// i
						js=xi[i];	// j+1
					}
					// now swap i+1 & j
					is=MEM[is].nbr[1];
					do {	// swap all the nodes in the small loop
						vecswap(MEM[is].r, MEM[js].r);
						is=MEM[is].nbr[1];	// move along the small loop
						js=MEM[js].nbr[0];
					} while(MEM[is].nbr[1]!=js && MEM[is].nbr[1]!=MEM[js].nbr[0]);
				}
			}
		}
	}
}


void MEMMotion1(void)
{	// run this after MEMforce is updated
	int i, flg;
	double n, dr[2];
	MEM_node *p;
	
	if(ran2(&mseed)<0.5) flg=1;
	else flg=0;
	
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		n = 2.0 + (p->nctx)*ksCTX_MEM + (p->necm)*ksECM_MEM;	// 2 stretch + 4 bend
		vecdiv(p->dlvec, n, dr);	// 2 links per node, ignoring CTX & ECM
		//limitvector(dr, ksiMEM);
		vecadd(p->r, dr, p->r);
	}
	
	//HandleMEMcrossing();
	GetMembraneGeometry(1);
}



void MEMMotion(void)
{	// run this after MEMforce is updated
	int i;
	double n, dr[2];
	MEM_node *p;
	
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		n = 4.0 + (p->nctx)*ksCTX_MEM + (p->necm)*ksECM_MEM;	// 2 stretch + 4 bend
		vecdiv(p->dlvec, n, dr);	// 2 links per node, ignoring CTX & ECM
		limitvector(dr, limMEM);
		vecadd(p->r, dr, p->r);
	}
	
	//if(ran2(&mseed)<0.2) HandleMEMcrossing();
	//HandleMEMcrossing();
	
	CheckMEMcrossing();	// affects both ctx creation and mem force
	GetMembraneGeometry(1);
}


void MEMfluctuation(void)
{
	int i, j;
	MEM_node *p;
	
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		for(j=0; j<2; j++) p->r[j] += ksiMEMfluct*(1.0-2*ran2(&mseed));
	}
}


//-------------------------------------------

void NUCMotion1a(void)	// fixing nucleus's velocity
{
	double n, dy;
	
	n=NcontactCTXNUC+NcontactMEMNUC/ksCTX_MEM+NcontactECMNUC/ksCTX_ECM;
	n=max2(n,LinkPerNode);
	n/=2;
	if(n==0) dy=0.0;
	else dy=Fnuc[1]/n;
	
	Rnuc[0] += V0dt;	// bead motion
	Rnuc[1] += dy;
}


void NUCMotion1b(void)	// fixing nucleus's force
{
	double n, dr[2];
	
	n=NcontactCTXNUC+NcontactMEMNUC/ksCTX_MEM+NcontactECMNUC/ksCTX_ECM;
	n=max2(n,LinkPerNode);
	n/=2;
	if(n==0) {
		dr[0]=mjuNUCksdt*dLloadCTX;
		dr[0]=min2(dr[0], 0.1*ksiCTX);
		dr[1]=0.0;
	}
	else {
		dr[0]=(Fnuc[0]+dLloadCTX)/n;
		dr[1]=Fnuc[1]/n;
	}
	vecadd(Rnuc, dr, Rnuc);
}


void NUCMotion(void)	// contraction force
{
	double n, dr[2];
	
	n=NcontactCTXNUC+NcontactMEMNUC/ksCTX_MEM+NcontactECMNUC/ksCTX_ECM;
	n=max2(n, LinkPerNode);
	
	n*=2;
	
	vecdiv(Fnuc, n, dr);
	limitvector(dr, limNUC);
	vecadd(Rnuc, dr, Rnuc);
	
	Xnucmax=Rnuc[0]+R_NUC;
	Xnucmin=Rnuc[0]-R_NUC;
	Ynucmax=Rnuc[1]+R_NUC;
	Ynucmin=Rnuc[1]-R_NUC;
}


//-------------------------------------------


void ShiftCell(void)	// overall shifting of cell due to net external force from ECM
{
	int i;
	double r[2], dr[2];
	MEM_node *p;
	
	//NcontactECMMEM*=2;	// two links per ECM node
	
	if(NcontactECMMEM==0) {	// no contact
		veczero(r);
		for(i=0; i<N_MEM; i++) {
			p = &MEM[i];
			vecadd(r, p->r, r);
		}
		vecdiv(r, N_MEM, r);	// r is the current cell center
		vecsub(Rcellprev, r, dr);	// cell is immobile
	}
	else vecdiv(Fcell, NcontactECMMEM, dr);	// Fcell is in ECM's scale
	
	limitvector(dr, limCELL);
	
	for(i=0; i<N_MEM; i++) vecadd(MEM[i].r, dr, MEM[i].r);
	
	for(i=0; i<N_CTX; i++) vecadd(CTX[i]->r, dr, CTX[i]->r);	// don't add these two lines
	vecadd(Rnuc, dr, Rnuc);
}


void ShiftCYTO(void)	// overall shifting of cytoplasm due to net external force from MEM
{
	int i;
	double dr[2];
	
	//NcontactMEMCYTO*=0.5;	// only half of the side is opposing this motion
	NcontactMEMCYTO=max2(NcontactMEMCYTO,10);
	vecdiv(Fcyto, NcontactMEMCYTO, dr);
	limitvector(dr, limECM);
	
	for(i=0; i<N_CTX; i++) vecadd(CTX[i]->r, dr, CTX[i]->r);
	
	vecadd(Rnuc, dr, Rnuc);
}


//-------------------------------------------


int InspectCTXcross(double r1[2], double r2[2])
{
	int i, z;
	MEM_node *p, *q;
	
	z=0;
	for(i=0; i<N_MEM && z==0; i++) {
		p = &MEM[i];
		q = &MEM[p->nbr[1]];	// right neighbor
		z = SegSegIntersectProp(r1, r2, p->r, q->r);
	}
	return z;
}



void ExcludeMEM(double r1[2], double r2[2])
{
	int i, id[2], cnt, imin, imax, flg;
	double n12[2], r13[2], r, ri[2];
	MEM_node *p, *q;
	
	cnt=0;
	for(i=0; i<N_MEM && cnt<2; i++) {
		p = &MEM[i];
		q = &MEM[p->nbr[1]];	// right neighbor
		if(SegSegIntersectProp(r1, r2, p->r, q->r)) {
			id[cnt]=i;
			cnt++;
		}
	}
	if(cnt<2) return;
	
	imin=min2(id[0], id[1]);
	imax=max2(id[0], id[1]);
	if(imax-imin<N_MEMhalf) flg=1;	// cw continuously
	else flg=0;	// jump at 12 O'clock
	
	if(flg) {
		for(i=imin; i<=imax; i++) {	// project mem node-i onto r1-r2
			p = &MEM[i];
			vecsub(r2, r1, n12);	// if A=r1, B=r2, C=r3, D=project r3 to r1-r2
			normalize(n12, n12);	// then, D=A+(AC.n_AB)n_AB
			vecsub(p->r, r1, r13);
			r=dotprod(r13, n12);
			vecprod(n12, r, ri);
			vecadd(ri, r1, ri);
			veccopy(ri, p->r);	// mem node is projected onto ctx link
		}
	}
	else {
		for(i=imax; i<N_MEM; i++) {
			p = &MEM[i];
			vecsub(r2, r1, n12);	// if A=r1, B=r2, C=r3, D=project r3 to r1-r2
			normalize(n12, n12);	// then, D=A+(AC.n_AB)n_AB
			vecsub(p->r, r1, r13);
			r=dotprod(r13, n12);
			vecprod(n12, r, ri);
			vecadd(ri, r1, ri);
			veccopy(ri, p->r);	// mem node is projected onto ctx link
		}
		for(i=0; i<imin; i++) {
			p = &MEM[i];
			vecsub(r2, r1, n12);	// if A=r1, B=r2, C=r3, D=project r3 to r1-r2
			normalize(n12, n12);	// then, D=A+(AC.n_AB)n_AB
			vecsub(p->r, r1, r13);
			r=dotprod(r13, n12);
			vecprod(n12, r, ri);
			vecadd(ri, r1, ri);
			veccopy(ri, p->r);	// mem node is projected onto ctx link
		}
	}
}



void MEMCTXexclude(void)	// to avoid segment-segment intersection
{
	int i;
	CTX_node *p, *q;
	
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		if(p->nearmem) {
			q = p->next;
			while(q) {
				ExcludeMEM(p->r, q->r);
				q = q->next;
			}
		}
	}
}

//-------------------------------------------

void ECMCTXAdhesion(void)
{
	int i;
	double r[2], dr[2], n1k1, n2k2, ntkt;
	CTX_node *c;
	ECM_node *e;
	
	for(i=0; i<N_CTX; i++) {
		c = CTX[i];
		if(c->adhere == 1) {
			e = ECM[c->adhereid];
			n1k1=(c->nnbr)*ksCTX;
			n2k2=(e->nnbr)*ksECM;
			ntkt=n1k1+n2k2;
			if(ntkt>0) {
				vecsub(e->r, c->r, r);	// displacement from CTX to ECM
				if(norm(r)<ksiCTXmin) {	// small separation, just merge the two nodes
					vecprod(r, n2k2/ntkt, dr);	// move to somewhere in between
					vecadd(c->r, dr, c->r);
					veccopy(c->r, e->r);
				}
				else {	// large separation
					limitvector(r, ksiCTXmin);
					vecprod(r, n2k2/ntkt, dr);
					vecadd(c->r, dr, c->r);
					if(n2k2>0) {
						vecprod(dr, -n1k1/n2k2, dr);
						vecadd(e->r, dr, e->r);
					}
				}
			}
		}
	}
	
	UpdateECM_Nbrs(0);	// update all the rest nodes' positions
	UpdateCTX_Nbrs(0);
}



void ECMCTXAdhesionTIP(void)
{
	int i;
	double r[2], dr[2], n1k1, n2k2, ntkt;
	CTX_node *c;
	ECM_node *e;
	
	for(i=0; i<N_CTX; i++) {
		c = CTX[i];
		if(c->adhere == 1) {
			e = ECM[c->adhereid];
			n1k1=(c->nnbr)*ksCTX;
			n2k2=(e->nnbr)*ksECM;
			ntkt=n1k1+n2k2;
			if(ntkt>0) {
				vecsub(e->r, c->r, r);	// displacement from CTX to ECM
				vecprod(r, n2k2/ntkt, dr);		// just merge the two nodes
				vecadd(c->r, dr, c->r);
				veccopy(c->r, e->r);
			}
		}
	}
	
	UpdateECM_Nbrs(0);	// update all the rest nodes' positions
	UpdateCTX_Nbrs(0);
}

//-------------------------------------------

void FlushTracking(int n)
{
	int i;
	FILE *fp;
	
	n_track+=n;
	fp=fopen("track.dat","a");
	for(i=0; i<n; i++) {
		fprintf(fp, "%.4g\t%.5g\t%.5g\n", smp_t_buffer[i], smp_x_buffer[i], smp_y_buffer[i]);
	}
	fclose(fp);
}


void SaveTracking(void)
{
	smp_cnt++;
	if(smp_cnt >= smp_skip) {	// time to record
		smp_t_buffer[smp_ptr]=t;
		//smp_x_buffer[smp_ptr]=Rcell[0];	// save the position of cell center
		//smp_y_buffer[smp_ptr]=Rcell[1];
		smp_x_buffer[smp_ptr]=Rnuc[0];	// save the position of nucleus
		smp_y_buffer[smp_ptr]=Rnuc[1];
		smp_ptr++;
		
		if(smp_ptr>=smp_buffer) {
			FlushTracking(smp_bufferm1);
			smp_ptr=0;
		}
		
		smp_cnt=0;
	}
}


void GetAllMotions(void)
{
	ECMMotion();
	CTXMotion();
	MEMMotion();
	NUCMotion();
	
#if CTXADH
	ECMCTXAdhesion();
#endif

#if EXTNSN
	ECMCTXAdhesionTIP();
#endif

	//GetAllForces();
	
	ShiftCell();
	ShiftCYTO();
	
//	MEMCTXexclude();
	
	UpdateCTX_Nbrs(0);
}


void GetAllFluctuations(void)
{
	ECMfluctuation();
	CTXfluctuation();
	MEMfluctuation();
	// ignore NUC fluctuations
}

