
void skip(FILE *fp)
{
	char ch;
	do {
		ch=fgetc(fp);
	} while(ch!='\n' && ch!=EOF);
}


float GridSearch1(void)
{
	float z;
	if(Para1min<=0) z=Para1min+(ThisSrch-1.0)/max2(Nsrch1-1.0,1.0)*(Para1max-Para1min);
	else if(Para1max/Para1min<50) z=Para1min+(ThisSrch-1.0)/max2(Nsrch1-1.0,1.0)*(Para1max-Para1min);
	else z=exp((log(Para1max)-log(Para1min))*((ThisSrch-1.0)/max2(Nsrch1-1.0,1.0))+log(Para1min));
	return z;
}


void GridSearch2(float *x, float *y)
{
	int i, j;

	// change #2 first
	///*		
	i=(int)((ThisSrch-1)/Nsrch2);	// row #
	j=(ThisSrch-1)-i*Nsrch2;	// column #
	//*/

	// change #1 first
	/*
	j=(int)((ThisSrch-1)/Nsrch1);	// column #
	i=(ThisSrch-1)-j*Nsrch1;	// row #
	*/

	if(Para1min<=0) *x=Para1min+i/max2(Nsrch1-1.0,1.0)*(Para1max-Para1min);
	else if(Para1max/Para1min<50) *x=Para1min+i/max2(Nsrch1-1.0,1.0)*(Para1max-Para1min);
	else *x=exp((log(Para1max)-log(Para1min))*(i/max2(Nsrch1-1.0,1.0))+log(Para1min));
	
	if(Para2min<=0) *y=Para2min+j/max2(Nsrch2-1.0,1.0)*(Para2max-Para2min);
	else if(Para2max/Para2min<50) *y=Para2min+j/max2(Nsrch2-1.0,1.0)*(Para2max-Para2min);
	else *y=exp((log(Para2max)-log(Para2min))*(j/max2(Nsrch2-1.0,1.0))+log(Para2min));
}


void ParaSearch(void)	// possible variables: ksiECM, kdadh, Y_ECM ...
{
	FILE *fp;
	
	fp=fopen("search.ini", "r");
	if(!fp) {
		printf("Error: cannot open file 'search.ini'.\n\n");
		//printf("Press Enter to exit...");
		//(void) getchar();
		exit(0);
	}
	if(SEARCH==1) {	// do searching
		fscanf(fp, "%s %f %f", SrchVar1, &Para1min, &Para1max);
		if(SRCHNO==1) {
			Para1=GridSearch1();
			ksiECM=Para1;	// change the variable if necessary !!!
			//kdadh=Para1;
			//Y_ECM=Para1;
			//Vg=Para1;
			//Vs=Para1;
		}
		else if(SRCHNO==2) {
			skip(fp);
			fscanf(fp, "%s %f %f", SrchVar2, &Para2min, &Para2max);
			GridSearch2(&Para1, &Para2);	// change the variables if necessary !!!
			ksiECM=Para1;	// change the variable if necessary !!!
			kdadh =Para2;
		}
	}
}


void readpara(void)
{
	char var[50];
	FILE *fp;

	fp=fopen("paras.ini", "r");
	if(!fp) {
		printf("Error: cannot open file 'para.ini'.\n\n");
		//printf("Press Enter to exit...");
		//(void) getchar();
		exit(0);
	}
	
	fscanf(fp, "%s %f", var, &XLEN);
	skip(fp);
	fscanf(fp, "%s %f", var, &YLEN);
	skip(fp);
	fscanf(fp, "%s %f", var, &ksiECM);
	skip(fp);
	fscanf(fp, "%s %f", var, &varECM);
	skip(fp);
	fscanf(fp, "%s %f", var, &R_MEM);
	skip(fp);
	fscanf(fp, "%s %f", var, &R_NUC);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &L_EXT);
	skip(fp);
	fscanf(fp, "%s %f", var, &R_EXT);
	skip(fp);
	fscanf(fp, "%s %f", var, &W_EXTADH);
	skip(fp);
	fscanf(fp, "%s %f", var, &L_EXTADH);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &R_MELTfct);
	skip(fp);
	fscanf(fp, "%s %f", var, &R_TIPfct);
	skip(fp);
	fscanf(fp, "%s %d", var, &N_ADH_MAX);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &knuc);
	skip(fp);
	fscanf(fp, "%s %f", var, &knuctip);
	skip(fp);
	fscanf(fp, "%s %f", var, &nucbias);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &kdis);
	skip(fp);
	fscanf(fp, "%s %f", var, &kdadh);
	skip(fp);
	fscanf(fp, "%s %f", var, &knadh);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &Vg);
	skip(fp);
	fscanf(fp, "%s %f", var, &Vs);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &fbrECM);
	skip(fp);
	fscanf(fp, "%s %f", var, &Y_ECM);
	skip(fp);
	fscanf(fp, "%s %f", var, &ksCTX);
	skip(fp);
	fscanf(fp, "%s %f", var, &ksMEM);
	skip(fp);
	fscanf(fp, "%s %f", var, &kbMEM);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &LminCTXfct);
	skip(fp);
	fscanf(fp, "%s %f", var, &LmaxCTXfct);
	skip(fp);
	
	fscanf(fp, "%s %f", var, &eta);
	skip(fp);
	fscanf(fp, "%s %f", var, &dlt);
	skip(fp);
	
	fscanf(fp, "%s %d", var, &Nrepeat);
	skip(fp);
	fscanf(fp, "%s %f", var, &Tmax);
	skip(fp);
	fscanf(fp, "%s %f", var, &Tsmp);
	skip(fp);
	fscanf(fp, "%s %f", var, &smp_dt);
	skip(fp);
	
	fscanf(fp, "%s %d", var, &Width);
	skip(fp);
	fscanf(fp, "%s %d", var, &Height);
	skip(fp);
	fscanf(fp, "%s %f", var, &ZOOM);
	fclose(fp);
	
#if !OPENGL && SEARCH
	ParaSearch();
#endif
}



void showpara(void)
{
	printf("================\n");
	printf("XLEN = %.4g\n", XLEN);
	printf("YLEN = %.4g\n", YLEN);
	printf("ksiECM = %.4g\n", ksiECM);
	printf("varECM = %.4g\n", varECM);
	printf("R_MEM = %.4g\n", R_MEM);
	printf("R_NUC = %.4g\n", R_NUC);
	printf("L_EXT = %.4g\n", L_EXT);
	printf("R_EXT = %.4g\n", R_EXT);
	printf("W_EXTADH = %.4g\n", W_EXTADH);
	printf("L_EXTADH = %.4g\n", L_EXTADH);
	printf("R_MELTfct = %.4g\n", R_MELTfct);
	printf("R_TIPfct = %.4g\n", R_TIPfct);
	printf("N_ADH_MAX = %d\n", N_ADH_MAX);
	printf("knuc = %.4g\n", knuc);
	printf("knuctip = %.4g\n", knuctip);
	printf("nucbias = %.4g\n", nucbias);
	printf("kdis = %.4g\n", kdis);
	printf("kdadh = %.4g\n", kdadh);
	printf("knadh = %.4g\n", knadh);
	printf("Vg = %.4g\n", Vg);
	printf("Vs = %.4g\n", Vs);
	printf("fbrECM = %.4g\n", fbrECM);
	printf("Y_ECM = %.4g\n", Y_ECM);
	printf("ksCTX = %.4g\n", ksCTX);
	printf("ksMEM = %.4g\n", ksMEM);
	printf("kbMEM = %.4g\n", kbMEM);
	printf("LminCTXfct = %.4g\n", LminCTXfct);
	printf("LmaxCTXfct = %.4g\n", LmaxCTXfct);
	printf("eta = %.4g\n", eta);
	printf("dlt = %.4g\n", dlt);
	printf("Nrepeat = %d\n", Nrepeat);
	printf("Tmax = %.4g\n", Tmax);
	printf("Tsmp = %.4g\n", Tsmp);
	printf("smp_dt = %.4g\n", smp_dt);
	printf("Width = %d\n", Width);
	printf("Height = %d\n", Height);
	printf("ZOOM = %.4g\n", ZOOM);
	
	printf("================\n\n");
}


void adjustpara(void)	// adjust parameters
{
	XLEN=max2(XLEN, 6*ksiECM);
	YLEN=max2(YLEN, 4*ksiECM);
	//fbrECM*=Y_ECM/10.0;	// braking force scales linearly with Y_ECM (ks~Y, dE~Y -> fbr^2~dE*Ks -> fbr~Y)
}


void getconst(void)
{
	double k;
	
	adjustpara();
	
	dt=2.0;
	
	smpskip=(int)(Tsmp/dt);	// frequency to sample Fnuc & Vnuc
	smpdt=smpskip*dt;
	
	smp_bufferm1=smp_buffer-1;
	R_MELT=R_MELTfct*R_MEM;
	R_TIP=R_TIPfct*ksiECM;
	
	limNUC=min2(Vg*dt, ksiECM);
	limCELL=limNUC;
	smp_skip=(int)(smp_dt/dt+0.1);
	
	Vgdt=Vg*dt;
	Vsdt=Vs*dt;
	knucdt=knuc*dt;
	knuctipdt=knuctip*dt;
	kdisdt=kdis*dt;
	Tdadh=1.0/kdadh;
	Tnadh=1.0/knadh;
	probnucfront=(1+nucbias)/2.0;
	
	R_MEM2=R_MEM*R_MEM;
	R_NUC2=R_NUC*R_NUC;
	R_MEMdb=2.0*R_MEM;
	R_NUCdb=2.0*R_NUC;
	if(R_MEM<=R_NUC) { printf("Error: Rmem < Rnuc\n"); exit(0); }

	// tunnel
	XLENhalf=0.5*XLEN;
	YLENhalf=0.5*YLEN;
	ECMarea=XLEN*YLEN;

	LeftBnd=-XLENhalf;	// left boudnary for REPEAT & calc <F>
	RightBnd=XLENhalf-ksiECM;	// right boundary for calc. <F>
	
	// ECM
	ksECM=Y_ECM*ksiECM;	// ks=Y*ksi is the linear spring const.
	ksECMlayer=ksECMlayerFCT*ksECM;

	ksiECMmin=0.2*ksiECM;
	ksiECMheight=sqrt(3)*ksiECM/2;
	ksiECMminpVsdt=ksiECMmin+Vsdt;
	ksiECMfluct=sqrt(2.0*4.5e-3/6/ksECM);	// 1kT=4.5pN*nm=4.5e-3pN*um
	limECM=0.1*min2(ksiECM, fbrECM/ksECM);

	Nx_ECM=(int)(XLEN/ksiECM+0.5);
	Ny_ECM=(int)(YLEN/ksiECMheight+0.5);
	N_ECM=(Nx_ECM+1)*(Ny_ECM+1);
	Nx_ECMp1=Nx_ECM+1;	// for processing boudaries
	N_ECM_plus=(Nx_ECM+2)*(Ny_ECM+1);	// for processing boudaries

	dlbrECM=fbrECM/ksECM;

	// CTX
	N_CTX_INI=(int)(knuc/kdis+0.5);
	ksiCTX=sqrt(Pi*R_MEM2/N_CTX_INI);	// average meshsize for CTX
	ksiCTXmin=LminCTXfct*R_MEM;	//0.2*ksiCTX;
	ksiCTXmax=LmaxCTXfct*R_MEM;	//6.0*ksiCTX;
	ksiCTXminpVsdt=ksiCTXmin+Vsdt;
	ksiCTXmaxpVgdt=ksiCTXmax+Vgdt;
	ksiCTXfluct=sqrt(2.0*4.5e-3/6/ksCTX);	// 1kT=4.5pN*nm=4.5e-3pN*um

	//ksiCTXnewposmax=1.0*min2(ksiCTX, ksiMEM);
	ksiCTXnewposmax=0.2*ksiCTX;
	ksiCTXnbrmin=2.0*ksiCTX;
	ksiCTXnbrmax=1.0*R_MEM;

	dlbrCTX=fbrCTX/ksCTX;

	// MEM
	N_MEMhalf=N_MEM/2;
	N_MEMm1=N_MEM-1;
	N_MEMm3=N_MEM-3;

	ksiMEM=Pidb*R_MEM/N_MEM;	// average segment-length of membrane links
	
	kbMEM=max2(1.0, Y_ECM*ksiECM*pow(ksiMEM,2)/pow(2.0,2));	// mem-ecm force, max bending angle =2.0
	k=1.0/(1.0/(ksMEM/2)+1.0/ksCTX);        // effective spring constant between ctx & mem
	kbMEM=max2(kbMEM, Vg*dt*k*ksiMEM/2.0);	// mem-ctx torque=vg*dt*k*dl, max bending angle =2.0
	
	ksiMEMfluct=sqrt(2.0*4.5e-3/6/ksiMEM);	// 1kT=4.5pN*nm=4.5e-3pN*um
	kb_ksMEM=kbMEM/ksMEM;
	N_TIP_SEG=(int)(L_EXTADH/ksiECM);
	
	limMEM=0.2*ksiMEM;
	AngMemSelfAvoid=150.0*d2r;	// beyond this angle membrane tries to avoid itself
	FmaxMemSelfAvoid=0.5*ksiMEM;
	R_memavoid=AvoidFactor*ksiMEM;
	R_memavoiddb=2.0*R_memavoid;
	DLmax_memavoid=AvoidDLmaxFct*ksiMEM;
	AvoidDLmaxFct=max2(kbMEM/ksiECM, max2(ksECM/ksMEM,20));	// factor of max self-avoiding displacement comparing to segment length 

	// Adhesions
	//R_CTXadhere=0.25*max2(ksiCTX, ksiECM);
	R_CTXadhere=0.5*ksiCTX;
	R_CTXadheresquare=R_CTXadhere*R_CTXadhere;
	dnearmem=0.25*min2(ksiECM, ksiMEM);

	ksMEMdb=2.0*ksMEM;
	ksECM_MEM=ksECM/ksMEM;
	ksCTX_MEM=ksCTX/ksMEM;
	ksCTX_ECM=ksCTX/ksECM;

	mjuECM=log(max2(ksiECM/dlt,dlt/ksiECM))/3.0/Pi/eta/ksiECM;	// filament moving at random direction, make sure ksi>dlt
	mjuCTX=log(max2(ksiCTX/dlt,dlt/ksiCTX))/3.0/Pi/eta/ksiCTX;
	mjuMEM=1.0/(12*eta*sqrt(ksiMEM*ksiECM));	// area=ksiMEM*ksiECM, assuming a random moving disk instead of filament
	mjuNUC=1.0/(6.0*Pi*eta*R_NUC);	// nucleus

	mjuECMksdt=mjuECM*ksECM*dt;	// v=mju*f=mju*ks*dl,  so dr=v*dt=(mju*ks*dt)*dl
	mjuCTXksdt=mjuCTX*ksCTX*dt;
	mjuMEMksdt=mjuMEM*ksMEM*dt;
	mjuNUCksdt=mjuNUC*ksCTX*dt;

	mjuECMksdtinv=1.0/mjuECMksdt;
	mjuCTXksdtinv=1.0/mjuCTXksdt;
	mjuMEMksdtinv=1.0/mjuMEMksdt;
	mjuNUCksdtinv=1.0/mjuNUCksdt;

	dlcolorscaleECM=dlbrECM;
	dlcolorscaleCTX=dlbrCTX;
	dlcolorscaleMEM=max2(dlcolorscaleECM, dlcolorscaleCTX);
}

