
// graph with adjacent list representation modified from 
// "C and Data Structures" by Deshpande & Kakde

void getvertexr(int i, int j, double r1[2], double r2[2])	// return vertices with id=i&j
{
	int flg=0;
	tVertex p;
	
	p=vertices;
	while(flg<2 && p) {
		if(i==p->vnum) { veccopy(p->v,r1); flg++; }
		if(j==p->vnum) { veccopy(p->v,r2); flg++; }
		p=p->next;
	}
}


int swapcomp(int p[2], int i, int j)
{
	if(p[0]==i && p[1]==j) return 1;
	if(p[0]==j && p[1]==i) return 1;
	return 0;
}


void addpair2list(int i, int j)	// add (i, j) to pair list. i&j are the id's of nodes
{
	ECM_edge *p, *q;

	if(!ECMedge) {
		ECMedge=(ECM_edge *)malloc(sizeof(ECM_edge));
		ECMedge->pair[0]=i;
		ECMedge->pair[1]=j;
		ECMedge->next = NULL;
		Nedge_ECM++;
		return;
	}
	
	p=q=ECMedge;
	while(p && !swapcomp(p->pair, i, j)) {q=p; p=p->next;}	// just one-way connection
	if(!p) {	// p goes to the end and finds it to be a new pair
		p=(ECM_edge *)malloc(sizeof(ECM_edge));	// new pair
		p->pair[0]=i;
		p->pair[1]=j;
		p->next = NULL;	// add to the tail
		q->next = p;
		Nedge_ECM++;
	//	printf("%d: (%d, %d)\n", Nedge_ECM, i, j);
	}
	//else printf(".");	// duplicates
}


void addface2list(tFace p)	// get pairs from each face
{
	int i, j, id[3];
	double v[3][2];
	
	for(i=0; i<3; i++) {	// three vertices
		id[i] = p->vertex[i]->vnum;
		veccopy(p->vertex[i]->v, v[i]);
	}
	
	for(i=0; i<3; i++) {
		j=(i+1)%3;
		addpair2list(id[i],id[j]);
	}
}


void getedgelist(void)	// get pairs from all faces
{
	tFace p;
	p=faces;
	if(p) do {
		if(p->lower) addface2list(p);
		p = p->next;
	} while(p!=faces);
}


void testedgelist(void)
{
	int i=0;
	ECM_edge *p;
	p=ECMedge;
	printf("n_edge=%d\n", Nedge_ECM);
	while(p) {
		printf("i=%d,\t(%d, %d)\n", i, p->pair[0], p->pair[1]);
		i++;
		p=p->next;
	}
}

void getpair_i(int i, int pair[2])	// return the i-th pair
{
	int j=0;
	ECM_edge *p;

	p=ECMedge;
	while(j++<i) p=p->next;
	pair[0] = p->pair[0];
	pair[1] = p->pair[1];
}


void printECMGraph()	// prints the graph.
{
	int i;
	ECM_node *p;
	
	for( i=0; i<N_ECM_plus; ++i ) {
		printf("%d: ", i);
		p=ECM[i];
		if(!p) printf("Null");
		while(p) {
			printf("[%d] ", p->id);
			//if(p->connected==1) printf("[%d] ", p->id);
			p = p->next;
		}
		printf( "\n" );
	}
	printf("\n");
}


void insertECMEdge( ECM_node **ptr, int id )	// insert a new ECM_node at the start.
{
	ECM_node *newnode = (ECM_node *)malloc(sizeof(ECM_node));
	newnode->id = id;
	newnode->next = *ptr;
	*ptr = newnode;
}


void GetECMGraph(int n)	// fills graph as adjacency list from array edges.
{
	int i;
	int pair[2];
	for( i=0; i<Nedge_ECM; ++i ) {
		getpair_i(i, pair);
		insertECMEdge(ECM+pair[0], pair[1]);
		insertECMEdge(ECM+pair[1], pair[0]); // undirected graph.
	}
	// following makes the 1st column of adjacent list to be the node itself, use PrintGraph() to see
	for(i=0; i<n; i++) insertECMEdge(ECM+i, i);
	//for(i=n; i<NnodesMax; i++) ECM[i]=NULL;	// nullify the rest
}


void ReadECMPos(int n)	// initial setup: read node's r from vertices
{
	int i, id;
	tVertex v;
	ECM_node *p;
	
	for(i=0; i<n; i++) {	// for each graph node, find node coordinates
		p=ECM[i];
		
		while(p) {
			id = p->id;	// this is here b/c the 1st column is the node itself
			v=vertices;	// read position from triangulation
			while(v && v->vnum != id) v = v->next;	// find the node from vertices
			if(v) veccopy(v->v, p->r);	// copy the coordinates
			else { printf("error in graph-prop.\n"); exit(0); }
			p = p->next;
		}
	}
}


void GetECMProp(int n)	// initial setup: read node's r from vertices
{
	int i, cnt;
	double rc[2], r2;
	ECM_node *p, *q;
	
	for(i=0; i<n; i++) {	// for each graph node, find initial rest length
		p = ECM[i];
		
		vecsub(p->r, Rnuc, rc);
		r2=pow(rc[0], 2)+pow(rc[1], 2);
		if(r2<R_NUC2) p->contact = 1;	// inside the bead
		else p->contact = 0;
		
		p->nearmem = 0;
		p->connected = 1;
		p->nadhere = 0;
		if(fabs(p->r[1])>YLENhalf-0.5*ksiECMheight) p->bnd = 1;
		else p->bnd = 0;
		p->l0 = 0.0;	// itself
		p->dl = 0.0;
		veczero(p->dlvec);
		
		q = p->next;
		cnt=0;	// neighbor counter
		while(q) {
			q->connected = 1;
			q->l0 = distance(p->r, q->r);	// distance of ECM[i][0] to ECM[i][j]
			q->dl = 0.0;
			cnt++;
			q = q->next;
		}
		p->nnbr = cnt;
	}
}


void TrimECM(int n)	// do this only at the very beginning
{
	int i, flg;
	ECM_node *p, *q, *r;
	
	for(i=0; i<n; i++) {
		p=ECM[i];
		q = p->next;
		while(q) {
			if(q->l0 > (1.5+varECM)*ksiECM) {	// remove link if it is too long or nodes are at boudaries
				r = ECM[q->id]->next;	// go to the main node of q
				flg = 1;
				while(r && flg) {
					if(r->id == i) {
						r->connected = -1;	// remove p from q-list
						flg = 0;
					}
					r = r->next;
				}
				q->connected = -1;	// back to the current thread, remove q from p-list
			}
			q = q->next;
		}
	}
}


void CopyECMNodeProp1(ECM_node *p1, ECM_node *p2)	// except for nnbr & next
{
	p2->id = p1->id;
	p2->bnd = p1->bnd;
	p2->contact = p1->contact;
	p2->connected = p1->connected;
	p2->nadhere = p1->nadhere;
	p2->l0 = p1->l0;
	p2->dl = p1->dl;
	
	veccopy(p1->dlvec, p2->dlvec);
	veccopy(p1->r, p2->r);
	veccopy(p1->nrm, p2->nrm);
}


void CopyECMNodeProp2(ECM_node *p1, ECM_node *p2)	// with nnbr & next
{
	p2->id = p1->id;
	p2->nnbr = p1->nnbr;
	p2->bnd = p1->bnd;
	p2->contact = p1->contact;
	p2->connected = p1->connected;
	p2->nadhere = p1->nadhere;
	p2->l0 = p1->l0;
	p2->dl = p1->dl;
	
	veccopy(p1->dlvec, p2->dlvec);
	veccopy(p1->r, p2->r);
	veccopy(p1->nrm, p2->nrm);
	p2->next = p1->next;
}


void WrapECM(void)	// wrap up the mesh, virtual links between head & tail are (connected=-2)
{
	int i, j, il, ir, ighost, flg1, flg2;
	ECM_node *p, *q, *r, *s;
	
	//printf("Nx=%d\tNy=%d\n", Nx_ECM, Ny_ECM);
	//printf("N_ECM=%d\tNnodesplus=%d\n", N_ECM, N_ECM_plus);
	for(i=0; i<=Ny_ECM; i++) {	// for each row
		j=i*(Nx_ECMp1+1)+Nx_ECMp1;	// j is the ghost node on the right
		ECM[j]->connected = -2;	// mark as ghost node
		//printf("%d\t", j);
	}
	
	for(i=0; i<=Ny_ECM; i++) {	// for each row
		il=i*(Nx_ECMp1+1);	// the one on the far left
		ighost=il+Nx_ECMp1;	// the one on the far right, il & ighost should merge
		ir=ighost-1;	// the one on the wrapped right
		
		p=ECM[ighost];	// for each ghost grid p
		q = p->next;
		while(q) {	// for each neighbor q, change its neighbor from ighost to il
			r=ECM[q->id];
			if(r->connected != -2) {	// q is not a ghost node
				r = r->next;	// r is q's neighbor
				flg1=1;
				while(r && flg1) {	// search r to find ighost
					if(r->id == ighost) {	// if r is ighost, replace it with il
						flg1=0;
						CopyECMNodeProp1(ECM[il], r);	// don't copy nnbr
						r->l0 = distance(ECM[il]->r, ECM[q->id]->r);
						r->connected = -2;
						
						s = ECM[il]->next;	// now connect node-il to node-ir
						flg2=1;
						while(s && flg2) {
							if(s->connected == -1) {	// s is an empty link of node-il
								flg2=0;
								CopyECMNodeProp1(ECM[q->id], s);	// don't copy nnbr
								s->l0 = distance(ECM[il]->r, ECM[q->id]->r);
								s->connected = -2;
							}
							s = s->next;
						}
					}
					r = r->next;
				}
			}
			q = q->next;
		}
	}
}


void SwapECMNodes(ECM_node *p1, ECM_node *p2)
{
	ECM_node *p;
	p=(ECM_node *)malloc(sizeof(ECM_node));
	CopyECMNodeProp2(p1,p);
	CopyECMNodeProp2(p2,p1);
	CopyECMNodeProp2(p,p2);
	free(p);
}


void SortECM(void)	// move ghost nodes to the bottom, only the front N_ECM are valid
{
	int i, j, k;
	int *newid;
	ECM_node *p;
	
	for(i=Ny_ECM; i>=0; i--) {	// for each row, swap from bottom to avoid change in id & order
		j=i*(Nx_ECMp1+1)+Nx_ECMp1;	// j is the ghost node
		//printf("%d\t", j);
		for(k=j; k<N_ECM_plus-1; k++) {	// k is always the ghost node, bubble sorting
			SwapECMNodes(ECM[k], ECM[k+1]);	// move the ghost node all the way to the bottom
		}
	}
	
	newid=malloc(N_ECM_plus*sizeof(int));	// list of new ID's
	for(i=0; i<N_ECM_plus; i++) newid[ECM[i]->id] = i;	// newid[oldID]=newID
	
	// re-arrange id
	for(i=0; i<N_ECM_plus; i++) {
		p=ECM[i];
		p->id = newid[p->id];	// new id = i
		p = p->next;
		while(p) {	// notice all the neighbors about the change
			p->id = newid[p->id];
			p = p->next;
		}
	}
	//	now i=[0,N_ECM) are nodes in a wraped network
	free(newid);
}


void ECMiniPos(void)	// initial position for head nodes, for strain field
{
	int i;
	ECM_node *p;
	
	for(i=0; i<N_ECM; i++) {
		p = ECM[i];
		veccopy(p->r, p->rini);
	}
}


void EmbedCell(void)
{
	int i, flg;
	double d, dm;
	ECM_node *p, *q, *r;
	
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		d=distance(p->r, Rnuc);
		if(EMBED_==1) dm=R_NUC;	// clear nucleus
		else dm=R_MEM;	// clear cell
		if(d<dm) {	// p is disconnected if inside the cell
			p->connected = 0;
			q = p->next;
			while(q) {	// q is a neighbor of p
				r = ECM[q->id]->next;	// search in q's list to remove p
				flg = 1;
				while(r && flg) {	// find p in q's list
					if(r->id == i) {
						r->connected = 0;
						flg=0;
					}
					r = r->next;
				}
				q->connected = 0;	// back to the current thread, remove q from p-list
				q = q->next;
			}
		}	// end of r<R_MEM
	}
}


void PrepMultiECM(void)
{
	int i;
	
	r_ECM_ini=(double **)calloc(N_ECM, sizeof(double *));	
	for(i=0; i<N_ECM; i++) {
		r_ECM_ini[i] = malloc(2*sizeof(double));
		veccopy(ECM[i]->r, r_ECM_ini[i]);
	//	printf("%d\t(%.2f,\t%.2f)\t\t(%.2f,\t%.2f)\n", i, ECM[i]->r[0], ECM[i]->r[1], r_ECM_ini[i][0], r_ECM_ini[i][1]);
	}
}


void BuildECM(void)
{
	ECM = (ECM_node **)calloc(N_ECM_plus, sizeof(ECM_node *));
	
	Nedge_ECM=0;
	TriangulationSuccess=0;
	DoTriangulation();
	getedgelist();
	
	GetECMGraph(N_ECM_plus);
	ReadECMPos(N_ECM_plus);
	GetECMProp(N_ECM_plus);
	TrimECM(N_ECM_plus);
	
	WrapECM();
	SortECM();
	ECMiniPos();
#if EMBED_
	EmbedCell();
#endif
	
#if MLTECM
	PrepMultiECM();
#endif
	
	//GetECMGraphProp(N_ECM);	// update the N_ECM in the front
	//printECMGraph();
}


void CleanECM(void)
{
	int i;
	ECM_edge *p;
	ECM_node *q;
	
	CleanTriangles();
	
	while(ECMedge) {
		p=ECMedge;
		ECMedge = p->next;
		free(p);
	}
	ECMedge=NULL;

	//printECMGraph();
	if(ECM) {
		for(i=N_ECM_plus-1; i>=0; i--) {
			while(ECM[i]) {
				q=ECM[i];
				ECM[i] = q->next;
				free(q);
			}
			free(ECM[i]);
			//printECMGraph();
		}
		free(ECM);
	}
	ECM=NULL;
	
#if MLTECM
	if(r_ECM_ini) {
		for(i=N_ECM-1; i>=0; i--) free(r_ECM_ini[i]);
		free(r_ECM_ini);
	}
	r_ECM_ini=NULL;
#endif
}


// --------- dynamics below ------------



void RemoveECM_link_i(ECM_node *p, ECM_node *q)	// to remove the link between ECM nodes p & q
{	// note: p is the head node, q is inside the p-list: [p]---[q]---, not the head node!
	int flg;
	ECM_node *r;

	q->connected = 0;	// in p's own list: [p]---, remove q
	if(p->nnbr > 1) (p->nnbr)--;
	
	r = ECM[q->id]->next;	// in q's own list: [q]---[r]---, find r->id = p->id
	flg = 1;
	while(r && flg) {
		if(r->id == p->id) {	// this is p: [q]---[r=p]---
			if(ECM[q->id]->nnbr > 1) (ECM[q->id]->nnbr)--;
			r->connected = 0;	// remove p from q-list
			flg = 0;
		}
		r = r->next;
	}
}


void ECMLinkRupture(void)
{
	int i;
	ECM_node *p, *q;
	
	for(i=0; i<N_ECM; i++) {
		p = ECM[i];
		q = p->next;
		while(q) {
			if(q->connected == 1 && q->dl > dlbrECM) {	// remove link if it is too long
				RemoveECM_link_i(p, q);
			}
			q = q->next;
		}
	}
}


void ECMLinkRupture1(void)
{
	int i, flg;
	ECM_node *p, *q, *r;
	for(i=0; i<N_ECM; i++) {
		p = ECM[i];
		q = p->next;
		while(q) {
			if(q->connected == 1 && q->dl > dlbrECM) {	// remove link if it is too long
				r = ECM[q->id]->next;	// go to the main node of q
				flg = 1;
				while(r && flg) {
					if(r->id == i) {
						if(ECM[q->id]->nnbr > 1) (ECM[q->id]->nnbr)--;
						r->connected = 0;	// remove p from q-list
						flg = 0;
					}
					r = r->next;
				}
				if(p->nnbr > 1) (p->nnbr)--;
				q->connected = 0;	// back to the current thread, remove q from p-list
			}
			q = q->next;
		}
	}
}


void ECMLinkAnneal(void)
{
	int i, flg;
	double xc, l0;
	ECM_node *p, *q, *r;
	
	xc=Rnuc[0];
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->r[0]>xc) {
			q = p->next;
			while(q) {
				//if(q->r[0]>xc && q->connected==0) {
				if(q->connected==0) {
					l0 = distance(p->r, q->r);
					r = ECM[q->id]->next;	// go to the main node of q
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							(ECM[q->id]->nnbr)++;
							r->connected = 1;	// p in q-list
							r->l0 = l0;
							r->dl = 0.0;
							veczero(r->dlvec);
							flg = 0;
						}
						r = r->next;
					}
					(p->nnbr)++;
					q->connected = 1;	// back to the current thread, q in p-list
					q->l0 = l0;
					q->dl = 0.0;
					veczero(q->dlvec);
				}
				q = q->next;
			}
		}
	}
}


void ECMLinkShrink(void)
{
	int i;
	double xc, l0, flg;
	ECM_node *p, *q, *r;
	
	xc=Rnuc[0];
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->r[0]>xc) {
			if(p->bnd == 1) p->bnd = 0;	// allows bondary contraction
			q = p->next;
			while(q) {
				//if(q->r[0]>xc && q->connected == 1 && q->l0 > ksiECMminpVsdt) {
				if(q->connected == 1 && q->l0 > ksiECMminpVsdt) {
					l0 = q->l0 - Vsdt*pow((q->l0)/ksiECMmin,1);
					r = ECM[q->id]->next;
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							r->l0 = l0;
							flg = 0;
						}
						r = r->next;
					}
					q->l0 = l0;
				}
				q = q->next;
			}
		}
	}
}


void ECMmelt1(void)
{
	int i;
	double d;
	ECM_node *e, *p;
	
	for(i=0; i<N_ECM; i++) {	// melt ECM near tip
		e = ECM[i];
		if(e->connected == 1) {
			d = distance(e->r, MEM[TIP_ID].r);
			if(d<R_TIP) {	// if e is close to tip, remove it
				p = e->next;
				while(p) {	// mark all the neighbors (p) of e: [e]---[p]---
					if(p->connected == 1) {
						RemoveECM_link_i(e, p);
					}
					p = p->next;
				}
			}
		}
	}
}


void ECMmelt(void)
{
	int i, j;
	double d, x1, x2, y1, y2;
	MEM_node *m;
	ECM_node *e, *p;
	
	x1=Xmin-R_TIP;
	x2=Xmax+R_TIP;
#if EXTNSN
	x2-=L_EXT;	// to exclude the finger
#endif
	y1=Ymin-R_TIP;
	y2=Ymax+R_TIP;
	
	for(i=0; i<N_MEM; i++) {	// find the membrane at the leading edge that has the same y as NUC
		m = &MEM[i];
		m->melt = 0;
		
	#if EXTNSN
		if(m->r[0]>Rnuc[0]+0.75*R_NUC && m->r[0]<Rnuc[0]+1.25*R_NUC) m->melt = 1;
	#else
		if(m->nrm[0]>0 && fabs(m->r[1] - Rcell[1]) < R_MELT && m->r[0] > Rcell[0]) m->melt = 1;
		//if(m->nrm[0]>0 && fabs(m->r[1] - Rnuc[1]) < R_MELT && m->r[0] > Rcell[0]) m->melt = 1;
	#endif
		
		if(m->melt) {
			for(j=0; j<N_ECM; j++) {	// melt ECM near this part of membrane
				e = ECM[j];
				if(e->connected == 1 && e->r[0] > x1 && e->r[0] < x2 && e->r[1] > y1 && e->r[1] < y2) {	// narrow to a small region
					d = distance(e->r, m->r);
					if(d<R_TIP) {	// if e is close to tip, remove it
						p = e->next;
						while(p) {	// remove all the neighbors (p) of e: [e]---[p]---
							if(p->connected == 1) RemoveECM_link_i(e,p);
							p = p->next;
						}
					}
				}
			}
		}
	}
}


void ECMDynamics(void)
{
	ECMLinkRupture();
#if ECMMLT
	ECMmelt();
#endif

}

