
void getVnuc(void)	// run this every smpdt interval
{
	double dr[2];
	vecsub(Rnuc, Rnucprev, dr);
	vecdiv(dr, smpdt, Vnuc);
	veccopy(Rnuc, Rnucprev);
	
	vecsub(Rcell, Rcellprev, dr);
	vecdiv(dr, smpdt, Vcell);
	veccopy(Rcell, Rcellprev);
}


void DoSampling(void)
{
	vecadd(Fnucave, Fnuc, Fnucave);
	fnucave=norm(Fnucave)/smptot;	// for displaying, now in unis of length
	
	vecadd(Vnucave, Vnuc, Vnucave);
	vnucave=norm(Vnucave)/smptot;
	
	vecadd(Vcellave, Vcell, Vcellave);
	vcellave=norm(Vcellave)/smptot;
}

/*
void GetAverageFV(void)
{
	int i;
	if(smptot==0) {
		printf("No Fnuc has been sampled.\n");
		return;
	}
	for(i=0; i<2; i++) {
		Fnucave[i]/=smptot;
		Vnucave[i]/=smptot;
		Vcellave[i]/=smptot;
	}
	fnucave=norm(Fnucave);	// in units of length
	vnucave=norm(Vnucave);
	vcellave=norm(Vcellave);
}
*/


void SaveStatSingle(void)	// REPEAT=0
{
	FILE *fp;
	
	//GetAverageFV();
	ProcessTrack();
	fp=fopen("V.dat", "w");
	printf("<V> = %.3g um/hr\n", Vcell_ave*3600);
	fprintf(fp, "%.4g um/hr\n", Vcell_ave*3600);
	fclose(fp);
}


void SaveStatMulti(void)	// REPEAT=1
{
	int i;
	char str1[200], str2[200];
	double va, verr;
	FILE *fp;
	
	if(NrepeatValid==0) {
		printf("No repeat has been completed.\n");
		printf("<V> = %.4g um/hr.\n", Vcell_ave*3600);
		return;
	}
	printf("------------------------\n");
	
	vrepeatave=vrepeatsum/max2(NrepeatValid,1);
	vrepeaterr=0.0;
	vcellave=0.0;
	for(i=0; i<NrepeatValid; i++) {
		vcellave+=vrepeatind[i];
		vrepeaterr+=pow(vrepeatind[i]-vrepeatave,2);
	}
	vcellave/=max2(NrepeatValid,1);
	vrepeaterr/=max2(NrepeatValid,1);
	vrepeaterr=sqrt(vrepeaterr);
	
	va=vcellave*3600;	// in unit of um/hr
	verr=vrepeaterr*3600;
	
#if !OPENGL && SEARCH
	if(SRCHNO==1) {
		sprintf(str1, "%s\t<V>(um/hr)\tError(um/hr)", SrchVar1);
		sprintf(str2, "%.4g\t%.4g\t%.2g", Para1, va, verr);
	}
	else if(SRCHNO==2) {
		sprintf(str1, "%s\t%s\t<V>(um/hr)\tError(um/hr)", SrchVar1,  SrchVar2);
		sprintf(str2, "%.4g\t%.4g\t%.4g\t%.2g", Para1, Para2, va, verr);
	}
#else
	sprintf(str1, "<V> = %.3g +/- %.2g um/hr", va, verr);
	sprintf(str2, "");
#endif

	fp=fopen("V.dat", "w");	// final output
	printf("%s\n%s\n", str1, str2);
	fprintf(fp, "%s\n%s\n", str1, str2);	// final output
	fclose(fp);
	
	fp=fopen("multi.dat", "a");	// append to multi.dat in MultipleRuns() in main.c
	fprintf(fp, "------------------------------------\n");
	fprintf(fp, "ave\t%.4g um/hr\n", va);
	fclose(fp);
}


void DoStat(void)
{
#if REPEAT
	SaveStatMulti();
#else
	SaveStatSingle();
#endif
}



