
void CopyCTXNode(CTX_node *p1, CTX_node *p2)
{
	p2->id = p1->id;
	p2->nnbr = p1->nnbr;
	p2->contact = p1->contact;
	p2->connected = p1->connected;
	p2->nearmem = p1->nearmem;
	p2->nearmemid = p1->nearmemid;
	p2->adhere = p1->adhere;
	p2->adhereid = p1->adhereid;
	p2->l0 = p1->l0;
	p2->l0max = p1->l0max;
	p2->dl = p1->dl;
	veccopy(p1->r, p2->r);
	veccopy(p1->dlvec, p2->dlvec);
	p2->adheretime = p1->adheretime;
	p2->next = p1->next;
}


void SwapCTXNodes(CTX_node *p1, CTX_node *p2)
{
	CTX_node *p;
	p=(CTX_node *)malloc(sizeof(CTX_node));
	CopyCTXNode(p1,p);
	CopyCTXNode(p2,p1);
	CopyCTXNode(p,p2);
	free(p);
}


void GetNewCTXNodePos(double r[2])
{
	int i, id, n;
//	int memid[N_MEM];
	double dr[2];
//	MEM_node *p;
	
	/*
	n=0;
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		//if(p->nrm[0]<0) memid[n++] = p->id;	// membrane facing left
		if(p->health) memid[n++] = p->id;
	}
	
	id=(int)(n*ran2(&mseed));	// choose a random node from this part of membrane
	id=memid[id];
	*/
	
	n=0;
	do {
		id = (int)(ran2(&mseed)*N_MEM);
		id = min2(id, N_MEMm1);
		n++;
	} while(MEM[id].health==0 && n<N_MEM);
	
	for(i=0; i<2; i++) dr[i] = (1.0-2*ran2(&mseed))*ksiCTXnewposmax;
	if(dotprod(dr, MEM[id].nrm)>0) vecprod(dr, -1.0, dr);	// make sure new position is inside the cell
	vecadd(MEM[id].r, dr, r);
}


void GetNewCTXNodePosFront(double r[2])
{
	int i, n, id;
	int memid[N_MEM];
	double dr[2];
	MEM_node *p;
	
	n=0;
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		if(p->nrm[0]>0) memid[n++] = p->id;	// membrane facing left
	}
	
	id=(int)(n*ran2(&mseed));	// choose a random node from this part of membrane
	id=memid[id];
	
	for(i=0; i<2; i++) dr[i] = (1.0-2*ran2(&mseed))*ksiCTXnewposmax;
	if(dotprod(dr, MEM[id].nrm)>0) vecprod(dr, -1.0, dr);	// make sure new position is inside the cell
	vecadd(MEM[id].r, dr, r);
}



void GetNewCTXNodePosBack(double r[2])
{
	int i, n, id;
	int memid[N_MEM];
	double dr[2];
	MEM_node *p;
	
	n=0;
	for(i=0; i<N_MEM; i++) {
		p = &MEM[i];
		if(p->nrm[0]<0) memid[n++] = p->id;	// membrane facing left
	}
	
	id=(int)(n*ran2(&mseed));	// choose a random node from this part of membrane
	id=memid[id];
	
	for(i=0; i<2; i++) dr[i] = (1.0-2*ran2(&mseed))*ksiCTXnewposmax;
	if(dotprod(dr, MEM[id].nrm)>0) vecprod(dr, -1.0, dr);	// make sure new position is inside the cell
	vecadd(MEM[id].r, dr, r);
}


void GetNewCTXNodePosTip(double r[2])
{
	int i, n;
	double dr[2];
	MEM_node *p, *q;
	
	//for(i=0; i<2; i++) r[i] = MEM[EXT_TIP_ID].r[i] + 0.2*(1-2*ran2(&mseed))*ksiMEM;
	//r[0]-=0.2*ran2(&mseed)*L_EXTADH;
	
	//for(i=0; i<2; i++) r[i] = MEM[EXT_TIP_ID].r[i] - 0.8*ran2(&mseed)*L_EXTADH*MEM[TIP_ID].nrm[i];
	
	n=(int)(ran2(&mseed)*N_TIP_SEG);
	p=&MEM[EXT_TIP_ID];
	if(ran2(&mseed)<0.5) {
		for(i=0; i<n; i++) {
			q=&MEM[p->nbr[0]];
			p=q;
		}
	}
	else {
		for(i=0; i<n; i++) {
			q=&MEM[p->nbr[1]];
			p=q;
		}
	}
	
	for(i=0; i<2; i++) dr[i] = (1.0-2*ran2(&mseed))*ksiCTXnewposmax;
	if(dotprod(dr, p->nrm)>0) vecprod(dr, -1.0, dr);	// make sure new position is inside the cell
	vecadd(p->r, dr, r);
}



int CrossMembrane(double r1[2], double r2[2])
{
	int i, z;
	MEM_node *p, *q;
	
	z=0;
	for(i=0; i<N_MEM && z==0; i++) {
		p = &MEM[i];
		q = &MEM[p->nbr[1]];
		z = SegSegIntersectProp(r1, r2, p->r, q->r);
	}
	return z;
}


void GetCTXNeighborPos(double r[2], int idx[], int *nx)
{
	int i, j, k, cnt, nmax, flg;
	int idxplus[LinkPerNodeplus], idxplusflag[LinkPerNodeplus];
	double rtmp, rmin[LinkPerNodeplus], dotpd;
	double r1[2], r2[2], n1[2], n2[2];
	CTX_node *p;

	for(i=0; i<LinkPerNodeplus; i++) {
		rmin[i]=inf;
		idxplus[i]=idxplusflag[i]=0;
	}
	
	cnt=0;
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		rtmp=distance(r,p->r);
		
		flg=0;
		
		// rmin[0]<rmin[1]<...<rmin[n-1]
		// set min & max thresholds for link distance
		//if(rtmp>ksiCTXmin && rtmp<ksiCTXmax && rtmp<rmin[LinkPerNodeplusm1] && p->nnbr<LinkPerNodedb) flg=1;
		if(rtmp>ksiCTXnbrmin && rtmp<ksiCTXnbrmax && rtmp<rmin[LinkPerNodeplusm1] && p->nnbr<LinkPerNodedb) flg=1;
			
	#if EXTNSN
		if(flg==1 && r[0]>Xmax-L_EXT) {	// choose parallel links in the neck
			vecsub(p->r, r, r1);
			normalize(r1, r1);
			
			if(fabs(r1[0])<0.8) flg=0;	// exclude vertical links
			/*
			if(distance(r, MEM[EXT_TIP_ID].r)<L_EXTADH) {	// very tip
				if(dotprod(MEM[EXT_TIP_ID].nrm, r1)<0.7) flg=0;	// keep links along protrusion
			}
			else if(fabs(r1[0])<0.8) flg=0;	// rest of the protrusion, keep horizontal
			*/
		}
	#endif
		
//		if(flg==1) if(CrossMembrane(r, p->r)) flg=0;
			
		if(flg) {
			j=LinkPerNodeplusm1;
			while(rtmp<rmin[j] && j>0) j--;
			if(j>0 && rtmp>rmin[j]) j++;
			for(k=LinkPerNodeplusm1; k>j; k--) {	// move the rest
				rmin[k]=rmin[k-1];
				idxplus[k]=idxplus[k-1];
			}
			rmin[j]=rtmp;
			idxplus[j] = p->id;
			cnt++;
			//printf("%d\t%d\t%d\n", idx[0],idx[1],idx[2]);
			//printf("%.2f\t%.2f\t%.2f\t%.2f\t%.2f\n", rmin[0],rmin[1],rmin[2],rmin[3],rmin[4]);
		}
	}
	
	for(i=0; i<LinkPerNode; i++) idx[i]=idxplus[i];	// temporarily accept it
	
	if(cnt<LinkPerNode) {	// not enough nodes selected
		*nx=cnt;
		return;
	}
	
	nmax=min2(cnt, LinkPerNodeplus);	// cnt may < or > LinkPerNodeplus
	*nx=k=1;	// fix idx[0]=idxplus[0]
	idxplusflag[0]=1;
	for(i=0; i<LinkPerNodem1; i++) {	// among LinkPerNodeplus, pick LinkPerNode nodes
		vecsub(r, CTX[idxplus[i]]->r, r1);
		normalize(r1, n1);
		j=i;
		do {
			j++;
			vecsub(r, CTX[idxplus[j]]->r, r2);
			normalize(r2,n2);
			dotpd=fabs(dotprod(n1,n2));
		} while(dotpd>0.8 && idxplusflag[j]==1 && j<nmax);	// shouldn't be too close
		//} while(idxplusflag[j]==1 && j<nmax);	// shouldn't be too close
		
		if(j<nmax && k<LinkPerNode) {
			idx[k]=idxplus[j];
			idxplusflag[j]=1;	// this node is now taken
			k++;
			(*nx)++;
		}
	}
}


void AppendCTXNode(CTX_node *p, int id)	// append node id to thread p
{
	CTX_node *q, *r;
	
	if(!p) printf("error\n");
	q = p;
	while(q->next) q = q->next;	// q is the end of p
	
	r = (CTX_node *)malloc(sizeof(CTX_node));
	q->next = r;
	
	CopyCTXNode(CTX[id], r);
	r->l0 = distance(p->r, r->r);
	r->dl = 0.0;
	r->next = NULL;
}


void GetNewCTXNodeProp(CTX_node *p)	// get new node's properties, input is p->R0
{
	p->nnbr = 0;
	p->contact = 0;
	p->connected = 1;
	p->nearmem = 0;
	p->nearmemid = 0;
	p->adhere = 0;
	p->adhereid = -1;
	p->l0 = 0.0;	// itself
	//p->l0max = ksiCTXmax*expdev(&mseed);	// l0max will be updated separately
	p->dl = 0.0;
	p->adheretime = 0.0;
	veczero(p->dlvec);
}


void syncCTXlmaxPair(int i, int j)	// sync i->j->lmax and j->i->lmax
{
	double lmax;
	CTX_node *p;
	
	lmax = ksiCTXmax*expdev(&mseed);
	p = CTX[i]->next;
	while(p && p->id != j) p = p->next;	// j in i's node
	if(p) p->l0max = lmax;
	
	p = CTX[j]->next;
	while(p && p->id != i) p = p->next;	// i in j's node
	if(p) p->l0max = lmax;
}


void insertCTXEdge( CTX_node **ptr, int id )	// insert a new ECM_node at the start.
{
	CTX_node *newnode = (CTX_node *)malloc(sizeof(CTX_node));
	newnode->id = id;
	newnode->next = *ptr;
	*ptr = newnode;
}



void printCTXGraph(void)	// prints the graph.
{
	int i;
	CTX_node *p;
	
	for( i=0; i<N_CTX; i++ ) {
		printf("%d: ", i);
		p=CTX[i];
		if(!p) printf("Null");
		while(p) {
			printf("[%d] ", p->id);
			//if(p->connected==1) printf("[%d] ", p->id);
			p = p->next;
		}
		printf( "\n" );
	}
	printf("\n");
}



void BuildCTX(void)	// initializing cortex
{
	int i, j, n, nx, idx[LinkPerNode], flg;
	double r[2], r2;
	CTX_node *p;
	
	N_CTX=N_CTX_INI;
	CTX = (CTX_node **)calloc(N_CTX_MAX, sizeof(CTX_node *)); 
	
	for(i=0; i<N_CTX_INI; i++) {
		CTX[i] = (CTX_node *)malloc(sizeof(CTX_node));
		p = CTX[i];
		p->id = i;
		do {
			r[0] = R_MEM*(1-2*ran2(&mseed));
			r[1] = R_MEM*(1-2*ran2(&mseed));
			r2=pow(r[0],2)+pow(r[1],2);
		} while(r2>R_MEM2 || r2<R_NUC2);
		vecadd(r, Rnuc, p->r);	// translate to nucleus frame
		GetNewCTXNodeProp(p);	// input p->r, get other initial properties
		p->next = NULL;
	}
	for(i=N_CTX_INI; i<N_CTX_MAX; i++) CTX[i]=NULL;	// nullify the rest
	
	for(i=0; i<N_CTX_INI; i++) {
		//printf("%d:\t", i);
		GetCTXNeighborPos(CTX[i]->r, idx, &nx);	// nx neighbors
		for(j=0; j<nx; j++) {	// for each neighbor
			n=idx[j];
			
			flg=1;
			p = CTX[i]->next;
			while(p && flg) {	// if n is already in i's list, return flg=0
				if(p->id == n) flg=0;
				p = p->next;
			}
			p = CTX[n]->next;
			while(p && flg) {	// if i is already in n's list, return flg=0
				if(p->id == i) flg=0;
				p = p->next;
			}
			
			if(flg==1) {	// i is not in n's list, and n is not in i's list
				if(CTX[n]->nnbr < LinkPerNode && CTX[i]->nnbr < LinkPerNode) {
					AppendCTXNode(CTX[i], n);	// append CTX[n] to thread CTX[i]
					AppendCTXNode(CTX[n], i);	// append CTX[i] to thread CTX[n]
					(CTX[i]->nnbr)++;
					(CTX[n]->nnbr)++;
					syncCTXlmaxPair(i, n);	// sync l0max in both nodes
					//printf("%d, ", n);
				}
			}
		}
		//printf("\n");
	}
	//printCTXGraph();
	//exit(0);
}


void CleanCTX(void)
{
	int i;
	CTX_node *p;
	
	if(CTX) {
		for(i=N_CTX-1; i>=0; i--) {
			while(CTX[i]) {
				p=CTX[i];
				CTX[i] = p->next;
				free(p);
			}
			free(CTX[i]);
		}
		free(CTX);
	}
	CTX=NULL;
}



void checknodes(int n)
{
	int i;
	CTX_node *p;
	
	for(i=0; i<N_CTX; i++) {
		p=CTX[i]->next;
		while(p) {
			if(p->id >= N_CTX || p->id <0) {
				printf("\nProblem at position %d, node %d\n", n, i);
				printCTXGraph();
				(void)getchar();
			}
			p = p->next;
		}
	}		
}


void NodesStats(void)
{
	int i;
	CTX_node *q;

	Nlinks=0;
	linklenave=0.0;
	for(i=0; i<N_CTX; i++) {
		Nlinks += CTX[i]->nnbr;
		q=CTX[i]->next;
		while(q) {
			linklenave += q->l0;
			q = q->next;
		}
	}
	Nlinks/=2;
	linklenave/=max2(2*Nlinks,1);
	Nlinkpernode=(float) (1.0*Nlinks/max2(N_CTX,1));
}



//--- dynamics below ---


void NodeCreationNuc(int pos)	// create 1 node and connect to other nodes, append to graph
{
	int i, nm, nx, idx[LinkPerNode];
	double r[2];
	CTX_node *p;

	if(N_CTX>=N_CTX_MAX) { printf("Too many nodes.\n"); exit(0); }
		
	if(pos==0) {
		if(nucbias==0) GetNewCTXNodePos(r);	// new node's id=nm, append to the list (position of node is random)
		else {
			if(ran2(&mseed)<probnucfront) GetNewCTXNodePosFront(r);
			else GetNewCTXNodePosBack(r);
		}
	}
	else GetNewCTXNodePosTip(r);	// position is near protrusion tip;
	
	GetCTXNeighborPos(r, idx, &nx);	// nx neighbors
	
//	printf("idx=%d, %d, %d\n", idx[0],idx[1],idx[2]);
	
	nm=N_CTX;
	N_CTX++;
	
	// add graph structure, malloc already in insertEdge
	insertCTXEdge(CTX+nm, nm);	// add nm to the head of CTX[nm], self as 1st column'
	p = CTX[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(r, p->r);
	GetNewCTXNodeProp(p);	// input p->r, get other initial properties
	
	//for(i=LinkPerNode-nx; i<LinkPerNode; i++) {	// for each neighbor
	for(i=0; i<nx; i++) {	// for each neighbor
		AppendCTXNode(CTX[nm], idx[i]);	// append idx[i] to thread CTX[nm]
		AppendCTXNode(CTX[idx[i]], nm);	// append nm to thread CTX[idx[i]]
		(CTX[idx[i]]->nnbr)++;	// update neighbor counter
		syncCTXlmaxPair(idx[i], nm);	// sync l0max in both nodes
	}
}


void NodeDeletion(int id)	// remove id thread from the graph, replace it with the last thread
{
	int nm, flg;
	CTX_node *p, *q, *r;
	
	if(N_CTX<1) return;
	
	// node id is ready for deletion
	nm=N_CTX-1;
	N_CTX--;
	
	
	// Don't forget this!!!
	p = CTX[id];
	if(p->adhere == 1) ECM[p->adhereid]->nadhere -= 1;


	/*
	// remove thread id
	while(CTX[id]) {
		p=CTX[id];	// remove node id, replace this thread with the last thread
		CTX[id] = p->next;
		//-----
		if(p->id != id) {	// to find node id in other threads
			q=CTX[p->id];	// in neighbor's thread
			r = q->next;
			flg=1;
			while(r && flg) {
				if(r->id == id) {	// remove this node from neighbor thread
					q->next = r->next;
					free(r);
					r = q->next;
					(CTX[p->id]->nnbr)--;	// update neighbor counter
					flg=0;
				}
				else {
					q = r;
					r = r->next;
				}
			}
		}
		//---
		free(p);
		CTX[id]=NULL;	// now CTX[id]=NULL
	}
	*/

	// remove thread id
	p = CTX[id]->next;	// remove node id, replace this thread with the last thread
	while(p) {
		q = CTX[p->id];	// to find node id in other threads
		r = q->next;
		flg=1;
		while(r && flg) {
			if(r->id == id) {	// remove this node from neighbor thread
				q->next = r->next;
				free(r);
				r = q->next;
				(CTX[p->id]->nnbr)--;	// update neighbor counter
				flg=0;
			}
			else {
				q = r;
				r = q->next;
			}
		}
		q = p;
		p = p->next;
		free(q);
	}
	free(CTX[id]);
	CTX[id]=NULL;	// now CTX[id]=NULL

	// copy the last thread's head to id-thread, and rename it to id
	// the rest of the thread is still there, ->next still points to the next node
	if(id!=nm) {
		CTX[id] = (CTX_node *)malloc(sizeof(CTX_node));
		CopyCTXNode(CTX[nm],CTX[id]);
		free(CTX[nm]);	// only remove the head node of the last thread
		CTX[nm]=NULL;	// this line is missing in actin code!!!
		//	now CTX[nm]=NULL, creation of nodes will use insertEdge, which has malloc
	
		// update id
		p=CTX[id];	// previous node-nm
		while(p) {
			if(p->id == nm) p->id = id;	// update previous head-node information
			else {
				q = CTX[p->id]->next;	// this thread contains node[id] (old node[nm])
				while(q) {
					if(q->id == nm) q->id = id;	// update id
					q = q->next;
				}
			}
			p = p->next;
		}
	}
}



void NodeDeletionRnd(void)	// remove 1 rnd. thread from the graph
{
	int id;
	
	if(N_CTX<1) return;
	id=(int)(ran2(&mseed)*N_CTX);
	id=min2(id, N_CTX-1);
	NodeDeletion(id);
}



void NodeDeletionOrphan(void)	// remove orphan nodes
{
	int i, id, flg, go;
	CTX_node *p;
	
	flg=1;
	while(flg) {
		go=1;
		i=N_CTX-1;
		while(i>=0 && go) {
			p=CTX[i];
		//	if(p->nnbr <1 && p->connected==0) {id=i; go=0;}
			if(p->nnbr <1) {id=i; go=0;}
			i--;
		}
		if(go==0) {NodeDeletion(id); flg=1;}	// now Nnodes changes
		else flg=0;
	}
	
	/*
	int i;
	for(i=Nnodes-1; i>=0; i--) {	// i goes from big to small, b/c deletion will change the value of Nnodes
		if(CTX[i]->nnbr <1) NodeDeletion(i);
	}	
	*/
}


void CTXLinkRupture(void)	// temporarily break the link by setting p->connected = 0
{
	int i, flg;
	double xc;
	CTX_node *p, *q, *r;
	
	xc=Rcell[0];
#if EXTNSN
	xc=(Rcell[0]+Xmax)/2.0;
#endif
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		if(p->r[0] > xc) {
			q = p->next;
			while(q) {
				if(q->connected == 1 && q->dl > dlbrCTX) {	// rupture if streched too much
					q->connected = 0;
					r = CTX[q->id]->next;	// go to the main node of q
					flg = 1;
					while(r && flg) {
						if(r->id == i) {	// remove p from q-list
							r->connected = 0;
							flg = 0;
						}
						r = r->next;
					}
					if(CTX[q->id]->nnbr>1) (CTX[q->id]->nnbr)--;
					if(p->nnbr>0) (p->nnbr)--;
				}
				q = q->next;
			}
		}
	}
}


void CTXLinkAnneal(void)
{
	int i, flg;
	double xc, l0;
	CTX_node *p, *q, *r;
	
	xc=Rcell[0];
#if EXTNSN
	xc=(Rcell[0]+Xmax)/2.0;
#endif
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		if(p->r[0]<xc) {
			q = p->next;
			while(q) {
				//if(q->r[0]<xc && q->connected == 0) {
				if(q->connected == 0) {
					q->connected = 1;	// q in p-list
					l0 = distance(p->r, q->r);
					r = CTX[q->id]->next;	// go to the main node of q
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							r->connected = 1;	// p in q-list
							r->l0 = l0;
							r->dl = 0.0;
							veczero(r->dlvec);
							flg = 0;
						}
						r = r->next;
					}
					(CTX[q->id]->nnbr)++;
					(p->nnbr)++;
					q->l0 = l0;
					q->dl = 0.0;
					veczero(q->dlvec);
				}
				q = q->next;
			}
		}
	}
}


void CTXLinkShrink(void)
{
	int i;
	double xc, l0, flg;
	CTX_node *p, *q, *r;
	
	xc=Rcell[0];
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		if(p->r[0]<xc) {
//			if(p->bnd == 1) p->bnd = 0;	// allows bondary contraction
			q = p->next;
			while(q) {
				//if(q->r[0]<xc && q->connected == 1 && q->l0 > ksiCTXminpVsdt) {
				if(q->connected == 1 && q->l0 > ksiCTXminpVsdt) {
					l0 = q->l0 - Vsdt;	//*pow((q->l0)/ksiCTXmin,1);
					r = CTX[q->id]->next;
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							r->l0 = l0;
							flg = 0;
						}
						r = r->next;
					}
					q->l0 = l0;
				}
				q = q->next;
			}
		}
	}
}


void CTXLinkGrowShrink1(void)	// abrupt boundary between grow & shrink
{
	int i;
	double xc, l0, flg;
	CTX_node *p, *q, *r;
	
	xc=Rnuc[0];
	for(i=0; i<N_CTX; i++) {
		p=CTX[i];
		if(p->r[0] > xc) {	// front half, growth
			q = p->next;
			while(q) {
				if(q->r[0] > xc && q->connected == 1 && q->l0 < ksiCTXmaxpVgdt) {
				//if(q->connected == 1 && q->l0 < ksiCTXmaxpVgdt) {
					l0 = q->l0 + Vgdt;//*pow(1-(q->l0)/ksiCTXmax,1);
					r = CTX[q->id]->next;
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							r->l0 = l0;
							flg = 0;
						}
						r = r->next;
					}
					q->l0 = l0;
				}
				q = q->next;
			}
		}
		else if(p->r[0] < xc) {	// rear half, shrink
			q = p->next;
			while(q) {
				//if(q->r[0] < xc && q->connected == 1 && q->l0 > ksiCTXminpVsdt) {
				if(q->connected == 1 && q->l0 > ksiCTXminpVsdt) {
					l0 = q->l0 - Vsdt*pow((q->l0)/ksiCTXmin,1);
					r = CTX[q->id]->next;
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							r->l0 = l0;
							flg = 0;
						}
						r = r->next;
					}
					q->l0 = l0;
				}
				q = q->next;
			}
		}
	}
}


void CTXLinkGrowShrink(void)	// linear transition between grow & shrink
{
	int i;
	double xc, yc, xm, x, v, l0, ok, flg;
	CTX_node *p, *q, *r;
	
	xc=Rcell[0];
	//xc=0.6*(Xmax-Xmin)+Xmin;
	yc=Rcell[1];
	
#if EXTNSN
	//xc=(Rcell[0]+Xmax)/2.0;
	xc=(Rnuc[0]+Xmax)/2.0;
#endif
	
	xm=Xmax-xc;
	xm=max2(xm, ksiCTX);
	
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		
		if(p->connected == 1) {
			x = p->r[0] - xc;
			if(x>=0) {	// growing CTX at the front
				//xm=sqrt(fabs(R_MEMdb - pow(p->r[1],2)));
				//xm=max2(xm, ksiCTX);
				v = Vg*min2(x/xm,1);
			}
			else {	// shrinking CTX at the rear
				///*
				//xm=sqrt(fabs(R_MEMdb - pow(p->r[1],2)));
				//xm=max2(xm, ksiCTX);
				v = Vs*max2(2*x/xm,-1);
				//*/
				//v = -Vs;
			}
			q = p->next;
			while(q) {
				//if(x>=0 && q->l0 < ksiCTXmax) ok=1;
				//else if(x<0 && q->l0 >= ksiCTXmin) ok=1;
				if(x>=0 && q->l0 < q->l0max) ok=1;
				else if(x<0 && q->l0 >= q->l0max) ok=1;
				else ok=0;
				if(ok && q->connected == 1) {
				//if(q->connected == 1 && q->l0 > ksiCTXmin && q->l0 < ksiCTXmax) {
					l0 = q->l0 + v*dt;
					q->l0 = l0;	// update q in [p]---[q]---
					
					r = CTX[q->id]->next;
					flg = 1;
					while(r && flg) {
						if(r->id == i) {
							r->l0 = l0;	// update p in [q]---[p]---
							flg = 0;
						}
						r = r->next;
					}
				}
				q = q->next;
			}
		}
	}
}


void CTXadhesion(void)
{
	int i, j, id, flag;
	double d, dmin;
	CTX_node *c;
	ECM_node *e;
	
	N_ADH=0;
	for(i=0; i<N_CTX; i++) {
		if(CTX[i]->adhere == 1) N_ADH++;
	}
	if(N_ADH<N_ADH_MAX) ADH_OK=1;
	else ADH_OK=0;
	
	for(i=0; i<N_CTX; i++) {
		c = CTX[i];
		if(c->adheretime < Tdadh) c->adheretime += dt;
		
		if(c->adhere == 1) {	// if CTX is adhered to ECM in the previous step
			flag=1;
			e = ECM[c->adhereid];
			//if(c->nearmem == 0 || e->nearmem == 0) flag = 0;	//see if c->nearmem & e->nearmem are still 1
			if(c->nnbr<=0 || e->nnbr<=0) flag = 0;	// either one losts all its neighbors
			else {	// adhesion is good
				if(c->adheretime >= Tdadh) flag = 0;	// time to detach
			}
			if(flag==0) {	// adhesion broken
				c->adhere = 0;
				e->nadhere -= 1;
				//e->nadhere = max2(e->nadhere, 0);
				c->adhereid = -1;
				c->adheretime = -Tnadh;	//0.0;	// recovery time for a new formation
			}
		}
		else {	// c->adhere = 0
			flag=0;
			if(c->adheretime >=0 && c->nearmem && ADH_OK==1) flag=1;	// CTX is not adhered to ECM but is now in contact with MEM and has recovered
			
			#if EXTNSN
			if(flag) {
				if(distance(MEM[EXT_TIP_ID].r, c->r)>L_EXTADH) flag=0;	// only tip adheres
			}
			#endif
			
			if(flag) {
				dmin=inf;
				id=-1;
				for(j=0; j<N_ECM; j++) {
					e = ECM[j];
					//if(e->nearmem == 1) {	// ECM is also in contact with MEM, don't use e->connected ==1!
						d = distancesquare(c->r, e->r);
						if(d<dmin) {
							dmin = d;
							id = j;
						}
					//}
				}
				if(id>=0) {	// choose the nearest ecm node to adhere
					if(dmin < R_CTXadheresquare) {	// ready for a new adhesion
						e = ECM[id];
						c->adhere = 1;
						e->nadhere += 1;
						c->adhereid = e->id;
						c->adheretime = 0;
						N_ADH++;
						if(N_ADH>=N_ADH_MAX) ADH_OK=0;
					}
				}
			}
		}
	}
}




void CTXDynamics(void)	// run once in each dt
{
	int i, n;
	
	//checknodes(1);
	probnuc+=knucdt;
	if(probnuc>1.0) {
		n=(int)(probnuc);
		for(i=0; i<n; i++) {
			NodeCreationNuc(0);
			//checknodes(2);
		}
		probnuc-=n;
	}
	
	probnuctip+=knuctipdt;
	if(probnuctip>1.0) {
		n=(int)(probnuctip);
		for(i=0; i<n; i++) {
			NodeCreationNuc(1);
		}
		probnuctip-=n;	
	}
	
	probdis+=kdisdt*N_CTX;
	if(probdis>1.0) {
		n=(int)(probdis);
		for(i=0; i<n; i++) {
			NodeDeletionRnd();
			//checknodes(3);
		}
		probdis-=n;
	}
	
	//NodeDeletionOrphan();
	
	//CTXLinkRupture();
	//CTXLinkAnneal();
	
	//CTXLinkShrink();
	CTXLinkGrowShrink();
	CTXadhesion();
}


