/*
scaling: thickness in the z-direction is 0.02 um.
units: micron, sec, pN
*/

#define N_MEM 50	// # of membrane nodes

#define ksECMlayerFCT 0.01	// spring constant factor of links between 2 ECM layers
#define AvoidFactor 1.0	// factor of self-avoiding distance comparing to segment length

#define N_CTX_MAX 3000	// max number of cortex nodes
#define fbrCTX 1.0e3	// CTX's rupture force, in pN

#define N_Relax 2	// how many times faster gel relaxes than bead
#define LinkPerNode 6	// links per new node, integer
#define LinkPerNodem1 (LinkPerNode-1)
#define LinkPerNodedb (2*LinkPerNode)
#define LinkPerNodeplus (LinkPerNode+30)
#define LinkPerNodeplusm1 (LinkPerNodeplus-1)

// gel relax solver
#define Matrix_ITOL 1
#define Matrix_TOL 1.0e-9
#define Matrix_ITMAX 75

#define Pi 3.14159265
#define Pihalf (Pi/2.0)
#define Pidb (2.0*Pi)
#define r2d (180.0/Pi)
#define d2r (Pi/180.0)
#define eps 1.0e-10
#define inf 1.0e10

// data sampling
#define smp_buffer 30	// buffer size
#define icutoff 3	// cutoff factor for Gaussian smoothing range
#define smoothwindow (0.5*R_NUC)	// smoothing window size in microns

//--- GL ---
#define HWratio (1.0f*Height/Width)

// display partical size
#define TextureWidth 256
#define ParticleRadius 0.15	//  for bead
#define TextureHalfWidth (TextureWidth/2)
#define TextureDecayWidth (TextureHalfWidth/5)
#define TextureDecayWidth2 (TextureDecayWidth*TextureDecayWidth)
#define TextureDecayWidth2db (2.0*TextureDecayWidth2)
#define LinkDecorSpacing (0.2*ParticleRadius)

//-------------------------------------

// constant paras read from paras.ini
int Nrepeat, N_ADH_MAX;
float XLEN, YLEN, ksiECM, varECM;
float R_MEM, R_NUC, L_EXT, R_EXT, W_EXTADH, L_EXTADH;
float R_MELTfct, R_TIPfct;
float knuc, knuctip, nucbias;
float kdis, kdadh, knadh, Vg, Vs;
float fbrECM, Y_ECM, ksCTX, ksMEM;
float LminCTXfct, LmaxCTXfct, eta, dlt;
float Tmax, Tsmp, smp_dt;

// para search
int Nsrch1, Nsrch2, Nsrch3, ThisSrch;
float Para1min, Para1max, Para2min, Para2max, Para3min, Para3max;
float Para1, Para2;
char SrchVar1[100], SrchVar2[100];

// variables
int N_ECM, N_CTX;	// ECM & Cortex nodes
int NcontactCTXNUC, NcontactMEMNUC, NcontactECMNUC;
int Nedge_ECM, Nedge_CTX;
int N_MEMhalf, N_MEMm1, N_MEMm3;

int Nx_ECM, Ny_ECM, Nx_ECMp1, N_ECM_plus;
int Nlinks, N_CTX_INI;
int TIP_ID, EXT_TIP_ID, N_TIP_SEG;
int N_ADH, ADH_OK;
int NrepeatValid, ValidRun;

int TriangulationSuccess, noise;
int smpskip, smpcnt, smptot, vsmpcnt;
int repeatcnt, staton;
int *connectednodes;
long mseed;

double t, dt, V0dt, Vgdt, Vsdt, R_MEM2, R_NUC2, R_NUCdb, R_MEMdb, smpdt;
double R_MELT, R_TIP;
double probnuc, probnuctip, knucdt, knuctipdt, probdis, kdisdt, probnucfront;
double Tdadh, Tnadh, dnearmem, AvoidDLmaxFct;

double XLENhalf, YLENhalf, ECMarea;
double Area, Area0, dArea;
double Xmax, Ymax, Xmin, Ymin;
double Xnucmax, Ynucmax, Xnucmin, Ynucmin;
double dlbrECM, dlbrCTX, LeftBnd, RightBnd;
double AngMemSelfAvoid, FmaxMemSelfAvoid;
double NcontactECMMEM, NcontactMEMCYTO;
double R_CTXadhere, R_CTXadheresquare;

double ksECM, ksECM_MEM, ksCTX_MEM, ksCTX_ECM, kbMEM, kb_ksMEM, ksMEMdb, ksECMlayer;
double ksiECMheight, ksiECMmin, ksiECMminpVsdt, ksiECMfluct;
double ksiCTX, ksiCTXmin, ksiCTXmax, ksiCTXminpVsdt, ksiCTXmaxpVgdt, ksiCTXfluct;
double ksiCTXnewposmax, ksiCTXnbrmin, ksiCTXnbrmax;
double ksiMEM, ksiMEMfluct;
double limECM, limNUC, limCELL, limMEM;

double R_memavoid, R_memavoiddb, DLmax_memavoid;

double mjuECM, mjuCTX, mjuMEM, mjuNUC;
double mjuECMksdt, mjuCTXksdt, mjuMEMksdt, mjuNUCksdt;
double mjuECMksdtinv, mjuCTXksdtinv, mjuMEMksdtinv, mjuNUCksdtinv;

double dLloadECM, dLloadCTX;
double dlcolorscaleECM, dlcolorscaleCTX, dlcolorscaleMEM;

double MEMprev[N_MEM][2];	// previous membrane position
double Rcell[2], Rcellprev[2];	// center of cell
double Rnuc[2], Rnucprev[2], Rnucini[2];	// center of nucleus
double Fcell[2], Fcyto[2];
double Fnuc[2], Fnucave[2], fnucave;
double Vnuc[2], Vnucave[2], vnucave;
double Vcell[2], Vcellave[2], vcellave;
double linklenave, Nlinkpernode;

double frepeatsum, frepeatave, frepeaterr;
double vrepeatsum, vrepeatave, vrepeaterr;
double *frepeatind, *vrepeatind;	// to calculate variance

double **r_ECM_ini;

// data sampling
int n_track, smp_bufferm1;
int smp_cnt, smp_skip, smp_num, smp_ptr;
float *t_seq, *x_seq, *y_seq, *x_seqsm, *y_seqsm;	// smoothed
double smp_t_buffer[smp_buffer], smp_x_buffer[smp_buffer], smp_y_buffer[smp_buffer];
double Vcell_est, Vcell_ave, Lpath, Lpathsm;

// GL
int Width, Height;
float ZOOM;
int pause, showskip, showfila, linkcolor, showforce;
int shownormal, showstrain, showmelt;
int mouse_x, mouse_y, mouse_left, mouse_right;
int disp_nshift[2];
float zoom, zoominv, PanX, PanY;
float arrowheadlen;

#if OPENGL
GLuint bead, arrowhead;
static GLubyte TexImage[TextureWidth][TextureWidth][4];
static GLuint texName;
#if SAVPIC
	int nframe;
	unsigned long img_cnt, img_cntm;
	static GLubyte* img_data=0;
	char img_name[20];
#endif
#endif


// structures

typedef	enum { FALSE, TRUE } bool;

/* Define structures for vertices, edges and faces */
typedef struct tVertexStructure tsVertex;
typedef tsVertex *tVertex;

typedef struct tEdgeStructure tsEdge;
typedef tsEdge *tEdge;

typedef struct tFaceStructure tsFace;
typedef tsFace *tFace;

struct tVertexStructure {
   double   v[3];
   int	    vnum;
   tEdge    duplicate;	/* pointer to incident cone edge (or NULL) */
   bool     onhull;		/* T iff point on hull. */
   bool	    mark;		/* T iff point already processed. */
   tVertex  next, prev;
};

struct tEdgeStructure {
   tFace    adjface[2];
   tVertex  endpts[2];
   tFace    newface;    /* pointer to incident cone face. */
   bool     delete;		/* T iff edge should be delete. */
   tEdge    next, prev;
};

struct tFaceStructure {
   tEdge    edge[3];
   tVertex  vertex[3];
   bool	    visible;	   /* T iff face visible from new point. */
   bool     lower;         /* T iff on the lower hull */
   tFace    next, prev;
};


/* Define flags */
#define ONHULL   	TRUE
#define REMOVED  	TRUE
#define VISIBLE  	TRUE
#define PROCESSED	TRUE
#define SAFE		1000000     /* Range of safe coord values. */

/* Global variable definitions */
tVertex vertices = NULL;
tEdge edges    	 = NULL;
tFace faces    	 = NULL;

bool check = FALSE;


//----- graph -----
typedef struct ECM_edge ECM_edge;
typedef struct ECM_node ECM_node;
typedef struct MEM_node MEM_node;
typedef struct CTX_node CTX_node;

struct ECM_edge {
	int pair[2];
	ECM_edge *next;
};


struct ECM_node {	// node property
	int id;	// node #
	int bnd, nnbr;	// if on boundary, number of neighbors
	int contact, nearmem;	// if contact, if near MEM
	int connected;	// for coarse-graining
	int nadhere;	// # of adhesions to CTX
	double l0, dl, dlvec[2];	// link's rest length and deformation, dl=l-l0, dl>0 for stretching
	double r[2], rini[2];	// position in lab frame
	double nrm[2];	// local normal in bead frame
	ECM_node *next;
};


struct MEM_node {
	int id, nbr[2], contact, health, melt;	// contact=1 for contacting nucleus, health=0 if crossed
	int nctx, necm;	// # of contacting links from CTX & ECM
	double l[2], l0[2], dl[2];	// 2 neighbors
	double r[2], nrm[2], tng[2], dlvec[2];	// 2D
	double A, B, C, Denom;	// for point-2-line distance calc., line is from i to i+1
	double nrmedge[2], tngedge[2];	// normal & tangent of edge i to i+1
};


struct CTX_node {	// cortex node
	int id, nnbr, contact, connected;	// id, # of neighbors, if contacting nuc/mem, if connected
	int nearmem, adhere, adhereid;	// near MEM or not, adhere to ECM or not, adhereed to ECM-id
	double r[2];	// position
	double l0, dl;	// link's rest length and deformation, dl=l-l0, dl>0 for stretching
	double l0max;
	double dlvec[2];	// vector extension & force
	double adheretime;	// lifetime of adheresion site
	int nearmemid;
	CTX_node *next;
};


ECM_edge *ECMedge=NULL;
ECM_node **ECM=NULL;
MEM_node *MEM;
CTX_node **CTX=NULL;


//--- macro functions ---
#define max2(x,y) (x>y?x:y)
#define min2(x,y) (x<y?x:y)
#define SIGN(a,b) ((b)>=0.0?fabs(a):-fabs(a))
#define sign(x) (x>=0.0?1.0:-1.0)


//--- Functions ---
void init(void);
void initview(void);
void reset(void);
void printCTXGraph(void);
void DoSimu(void);
void SolveRelaxation(void);
void CleanUp(void);
void terminate(void);
void display_list(void);

void veccopy(double r1[2], double r2[2]);
void vecadd (double r1[2], double r2[2], double r3[2]);
void vecsub (double r1[2], double r2[2], double r3[2]);
void vecprod(double r1[2], double x, double r2[2]);
void veczero(double r[2]);
double dtoprod(double r1[2], double r2[2]);
double unitdotprod(double r1[2], double r2[2]);
double norm(double r[2]);
void normalize(double r1[2], double r2[2]);
double distance(double r1[2], double r2[2]);
int CutOffBead(double r1[2], double r2[2]);
void Crt2Pola(double r[2], double *len, double *a);
void Crt2Polb(double r[2], double *len, double *a);
void Pol2Crt(double len, double a, double r[2]);
int NodeOnBead(double r[2]);

void avoidplate(ECM_node *p);
double ran2(long *idum);
double ran3(long *idum);


/* Function declarations */
tVertex MakeNullVertex( void );
void    ReadVertices( void );
void    DoubleTriangle( void );
void    ConstructHull( void );
bool    AddOne( tVertex p );
double  Volumed(tFace f, tVertex p);
tFace	MakeConeFace( tEdge e, tVertex p );
void    MakeCcw( tFace f, tEdge e, tVertex p );
tEdge   MakeNullEdge( void );
tFace   MakeNullFace( void );
tFace   MakeFace( tVertex v0, tVertex v1, tVertex v2, tFace f );
void    CleanUpDelaunay( void );
void    CleanEdges( void );
void    CleanFaces( void );
void    CleanVertices( void );
bool    Collinear( tVertex a, tVertex b, tVertex c );
double	Normz( tFace f );
void    LowerFaces( void );
void    CleanTriangles( void );

//--- graph ---
void BuildGraph(void);
void CleanGraph(void);
void CleanTriangles(void);
void CleanUp(void);
void BuildNetwork(void);



