
// update all forces here, no motion yet

void ResetAllForces(void)
{
	int i;
	MEM_node *m;
	ECM_node *e;
	CTX_node *c;
	
	veczero(Fnuc);
	veczero(Fcell);
	veczero(Fcyto);
	NcontactECMMEM=NcontactMEMCYTO=0;
	
	for(i=0; i<N_MEM; i++) {
		m = &MEM[i];
		veczero(m->dlvec);
		m->nctx = m->necm = 0;
	}
	
	for(i=0; i<N_ECM; i++) {
		e = ECM[i];
		while(e) {
			veczero(e->dlvec);
			e = e->next;
		}
	}
	
	for(i=0; i<N_CTX; i++) {
		c = CTX[i];
		while(c) {
			veczero(c->dlvec);
			c = c->next;
		}
	}
}


//-----------------------------------------

void ECMselF(ECM_node *e)	// ECM self-interaction
{
	int flg;
	double dr[2], l, nr[2], dlv[2];
	ECM_node *p, *q;
	
	p = e->next;
	while(p) {	// for each neighbor p
		flg=0;
		if(p->connected == 1) {	// connected to e!
			flg=1;
			q = ECM[p->id];
			if(e->nnbr == 1 && q->nnbr==1 && e->nadhere <= 0 && q->nadhere <= 0) flg=0;	// isolated pair
		}
		
		if(flg) {
			vecsub(p->r, e->r, dr);	// dr is from e to its neighbor p
			l=norm(dr);
			p->dl = l - p->l0;
			if(p->dl == 0.0) veczero(dlv);
			else {
				normalize(dr, nr);
				vecprod(nr, p->dl, dlv);
			}
			vecadd(e->dlvec, dlv, e->dlvec);
		}
		p = p->next;
	}

#if MLTECM	// multiple ECM layers
	vecsub(r_ECM_ini[e->id], e->r, dr);	// with respect to e's initial position
	vecprod(dr, ksECMlayer, dlv);
	vecadd(e->dlvec, dlv, e->dlvec);
#endif
}



void CTXselF(CTX_node *c)	// CTX self-interaction
{
	double dr[2], l, nr[2], dlv[2];
	CTX_node *p;
	
	p = c->next;
	while(p) {	// for each neighbor p
		if(p->connected == 1) {
			vecsub(p->r, c->r, dr);	// dr is from c to its neighbor p
			l=norm(dr);
			p->dl = l - p->l0;
			if(p->dl == 0.0) veczero(dlv);
			else {
				normalize(dr, nr);
				vecprod(nr, p->dl, dlv);
			}
			vecadd(c->dlvec, dlv, c->dlvec);
		}
		p = p->next;
	}
}


void MEMstretch(MEM_node *m)	// MEM self-interaction
{	// nodes are connected as --r1--p--r2--, input is r1,r2,r2,l0; output is p->l,dl,dlvec
	int i;
	double dr1[2], dr2[2], fct[2], dlv[2];
	
	//	i1 <--[r1]-- i --[r2]--> i2
	vecsub(MEM[m->nbr[0]].r, m->r, dr1);	// left displacement
	vecsub(MEM[m->nbr[1]].r, m->r, dr2);	// right displacement
	
	m->l[0] = norm(dr1);	// left length
	m->l[1] = norm(dr2);	// right length
	
	for(i=0; i<2; i++) {
		m->dl[i] = m->l[i] - m->l0[i];
		fct[i]=1-(m->l0[i])/avoidzero(m->l[i]);
	}
	
	vecprod(dr1, fct[0], dr1);	// left stretching
	vecprod(dr2, fct[1], dr2);	// right stretching
	
	vecadd(dr1, dr2, dlv);	// dlv is actually the displacement, not force
	vecadd(m->dlvec, dlv, m->dlvec);
}


void MEMbend(MEM_node *m)	// bending
{
	int i1, i2;
	double a, tau, r1[2], r2[2], f1[2], f2[2], f[2];
	
	i1 = m->nbr[0];
	i2 = m->nbr[1];
	vecsub(m->r, MEM[i1].r, r1);	// left displacement
	vecsub(MEM[i2].r, m->r, r2);	// right displacement
	// now i1 --[r1]--> i --[r2]--> i2
	
	normalize(r1, r1);
	normalize(r2, r2);
	a=-getanglesign(r1, r2);	// a>0 for convex, a<0 for concave
	tau=a*kb_ksMEM;	// tau>0 for convex, tau<0 for concave
	f1[0]=-r1[1];	// unit direction of force on node-i1
	f1[1]=r1[0];
	f2[0]=-r2[1];	// unit direction of force on node-i2
	f2[1]=r2[0];
	vecprod(f1, tau/(m->l[0]), f1);
	vecprod(f2, tau/(m->l[1]), f2);
	
	vecadd(f1, f2, f);
	
	vecadd(MEM[i1].dlvec, f1, MEM[i1].dlvec);
	vecadd(MEM[i2].dlvec, f2, MEM[i2].dlvec);
	vecsub(m->dlvec, f, m->dlvec);	// opposite force on node-i
}


void GetSelfAvoidF(double dr, double drmax, double nr[2], double fvec[2])
{
	double f;
	f = DLmax_memavoid*pow(1-dr/drmax, 4);
	f = min2(f, ksiMEM);
	//f = min2(drmax/dr-1, DLmax_memavoid);
	vecprod(nr, f, fvec);
}



void MEMavoid1(MEM_node *m)	// node-node repelling
{
	int i;
	double dx, dy, dr, nr[2], fvec[2];
	MEM_node *p;
	
	for(i=0; i<N_MEM; i++) {
		if(i != m->id && i != m->nbr[0] && i != m->nbr[1]) {	// search through other mem nodes
			p = &MEM[i];
			dx = m->r[0] - p->r[0];	// dx from p to m
			if(fabs(dx) < R_memavoiddb) {
				dy = m->r[1] - p->r[1];	// dy from p to m
				if(fabs(dy) < R_memavoiddb) {	// p is inside a R_memavoiddb x R_memavoiddb region
					dr = sqrt(dx*dx+dy*dy);
					if(dr < R_memavoid) {	// p is inside m's repulsive field
						dr = max2(dr, eps);
						nr[0] = dx/dr;	// nr is pointing from p to m
						nr[1] = dy/dr;
						GetSelfAvoidF(dr, R_memavoid, nr, fvec);	// fvec pointing from p to m
						vecadd(m->dlvec, fvec, m->dlvec);	// repeling force
						vecsub(p->dlvec, fvec, p->dlvec);
					}
				}
			}
		}
	}
}


void MEMavoid(MEM_node *m)	// node-edge repelling
{
	int i;
	double r1[2], r2[2], r[2], dr[2];
	double drr, nr[2], fvec[2];
	MEM_node *p, *q;
	
	for(i=0; i<N_MEM; i++) {
		if(i != m->id && i != m->nbr[0] && i != m->nbr[1]) {	// search through other mem nodes
			p = &MEM[i];
			q = &MEM[p->nbr[1]];
			vecsub(p->r, m->r, r1);
			vecsub(q->r, m->r, r2);
			if(crossprod(r1, p->nrmedge)*crossprod(r2, p->nrmedge)<0) {	// m is within p-q limit
				getperpfoot(p->r, q->r, m->r, r);	// r is the perp foot from m to p-q
				vecsub(m->r, r, dr);	// dr is from p-q to m
				drr=norm(dr);
				if(drr < R_memavoid) {	// in the repulsive field
					drr = max2(drr, eps);
					nr[0] = dr[0]/drr;	// nr is from p-q to m
					nr[1] = dr[1]/drr;
					GetSelfAvoidF(drr, R_memavoid, nr, fvec);	// fvec pointing from p-q to m
					vecadd(m->dlvec, fvec, m->dlvec);
					//vecdiv(fvec, 2.0, fvec);	// shared equally between p & q
					vecsub(p->dlvec, fvec, p->dlvec);
					vecsub(q->dlvec, fvec, q->dlvec);
				}
			}
		}
	}
}


//-----------------------------------------

void ECMxMEM1(ECM_node *e)	// updates both e->dlvec and corresponding m->dlvec, ecm node vs. mem node
{
	int i, id;
	double d, dmin, dotp, r[2], dr[2], r1[2], r2[2], h;
	MEM_node *m, *mr;
	
	if(e->r[0] > Xmax || e->r[0] < Xmin) return;
	if(e->r[1] > Ymax || e->r[1] < Ymin) return;
	
	dmin=inf;
	id=0;
	for(i=0; i<N_MEM; i++) {	// to find the nearest membrane node id
		m = &MEM[i];
		d = distancesquare(m->r, e->r);
		if(d<dmin) {
			dmin=d;	// dmin is distance squared!
			id=i;
		}
	}
	
	dmin=sqrt(dmin);
	if(dmin>R_MEM) return;
	
	m = &MEM[id];
	vecsub(m->r, e->r, r);	// r pointing from ecm to membrane
	dotp=dotprod(r, m->nrm);
	if(dotp>0) {	// ecm is inside membrane
		e->nearmem = 1;
		e->contact += 1;
		m->necm += e->nnbr;
		NcontactECMMEM += e->nnbr;
		vecprod(m->nrm, dotp, dr);	// dr is ECM's displacement, assuming MEM is not moving
		vecprod(dr, e->nnbr, dr);	// multiplied by # of ECM's neighbors
		vecadd(e->dlvec, dr, e->dlvec);	// force (future displacement) for ECM
		vecsub(Fcell, dr, Fcell);	// adds to total force on whole cell, in ECM's scale
		vecprod(dr, ksECM_MEM, dr);	// convert to MEM's scale
		vecsub(m->dlvec, dr, m->dlvec);	// force (future displacement) for MEM
		//vecsub(Fcell, dr, Fcell);	// adds to total force on whole cell, in MEM's scale
	}
	else {	// ecm is outside membrane
		mr = &MEM[m->nbr[1]];
		vecsub(mr->r, m->r, r1);	// triangle m1-m2-E
		vecsub(e->r, m->r, r2);
		h = fabs(crossprod(r1, r2))/(m->l[1]);	// triangle area = h*d/2 = m1E x m1m2 / 2
		if(h < dnearmem) e->nearmem = 1;	// ecm is near membrane
	}
}


void ECMxMEM(ECM_node *e)	// updates both e->dlvec and corresponding m->dlvec, ecm node vs. mem edge
{
	int i, id;
	double d, dmin, r[2], dr[2];
	double ks1, ks2, ks, f[2];
	MEM_node *m, *mr;
	
	if(e->r[0] > Xmax || e->r[0] < Xmin) return;
	if(e->r[1] > Ymax || e->r[1] < Ymin) return;
	
	dmin=inf;
	id=0;
	for(i=0; i<N_MEM; i++) {	// to find the nearest membrane node id
		m = &MEM[i];
		d = distancesquare(m->r, e->r);
		if(d<dmin) {
			dmin=d;	// dmin is distance squared!
			id=i;
		}
	}
	
	dmin=sqrt(dmin);
	if(dmin>R_MEM) return;
	
	m = &MEM[id];
	if(distancesquare(MEM[m->nbr[0]].r, e->r) < distancesquare(MEM[m->nbr[1]].r, e->r)) id = m->nbr[0];
	m = &MEM[id];
	
	vecsub(m->r, e->r, r);	// r pointing from ecm to membrane
	dmin=dotprod(r, m->nrmedge);
	
	if(dmin>0) {	// ecm is inside membrane
		mr = &MEM[m->nbr[1]];
		e->nearmem = 1;
		e->contact += 1;
		m->necm += e->nnbr;
		//mr->necm += e->nnbr;
		NcontactECMMEM += e->nnbr;
		
		vecprod(m->nrmedge, dmin, dr);	// dr is ECM's displacement, assuming MEM is not moving
		
		ks1=ksMEMdb;	// spring const. for MEM
		ks2=(e->nnbr)*ksECM;	// spring const. for ECM
		ks=ks1*ks2/(ks1+ks2);	// f=km*(dr-x)=ke*x -> x=km/(km+ke)*dr -> f=km*ke/(km+ke)*dr
		vecprod(dr, ks, f);
		
		vecdiv(f, ksECM, dr);	// total force on ECM in ECM's displacement
		vecadd(e->dlvec, dr, e->dlvec);	// force (future displacement) for ECM
		vecsub(Fcell, dr, Fcell);	// adds to total force on whole cell, in ECM's scale
		
		vecdiv(f, ksMEM, dr);	// total force on membrane in MEM's displacement
		vecsub(m->dlvec, dr, m->dlvec);
		vecsub(mr->dlvec, dr, mr->dlvec);
	}
	else {	// ecm is outside membrane
		if(dmin < dnearmem) e->nearmem = 1;	// ecm is near membrane
	}
}



void ECMxCTX(void)	// updates both e->dlvec and corresponding c->dlvec
{
	int i;
	ECM_node *e;
	
	for(i=0; i<N_ECM; i++) {
		e = ECM[i];
		if(e->nadhere > 0 && e->connected == 1 && e->nnbr > 0) {	// there are adheresions to CTX
			vecadd(Fcell, e->dlvec, Fcell);	// Fcell in ECM's scale
			if(e->nearmem == 0) NcontactECMMEM += e->nnbr;	// node is not counted in ECMxMEM(e)
		}
	}
}


void ECMxNUC(ECM_node *e)	// updates both e->dlvec and corresponding Fnuc
{
	double r[2], dr[2], r2, nr[2];
	
	if(e->r[0] > Xnucmax || e->r[0] < Xnucmin) return;
	if(e->r[1] > Ynucmax || e->r[1] < Ynucmin) return;
	
	vecsub(e->r, Rnuc, r);
	r2=pow(r[0], 2)+pow(r[1], 2);
	if(r2<R_NUC2) {	// if node is inside nuclues
		e->nearmem = 1;
		e->contact += 2;	// in contact with nuclues
		normalize(r, nr);
		
		vecprod(nr, (e->nnbr)*(R_NUC-sqrt(r2)), dr);	// toal force is pointing outward, in ECM's length
		vecadd(e->dlvec, dr, e->dlvec);	// future displacement for ECM in ECM's scale
		
		vecdiv(dr, ksCTX_ECM, dr);	// convert to CTX's scale
		vecsub(Fnuc, dr, Fnuc);	// force (future displacement) for NUC in CTX's scale
	}
}



void CTXxNUC(CTX_node *c)	// updates both c->dlvec and corresponding Fnuc
{
	double r[2], r2, nr[2], dr[2];

	if(c->r[0] > Xnucmax || c->r[0] < Xnucmin) return;
	if(c->r[1] > Ynucmax || c->r[1] < Ynucmin) return;
	
	vecsub(c->r, Rnuc, r);
	r2=pow(r[0], 2)+pow(r[1], 2);
	if(r2<R_NUC2) {	// if CTX is inside NUC
		c->contact += 1;	// in contact with NUC
		normalize(r, nr);	// pointing outward
		vecprod(nr, (R_NUC-sqrt(r2)), dr);	// pointing outward
		vecprod(dr, c->nnbr, dr);	// multiplied by # of CTX's neighbors
		vecadd(c->dlvec, dr, c->dlvec);	// force (future displacement) for CTX
		vecsub(Fnuc, dr, Fnuc);	// force (future displacement) for NUC
	}
}




void CTXxMEM1(CTX_node *c)	// updates both c->dlvec and corresponding m->dlvec, ctx node vs. mem node
{	// each CTX node interacts only with the nearest MEM node
	int i, id;
	double dmin, d;
	double r[2], dr[2], h;
	double ks1, ks2, ks, f[2];
	MEM_node *m;
	
	dmin=inf;
	id=0;
	for(i=0; i<N_MEM; i++) {	// to find the nearest membrane node id
		m = &MEM[i];
		if(m->health) {
			d=distancesquare(m->r, c->r);
			if(d<dmin) {
				dmin=d;	// dmin is distance squared!
				id=i;
			}
		}
	}
	
	c->nearmemid = id;
	m = &MEM[id];	// nearest MEM to CTX
	vecsub(m->r, c->r, r);	// r is from CTX to nearest MEM
	dmin=dotprod(r, m->nrm);
	
	if(dmin>=0) {	// ctx is inside membrane
		vecsub(m->r, c->r, r);	// c to m
		h = fabs(dotprod(r, m->nrmedge));	// distance to edge
		if(min2(h, dmin) < dnearmem) c->nearmem = 1;	// ctx is near membrane			
	}
	else {	// node is outside membrane
		c->nearmem = 1;
		c->contact += 2;	// in contact with membrane
		m->nctx += c->nnbr;
		NcontactMEMCYTO += c->nnbr;
		vecprod(m->nrm, dmin, dr);	// dr is pointing inward, assuming MEM is not moving
		
		ks1 = (c->nnbr)*ksCTX;	// spring const. for CTX
		ks2 = ksMEMdb;	// spring const. for MEM
		
		//ks = min2(ks1, ks2);	// should be this
		//ks = max2(ks1, ks2);	// this makes it look nicer
		ks = ks1;	// assumption is membrane is fluid s.t. it always follows ctx
		
		vecprod(dr, ks, f);	// force is calc'd from the smaller one
		
		vecdiv(f, ksCTX, dr);	// force on CTX in CTX's distance
		vecadd(c->dlvec, dr, c->dlvec);	//  force (future displacement) for CTX
		vecadd(Fcyto, dr, Fcyto);	// force on cytoplasm in CTX's distance
		
		vecdiv(f, ksMEM, dr);	// force on MEM in MEM's displacement
		vecsub(m->dlvec, dr, m->dlvec);	// force (future displacement) for MEM-i
	}
}



void CTXxMEM(CTX_node *c)	// updates both c->dlvec and corresponding m->dlvec, ctx node vs. mem edge
{	// each CTX node interacts only with the nearest MEM edge
	int i, id;
	double dmin, d, r[2], dr[2];
	double ks1, ks2, ks, f[2];
	double r1[2], r2[2], fct1, fct2, fct;
	MEM_node *m, *mr;
	
	dmin=inf;
	id=0;
	for(i=0; i<N_MEM; i++) {	// to find the nearest membrane node id
		m = &MEM[i];
		if(m->health) {
			d = distancesquare(m->r, c->r);
			if(d<dmin) {
				dmin=d;	// dmin is distance squared!
				id=i;
			}
		}
	}
	
	m = &MEM[id];	// following is to make sure that the average distance is minimum
	if(distancesquare(MEM[m->nbr[0]].r, c->r) < distancesquare(MEM[m->nbr[1]].r, c->r)) id = m->nbr[0];
	//id=m->nbr[0];
	
	c->nearmemid = id;
	m = &MEM[id];	// nearest MEM to CTX
	vecsub(m->r, c->r, r);
	dmin=dotprod(r, m->nrmedge);
	
	if(dmin>=0) {	// node is inside membrane
		if(dmin < dnearmem) c->nearmem = 1;	// ctx is near membrane
	}
	else {	// node is outside membrane
		mr = &MEM[m->nbr[1]];
		c->nearmem = 1;
		c->contact += 2;	// in contact with membrane
		m->nctx += c->nnbr;
		//mr->nctx += c->nnbr;
		NcontactMEMCYTO += c->nnbr;
		vecprod(m->nrmedge, dmin, dr);	// dr is pointing inward, assuming MEM is not moving
		
		ks1 = (c->nnbr)*ksCTX;	// spring const. for CTX
		ks2 = ksMEMdb;	// spring const. for MEM
		
		//ks = min2(ks1, ks2);	// should be this
		//ks = max2(ks1, ks2);	// this makes it look nicer
		ks = ks1;	// assumption is membrane is fluid s.t. it always follows ctx
		
		vecprod(dr, ks, f);	// force is calc'd from the smaller one
		
		vecdiv(f, ksCTX, dr);	// force on CTX in CTX's distance
		vecadd(c->dlvec, dr, c->dlvec);	//  force (future displacement) for CTX
		vecadd(Fcyto, dr, Fcyto);	// force on cytoplasm in CTX's distance
		
		///*
		vecsub(c->r, m->r, r1);
		vecsub(c->r, mr->r, r2);
		fct1=fabs(dotprod(r1, m->tngedge));
		fct2=fabs(dotprod(r2, m->tngedge));
		fct=fct1+fct2;
		fct1/=fct;
		fct2/=fct;
		//*/
		//fct1=fct2=0.5;
		
		vecdiv(f, ksMEM, dr);	// force on MEM in MEM's displacement
		vecprod(dr, fct1, r1);
		vecprod(dr, fct2, r2);
		vecsub(m->dlvec, r1, m->dlvec);	// force (future displacement) for MEM-i
		vecsub(mr->dlvec, r2, m->dlvec);	// force (future displacement) for MEM-(i+1)
	}
}



void MEMxCTX(MEM_node *m)	// mem node vs. ctx edge
{
	int i, n;
	double r1[2], r2[2], r[2], dr[2], ks1, ks2, ks, f[2];
	CTX_node *p, *q;
	
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		q = p->next;
		while(q) {
			if(q->id > i) {	// to avoid double-counting
				vecsub(p->r, m->r, r1);
				vecsub(q->r, m->r, r2);
				if(crossprod(r1, m->nrm)*crossprod(r2, m->nrm)<0) {	// m is within the p-q limit
					getperpfoot(p->r, q->r, m->r, r);	// r is the perp foot from m to line p-q
					vecsub(r, m->r, dr);
					if(dotprod(dr, m->nrm)>0) {	// m is inside p-q
						n = max2(p->nnbr + q->nnbr - 2, 2);	// subtract inter-links
						m->nctx += n;
						NcontactMEMCYTO += n;
						ks1=ksMEMdb;
						ks2=n*ksCTX;
						ks=min2(ks1, ks2);
						vecprod(dr, ks, f);	// actual force on membrane
						vecdiv(f, ksMEM, dr);	// force on membrane in MEM's scale
						vecadd(m->dlvec, dr, m->dlvec);
						
						vecdiv(f, ksCTX, dr);	// force on CTX in CTX's scale
						vecsub(Fcyto, dr, Fcyto);
						vecdiv(dr, 2, dr);	// force shared equally on p & q
						vecsub(p->dlvec, dr, p->dlvec);
						vecsub(q->dlvec, dr, q->dlvec);
					}
				}
			}
			q = q->next;
		}
	}
}



void MEMxNUC(MEM_node *m)	// updates both m->dlvec and corresponding Fnuc
{
	double r[2], r2, nr[2], dr[2];
	
	if(m->r[0] > Xnucmax || m->r[0] < Xnucmin) return;
	if(m->r[1] > Ynucmax || m->r[1] < Ynucmin) return;
	
	vecsub(m->r, Rnuc, r);
	r2=pow(r[0], 2)+pow(r[1], 2);
	if(r2<R_NUC2) {
		m->contact += 1;
		//NcontactMEMCYTO += 1;	//LinkPerNode;
		vecsub(m->r, Rnuc, r);
		normalize(r, nr);	// nr is pointing outward of NUC
		vecprod(nr, (R_NUC-sqrt(r2)), dr);	// pointing outward
		vecprod(dr, 2, dr);	// multiplied by # of MEM's neighbors
		vecadd(m->dlvec, dr, m->dlvec);	// force (future displacement) for MEM
		vecdiv(dr, ksCTX_MEM, dr);	// force converted to NUC's future displacement in CTX
		vecsub(Fnuc, dr, Fnuc);	// force (future displacement) for NUC
		//vecsub(Fcyto, dr, Fcyto);
	}
}



void NUCselF(void)	// after updating all other forces
{
	int i;
//	double dr[2];
	CTX_node *p;
	MEM_node *m;
	ECM_node *e;
	
	NcontactCTXNUC=NcontactMEMNUC=NcontactECMNUC=0;
	
	for(i=0; i<N_CTX; i++) {
		p = CTX[i];
		if(p->nnbr > 0 && (p->contact == 1 || p->contact == 3)) {
//			vecadd(Fnuc, p->dlvec, Fnuc);	// force in unit of force/(CTX's stiffness)
			//NcontactCTXNUC++;
			NcontactCTXNUC += p->nnbr;
		}
	}
	//NcontactCTXNUC=max2(NcontactCTXNUC,1);
	
	for(i=0; i<N_MEM; i++) {	// get force from membrane
		m = &MEM[i];
		if(m->contact == 1) {
//			vecdiv(m->dlvec, ksCTX_MEM, dr);	// convert membrane force to cortex force (displacement)
//			vecadd(Fnuc, dr, Fnuc);
			//NcontactMEMNUC++;
			NcontactMEMNUC += 2;
		}
	}
	
	for(i=0; i<N_ECM; i++) {	// get force from ECM
		e = ECM[i];
		if(m->contact >= 2) {
//			vecdiv(e->dlvec, ksCTX_ECM, dr);	// convert membrane force to cortex force (displacement)
//			vecadd(Fnuc, dr, Fnuc);
			//NcontactECMNUC++;
			NcontactECMNUC += e->nnbr;
		}
	}
}



void MEMpressure(void)
{
	int i;
	double p, l, f, dl[2];
	MEM_node *m;
	
	p=-1*(dArea/Area0);	// p>0 if dArea<0, p<0 if dArea>0
	for(i=0; i<N_MEM; i++) {
		m = &MEM[i];
		if(m->health) {
			l = (m->l[0] + m->l[1])/2.0;	// average segment length at m
			f=p*l;
			vecprod(m->nrm, f, dl);
			vecadd(m->dlvec, dl, m->dlvec);
		}
	}
}



//-----------------------------------------

void GetAllForces(void)
{
	int i;
	MEM_node *m;
	ECM_node *e;
	CTX_node *c;

/* interaction map, total of 6 interactions: ECM-MEM, ECM-CTX, ECM-NUC, CTX-NUC, CTX-MEM, MEM-NUC
	ECM -- MEM
	 |  \/  |
	 |  /\  |
	CTX -- NUC
 */

	ResetAllForces();	// reset all forces to 0

	for(i=0; i<N_ECM; i++) {
		e = ECM[i];
		e->nearmem = e->contact = 0;
		if(e->nnbr > 0 && e->connected == 1) {	// note that e->connected may be -1!
			ECMselF(e);	// ECM self-interaction
			ECMxMEM(e);	// ECM with MEM, also updates MEM->f (note: don't use MEMxECM(m) b/c searching for nearest mem)
			ECMxNUC(e);	// ECM with NUC, also updates Fnuc
		}
	}

	for(i=0; i<N_CTX; i++) {
		c = CTX[i];
		c->nearmem = c->contact = 0;
		c->nearmemid = 0;
		if(c->nnbr > 0) {
			CTXselF(c);	// CTX self-interaction
			CTXxNUC(c);	// CTX with NUC, also updates Fnuc
			CTXxMEM(c);	// CTX with MEM, also updates MEM->f (ctx node vs. mem edge)
		}
	}

	for(i=0; i<N_MEM; i++) {
		m = &MEM[i];
		MEMstretch(m);	// MEM self-interaction
		
	#if MEMBND
		//MEMbend(m);
		if(m->health) MEMbend(m);	// no bending for unhealthy ones
	#endif
	
	#if SLFAVD
		if(m->health) {	// MEM self-avoiding, only for healthy ones
			MEMavoid1(m);
			MEMavoid(m);
		}
	#endif
	
	// additional interaction from mem node vs. ctx edge
	#if MEMCTX
		if(m->health) MEMxCTX(m);	// MEM node vs. CTX edge, updates m->f & CTX->f
	#endif
		
		MEMxNUC(m);	// MEM with NUC, also updates Fnuc
	}

	ECMxCTX();	// this handles the balance of adhesion force
	NUCselF();

#if A_CNST
	MEMpressure();
#endif
}

