
//---------------- smoothing -----------------

double getLpath(float x[], float y[])	// size of the arrays is n_track
{
	int i;
	double r1[2], r2[2], z;
	
	z=0;
	for(i=1; i<n_track; i++) {
		r1[0]=x[i-1];	r1[1]=y[i-1];
		r2[0]=x[i];	r2[1]=y[i];
		z+=distance(r1,r2);
	}
	return z;
}


int readtrack(void)
{
	int i;
	char tmp[50];
	FILE *fp;
	
	if(n_track<=0) return 0;
	
	fp=fopen("track.dat", "r");
	if(!fp) { printf("Cannot find track.dat\n"); return 0;}
	
	t_seq=malloc(n_track*sizeof(float));
	x_seq=malloc(n_track*sizeof(float));
	y_seq=malloc(n_track*sizeof(float));
	x_seqsm=malloc(n_track*sizeof(float));
	y_seqsm=malloc(n_track*sizeof(float));
	
	fscanf(fp, "%s\t%s\t%s", tmp, tmp, tmp);
	for(i=0; i<n_track; i++) {	// saved t, x, y
		fscanf(fp, "%f\t%f\t%f", &t_seq[i], &x_seq[i], &y_seq[i]);
	}
	fclose(fp);
	
	Lpath=getLpath(x_seq, y_seq);
	Vcell_est=Lpath/t;// rough estimate of Vcell
	return n_track;
}


void smooth3pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	for(i=1; i<n_track-1; i++) s2[i]=(s1[i-1]+s1[i+1]+2*s1[i])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smooth7pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	s2[1]=(s1[0]+s1[2]+2*s1[1])/4.0;
	s2[2]=(s1[0]+s1[4]+4*(s1[1]+s1[3])+6*s1[2])/16.0;
	for(i=3; i<n_track-3; i++) {
		s2[i]=(s1[i-3]+s1[i+3]+6*(s1[i-2]+s1[i+2])+15*(s1[i-1]+s1[i+1])+20*s1[i])/64.0;
	}
	s2[n_track-3]=(s1[n_track-5]+s1[n_track-1]+4*(s1[n_track-4]+s1[n_track-2])+6*s1[n_track-3])/16.0;
	s2[n_track-2]=(s1[n_track-3]+s1[n_track-1]+2*s1[n_track-2])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void segsmooth(float s1[], float s2[])
{	
	if(n_track>7) smooth7pt(s1, s2);
	else smooth3pt(s1, s2);
}


float convolution(float x[], int ix, int di, int di2db, int mi)
{
	int i;
	float z;

	z=0.0;
	for(i=ix-mi; i<=ix+mi; i++) {
		z+=x[i]*exp(-pow(i-ix,2)/di2db);
	}
	z/=sqrt(Pidb)*di;
	return z;
}


void smoothtrack(void)
{
	int i, il, ir, di, mi, di2db;
	int nw, nwm;
	double smthwindow, path1, path2;
	float dlen, *x, *y;
	

	// smooth method 1
	x=malloc(n_track*sizeof(float));	// temporary arrays
	y=malloc(n_track*sizeof(float));
	segsmooth(x_seq, x);	// 7-pt smoothing
	segsmooth(y_seq, y);
	path1=getLpath(x,y);
	
	// smooth method 2: this may be inaccurate if cell is hardly moving
	dlen=Vcell_est*smp_dt;
	smthwindow=min2(smoothwindow, Lpath/10.0);
	nw=(int)(smthwindow/dlen+0.5);	// Gaussian window
	nw=min2(nw,n_track/2);
	nw=max2(nw,2);
	//printf("nw=%d\n", nw);
	nwm=icutoff*nw;	// Gaussian window cutoff
	
	// two boundaries
	for(i=0; i<n_track; i++) { x_seqsm[i]=x[i]; y_seqsm[i]=y[i]; }
	for(i=icutoff; i<n_track-icutoff; i++) {	// Gaussian smoothing inner part
		il=i;
		ir=n_track-1-i;
		mi=min2(min2(il, ir), nwm);	// max smoothing range for i
		di=max2(mi/icutoff, 1);	// sigma_width of smoothing
		di2db=2*di*di;
		
		x_seqsm[i]=convolution(x,i,di,di2db,mi);	//or use x_seq[i]
		y_seqsm[i]=convolution(y,i,di,di2db,mi);
	}
	path2=getLpath(x_seqsm, y_seqsm);
	
	if(path1<path2) {	// segment smoothing is better
		//printf("smooth-1\n");
		for(i=0; i<n_track; i++) {
			x_seqsm[i]=x[i];
			y_seqsm[i]=y[i];
		}
	}
	//else printf("smooth-2\n");
	
	Lpathsm=min2(path1, path2);
	Vcell_ave=Lpathsm/(t-smp_dt);	// Vcell_ave is in unit of um/s
	// t-smt_dt because the starting time is t=smt_dt instead of 0
	
	//printf("L=%.4g\t%.4g\n", Lpath, Lpathsm);
	
	free(x);
	free(y);
}


void savetrack(void)
{
	int i;
	FILE *fp;
	fp=fopen("track_sm.dat", "w");
	fprintf(fp, "#t\tx\ty\n");
	for(i=0; i<n_track; i++) {
		fprintf(fp, "%.4g\t%.5g\t%.5g\n", t_seq[i], x_seqsm[i], y_seqsm[i]);
	}
	fclose(fp);
}


//----------- overall ------------

void CleanStat(void)
{
	free(t_seq);
	free(x_seq);
	free(y_seq);
	free(x_seqsm);
	free(y_seqsm);
}


void ProcessTrack(void)
{
	int i;
	
	FlushTracking(smp_ptr);	// finishing up the leftovers
	i=readtrack();
	if(i>=3) {
		smoothtrack();	// <V> is calc'd here
		savetrack();
	}
	else Vcell_ave=-1;	// sth wrong
	
	if(i>0) CleanStat();
}



