
// relax mesh by solving linear equations A.x=b

int findnodeindex(int id, int nodes[], int n)
{
	int i;
	i=0;
	while(nodes[i]!=id && i<n) i++;
	if(i<n) return i;
	else return -1;
}


void buildmatrix(double **m, int nodes[], int n)
{	// 2D matrix m[1...N][1...N]
	int i, j, k;
	ECM_node *p;
	
	for(i=1; i<=n; i++) {
		for(j=1; j<=n; j++) m[i][j]=0.0;
		p=ECM[nodes[i-1]];
		m[i][i]=max2(p->nnbr,1);	// nnbr=0 will give trouble
		p = p->next;
		while(p) {	// i's neighbors are marked with -1
			if(ECM[p->id]->bnd==0) {
				k = findnodeindex(p->id, nodes, n);
				if(k<0) {printf("error in buidmatrix\n"); exit(0);}
				m[i][k]=-1.0;
			}
			p = p->next;
		}
	}
}


void buildvector(double *bx, double *by, int nodes[], int n)
{	// vector bx[1...N], by[1...N]
	int i;
	ECM_node *p;
	
	for(i=1; i<=n; i++) {
		p = ECM[nodes[i-1]];
		bx[i] = p->dlvec[0];
		by[i] = p->dlvec[1];
	}
}


void SolveRelaxation(void)
{
	int i, n, maxdim, iter;
	unsigned long *mija;
	double **m, *msa, *bx, *by, *vdx, *vdy, err1, err2, err;
	double r[2], drmax;
	ECM_node *p;
	
	if(Rnuc[0]>XLENhalf+R_NUC || Rnuc[0]<-XLENhalf-R_NUC) return;
	
	drmax=0.1*ksiECM;
	n=0;
	for(i=0; i<N_ECM; i++) {
		p=ECM[i];
		if(p->connected == 1 && p->bnd==0) connectednodes[n++]=i;	// this stores the id of connected nodes
		//if(p->connected == 1) connectednodes[n++]=i;	// this stores the id of connected nodes
	}
	
	maxdim=n*6+n+1;	// dimension of mija[] and msa[], link-per-node = 6
	maxdim*=2;	// why above alone is not working???
	
	m=dmatrix(1,n,1,n);
	mija=lvector(1,maxdim);
	msa=dvector(1,maxdim);
	
	bx=dvector(1,n);
	by=dvector(1,n);
	vdx=dvector(1,n);
	vdy=dvector(1,n);
	
	buildmatrix(m, connectednodes, n);
	buildvector(bx, by, connectednodes, n);
	dsprsin(m, n, Matrix_TOL, maxdim, msa, mija);
	for(i=1; i<=n; i++) vdx[i]=vdy[i]=0.0;
	
	linbcg(msa, mija, n, bx, vdx, Matrix_ITOL, Matrix_TOL, Matrix_ITMAX, &iter, &err1);
	linbcg(msa, mija, n, by, vdy, Matrix_ITOL, Matrix_TOL, Matrix_ITMAX, &iter, &err2);
	
	err=err1+err2;
	if(err>=0.0 && err<5.0) {	// sometimes the errors are huge or -inf!
		//printf(".");
		//printf("%.2g\t", err);
		for(i=1; i<=n; i++) {
			p=ECM[connectednodes[i-1]];
			
			if(p->bnd != -1) {	// assume bottom nodes are fixed
				r[0]=vdx[i];
				r[1]=vdy[i];
				limitvector(r,drmax);	// s.t. the displacement is smaller than 5nm
				if(p->bnd==0) {
					p->r[0] += r[0];
					p->r[1] += r[1];
				}
			}
		}
		
		for(i=0; i<n; i++) {
			p = ECM[i]->next;
			while(p) {
				veccopy(ECM[p->id]->r, p->r);
				p = p->next;
			}
		}
	}
	//else printf("%.2g\t", err);
	
	free_dmatrix(m,1,N_ECM,1,N_ECM);
	free_lvector(mija,1,maxdim);
	free_dvector(msa,1,maxdim);
	
	free_dvector(bx,1,N_ECM);
	free_dvector(by,1,N_ECM);
	free_dvector(vdx,1,N_ECM);
	free_dvector(vdy,1,N_ECM);
}


