from networks access *;

network three_tensor(int k = 1,
                     int gap = 25,
                     int wire_gap = 5,
                     int wire_height = 15,
                     bool attach_input = false) {
  network N;
  tensor A[] = new tensor[];
  tensor B[] = new tensor[];
  tensor C[] = new tensor[];
  mode_join p[] = new mode_join[];
  for (int i = 0; i < k; ++i) {
    A[i] = N.add_tensor((gap*i, 0), 10, 10);
    B[i] = N.add_tensor(((k+1)*gap + i*gap, 0), 10, 10);
    C[i] = N.add_tensor((k*gap - (k-1)/2*gap + i*gap, 50), 10, 10);
    p[i] = N.add_mode_join((C[i].mid.x, 25));
    N.join(A[i].mid + (0,10), p[i].mid);
    N.join(B[i].mid + (0,10), p[i].mid);
    N.join(C[i].mid + (0,-10), p[i].mid);
  }
  
  for (int i = 0; i < k; ++i) {
    N.add_path(smooth_vertical_path(A[i].mid + (-5,-10), A[0].mid + (-5 + wire_gap*i, -10-wire_height)));
    N.add_path(smooth_vertical_path(A[i].mid + (5,-10), A[k-1].mid + (5 - wire_gap*(k-1-i), -10-wire_height)));
    N.add_path(smooth_vertical_path(B[i].mid + (-5,-10), B[0].mid + (-5 + wire_gap*i, -10-wire_height)));
    N.add_path(smooth_vertical_path(B[i].mid + (5,-10), B[k-1].mid + (5 - wire_gap*(k-1-i), -10-wire_height)));
    N.add_path(smooth_vertical_path(C[i].mid + (-5,10), C[0].mid + (-5 + wire_gap*i, 10+wire_height)));
    N.add_path(smooth_vertical_path(C[i].mid + (5,10), C[k-1].mid + (5 - wire_gap*(k-1-i), 10+wire_height)));
  }

  if (attach_input) {
    tensor X = N.add_tensor((A[0].mid+A[k-1].mid)/2 + (0, -20-wire_height), gap*(k-1)/2+10, 10, pen=green);
    tensor Y = N.add_tensor((B[0].mid+B[k-1].mid)/2 + (0, -20-wire_height), gap*(k-1)/2+10, 10, pen=green);
    
    execution_node AX[] = new execution_node[];
    execution_node BY[] = new execution_node[];
    execution_node res[] = new execution_node[];
    execution_node AXBY = N.add_execution_node((A[0].mid+B[k-1].mid)/2 + (-10,30));
    for (int i = 0; i < k; ++i) {
      AX[i] = N.add_execution_node(A[i].mid + (-5, 20));
      N.exec_join(A[i].exec, AX[i]);
      if (i > 0) {
        N.exec_join(AX[i-1], AX[i]);
      } else {
        N.exec_join(X.exec, AX[i], A[0].mid + (-30, -2));
      }

      BY[i] = N.add_execution_node(B[i].mid + (-5, 20));
      N.exec_join(B[i].exec, BY[i]);
      if (i > 0) {
        N.exec_join(BY[i-1], BY[i]);
      } else {
        N.exec_join(Y.exec, BY[i], B[0].mid + (-30, -2));
      }

      res[i] = N.add_execution_node(C[i].mid + (0, 20));
      N.exec_join(C[i].exec, res[i]);
      if (i > 0) {
        N.exec_join(res[i-1], res[i]);
      } else {
        N.exec_join(AXBY, res[i], C[0].mid + (-30, -2));
      }
    }

    N.exec_join(AX[k-1], AXBY);
    N.exec_join(BY[k-1], AXBY, BY[k-1].mid + (0, 5));
  }    

  return N;
}
