function [zetak,etak] = get_vorticity(psik,qk)

% [zetak,etak] = GET_VORTICITY(psik,qk)  Calculates spectral relative
%     vorticity 'zetak' and vortex stretching 'etak' from spectral 
%     streamfunction field psik and PV field qk.  NOTE:  Only needs
%     psik as input if you only want zetak as output (qk is optional).

nz = size(psik,3); kmax = size(psik,2)-1;

[kx_,ky_,z_] = ndgrid(-kmax:kmax,0:kmax,1:nz);

for t = 1:size(psik,4)
  zetak(:,:,:,t) = -(kx_.^2+ky_.^2).*psik(:,:,:,t);
end

if nargin>1
   if nargout<2, error('Need qk input to calculate etak'), end
   etak = qk-zetak;
end
