function fout = laplacian_dp(f)

% fout = LAPLACIAN_DP(f) 
%     Calculates the laplacian of field 'f' assuming 'f'
%     is doubly periodic.

nx = size(f,1);
ny = size(f,2);
dx=2*pi/(nx-1);
dy=2*pi/(ny-1);

fout(2:nx-1,2:ny-1) = (f(3:nx,2:ny-1)+f(1:nx-2,2:ny-1))/dx^2 + ...
                           (f(2:nx-1,3:ny)+f(2:ny-1,1:ny-2))/dy^2 + ...
                           -2*(1/dx^2+1/dy^2)*f(2:nx-1,2:ny-1);

fout(1,2:ny-1) = (f(2,2:ny-1)+f(nx,2:ny-1))/dx^2 + ...
                      (f(1,3:ny)+f(1,1:ny-2))/dy^2 + ...
                      -2*(1/dx^2+1/dy^2)*f(1,2:ny-1);

%fout(nx,2:ny-1) = (f(1,2:ny-1)+f(nx-1,2:ny-1))/dx^2 + ...
%                      (f(1,3:ny)+f(1,1:ny-2))/dy^2 + ...
%                      -2*(1/dx^2+1/dy^2)*f(nx,2:ny-1);

fout(2:nx-1,1) = (f(3:nx,1)+f(1:nx-2,1))/dx^2 + ...
                      (f(2:nx-1,2)+f(2:nx-1,ny))/dy^2 + ...
                      -2*(1/dx^2+1/dy^2)*f(2:nx-1,1);
%fout(2:nx-1,ny) = (f(3:nx,1)+f(1:nx-2,1))/dx^2 + ...
%                      (f(2:nx-1,1)+f(2:nx-1,ny-1))/dy^2 + ...
%                      -2*(1/dx^2+1/dy^2)*f(2:nx-1,ny);


fout(1,1) = (f(2,1)+f(nx,1))/dx^2+(f(1,2)+f(1,ny))/dy^2 ...
                 -2*(1/dx^2+1/dy^2)*f(1,1);

%fout(nx,ny) = (f(1,ny)+f(nx-1,ny))/dx^2+(f(nx,1)+f(nx,ny-1))/dy^2 ...
%                 -2*(1/dx^2+1/dy^2)*f(nx,ny);
%fout(1,ny) = (f(2,ny)+f(nx,ny))/dx^2+(f(1,1)+f(1,ny-1))/dy^2 ...
%                 -2*(1/dx^2+1/dy^2)*f(1,ny);
%fout(nx,1) = (f(1,1)+f(nx-1,1))/dx^2+(f(nx,2)+f(nx,ny))/dy^2 ...
%                 -2*(1/dx^2+1/dy^2)*f(nx,1);

fout(nx,:) = fout(1,:);
fout(:,ny) = fout(:,1);
fout(nx,ny) = fout(1,1);

