module fft_pak

  ! Put the FFT call in a separate module to isolate the only part 
  ! which is platform dependant.  This one is for cfft.f
  !
  ! Routine: init_fft, fft
  !
  ! Dependencies: cfft.f

  implicit none
  private
  save

  real,dimension(:),allocatable   :: work
  integer                         :: nx, ny, nkx, nky,lwork

  public :: Init_fft, fft

  interface fft
     module procedure fft2, fft3
  end interface

contains

  !********************************************************************

  subroutine Init_fft(kmax)

    ! Initialize fft routine
    integer,intent(in)                 :: kmax

    nx = 2*kmax+2; ny = nx; nkx = 2*kmax+1; nky = kmax+1;lwork=4*(nx+ny)+30
    allocate(work(lwork))
    call zfft2i_64(nx,ny,work)
  
  end subroutine Init_fft

  !********************************************************************

  function fft2(f,dirn) result(fr)

    ! Calculate 2d complex to complex fft.  dirn = +1 or -1.
    ! these values correspond to sign of exponent in spectral
    ! sum (see man page on ccfft2d).
    complex,dimension(:,:)                  :: f
    complex,dimension(size(f,1),size(f,2))  :: fr
    integer,intent(in)                      :: dirn
    real                                    :: scale
    integer  :: i

    fr=f
    if (dirn==-1)then
       call zfft2b_64(nx,ny,fr,nx,work,lwork)
       scale = 1.0
    endif
    if (dirn==1)then
       call zfft2f_64(nx,ny,fr,nx,work,lwork)
       scale = 1.0/(nx*ny)
    endif

    fr = fr*scale

  end function fft2

  !********************************************************************

  function fft3(f,dirn) result(fr)

    ! Calculate 2d complex to complex fft.  dirn = +1 or -1.
    ! these values correspond to sign of exponent in spectral
    ! sum (see man page on ccfft2d).
    complex,dimension(:,:,:)                          :: f
    complex,dimension(size(f,1),size(f,2),size(f,3))  :: fr
    integer,intent(in)                                :: dirn
    real                                              :: scale
    integer                                           :: n

    fr=f
    do n = 1,size(f,3)
       if (dirn==-1)then
          call zfft2b_64(nx,ny,fr(:,:,n),nx,work,lwork)
          scale = 1.0
       endif
       if (dirn==1)then
          call zfft2f_64(nx,ny,fr(:,:,n),nx,work,lwork)
          scale = 1.0/(nx*ny)
      endif
    enddo

    fr = fr*scale

  end function fft3

  !********************************************************************

end module fft_pak
